/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarMalformatException;

public class PIFData
extends HashMap {
    private static Pattern pifRecordPattern = Pattern.compile("\\d+ +([^=]+)=(.*)");
    private Long sizeObject = null;

    public Long getSize() {
        return this.sizeObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PIFData(InputStream stream) throws TarMalformatException, IOException {
        try {
            String s;
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            int lineNum = 0;
            while ((s = br.readLine()) != null) {
                ++lineNum;
                Matcher m = pifRecordPattern.matcher(s);
                if (!m.matches()) {
                    throw new TarMalformatException(RB.singleton.getString(RB.PIF_MALFORMAT, lineNum, s));
                }
                String k = m.group(1);
                String v = m.group(2);
                if (v == null || v.length() < 1) {
                    this.remove(k);
                    continue;
                }
                this.put(k, v);
            }
        }
        finally {
            stream.close();
        }
        String sizeString = (String)this.get("size");
        if (sizeString != null) {
            try {
                this.sizeObject = Long.valueOf(sizeString);
            }
            catch (NumberFormatException nfe) {
                throw new TarMalformatException(RB.singleton.getString(RB.PIF_MALFORMAT_SIZE, sizeString));
            }
        }
    }
}

