/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarGenerator;
import org.hsqldb.lib.tar.TarMalformatException;
import org.hsqldb.lib.tar.TarReader;

public class DbBackup {
    protected File dbDir;
    protected File archiveFile;
    protected String instanceName;
    protected boolean overWrite = false;
    protected boolean abortUponModify = true;

    public static void main(String[] sa) throws IOException, TarMalformatException {
        block13: {
            try {
                if (sa.length < 1) {
                    System.out.println(RB.singleton.getString(RB.DBBACKUP_SYNTAX, DbBackup.class.getName()));
                    System.out.println();
                    System.out.println(RB.singleton.getString(RB.LISTING_FORMAT));
                    System.exit(0);
                }
                if (sa[0].equals("--save")) {
                    boolean overWrite = sa.length > 1 && sa[1].equals("--overwrite");
                    if (sa.length != (overWrite ? 4 : 3)) {
                        throw new IllegalArgumentException();
                    }
                    DbBackup backup = new DbBackup(new File(sa[sa.length - 2]), sa[sa.length - 1]);
                    backup.setOverWrite(overWrite);
                    backup.write();
                    break block13;
                }
                if (sa[0].equals("--list")) {
                    if (sa.length < 2) {
                        throw new IllegalArgumentException();
                    }
                    String[] patternStrings = null;
                    if (sa.length > 2) {
                        patternStrings = new String[sa.length - 2];
                        for (int i = 2; i < sa.length; ++i) {
                            patternStrings[i - 2] = sa[i];
                        }
                    }
                    new TarReader(new File(sa[1]), 0, patternStrings, new Integer(DbBackup.generateBufferBlockValue(new File(sa[1]))), null).read();
                    break block13;
                }
                if (sa[0].equals("--extract")) {
                    int firstPatInd;
                    boolean overWrite = sa.length > 1 && sa[1].equals("--overwrite");
                    int n = firstPatInd = overWrite ? 4 : 3;
                    if (sa.length < firstPatInd) {
                        throw new IllegalArgumentException();
                    }
                    String[] patternStrings = null;
                    if (sa.length > firstPatInd) {
                        patternStrings = new String[sa.length - firstPatInd];
                        for (int i = firstPatInd; i < sa.length; ++i) {
                            patternStrings[i - firstPatInd] = sa[i];
                        }
                    }
                    File tarFile = new File(sa[overWrite ? 2 : 1]);
                    int tarReaderMode = overWrite ? 2 : 1;
                    new TarReader(tarFile, tarReaderMode, patternStrings, new Integer(DbBackup.generateBufferBlockValue(tarFile)), new File(sa[firstPatInd - 1])).read();
                    break block13;
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException iae) {
                System.out.println(RB.singleton.getString(RB.DBBACKUP_SYNTAXERR, DbBackup.class.getName()));
                System.exit(2);
            }
        }
    }

    public DbBackup(File archiveFile, String dbPath) throws IOException {
        this.archiveFile = archiveFile;
        File dbPathFile = new File(dbPath);
        this.dbDir = dbPathFile.getAbsoluteFile().getParentFile();
        this.instanceName = dbPathFile.getName();
    }

    public void setOverWrite(boolean overWrite) {
        this.overWrite = overWrite;
    }

    public void setAbortUponModify(boolean abortUponModify) {
        this.abortUponModify = abortUponModify;
    }

    public boolean getOverWrite() {
        return this.overWrite;
    }

    public boolean getAbortUponModify() {
        return this.abortUponModify;
    }

    public void write() throws IOException, TarMalformatException {
        int i;
        File propertiesFile = new File(this.dbDir, this.instanceName + ".properties");
        File scriptFile = new File(this.dbDir, this.instanceName + ".script");
        File[] componentFiles = new File[]{propertiesFile, scriptFile, new File(this.dbDir, this.instanceName + ".backup"), new File(this.dbDir, this.instanceName + ".data"), new File(this.dbDir, this.instanceName + ".log"), new File(this.dbDir, this.instanceName + ".lobs")};
        boolean[] existList = new boolean[componentFiles.length];
        long startTime = new Date().getTime();
        for (int i2 = 0; i2 < existList.length; ++i2) {
            existList[i2] = componentFiles[i2].exists();
            if (i2 >= 2 || existList[i2]) continue;
            throw new FileNotFoundException(RB.singleton.getString(RB.FILE_MISSING, componentFiles[i2].getAbsolutePath()));
        }
        if (this.abortUponModify) {
            Properties p = new Properties();
            p.load(new FileInputStream(propertiesFile));
            String modifiedString = p.getProperty("modified");
            if (modifiedString != null && (modifiedString.equalsIgnoreCase("yes") || modifiedString.equalsIgnoreCase("true"))) {
                throw new IllegalStateException(RB.singleton.getString(RB.MODIFIED_PROPERTY, modifiedString));
            }
        }
        TarGenerator generator = new TarGenerator(this.archiveFile, this.overWrite, new Integer(DbBackup.generateBufferBlockValue(componentFiles)));
        for (i = 0; i < componentFiles.length; ++i) {
            if (!componentFiles[i].exists()) continue;
            generator.queueEntry(componentFiles[i].getName(), componentFiles[i]);
        }
        generator.write();
        if (this.abortUponModify) {
            try {
                for (i = 0; i < componentFiles.length; ++i) {
                    if (componentFiles[i].exists()) {
                        if (!existList[i]) {
                            throw new FileNotFoundException(RB.singleton.getString(RB.FILE_DISAPPEARED, componentFiles[i].getAbsolutePath()));
                        }
                        if (componentFiles[i].lastModified() <= startTime) continue;
                        throw new FileNotFoundException(RB.singleton.getString(RB.FILE_CHANGED, componentFiles[i].getAbsolutePath()));
                    }
                    if (!existList[i]) continue;
                    throw new FileNotFoundException(RB.singleton.getString(RB.FILE_APPEARED, componentFiles[i].getAbsolutePath()));
                }
            }
            catch (IllegalStateException ise) {
                if (!this.archiveFile.delete()) {
                    System.out.println(RB.singleton.getString(RB.CLEANUP_RMFAIL, this.archiveFile.getAbsolutePath()));
                }
                throw ise;
            }
        }
    }

    protected static int generateBufferBlockValue(File[] files) {
        long maxFileSize = 0L;
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null || files[i].length() <= maxFileSize) continue;
            maxFileSize = files[i].length();
        }
        int idealBlocks = (int)(maxFileSize / 5120L);
        if (idealBlocks < 1) {
            return 1;
        }
        if (idealBlocks > 40960) {
            return 40960;
        }
        return idealBlocks;
    }

    protected static int generateBufferBlockValue(File file) {
        return DbBackup.generateBufferBlockValue(new File[]{file});
    }
}

