/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class ReaderDataInput
implements DataInput {
    protected Reader reader;
    protected int pos;
    int lastChar = -1;

    public ReaderDataInput(Reader reader) {
        this.reader = reader;
        this.pos = 0;
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] bytes, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int b = this.read();
            if (b < 0) {
                throw new EOFException();
            }
            bytes[off + n++] = (byte)b;
        }
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    @Override
    public short readShort() throws IOException {
        int b1 = this.read();
        if (b1 < 0) {
            throw new EOFException();
        }
        int b2 = this.read();
        if (b2 < 0) {
            throw new EOFException();
        }
        return (short)(b1 << 8 | b2);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (b1 << 8) + b2;
    }

    @Override
    public final char readChar() throws IOException {
        int b2;
        int b1 = this.read();
        if ((b1 | (b2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((b1 << 8) + b2);
    }

    @Override
    public int readInt() throws IOException {
        throw new RuntimeException("not implemented.");
    }

    @Override
    public long readLong() throws IOException {
        throw new RuntimeException("not implemented.");
    }

    @Override
    public final float readFloat() throws IOException {
        throw new RuntimeException("not implemented.");
    }

    @Override
    public final double readDouble() throws IOException {
        throw new RuntimeException("not implemented.");
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new RuntimeException("not implemented.");
    }

    @Override
    public String readLine() throws IOException {
        throw new RuntimeException("not implemented.");
    }

    @Override
    public String readUTF() throws IOException {
        throw new RuntimeException("not implemented.");
    }

    public int read() throws IOException {
        if (this.lastChar >= 0) {
            int val = this.lastChar & 0xFF;
            this.lastChar = -1;
            ++this.pos;
            return val;
        }
        this.lastChar = this.reader.read();
        if (this.lastChar < 0) {
            return this.lastChar;
        }
        ++this.pos;
        return this.lastChar >> 8;
    }
}

