/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.store.BaseHashMap;

public class OrderedIntHashSet
extends BaseHashMap {
    public OrderedIntHashSet() {
        this(8);
    }

    public OrderedIntHashSet(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 1, 0, false);
        this.isList = true;
    }

    public boolean contains(int key) {
        return super.containsKey(key);
    }

    public boolean add(int key) {
        int oldSize = this.size();
        super.addOrRemove(key, 0L, null, null, false);
        return oldSize != this.size();
    }

    public boolean remove(int key) {
        boolean result;
        int oldSize = this.size();
        super.addOrRemove(key, 0L, null, null, true);
        boolean bl = result = oldSize != this.size();
        if (result) {
            int[] array = this.toArray();
            super.clear();
            for (int i = 0; i < array.length; ++i) {
                this.add(array[i]);
            }
        }
        return result;
    }

    public int get(int index) {
        this.checkRange(index);
        return this.intKeyTable[index];
    }

    public int getOrderedMatchCount(int[] array) {
        int i;
        for (i = 0; i < array.length && super.containsKey(array[i]); ++i) {
        }
        return i;
    }

    public int[] toArray() {
        int lookup = -1;
        int[] array = new int[this.size()];
        for (int i = 0; i < array.length; ++i) {
            int value;
            lookup = super.nextLookup(lookup);
            array[i] = value = this.intKeyTable[lookup];
        }
        return array;
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

