/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.store.BaseHashMap;

public class HashSet
extends BaseHashMap
implements Set {
    public HashSet() {
        this(8);
    }

    public HashSet(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 0, false);
    }

    @Override
    public boolean contains(Object key) {
        return super.containsKey(key);
    }

    public boolean containsAll(Collection col) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(Object key) {
        int lookup = this.getLookup(key, key.hashCode());
        if (lookup < 0) {
            return null;
        }
        return this.objectKeyTable[lookup];
    }

    @Override
    public boolean add(Object key) {
        int oldSize = this.size();
        super.addOrRemove(0L, 0L, key, null, false);
        return oldSize != this.size();
    }

    @Override
    public boolean addAll(Collection c) {
        int oldSize = this.size();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return oldSize != this.size();
    }

    public boolean addAll(Object[] keys) {
        boolean changed = false;
        for (int i = 0; i < keys.length; ++i) {
            if (!this.add(keys[i])) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean remove(Object key) {
        int oldSize = this.size();
        super.removeObject(key, false);
        return oldSize != this.size();
    }

    public boolean removeAll(Collection c) {
        Iterator it = c.iterator();
        boolean result = true;
        while (it.hasNext()) {
            result &= this.remove(it.next());
        }
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a == null || a.length < this.size()) {
            a = new Object[this.size()];
        }
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            a[i] = it.next();
            ++i;
        }
        return a;
    }

    @Override
    public Iterator iterator() {
        return new BaseHashMap.BaseHashIterator(this, true);
    }

    public String toString() {
        Iterator it = this.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(", ");
            } else {
                sb.append('[');
            }
            sb.append(it.next());
        }
        return sb.toString() + ']';
    }
}

