/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hsqldb.lib.IntValueHashMap;

public class WrapperInvocationHandler
implements InvocationHandler {
    public static final int WIH_NO_SURROGATE = 0;
    public static final int WIH_CLOSE_SURROGATE = 1;
    public static final int WIH_IS_CLOSED_SURROGATE = 2;
    public static final int WIH_GET_PARENT_SURROGATE = 3;
    public static final int WIH_GET_DATABASEMETADATA_SURROGATE = 4;
    public static final int WIH_CREATE_OR_PREPARE_STATEMENT_SURROGATE = 5;
    public static final int WIH_GET_RESULTSET_SURROGATE = 6;
    public static final int WIH_UNWRAP_SURROGATE = 7;
    public static final int WIH_GET_ARRAY_SURROGATE = 8;
    protected static final IntValueHashMap methodMap = new IntValueHashMap();
    protected static final Class[] arrayInterface = new Class[]{Array.class};
    protected static final Class[] connectionInterface = new Class[]{Connection.class};
    protected static final Class[] callableStatementInterface = new Class[]{CallableStatement.class};
    protected static final Class[] databaseMetaDataInterface = new Class[]{DatabaseMetaData.class};
    protected static final Class[] preparedStatementInterface = new Class[]{PreparedStatement.class};
    protected static final Class[] resultSetInterface = new Class[]{ResultSet.class};
    protected static final Class[] statementInterface = new Class[]{Statement.class};
    private Object delegate;
    private Object surrogate;
    private WrapperInvocationHandler parentHandler;
    private ConnectionPool connectionPool;
    private StatementPool statementPool;
    private WrapperInvocationHandler dbmdHandler;
    private boolean surrogateClosed;
    private StatementKey statementKey;
    private Set resultSets;
    private Set statements;

    protected static boolean _isCloseSurrogateMethod(Class clazz, Method method) {
        return (Connection.class.isAssignableFrom(clazz) || Statement.class.isAssignableFrom(clazz)) && "close".equals(method.getName());
    }

    protected static boolean _isIsClosedSurrogateMethod(Class clazz, Method method) {
        return (Connection.class.isAssignableFrom(clazz) || Statement.class.isAssignableFrom(clazz)) && "isClosed".equals(method.getName());
    }

    protected static boolean _isUnwrapMethod(Method method) {
        return "unwrap".equals(method.getName());
    }

    protected static Class[] _computeProxiedInterface(Object delegate) {
        if (delegate instanceof Array) {
            return arrayInterface;
        }
        if (delegate instanceof Connection) {
            return connectionInterface;
        }
        if (delegate instanceof CallableStatement) {
            return callableStatementInterface;
        }
        if (delegate instanceof DatabaseMetaData) {
            return databaseMetaDataInterface;
        }
        if (delegate instanceof PreparedStatement) {
            return preparedStatementInterface;
        }
        if (delegate instanceof ResultSet) {
            return resultSetInterface;
        }
        if (delegate instanceof Statement) {
            return statementInterface;
        }
        return null;
    }

    protected static int _computeSurrogateType(Method method) {
        return methodMap.get((Object)method, 0);
    }

    public WrapperInvocationHandler(Connection connection, ConnectionPool connectionPool, StatementPool statementPool) throws IllegalArgumentException {
        this(connection, null);
        this.connectionPool = connectionPool;
        this.statementPool = statementPool;
    }

    public WrapperInvocationHandler(Object delegate, WrapperInvocationHandler parent) throws IllegalArgumentException {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate: null");
        }
        Class[] proxiedInterface = WrapperInvocationHandler._computeProxiedInterface(delegate);
        if (proxiedInterface == null) {
            throw new IllegalArgumentException("delegate: " + delegate);
        }
        this.delegate = delegate;
        this.parentHandler = parent;
        this.surrogate = Proxy.newProxyInstance(proxiedInterface[0].getClassLoader(), proxiedInterface, (InvocationHandler)this);
    }

    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        switch (WrapperInvocationHandler._computeSurrogateType(method)) {
            case 1: {
                this.closeSurrogate();
                result = null;
                break;
            }
            case 2: {
                result = this.isClosedSurrogate() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 3: {
                this.checkSurrogateClosed();
                result = this.getParentSurrogate(method, args);
                break;
            }
            case 4: {
                this.checkSurrogateClosed();
                result = this.getDatabaseMetaDataSurrogate(method, args);
                break;
            }
            case 5: {
                this.checkSurrogateClosed();
                result = this.getCreatedOrPreparedStatementSurrogate(method, args);
                break;
            }
            case 6: {
                this.checkSurrogateClosed();
                result = this.getResultSetSurrogate(method, args);
                break;
            }
            case 7: {
                this.checkSurrogateClosed();
                result = this.unwrapSurrogate(method, args);
                break;
            }
            case 8: {
                this.checkSurrogateClosed();
                result = this.getArraySurrogate(method, args);
                break;
            }
            default: {
                this.checkSurrogateClosed();
                result = method.invoke(this.delegate, args);
            }
        }
        return result;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    protected void checkSurrogateClosed() throws Throwable {
        if (this.isClosedSurrogate()) {
            throw new SQLException("Surrogate Closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSurrogate() throws Throwable {
        if (this.surrogateClosed) {
            return;
        }
        if (this.resultSets != null) {
            for (WrapperInvocationHandler handler : this.resultSets) {
                try {
                    ((ResultSet)handler.delegate).close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    handler.closeSurrogate();
                }
                catch (Exception e) {}
            }
        }
        if (this.statements != null) {
            for (WrapperInvocationHandler handler : this.statements) {
                try {
                    handler.closeSurrogate();
                }
                catch (Exception exception) {}
            }
        }
        if (this.dbmdHandler != null) {
            try {
                this.dbmdHandler.closeSurrogate();
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        Object delegate = this.delegate;
        try {
            if (delegate instanceof Connection) {
                this.closeConnectionSurrogate();
            } else if (delegate instanceof Statement) {
                this.closeStatementSurrogate();
            }
        }
        finally {
            this.delegate = null;
            this.surrogate = null;
            this.dbmdHandler = null;
            this.parentHandler = null;
            this.statementKey = null;
            this.statementPool = null;
            this.connectionPool = null;
            this.surrogateClosed = true;
        }
    }

    protected void closeConnectionSurrogate() throws Throwable {
        ConnectionPool connectionPool = this.connectionPool;
        if (connectionPool == null) {
            Connection connection = (Connection)this.delegate;
            try {
                connection.close();
            }
            catch (SQLException ex) {}
        } else {
            Connection connection = (Connection)this.delegate;
            StatementPool statementPool = this.statementPool;
            connectionPool.checkIn(connection, statementPool);
        }
    }

    protected void closeStatementSurrogate() throws Throwable {
        StatementPool statementPool;
        Statement stmt = (Statement)this.delegate;
        StatementKey key = this.statementKey;
        StatementPool statementPool2 = statementPool = this.parentHandler == null ? null : this.parentHandler.statementPool;
        if (key == null || statementPool == null || !statementPool.isPoolable(stmt)) {
            try {
                stmt.close();
            }
            catch (Exception ex) {}
        } else {
            statementPool.checkIn(key, stmt);
        }
    }

    protected boolean isClosedSurrogate() throws Throwable {
        if (this.surrogateClosed) {
            return true;
        }
        WrapperInvocationHandler parent = this.parentHandler;
        if (parent != null && parent.isClosedSurrogate()) {
            this.closeSurrogate();
        }
        return this.surrogateClosed;
    }

    protected Object getParentSurrogate(Method method, Object[] args) throws Throwable {
        WrapperInvocationHandler parent = this.parentHandler;
        return parent == null ? null : parent.surrogate;
    }

    protected Object getDatabaseMetaDataSurrogate(Method method, Object[] args) throws Throwable {
        if (this.dbmdHandler == null) {
            Object dbmd = method.invoke(this.delegate, args);
            this.dbmdHandler = new WrapperInvocationHandler(dbmd, this);
        }
        return this.dbmdHandler.surrogate;
    }

    protected Object getCreatedOrPreparedStatementSurrogate(Method method, Object[] args) throws Throwable {
        Object stmt = null;
        StatementKey key = new StatementKey(method, args);
        StatementPool pool = this.statementPool;
        if (pool != null) {
            stmt = pool.checkOut(key);
        }
        if (stmt == null) {
            stmt = method.invoke(this.delegate, args);
        }
        WrapperInvocationHandler handler = new WrapperInvocationHandler(stmt, this);
        handler.statementKey = key;
        if (this.statements == null) {
            this.statements = new HashSet();
        }
        this.statements.add(handler);
        return handler.surrogate;
    }

    protected Object getResultSetSurrogate(Method method, Object[] args) throws Throwable {
        Object rs = method.invoke(this.delegate, args);
        WrapperInvocationHandler handler = new WrapperInvocationHandler(rs, this);
        if (this.resultSets == null) {
            this.resultSets = new HashSet();
        }
        this.resultSets.add(handler);
        return handler.surrogate;
    }

    protected Object unwrapSurrogate(Method method, Object[] args) throws Throwable {
        Object result = method.invoke(this.delegate, args);
        return result == this.delegate ? this.surrogate : result;
    }

    protected Object getArraySurrogate(Method method, Object[] args) throws Throwable {
        Object array = method.invoke(this.delegate, args);
        WrapperInvocationHandler handler = new WrapperInvocationHandler(array, this);
        return handler.surrogate;
    }

    static {
        Class[] poolingSensitiveInterfaces = new Class[]{Array.class, CallableStatement.class, Connection.class, DatabaseMetaData.class, PreparedStatement.class, ResultSet.class, Statement.class};
        for (int i = 0; i < poolingSensitiveInterfaces.length; ++i) {
            Class clazz = poolingSensitiveInterfaces[i];
            Method[] methods = clazz.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Method method = methods[j];
                Class<?> returnType = method.getReturnType();
                if (WrapperInvocationHandler._isCloseSurrogateMethod(clazz, method)) {
                    methodMap.put(method, 1);
                    continue;
                }
                if (WrapperInvocationHandler._isIsClosedSurrogateMethod(clazz, method)) {
                    methodMap.put(method, 2);
                    continue;
                }
                if (Array.class.isAssignableFrom(returnType)) {
                    methodMap.put(method, 8);
                    continue;
                }
                if (Connection.class.isAssignableFrom(returnType)) {
                    methodMap.put(method, 3);
                    continue;
                }
                if (Statement.class.isAssignableFrom(returnType)) {
                    String methodName = method.getName();
                    if (methodName.startsWith("create") || methodName.startsWith("prepare")) {
                        methodMap.put(method, 5);
                        continue;
                    }
                    methodMap.put(method, 3);
                    continue;
                }
                if (ResultSet.class.isAssignableFrom(returnType)) {
                    methodMap.put(method, 6);
                    continue;
                }
                if (DatabaseMetaData.class.isAssignableFrom(returnType)) {
                    methodMap.put(method, 4);
                    continue;
                }
                if (!WrapperInvocationHandler._isUnwrapMethod(method)) continue;
                methodMap.put(method, 7);
            }
        }
    }

    public static interface ConnectionPool {
        public void checkIn(Connection var1, StatementPool var2);
    }

    public static interface StatementPool {
        public void checkIn(StatementKey var1, Statement var2);

        public Statement checkOut(StatementKey var1);

        public boolean isPoolable(Statement var1);
    }

    public final class StatementKey {
        private final Method method;
        private final Object[] args;
        private int hashCode;

        StatementKey(Method method, Object[] args) {
            this.method = method;
            this.args = args == null ? null : (Object[])args.clone();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int h = this.method.hashCode();
                if (this.args != null) {
                    for (int i = this.args.length - 1; i >= 0; --i) {
                        if (this.args[i] == null) continue;
                        h = 31 * h + this.args[i].hashCode();
                    }
                }
                this.hashCode = h;
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof StatementKey) {
                StatementKey other = (StatementKey)obj;
                return this.method.equals(other.method) && (this.args == other.args || Arrays.equals(this.args, other.args));
            }
            return false;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArgs() {
            return this.args == null ? null : (Object[])this.args.clone();
        }
    }
}

