/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.JDBCConnectionPoolDataSource;
import org.hsqldb.jdbc.pool.JDBCXAConnection;
import org.hsqldb.jdbc.pool.JDBCXAConnectionWrapper;
import org.hsqldb.jdbc.pool.JDBCXAResource;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;

public class JDBCXADataSource
extends JDBCConnectionPoolDataSource
implements XADataSource {
    private HashMap resources = new HashMap();

    public void addResource(Xid xid, JDBCXAResource xaResource) {
        this.resources.put(xid, xaResource);
    }

    public JDBCXAResource removeResource(Xid xid) {
        return (JDBCXAResource)this.resources.remove(xid);
    }

    Xid[] getPreparedXids() {
        Iterator it = this.resources.keySet().iterator();
        HashSet preparedSet = new HashSet();
        while (it.hasNext()) {
            Xid curXid = (Xid)it.next();
            if (((JDBCXAResource)this.resources.get((Object)curXid)).state != JDBCXAResource.XA_STATE_PREPARED) continue;
            preparedSet.add(curXid);
        }
        return (Xid[])preparedSet.toArray(new Xid[0]);
    }

    JDBCXAResource getResource(Xid xid) {
        return (JDBCXAResource)this.resources.get(xid);
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        System.err.print("Executing " + this.getClass().getName() + ".getXAConnection()...");
        try {
            Class.forName("org.hsqldb.jdbc.JDBCDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Error opening connection: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Error opening connection: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new SQLException("Error opening connection: " + e.getMessage());
        }
        JDBCConnection connection = (JDBCConnection)DriverManager.getConnection(this.url, this.connProperties);
        System.err.print("New phys:  " + connection);
        JDBCXAResource xaResource = new JDBCXAResource(connection, this);
        JDBCXAConnectionWrapper xaWrapper = new JDBCXAConnectionWrapper(connection, xaResource, this.connectionDefaults);
        JDBCXAConnection xaConnection = new JDBCXAConnection(xaWrapper, xaResource);
        xaWrapper.setPooledConnection(xaConnection);
        return xaConnection;
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        this.validateSpecifiedUserAndPassword(user, password);
        return this.getXAConnection();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        throw new SQLException("Use the getXAConnections to get XA Connections.\nUse the class JDBCConnectionPoolDataSource for non-XA data sources.");
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        throw new SQLException("Use the getXAConnections to get XA Connections.\nUse the class JDBCConnectionPoolDataSource for non-XA data sources.");
    }
}

