/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.ConnectionDefaults;
import org.hsqldb.jdbc.pool.JDBCXAResource;
import org.hsqldb.jdbc.pool.LifeTimeConnectionWrapper;

public class JDBCXAConnectionWrapper
extends LifeTimeConnectionWrapper {
    private JDBCXAResource xaResource;

    public JDBCXAConnectionWrapper(JDBCConnection connection, JDBCXAResource xaResource, ConnectionDefaults connectionDefaults) throws SQLException {
        super(connection, connectionDefaults);
        this.xaResource = xaResource;
    }

    private void validateNotWithinTransaction() throws SQLException {
        if (this.xaResource.withinGlobalTransaction()) {
            throw new SQLException("Method prohibited within a global transaction");
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.validateNotWithinTransaction();
        super.setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        this.validateNotWithinTransaction();
        super.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.validateNotWithinTransaction();
        super.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateNotWithinTransaction();
        super.rollback(savepoint);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.validateNotWithinTransaction();
        return super.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.validateNotWithinTransaction();
        return super.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.validateNotWithinTransaction();
        super.setTransactionIsolation(level);
    }
}

