/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.ConnectionDefaults;
import org.hsqldb.jdbc.pool.JDBCPooledConnection;
import org.hsqldb.jdbc.pool.LifeTimeConnectionWrapper;

public class JDBCConnectionPoolDataSource
implements ConnectionPoolDataSource {
    public static final String driver = "org.hsqldb.jdbc.JDBCDriver";
    protected String url = null;
    protected ConnectionDefaults connectionDefaults = null;
    private int loginTimeout = 0;
    private PrintWriter logWriter = null;
    protected Properties connProperties = new Properties();

    public JDBCConnectionPoolDataSource() {
    }

    public JDBCConnectionPoolDataSource(String url, String user, String password, ConnectionDefaults connectionDefaults) throws SQLException {
        this.url = url;
        this.connectionDefaults = connectionDefaults;
        this.setUser(user);
        this.setPassword(password);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.connProperties.getProperty("user");
    }

    public void setUser(String user) {
        this.connProperties.setProperty("user", user);
    }

    public String getPassword() {
        return this.connProperties.getProperty("password");
    }

    public void setPassword(String password) {
        this.connProperties.setProperty("password", password);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Error opening connection: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Error opening connection: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new SQLException("Error opening connection: " + e.getMessage());
        }
        JDBCConnection connection = (JDBCConnection)DriverManager.getConnection(this.url, this.connProperties);
        return this.createPooledConnection(connection);
    }

    protected void validateSpecifiedUserAndPassword(String user, String password) throws SQLException {
        String configuredUser = this.connProperties.getProperty("user");
        String configuredPassword = this.connProperties.getProperty("password");
        if (user == null && configuredUser != null || user != null && configuredUser == null || user != null && !user.equals(configuredUser) || password == null && configuredPassword != null || password != null && configuredPassword == null || password != null && !password.equals(configuredPassword)) {
            throw new SQLException("Given user name or password does not match those configured for this object");
        }
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        this.validateSpecifiedUserAndPassword(user, password);
        return this.getPooledConnection();
    }

    public void close() {
    }

    protected void logInfo(String message) {
        if (this.logWriter != null) {
            this.logWriter.write("HSQLDB:Info: " + message + '\n');
            this.logWriter.flush();
        }
    }

    protected void logInfo(Throwable t) {
        if (this.logWriter != null) {
            t.printStackTrace(this.logWriter);
            this.logWriter.flush();
        }
    }

    protected void logInfo(String message, Throwable t) {
        if (this.logWriter != null) {
            this.logWriter.write("HSQLDB:Exception: " + message + '\n');
            this.logWriter.flush();
            this.logInfo(t);
        }
    }

    public Object setConnectionProperty(String name, String value) {
        return this.connProperties.setProperty(name, value);
    }

    public Object removeConnectionProperty(String name) {
        return this.connProperties.remove(name);
    }

    public Properties getConnectionProperties() {
        return this.connProperties;
    }

    public void setDatabase(String url) {
        this.setUrl(url);
    }

    public String getDatabase() {
        return this.getUrl();
    }

    private PooledConnection createPooledConnection(JDBCConnection connection) throws SQLException {
        LifeTimeConnectionWrapper connectionWrapper = new LifeTimeConnectionWrapper(connection, this.connectionDefaults);
        JDBCPooledConnection pooledConnection = new JDBCPooledConnection(connectionWrapper);
        connectionWrapper.setPooledConnection(pooledConnection);
        return pooledConnection;
    }
}

