/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.ColumnBase;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCNClob;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCResultSetMetaData;
import org.hsqldb.jdbc.JDBCSQLXML;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.StringInputStream;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class JDBCResultSet
implements ResultSet {
    private RowSetNavigator navigator;
    private ResultMetaData resultMetaData;
    int columnCount;
    private boolean wasNullValue;
    private ResultSetMetaData resultSetMetaData;
    private HsqlProperties connProperties;
    private IntValueHashMap columnMap;
    protected SQLWarning rootWarning;
    private Result result;
    JDBCStatementBase statement;
    SessionInterface session;
    int rsScrollabilty;
    int rsConcurrency;
    int rsHoldability;
    boolean rsInsertability;
    int fetchSize;
    boolean autoClose;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;
    JDBCPreparedStatement preparedStatement;
    boolean isRowUpdated;
    boolean isOnInsertRow;
    int currentUpdateRowNumber;

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
        return this.navigator.next();
    }

    @Override
    public void close() throws SQLException {
        if (this.navigator == null) {
            return;
        }
        this.navigator.close();
        this.navigator = null;
        if (this.autoClose && this.statement != null) {
            this.statement.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNullValue;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return (String)this.getColumnInType(columnIndex, Type.SQL_VARCHAR);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_BOOLEAN);
        return o == null ? false : (Boolean)o;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.TINYINT);
        return o == null ? (byte)0 : ((Number)o).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_SMALLINT);
        return o == null ? (short)0 : ((Number)o).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_INTEGER);
        return o == null ? 0 : ((Number)o).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_BIGINT);
        return o == null ? 0L : ((Number)o).longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_DOUBLE);
        return o == null ? 0.0f : ((Number)o).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_DOUBLE);
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (scale < 0) {
            throw Util.outOfRangeArgument();
        }
        NumberType targetType = NumberType.getNumberType(3, 100L, scale);
        BigDecimal bd = (BigDecimal)this.getColumnInType(columnIndex, targetType);
        if (bd != null) {
            bd = bd.setScale(scale, 1);
        }
        return bd;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object x = this.getColumnInType(columnIndex, Type.SQL_VARBINARY);
        if (x == null) {
            return null;
        }
        return ((BinaryData)x).getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(columnIndex, Type.SQL_DATE);
        if (t == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, t);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        TimeData t = (TimeData)this.getColumnInType(columnIndex, Type.SQL_TIME);
        if (t == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, t);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(columnIndex, Type.SQL_TIMESTAMP);
        if (t == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, t);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(s.getBytes("US-ASCII"));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringInputStream(s);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] b = this.getBytes(columnIndex);
        return this.wasNull() ? null : new ByteArrayInputStream(b);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        return this.result.getMainString();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultSetMetaData == null) {
            boolean isUpdatable = this.rsConcurrency == 1008;
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, isUpdatable, this.rsInsertability, this.connProperties);
        }
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        switch (sourceType.typeCode) {
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: 
            case 94: {
                return this.getTime(columnIndex);
            }
            case 93: 
            case 95: {
                return this.getTimestamp(columnIndex);
            }
            case 60: 
            case 61: {
                return this.getBytes(columnIndex);
            }
            case 14: {
                return this.getBoolean(columnIndex);
            }
            case 1111: 
            case 2000: {
                Object o = this.getColumnInType(columnIndex, sourceType);
                if (o == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)o).getObject();
                }
                catch (HsqlException e) {
                    throw Util.sqlException(e);
                }
            }
        }
        return this.getColumnInType(columnIndex, sourceType);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int columnIndex;
        this.checkClosed();
        if (columnLabel == null) {
            throw Util.nullArgument();
        }
        if (this.columnMap != null && (columnIndex = this.columnMap.get((Object)columnLabel, -1)) != -1) {
            return columnIndex;
        }
        String[] colLabels = this.resultMetaData.columnLabels;
        columnIndex = -1;
        for (int i = 0; i < this.columnCount; ++i) {
            if (!columnLabel.equalsIgnoreCase(colLabels[i])) continue;
            columnIndex = i;
            break;
        }
        ColumnBase[] columns = this.resultMetaData.columns;
        if (columnIndex < 0) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (!columnLabel.equalsIgnoreCase(columns[i].getNameString())) continue;
                columnIndex = i;
                break;
            }
        }
        if (columnIndex < 0) {
            int position = columnLabel.indexOf(46);
            if (position < 0) {
                throw Util.sqlException(28, columnLabel);
            }
            for (int i = 0; i < this.columnCount; ++i) {
                String match;
                String tabName = columns[i].getTableNameString();
                if (tabName == null || tabName.length() == 0) continue;
                String colName = columns[i].getNameString();
                if (columnLabel.equalsIgnoreCase(tabName + '.' + colName)) {
                    columnIndex = i;
                    break;
                }
                String schemName = columns[i].getSchemaNameString();
                if (schemName == null || schemName.length() == 0 || !columnLabel.equalsIgnoreCase(match = new StringBuffer(schemName).append('.').append(tabName).append('.').append(colName).toString())) continue;
                columnIndex = i;
                break;
            }
        }
        if (columnIndex < 0) {
            throw Util.sqlException(28, columnLabel);
        }
        ++columnIndex;
        if (this.columnMap == null) {
            this.columnMap = new IntValueHashMap();
        }
        this.columnMap.put(columnLabel, columnIndex);
        return columnIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringReader(s);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Type targetType = this.resultMetaData.columnTypes[columnIndex - 1];
        if (targetType.typeCode != 2 && targetType.typeCode != 3) {
            targetType = Type.SQL_DECIMAL_DEFAULT;
        }
        return (BigDecimal)this.getColumnInType(columnIndex, targetType);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        this.navigator.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        this.navigator.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        return this.navigator.first();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        return this.navigator.last();
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.navigator.isAfterLast()) {
            return 0;
        }
        return this.navigator.getRowNumber() + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        if (row > 0) {
            --row;
        } else if (row == 0) {
            return this.navigator.beforeFirst();
        }
        return this.navigator.absolute(row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        return this.navigator.relative(rows);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        this.rootWarning = null;
        return this.navigator.previous();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        switch (direction) {
            case 1000: {
                break;
            }
            case 1001: {
                this.checkNotForwardOnly();
                break;
            }
            case 1002: {
                this.checkNotForwardOnly();
                break;
            }
            default: {
                throw Util.notSupported();
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw Util.outOfRangeArgument();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return this.rsScrollabilty;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.rsConcurrency;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return this.isRowUpdated;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, null);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        Boolean value = x ? Boolean.TRUE : Boolean.FALSE;
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, value);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setIntParameter(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setIntParameter(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setIntParameter(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setLongParameter(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        Double value = new Double(x);
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, value);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        Double value = new Double(x);
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, value);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setObject(columnIndex, x, 0, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.updateNull(this.findColumn(columnLabel));
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.updateShort(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.updateInt(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.updateLong(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.updateString(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.performInsert();
    }

    @Override
    public void updateRow() throws SQLException {
        this.performUpdate();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.performDelete();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.startInsert();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.endInsert();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return (Statement)((Object)this.statement);
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        Object o = this.getColumnInType(columnIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof BlobDataID) {
            return new JDBCBlobClient(this.session, (BlobDataID)o);
        }
        if (o instanceof Blob) {
            return (Blob)o;
        }
        if (o instanceof BinaryData) {
            byte[] b = this.getBytes(columnIndex);
            return new JDBCBlob(b);
        }
        throw Util.sqlException(5561);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        Object o = this.getColumnInType(columnIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof ClobDataID) {
            return new JDBCClobClient(this.session, (ClobDataID)o);
        }
        if (o instanceof Clob) {
            return (Clob)o;
        }
        if (o instanceof String) {
            return new JDBCClob((String)o);
        }
        throw Util.sqlException(5561);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw Util.notSupported();
    }

    public Object getObject(String columnLabel, Map map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(columnIndex, Type.SQL_DATE);
        if (t == null) {
            return null;
        }
        long millis = t.getSeconds() * 1000L;
        if (cal != null) {
            millis = HsqlDateTime.convertMillisToCalendar(cal, millis);
        }
        return new Date(millis);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        TimeData t = (TimeData)this.getColumnInType(columnIndex, Type.SQL_TIME);
        if (t == null) {
            return null;
        }
        long millis = DateTimeType.normaliseTime(t.getSeconds()) * 1000;
        if (!this.resultMetaData.columnTypes[--columnIndex].isDateTimeTypeWithZone()) {
            Calendar calendar = cal == null ? this.session.getCalendar() : cal;
            millis = HsqlDateTime.convertMillisToCalendar(calendar, millis);
            millis = HsqlDateTime.getNormalisedTime(millis);
        }
        return new Time(millis);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(columnIndex, Type.SQL_TIMESTAMP);
        if (t == null) {
            return null;
        }
        long millis = t.getSeconds() * 1000L;
        if (!this.resultMetaData.columnTypes[--columnIndex].isDateTimeTypeWithZone()) {
            Calendar calendar;
            Calendar calendar2 = calendar = cal == null ? this.session.getCalendar() : cal;
            if (cal != null) {
                millis = HsqlDateTime.convertMillisToCalendar(calendar, millis);
            }
        }
        Timestamp ts = new Timestamp(millis);
        ts.setNanos(t.getNanos());
        return ts;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        if (x instanceof JDBCBlobClient) {
            throw Util.sqlException(62, "invalid Blob");
        }
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlobParameter(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.updateBlob(columnIndex, x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        if (x instanceof JDBCClobClient) {
            throw Util.sqlException(62, "invalid Clob");
        }
        this.startUpdate(columnIndex);
        this.preparedStatement.setClobParameter(columnIndex, x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.updateClob(columnIndex, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.navigator == null;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.updateString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.updateString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.updateClob(columnIndex, (Clob)nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.updateClob(columnLabel, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        return s == null ? null : new JDBCNClob(s);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        SQLXML sqlxml;
        this.checkColumn(columnIndex);
        int type = this.resultMetaData.columnTypes[columnIndex - 1].typeCode;
        switch (type) {
            case 137: {
                Object object = this.getObject(columnIndex);
                if (object == null) {
                    sqlxml = null;
                    break;
                }
                if (object instanceof SQLXML) {
                    sqlxml = (SQLXML)object;
                    break;
                }
                throw Util.notSupported();
            }
            case 40: {
                Clob clob = this.getClob(columnIndex);
                if (clob == null) {
                    sqlxml = null;
                    break;
                }
                sqlxml = new JDBCSQLXML(clob.getCharacterStream());
                break;
            }
            case 1: 
            case 12: 
            case 100: {
                Reader reader = this.getCharacterStream(columnIndex);
                if (reader == null) {
                    sqlxml = null;
                    break;
                }
                sqlxml = new JDBCSQLXML(reader);
                break;
            }
            case -9: 
            case -8: {
                Reader nreader = this.getNCharacterStream(columnIndex);
                if (nreader == null) {
                    sqlxml = null;
                    break;
                }
                sqlxml = new JDBCSQLXML(nreader);
                break;
            }
            case 30: {
                Blob blob = this.getBlob(columnIndex);
                if (blob == null) {
                    sqlxml = null;
                    break;
                }
                sqlxml = new JDBCSQLXML(blob.getBinaryStream());
                break;
            }
            case 60: 
            case 61: {
                InputStream inputStream = this.getBinaryStream(columnIndex);
                if (inputStream == null) {
                    sqlxml = null;
                    break;
                }
                sqlxml = new JDBCSQLXML(inputStream);
                break;
            }
            case 1111: 
            case 2000: {
                Object data = this.getObject(columnIndex);
                if (data == null) {
                    sqlxml = null;
                    break;
                }
                if (data instanceof SQLXML) {
                    sqlxml = (SQLXML)data;
                    break;
                }
                if (data instanceof String) {
                    sqlxml = new JDBCSQLXML((String)data);
                    break;
                }
                if (data instanceof byte[]) {
                    sqlxml = new JDBCSQLXML((byte[])data);
                    break;
                }
                if (data instanceof Blob) {
                    Blob blob = (Blob)data;
                    sqlxml = new JDBCSQLXML(blob.getBinaryStream());
                    break;
                }
                if (data instanceof Clob) {
                    Clob clob = (Clob)data;
                    sqlxml = new JDBCSQLXML(clob.getCharacterStream());
                    break;
                }
                throw Util.notSupported();
            }
            default: {
                throw Util.notSupported();
            }
        }
        return sqlxml;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    private Object[] getCurrent() throws SQLException {
        RowSetNavigator lnavigator = this.navigator;
        if (lnavigator == null) {
            throw Util.sqlException(3601);
        }
        if (lnavigator.isEmpty()) {
            throw Util.sqlException(3603, 410);
        }
        if (lnavigator.isBeforeFirst()) {
            throw Util.sqlException(3603, 411);
        }
        if (lnavigator.isAfterLast()) {
            throw Util.sqlException(3603, 412);
        }
        Object[] data = lnavigator.getCurrent();
        if (data == null) {
            throw Util.sqlException(3601);
        }
        return data;
    }

    private void checkClosed() throws SQLException {
        if (this.navigator == null) {
            throw Util.sqlException(3601);
        }
    }

    private void checkColumn(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw Util.sqlException(28, String.valueOf(columnIndex));
        }
    }

    private boolean trackNull(Object o) {
        this.wasNullValue = o == null;
        return this.wasNullValue;
    }

    private Object getColumnInType(int columnIndex, Type targetType) throws SQLException {
        Object[] rowData = this.getCurrent();
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[--columnIndex];
        Object value = rowData[columnIndex];
        if (this.trackNull(value)) {
            return null;
        }
        if (sourceType.typeCode != targetType.typeCode) {
            try {
                value = targetType.convertToTypeJDBC(this.session, value, sourceType);
            }
            catch (Exception e) {
                String stringValue = value instanceof Number || value instanceof String ? value.toString() : "instance of " + value.getClass().getName();
                String msg = "from SQL type " + sourceType.getNameString() + " to " + targetType.getJDBCClassName() + ", value: " + stringValue;
                Util.throwError(Error.error(5561, msg));
            }
        }
        return value;
    }

    private void checkNotForwardOnly() throws SQLException {
        if (this.rsScrollabilty == 1003) {
            throw Util.notSupported();
        }
    }

    private void checkUpdatable() throws SQLException {
        this.checkClosed();
        if (this.rsConcurrency == 1007) {
            throw Util.notUpdatableColumn();
        }
    }

    private void checkUpdatable(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumn(columnIndex);
        if (this.rsConcurrency == 1007) {
            throw Util.notUpdatableColumn();
        }
        if (this.resultMetaData.colIndexes[--columnIndex] == -1) {
            throw Util.notUpdatableColumn();
        }
        if (!this.resultMetaData.columns[columnIndex].isWriteable()) {
            throw Util.notUpdatableColumn();
        }
    }

    void startUpdate(int columnIndex) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (this.currentUpdateRowNumber != this.navigator.getRowNumber()) {
            this.preparedStatement.clearParameters();
        }
        this.currentUpdateRowNumber = this.navigator.getRowNumber();
        this.isRowUpdated = true;
    }

    private void clearUpdates() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isRowUpdated = false;
    }

    private void startInsert() throws SQLException {
        this.checkUpdatable();
        this.isOnInsertRow = true;
    }

    private void endInsert() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isOnInsertRow = false;
    }

    private void performUpdate() throws SQLException {
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            boolean set = this.preparedStatement.parameterSet[i] || this.preparedStatement.parameterStream[i];
            this.preparedStatement.resultOut.metaData.columnTypes[i] = set ? this.preparedStatement.parameterTypes[i] : Type.SQL_ALL_TYPES;
        }
        this.preparedStatement.resultOut.setActionType(81);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
        this.isRowUpdated = false;
    }

    private void performInsert() throws SQLException {
        this.checkUpdatable();
        for (int i = 0; i < this.columnCount; ++i) {
            boolean set;
            boolean bl = set = this.preparedStatement.parameterSet[i] || this.preparedStatement.parameterStream[i];
            if (!set) {
                throw Util.sqlException(3606);
            }
            this.preparedStatement.resultOut.metaData.columnTypes[i] = this.preparedStatement.parameterTypes[i];
        }
        this.preparedStatement.resultOut.setActionType(50);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    private void performDelete() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        this.preparedStatement.resultOut.metaData.columnTypes[this.columnCount] = this.resultMetaData.columnTypes[this.columnCount];
        this.preparedStatement.resultOut.setActionType(18);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    RowSetNavigator getNavigator() {
        return this.navigator;
    }

    void setNavigator(RowSetNavigator navigator) {
        this.navigator = navigator;
    }

    JDBCResultSet(SessionInterface session, JDBCStatementBase s, Result r, ResultMetaData metaData, HsqlProperties props) throws SQLException {
        this.session = session;
        this.statement = s;
        this.result = r;
        this.connProperties = props;
        this.rsScrollabilty = r.rsScrollability;
        this.rsConcurrency = r.rsConcurrency;
        this.rsHoldability = r.rsHoldability;
        this.navigator = r.getNavigator();
        this.resultMetaData = metaData;
        this.columnCount = this.resultMetaData.getColumnCount();
        if (this.rsConcurrency == 1008) {
            this.rsInsertability = true;
            for (int i = 0; i < metaData.colIndexes.length; ++i) {
                if (metaData.colIndexes[i] >= 0) continue;
                this.rsInsertability = false;
                break;
            }
            this.preparedStatement = new JDBCPreparedStatement(s.connection, this.result);
        }
    }
}

