/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.BlobInputStream;
import org.hsqldb.jdbc.ClobInputStream;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCParameterMetaData;
import org.hsqldb.jdbc.JDBCResultSetMetaData;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class JDBCPreparedStatement
extends JDBCStatementBase
implements PreparedStatement {
    boolean poolable = true;
    protected Object[] parameterValues;
    protected boolean[] parameterSet;
    protected boolean[] parameterStream;
    protected Type[] parameterTypes;
    protected byte[] parameterModes;
    protected long[] streamLengths;
    protected boolean hasStreams;
    protected boolean hasLOBs;
    protected boolean isBatch;
    protected ResultMetaData resultMetaData;
    protected ResultMetaData parameterMetaData;
    protected JDBCResultSetMetaData resultSetMetaData;
    protected Object pmd;
    protected String sql;
    protected long statementID;
    protected int statementRetType;
    protected final boolean isResult;
    protected SessionInterface session;

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        this.checkStatementType(2);
        this.fetchResult();
        return this.getResultSet();
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        this.checkStatementType(1);
        this.fetchResult();
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public synchronized void setBoolean(int parameterIndex, boolean x) throws SQLException {
        Boolean b = x ? Boolean.TRUE : Boolean.FALSE;
        this.setParameter(parameterIndex, b);
    }

    @Override
    public synchronized void setByte(int parameterIndex, byte x) throws SQLException {
        this.setIntParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setShort(int parameterIndex, short x) throws SQLException {
        this.setIntParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setInt(int parameterIndex, int x) throws SQLException {
        this.setIntParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setLong(int parameterIndex, long x) throws SQLException {
        this.setLongParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setFloat(int parameterIndex, float x) throws SQLException {
        this.setDouble(parameterIndex, x);
    }

    @Override
    public synchronized void setDouble(int parameterIndex, double x) throws SQLException {
        Double d = new Double(x);
        this.setParameter(parameterIndex, d);
    }

    @Override
    public synchronized void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, true);
        if (x == null) {
            throw Util.nullArgument("x");
        }
        try {
            String s = StringConverter.inputStreamToString(x, "US-ASCII");
            if (s.length() > length) {
                s = s.substring(0, length);
            }
            this.setParameter(parameterIndex, s);
        }
        catch (IOException e) {
            throw Util.sqlException(34);
        }
    }

    @Override
    public synchronized void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, true);
        Object msg = null;
        int ver = 4;
        if (x == null) {
            throw Util.nullArgument("x");
        }
        String encoding = "UTF8";
        StringWriter writer = new StringWriter();
        try {
            int charsRead;
            CountdownInputStream cis = new CountdownInputStream(x);
            InputStreamReader reader = new InputStreamReader((InputStream)cis, encoding);
            char[] buff = new char[1024];
            cis.setCount(length);
            while (-1 != (charsRead = reader.read(buff))) {
                writer.write(buff, 0, charsRead);
            }
        }
        catch (IOException ex) {
            throw Util.sqlException(19, ex.toString());
        }
        this.setParameter(parameterIndex, writer.toString());
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        this.checkClosed();
        ArrayUtil.fillArray(this.parameterValues, null);
        ArrayUtil.clearArray(90, this.parameterSet, 0, this.parameterSet.length);
        ArrayUtil.clearArray(90, this.parameterStream, 0, this.parameterStream.length);
        ArrayUtil.clearArray(74, this.streamLengths, 0, this.parameterStream.length);
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x, scaleOrLength);
        } else if (x instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)x, scaleOrLength);
        } else {
            this.setObject(parameterIndex, x);
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        this.fetchResult();
        return this.statementRetType == 2;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        this.checkClosed();
        this.checkParametersSet();
        if (!this.isBatch) {
            this.resultOut.setBatchedPreparedExecuteRequest();
            this.isBatch = true;
        }
        try {
            this.performPreExecute();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
        int len = this.parameterValues.length;
        Object[] batchParamValues = new Object[len];
        System.arraycopy(this.parameterValues, 0, batchParamValues, 0, len);
        this.resultOut.addBatchedPreparedExecuteRequest(batchParamValues);
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, false);
        Type outType = this.parameterTypes[parameterIndex - 1];
        switch (outType.typeCode) {
            case 60: 
            case 61: {
                this.setBlobForBinaryParameter(parameterIndex, x);
                return;
            }
            case 30: {
                this.setBlobParameter(parameterIndex, x);
                break;
            }
            default: {
                throw Util.invalidArgument();
            }
        }
    }

    private void setBlobForBinaryParameter(int parameterIndex, Blob x) throws SQLException {
        if (x instanceof JDBCBlob) {
            this.setParameter(parameterIndex, ((JDBCBlob)x).data());
            return;
        }
        if (x == null) {
            this.setParameter(parameterIndex, null);
            return;
        }
        this.checkSetParameterIndex(parameterIndex, true);
        long length = x.length();
        if (length > Integer.MAX_VALUE) {
            String msg = "Maximum Blob input octet length exceeded: " + length;
            throw Util.sqlException(34, msg);
        }
        try {
            InputStream in = x.getBinaryStream();
            HsqlByteArrayOutputStream out = new HsqlByteArrayOutputStream(in, (int)length);
            this.setParameter(parameterIndex, out.toByteArray());
        }
        catch (IOException e) {
            throw Util.sqlException(34, e.toString());
        }
    }

    @Override
    public synchronized void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, false);
        Type outType = this.parameterTypes[parameterIndex - 1];
        switch (outType.typeCode) {
            case 1: 
            case 12: {
                this.setClobForStringParameter(parameterIndex, x);
                return;
            }
            case 40: {
                this.setClobParameter(parameterIndex, x);
                return;
            }
        }
        throw Util.invalidArgument();
    }

    private void setClobForStringParameter(int parameterIndex, Clob x) throws SQLException {
        if (x instanceof JDBCClob) {
            this.setParameter(parameterIndex, ((JDBCClob)x).data());
            return;
        }
        if (x == null) {
            this.setParameter(parameterIndex, null);
            return;
        }
        this.checkSetParameterIndex(parameterIndex, false);
        long length = x.length();
        if (length > Integer.MAX_VALUE) {
            String msg = "Max Clob input character length exceeded: " + length;
            throw Util.sqlException(34, msg);
        }
        try {
            Reader reader = x.getCharacterStream();
            CharArrayWriter writer = new CharArrayWriter(reader, (int)length);
            this.setParameter(parameterIndex, writer.toString());
        }
        catch (IOException e) {
            throw Util.sqlException(19, e.toString());
        }
    }

    @Override
    public synchronized void setArray(int parameterIndex, Array x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.statementRetType != 2) {
            return null;
        }
        if (this.resultSetMetaData == null) {
            boolean isUpdatable = this.rsConcurrency == 1008;
            boolean isInsertable = isUpdatable;
            if (isInsertable) {
                for (int i = 0; i < this.resultMetaData.colIndexes.length; ++i) {
                    if (this.resultMetaData.colIndexes[i] >= 0) continue;
                    isInsertable = false;
                    break;
                }
            }
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, isUpdatable, isInsertable, this.connection.connProperties);
        }
        return this.resultSetMetaData;
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, false);
        int i = parameterIndex - 1;
        if (x == null) {
            this.parameterValues[i] = null;
            return;
        }
        Type outType = this.parameterTypes[i];
        long millis = HsqlDateTime.convertToNormalisedDate(x.getTime(), cal);
        int zoneOffset = HsqlDateTime.getZoneMillis(cal, millis);
        switch (outType.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                break;
            }
            default: {
                throw Util.sqlException(5561);
            }
        }
        this.parameterValues[i] = new TimestampData((millis + (long)zoneOffset) / 1000L);
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, false);
        int i = parameterIndex - 1;
        if (x == null) {
            this.parameterValues[i] = null;
            return;
        }
        Type outType = this.parameterTypes[i];
        long millis = x.getTime();
        int zoneOffset = 0;
        Calendar calendar = cal == null ? this.session.getCalendar() : cal;
        millis = HsqlDateTime.convertMillisFromCalendar(calendar, millis);
        millis = HsqlDateTime.convertToNormalisedTime(millis);
        switch (outType.typeCode) {
            case 92: {
                break;
            }
            case 94: {
                zoneOffset = HsqlDateTime.getZoneMillis(calendar, millis);
                break;
            }
            default: {
                throw Util.sqlException(5561);
            }
        }
        this.parameterValues[i] = new TimeData((int)(millis / 1000L), 0, zoneOffset / 1000);
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkSetParameterIndex(parameterIndex, false);
        int i = parameterIndex - 1;
        if (x == null) {
            this.parameterValues[i] = null;
            return;
        }
        Type outType = this.parameterTypes[i];
        long millis = x.getTime();
        int zoneOffset = 0;
        Calendar calendar = cal == null ? this.session.getCalendar() : cal;
        millis = HsqlDateTime.convertMillisFromCalendar(calendar, millis);
        switch (outType.typeCode) {
            case 93: {
                break;
            }
            case 95: {
                zoneOffset = HsqlDateTime.getZoneMillis(calendar, millis);
                break;
            }
            case 92: {
                this.parameterValues[i] = new TimeData((int)(millis / 1000L), x.getNanos(), 0);
                break;
            }
            case 94: {
                zoneOffset = HsqlDateTime.getZoneMillis(calendar, millis);
                this.parameterValues[i] = new TimeData((int)(millis / 1000L), x.getNanos(), zoneOffset / 1000);
                break;
            }
            default: {
                throw Util.sqlException(5561);
            }
        }
        this.parameterValues[i] = new TimestampData(millis / 1000L, x.getNanos(), zoneOffset / 1000);
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        this.checkClosed();
        this.checkStatementType(1);
        if (!this.isBatch) {
            throw Util.sqlExceptionSQL(1256);
        }
        this.generatedResult = null;
        int batchCount = this.resultOut.getNavigator().getSize();
        this.resultIn = null;
        try {
            this.resultIn = this.session.execute(this.resultOut);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
        finally {
            this.performPostExecute();
            this.resultOut.getNavigator().clear();
            this.isBatch = false;
        }
        if (this.resultIn.isError()) {
            throw Util.sqlException(this.resultIn);
        }
        RowSetNavigator navigator = this.resultIn.getNavigator();
        int[] updateCounts = new int[navigator.getSize()];
        for (int i = 0; i < updateCounts.length; ++i) {
            Object[] data = navigator.getNext();
            updateCounts[i] = (Integer)data[0];
        }
        if (updateCounts.length != batchCount) {
            if (this.errorResult == null) {
                throw new BatchUpdateException(updateCounts);
            }
            this.errorResult.getMainString();
            throw new BatchUpdateException(this.errorResult.getMainString(), this.errorResult.getSubString(), this.errorResult.getErrorCode(), updateCounts);
        }
        return updateCounts;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closeResultData();
        HsqlException he = null;
        try {
            if (!this.connection.isClosed) {
                this.session.execute(Result.newFreeStmtRequest(this.statementID));
            }
        }
        catch (HsqlException e) {
            he = e;
        }
        this.parameterValues = null;
        this.parameterSet = null;
        this.parameterStream = null;
        this.parameterTypes = null;
        this.parameterModes = null;
        this.resultMetaData = null;
        this.parameterMetaData = null;
        this.resultSetMetaData = null;
        this.pmd = null;
        this.connection = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
        if (he != null) {
            throw Util.sqlException(he);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        String sql = this.sql;
        Object[] pv = this.parameterValues;
        if (sql == null || pv == null) {
            sb.append("[closed]");
            return sb.toString();
        }
        sb.append("[sql=[").append(sql).append("]");
        if (pv.length > 0) {
            sb.append(", parameters=[");
            for (int i = 0; i < pv.length; ++i) {
                sb.append('[');
                sb.append(pv[i]);
                sb.append("], ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(']');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.pmd == null) {
            this.pmd = new JDBCParameterMetaData(this.parameterMetaData);
        }
        return (ParameterMetaData)this.pmd;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        return super.getMoreResults(current);
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        return this.getGeneratedResultSet();
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public synchronized void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public synchronized void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, value);
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public synchronized void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public synchronized void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            Util.sqlException(3401);
        }
        this.setAsciiStream(parameterIndex, x, (int)length);
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length < 0L) {
            throw Util.sqlException(62, "length: " + length);
        }
        if (x instanceof BlobInputStream) {
            throw Util.sqlException(62, "invalid InputStream");
        }
        this.checkSetParameterIndex(parameterIndex, true);
        if (this.parameterTypes[parameterIndex - 1].typeCode == 30) {
            this.streamLengths[parameterIndex - 1] = length;
            this.setParameter(parameterIndex, x);
            return;
        }
        try {
            if (length > Integer.MAX_VALUE) {
                String msg = "Maximum Blob input length exceeded: " + length;
                throw Util.sqlException(34, msg);
            }
            HsqlByteArrayOutputStream output = new HsqlByteArrayOutputStream(x, (int)length);
            this.setParameter(parameterIndex, output.toByteArray());
        }
        catch (IOException e) {
            throw Util.sqlException(34, e.toString());
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (length < 0L) {
            throw Util.sqlException(62, "length: " + length);
        }
        if (reader instanceof ClobInputStream) {
            throw Util.sqlException(62, "invalid Reader");
        }
        this.checkSetParameterIndex(parameterIndex, true);
        if (this.parameterTypes[parameterIndex - 1].typeCode == 40) {
            this.streamLengths[parameterIndex - 1] = length;
            this.setParameter(parameterIndex, reader);
            return;
        }
        try {
            if (length > Integer.MAX_VALUE) {
                String msg = "Maximum Clob input length exceeded: " + length;
                throw Util.sqlException(34, msg);
            }
            CharArrayWriter writer = new CharArrayWriter(reader, (int)length);
            this.setParameter(parameterIndex, writer.toString());
        }
        catch (IOException e) {
            throw Util.sqlException(34, e.toString());
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public synchronized void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw Util.outOfRangeArgument();
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw Util.outOfRangeArgument();
        }
        this.maxRows = max;
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        if (seconds < 0 || seconds > Short.MAX_VALUE) {
            throw Util.outOfRangeArgument();
        }
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        return super.getResultSet();
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return super.getUpdateCount();
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw Util.notSupported();
        }
        this.fetchDirection = direction;
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw Util.outOfRangeArgument();
        }
        this.fetchSize = rows;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public synchronized int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.rsConcurrency;
    }

    @Override
    public synchronized int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.rsScrollability;
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        this.checkClosed();
        if (this.isBatch) {
            this.resultOut.getNavigator().clear();
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public synchronized void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        this.poolable = poolable;
    }

    @Override
    public synchronized boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    JDBCPreparedStatement(JDBCConnection c, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int generatedKeys, int[] generatedIndexes, String[] generatedNames) throws HsqlException, SQLException {
        this.isResult = false;
        this.connection = c;
        this.session = c.sessionProxy;
        sql = c.nativeSQL(sql);
        int[] keyIndexes = null;
        if (generatedIndexes != null) {
            keyIndexes = new int[generatedIndexes.length];
            for (int i = 0; i < generatedIndexes.length; ++i) {
                keyIndexes[i] = generatedIndexes[i] - 1;
            }
        }
        this.resultOut = Result.newPrepareStatementRequest();
        this.resultOut.setPrepareOrExecuteProperties(sql, 0, 0, 0, this.queryTimeout, resultSetType, resultSetConcurrency, resultSetHoldability, generatedKeys, generatedIndexes, generatedNames);
        Result in = this.session.execute(this.resultOut);
        if (in.isError()) {
            throw Util.sqlException(in);
        }
        Result current = in;
        while (current.getChainedResult() != null) {
            if (!(current = current.getUnlinkChainedResult()).isWarning()) continue;
            SQLWarning w = Util.sqlWarning(current);
            if (this.rootWarning == null) {
                this.rootWarning = w;
                continue;
            }
            this.rootWarning.setNextWarning(w);
        }
        this.connection.setWarnings(this.rootWarning);
        this.statementID = in.getStatementID();
        this.statementRetType = in.getStatementType();
        this.resultMetaData = in.metaData;
        this.parameterMetaData = in.parameterMetaData;
        this.parameterTypes = this.parameterMetaData.getParameterTypes();
        this.parameterModes = this.parameterMetaData.paramModes;
        this.rsScrollability = in.rsScrollability;
        this.rsConcurrency = in.rsConcurrency;
        this.rsHoldability = in.rsHoldability;
        int paramCount = this.parameterMetaData.getColumnCount();
        this.parameterValues = new Object[paramCount];
        this.parameterSet = new boolean[paramCount];
        this.parameterStream = new boolean[paramCount];
        this.streamLengths = new long[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            if (!this.parameterTypes[i].isLobType()) continue;
            this.hasLOBs = true;
            break;
        }
        this.resultOut = Result.newPreparedExecuteRequest(this.parameterTypes, this.statementID);
        this.resultOut.setStatement(in.getStatement());
        this.sql = sql;
    }

    JDBCPreparedStatement(JDBCConnection c, Result result) {
        this.isResult = true;
        this.connection = c;
        this.session = c.sessionProxy;
        int paramCount = result.metaData.getExtendedColumnCount();
        this.parameterMetaData = result.metaData;
        this.parameterTypes = result.metaData.columnTypes;
        this.parameterModes = new byte[paramCount];
        this.parameterValues = new Object[paramCount];
        this.parameterSet = new boolean[paramCount];
        this.parameterStream = new boolean[paramCount];
        this.streamLengths = new long[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            this.parameterModes[i] = 1;
            if (!this.parameterTypes[i].isLobType()) continue;
            this.hasLOBs = true;
        }
        this.resultOut = Result.newUpdateResultRequest(this.parameterTypes, result.getResultId());
    }

    protected void checkStatementType(int type) throws SQLException {
        if (type != this.statementRetType) {
            if (this.statementRetType == 1) {
                throw Util.sqlException(1253);
            }
            throw Util.sqlException(1254);
        }
    }

    protected void checkSetParameterIndex(int i, boolean isStream) throws SQLException {
        this.checkClosed();
        if (i < 1 || i > this.parameterValues.length) {
            String msg = "parameter index out of range: " + i;
            throw Util.outOfRangeArgument(msg);
        }
        if (isStream) {
            this.parameterStream[i - 1] = true;
            this.parameterSet[i - 1] = false;
        } else {
            this.parameterStream[i - 1] = false;
            this.parameterSet[i - 1] = true;
        }
        byte mode = this.parameterModes[i - 1];
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                String msg = "Not IN or INOUT mode: " + mode + " for parameter: " + i;
                throw Util.invalidArgument(msg);
            }
        }
    }

    protected void checkGetParameterIndex(int i) throws SQLException {
        this.checkClosed();
        if (i < 1 || i > this.parameterValues.length) {
            String msg = "parameter index out of range: " + i;
            throw Util.outOfRangeArgument(msg);
        }
        byte mode = this.parameterModes[i - 1];
        switch (mode) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                String msg = "Not OUT or INOUT mode: " + mode + " for parameter: " + i;
                throw Util.invalidArgument(msg);
            }
        }
    }

    private void checkParametersSet() throws SQLException {
        if (this.isResult) {
            return;
        }
        for (int i = 0; i < this.parameterSet.length; ++i) {
            if (this.parameterModes[i] == 4 || this.parameterSet[i] || this.parameterStream[i]) continue;
            throw Util.sqlException(152);
        }
    }

    void setParameter(int i, Object o) throws SQLException {
        this.checkSetParameterIndex(i, false);
        --i;
        if (o == null) {
            this.parameterValues[i] = null;
            return;
        }
        Type outType = this.parameterTypes[i];
        switch (outType.typeCode) {
            case 1111: {
                try {
                    if (o instanceof Serializable) {
                        o = new JavaObjectData((Serializable)o);
                        break;
                    }
                }
                catch (HsqlException e) {
                    Util.throwError(e);
                }
                Util.throwError(Error.error(5565));
                break;
            }
            case 14: 
            case 15: {
                try {
                    if (o instanceof Boolean) {
                        o = outType.convertToDefaultType(this.session, o);
                        break;
                    }
                    if (o instanceof Integer) {
                        o = outType.convertToDefaultType(this.session, o);
                        break;
                    }
                    if (o instanceof byte[]) {
                        o = outType.convertToDefaultType(this.session, o);
                        break;
                    }
                    if (o instanceof String) {
                        o = outType.convertToDefaultType(this.session, o);
                        break;
                    }
                }
                catch (HsqlException e) {
                    Util.throwError(e);
                }
                Util.throwError(Error.error(5565));
            }
            case 60: 
            case 61: {
                if (o instanceof byte[]) {
                    o = new BinaryData((byte[])o, !this.connection.isNetConn);
                    break;
                }
                try {
                    if (o instanceof String) {
                        o = outType.convertToDefaultType(this.session, o);
                        break;
                    }
                }
                catch (HsqlException e) {
                    Util.throwError(e);
                }
                Util.throwError(Error.error(5565));
                break;
            }
            case 30: {
                this.setBlobParameter(i + 1, o);
                return;
            }
            case 40: {
                this.setClobParameter(i + 1, o);
                return;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                try {
                    if (o instanceof String) {
                        o = outType.convertToType(this.session, o, Type.SQL_VARCHAR);
                        break;
                    }
                    o = outType.convertJavaToSQL(this.session, o);
                    break;
                }
                catch (HsqlException e) {
                    Util.throwError(e);
                }
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                try {
                    if (o instanceof String) {
                        o = outType.convertToType(this.session, o, Type.SQL_VARCHAR);
                        break;
                    }
                    o = outType.convertToDefaultType(this.session, o);
                    break;
                }
                catch (HsqlException e) {
                    Util.throwError(e);
                }
            }
            default: {
                try {
                    o = outType.convertToDefaultType(this.session, o);
                    break;
                }
                catch (HsqlException e) {
                    Util.throwError(e);
                }
            }
        }
        this.parameterValues[i] = o;
    }

    void setClobParameter(int i, Object o) throws SQLException {
        if (o instanceof JDBCClobClient) {
            throw Util.sqlException(62, "invalid Clob");
        }
        if (o instanceof Clob) {
            this.parameterValues[i - 1] = o;
            this.parameterSet[i - 1] = true;
            return;
        }
        if (o instanceof ClobInputStream) {
            throw Util.sqlException(62, "invalid Reader");
        }
        if (o instanceof Reader) {
            this.parameterValues[i - 1] = o;
            this.parameterStream[i - 1] = true;
            return;
        }
        throw Util.invalidArgument();
    }

    void setBlobParameter(int i, Object o) throws SQLException {
        if (o instanceof JDBCBlobClient) {
            throw Util.sqlException(62, "invalid Clob");
        }
        if (o instanceof Blob) {
            this.parameterValues[i - 1] = o;
            this.parameterSet[i - 1] = true;
            return;
        }
        if (o instanceof BlobInputStream) {
            throw Util.sqlException(62, "invalid InputStream");
        }
        if (o instanceof InputStream) {
            this.parameterValues[i - 1] = o;
            this.parameterStream[i - 1] = true;
            return;
        }
        throw Util.invalidArgument();
    }

    void setIntParameter(int i, int value) throws SQLException {
        this.checkSetParameterIndex(i, false);
        int outType = this.parameterTypes[i - 1].typeCode;
        switch (outType) {
            case -6: 
            case 4: 
            case 5: {
                Integer o = new Integer(value);
                this.parameterValues[i - 1] = o;
                break;
            }
            case 25: {
                Long o = new Long(value);
                this.parameterValues[i - 1] = o;
                break;
            }
            case 60: 
            case 61: 
            case 1111: {
                throw Util.sqlException(Error.error(5565));
            }
            default: {
                this.setParameter(i, new Integer(value));
            }
        }
    }

    void setLongParameter(int i, long value) throws SQLException {
        this.checkSetParameterIndex(i, false);
        int outType = this.parameterTypes[i - 1].typeCode;
        switch (outType) {
            case 25: {
                Long o = new Long(value);
                this.parameterValues[i - 1] = o;
                break;
            }
            case 60: 
            case 61: 
            case 1111: {
                throw Util.sqlException(Error.error(5565));
            }
            default: {
                this.setParameter(i, new Long(value));
            }
        }
    }

    private void performPreExecute() throws SQLException, HsqlException {
        if (!this.hasLOBs) {
            return;
        }
        for (int i = 0; i < this.parameterValues.length; ++i) {
            Reader reader;
            ResultLob resultLob;
            long length;
            long id;
            Object value = this.parameterValues[i];
            if (value == null) continue;
            if (this.parameterTypes[i].typeCode == 30) {
                InputStream stream;
                BlobDataID blob = null;
                if (value instanceof JDBCBlobClient) {
                    blob = ((JDBCBlobClient)value).blob;
                    id = blob.getId();
                } else if (value instanceof Blob) {
                    length = ((Blob)value).length();
                    blob = this.session.createBlob(length);
                    id = blob.getId();
                    stream = ((Blob)value).getBinaryStream();
                    resultLob = ResultLob.newLobCreateBlobRequest(this.session.getId(), id, stream, length);
                    this.session.allocateResultLob(resultLob, null);
                    this.resultOut.addLobResult(resultLob);
                } else if (value instanceof InputStream) {
                    length = this.streamLengths[i];
                    blob = this.session.createBlob(length);
                    id = blob.getId();
                    stream = (InputStream)value;
                    resultLob = ResultLob.newLobCreateBlobRequest(this.session.getId(), id, stream, length);
                    this.session.allocateResultLob(resultLob, null);
                    this.resultOut.addLobResult(resultLob);
                }
                this.parameterValues[i] = blob;
                continue;
            }
            if (this.parameterTypes[i].typeCode != 40) continue;
            ClobDataID clob = null;
            if (value instanceof JDBCClobClient) {
                clob = ((JDBCClobClient)value).clob;
                id = clob.getId();
            } else if (value instanceof Clob) {
                length = ((Clob)value).length();
                reader = ((Clob)value).getCharacterStream();
                clob = this.session.createClob(length);
                id = clob.getId();
                resultLob = ResultLob.newLobCreateClobRequest(this.session.getId(), id, reader, length);
                this.session.allocateResultLob(resultLob, null);
                this.resultOut.addLobResult(resultLob);
            } else if (value instanceof Reader) {
                length = this.streamLengths[i];
                clob = this.session.createClob(length);
                id = clob.getId();
                reader = (Reader)value;
                resultLob = ResultLob.newLobCreateClobRequest(this.session.getId(), id, reader, length);
                this.session.allocateResultLob(resultLob, null);
                this.resultOut.addLobResult(resultLob);
            }
            this.parameterValues[i] = clob;
        }
    }

    void fetchResult() throws SQLException {
        this.checkClosed();
        this.closeResultData();
        this.checkParametersSet();
        if (this.isBatch) {
            throw Util.sqlExceptionSQL(1255);
        }
        if (this.isResult) {
            this.resultOut.setPreparedResultUpdateProperties(this.parameterValues);
        } else {
            this.resultOut.setPreparedExecuteProperties(this.parameterValues, this.maxRows, this.fetchSize);
        }
        try {
            this.performPreExecute();
            this.resultIn = this.session.execute(this.resultOut);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
        finally {
            this.performPostExecute();
        }
        if (this.resultIn.isError()) {
            throw Util.sqlException(this.resultIn);
        }
    }

    boolean isAnyParameterSet() {
        for (int i = 0; i < this.parameterValues.length; ++i) {
            if (!this.parameterSet[i]) continue;
            return true;
        }
        return false;
    }
}

