/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;
import org.hsqldb.jdbc.Util;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class JDBCParameterMetaData
implements ParameterMetaData,
Wrapper {
    ResultMetaData rmd;
    String[] classNames;
    int parameterCount;

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkRange(param);
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkRange(param);
        return this.rmd.columnTypes[--param].isNumberType();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkRange(param);
        Type type = this.rmd.columnTypes[--param];
        if (type.isDateTimeType()) {
            return type.displaySize();
        }
        long size = type.precision;
        if (size > Integer.MAX_VALUE) {
            size = 0L;
        }
        return (int)size;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkRange(param);
        return this.rmd.columnTypes[--param].scale;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkRange(param);
        return this.rmd.columnTypes[--param].getJDBCTypeCode();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkRange(param);
        return this.rmd.columnTypes[--param].getNameString();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkRange(param);
        return this.rmd.columnTypes[--param].getJDBCClassName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkRange(param);
        return this.rmd.paramModes[--param];
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    JDBCParameterMetaData(ResultMetaData metaData) throws SQLException {
        this.rmd = metaData;
        this.parameterCount = this.rmd.getColumnCount();
    }

    void checkRange(int param) throws SQLException {
        if (param < 1 || param > this.parameterCount) {
            String msg = param + " is out of range";
            throw Util.outOfRangeArgument(msg);
        }
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Throwable t) {
            return super.toString() + "[toStringImpl_exception=" + t + "]";
        }
    }

    private String toStringImpl() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        int count = this.getParameterCount();
        if (count == 0) {
            sb.append("[parameterCount=0]");
            return sb.toString();
        }
        Method[] methods = this.getClass().getDeclaredMethods();
        sb.append('[');
        int len = methods.length;
        for (int i = 0; i < count; ++i) {
            sb.append('\n');
            sb.append("    parameter_");
            sb.append(i + 1);
            sb.append('=');
            sb.append('[');
            for (int j = 0; j < len; ++j) {
                Method method = methods[j];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                sb.append(method.getName());
                sb.append('=');
                sb.append(method.invoke((Object)this, new Integer(i + 1)));
                if (j + 1 >= len) continue;
                sb.append(',');
                sb.append(' ');
            }
            sb.append(']');
            if (i + 1 >= count) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('\n');
        sb.append(']');
        return sb.toString();
    }
}

