/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.ClobInputStream;
import org.hsqldb.jdbc.Util;
import org.hsqldb.types.ClobDataID;

public class JDBCClobClient
implements Clob {
    ClobDataID clob;
    SessionInterface session;
    boolean isClosed;

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        return new ClobInputStream(this, 0L, this.length(), this.session.getStreamBlockSize());
    }

    @Override
    public synchronized String getSubString(long pos, int length) throws SQLException {
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, pos - 1L, length)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.clob.getSubString(this.session, pos - 1L, length);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized long length() throws SQLException {
        try {
            return this.clob.length(this.session);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized long position(String searchstr, long start) throws SQLException {
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, start - 1L, 0L)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.clob.position(this.session, searchstr, start - 1L);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized long position(Clob searchstr, long start) throws SQLException {
        return this.position(searchstr.getSubString(0L, (int)searchstr.length()), start);
    }

    @Override
    public synchronized OutputStream setAsciiStream(long pos) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized Writer setCharacterStream(long pos) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public synchronized int setString(long pos, String str, int offset, int len) throws SQLException {
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, pos - 1L, len)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.clob.setString(this.session, pos - 1L, str, offset, len);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void truncate(long len) throws SQLException {
        try {
            this.clob.truncate(this.session, len);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public synchronized Reader getCharacterStream(long pos, long length) throws SQLException {
        return new ClobInputStream(this, pos - 1L, length, this.session.getStreamBlockSize());
    }

    char[] getChars(long position, int length) throws SQLException {
        try {
            return this.clob.getChars(this.session, position - 1L, length);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    JDBCClobClient(SessionInterface session, ClobDataID clob) {
        this.session = session;
        this.clob = clob;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }
}

