/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.java.JavaSystem;

public class JDBCClob
implements Clob {
    private static final long MIN_POS = 1L;
    private static final long MAX_POS = 0x80000000L;
    private volatile String data;
    private final boolean createdByConnection;

    @Override
    public long length() throws SQLException {
        String ldata = this.data;
        this.checkValid(ldata);
        return ldata.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        String ldata = this.data;
        this.checkValid(ldata);
        int dlen = ldata.length();
        if (pos < 1L || pos > (long)dlen) {
            Util.outOfRangeArgument("pos: " + pos);
        }
        if (length < 0 || (long)length > (long)dlen - --pos) {
            throw Util.outOfRangeArgument("length: " + length);
        }
        return pos == 0L && length == dlen ? ldata : ldata.substring((int)pos, (int)pos + length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        String ldata = this.data;
        this.checkValid(ldata);
        return new StringReader(ldata);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkValid(this.data);
        try {
            return new ByteArrayInputStream(this.data.getBytes("US-ASCII"));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        int pos;
        String ldata = this.data;
        this.checkValid(ldata);
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        if (searchstr == null || start > 0x80000000L) {
            return -1L;
        }
        return (pos = ldata.indexOf(searchstr, (int)(--start))) < 0 ? -1L : (long)(pos + 1);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        long sslen;
        String ldata = this.data;
        this.checkValid(ldata);
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        if (searchstr == null) {
            return -1L;
        }
        long dlen = ldata.length();
        if (--start > dlen - (sslen = searchstr.length())) {
            return -1L;
        }
        String s = searchstr instanceof JDBCClob ? ((JDBCClob)searchstr).data() : searchstr.getSubString(1L, (int)sslen);
        int pos = ldata.indexOf(s, (int)start);
        return pos < 0 ? -1L : (long)(pos + 1);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        if (str == null) {
            throw Util.nullArgument("str");
        }
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        StringBuffer sb;
        if (!this.createdByConnection) {
            throw Util.notSupported();
        }
        String ldata = this.data;
        this.checkValid(ldata);
        if (str == null) {
            throw Util.nullArgument("str");
        }
        int strlen = str.length();
        if (offset < 0 || offset > strlen) {
            throw Util.outOfRangeArgument("offset: " + offset);
        }
        if (len > strlen - offset) {
            throw Util.outOfRangeArgument("len: " + len);
        }
        if (pos < 1L || pos > 1L + (long)(Integer.MAX_VALUE - len)) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        int ipos = (int)(pos - 1L);
        int dlen = ldata.length();
        if (ipos > dlen - len) {
            sb = new StringBuffer(ipos + len);
            sb.append(ldata.substring(0, ipos));
            ldata = null;
            sb.append(str.substring(offset, offset + len));
            str = null;
        } else {
            sb = new StringBuffer(ldata);
            ldata = null;
            int i = ipos;
            for (int j = 0; j < len; ++j) {
                sb.setCharAt(i, str.charAt(offset + j));
                ++i;
            }
            str = null;
        }
        this.checkValid(this.data);
        this.data = sb.toString();
        return len;
    }

    @Override
    public OutputStream setAsciiStream(final long pos) throws SQLException {
        if (!this.createdByConnection) {
            throw Util.notSupported();
        }
        this.checkValid(this.data);
        if (pos < 1L || pos > 0x80000000L) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        return new ByteArrayOutputStream(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    JDBCClob.this.setString(pos, new String(this.toByteArray(), "US-ASCII"));
                }
                catch (SQLException se) {
                    throw JavaSystem.toIOException(se);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public Writer setCharacterStream(final long pos) throws SQLException {
        if (!this.createdByConnection) {
            throw Util.notSupported();
        }
        this.checkValid(this.data);
        if (pos < 1L || pos > 0x80000000L) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        return new StringWriter(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    JDBCClob.this.setString(pos, this.toString());
                }
                catch (SQLException se) {
                    throw JavaSystem.toIOException(se);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void truncate(long len) throws SQLException {
        String ldata = this.data;
        this.checkValid(ldata);
        long dlen = ldata.length();
        if (len != dlen) {
            if (len < 0L || len > dlen) {
                throw Util.outOfRangeArgument("len: " + len);
            }
            this.data = ldata.substring(0, (int)len);
        }
    }

    @Override
    public void free() throws SQLException {
        this.data = null;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw Util.outOfRangeArgument("length: " + length);
        }
        return new StringReader(this.getSubString(pos, (int)length));
    }

    public JDBCClob(String data) throws SQLException {
        this.init(data);
        this.createdByConnection = false;
    }

    protected JDBCClob() {
        this.data = "";
        this.createdByConnection = true;
    }

    protected void init(String data) throws SQLException {
        if (data == null) {
            throw Util.nullArgument("data");
        }
        this.data = data;
    }

    protected void checkValid(Object data) {
        if (data == null) {
            throw new RuntimeException("null data");
        }
    }

    protected String data() throws SQLException {
        String ldata = this.data;
        this.checkValid(ldata);
        return ldata;
    }
}

