/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.BlobInputStream;
import org.hsqldb.jdbc.Util;
import org.hsqldb.types.BlobDataID;

public class JDBCBlobClient
implements Blob {
    BlobDataID blob;
    SessionInterface session;
    boolean isClosed;

    @Override
    public synchronized long length() throws SQLException {
        try {
            return this.blob.length(this.session);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized byte[] getBytes(long pos, int length) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, pos - 1L, length)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.blob.getBytes(this.session, pos - 1L, length);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        return new BlobInputStream(this, 0L, this.length(), this.session.getStreamBlockSize());
    }

    @Override
    public synchronized long position(byte[] pattern, long start) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, start, 0L)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.blob.position(this.session, pattern, start - 1L);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized long position(Blob pattern, long start) throws SQLException {
        byte[] bytePattern = pattern.getBytes(1L, (int)pattern.length());
        return this.position(bytePattern, start);
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, pos - 1L, bytes.length)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.blob.setBytes(this.session, pos - 1L, bytes);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (!JDBCBlobClient.isInLimits(bytes.length, offset, len)) {
            throw Util.outOfRangeArgument();
        }
        if (offset != 0 || len != bytes.length) {
            byte[] newBytes = new byte[len];
            System.arraycopy(bytes, offset, newBytes, 0, len);
            bytes = newBytes;
        }
        return this.setBytes(pos, bytes);
    }

    @Override
    public synchronized OutputStream setBinaryStream(long pos) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized void truncate(long len) throws SQLException {
        try {
            this.blob.truncate(this.session, len);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public synchronized InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, pos - 1L, length)) {
            throw Util.outOfRangeArgument();
        }
        return new BlobInputStream(this, pos - 1L, length, this.session.getStreamBlockSize());
    }

    JDBCBlobClient(SessionInterface session, BlobDataID blob) {
        this.session = session;
        this.blob = blob;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.sqlException(1251);
        }
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }
}

