/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.dbinfo;

import java.util.Locale;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Table;
import org.hsqldb.TextTable;
import org.hsqldb.dbinfo.DITypeInfo;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Types;

final class DITableInfo {
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    static final short tableIndexOther = 3;
    private static final int HALF_MAX_INT = 0x3FFFFFFF;
    private int hnd_column_remarks = -1;
    private int hnd_table_remarks = -1;
    private Table table;
    private static final DITypeInfo ti = new DITypeInfo();

    DITableInfo() {
        this.setupBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupBundles() {
        Class<BundleHandler> clazz = BundleHandler.class;
        synchronized (BundleHandler.class) {
            Locale oldLocale = BundleHandler.getLocale();
            BundleHandler.setLocale(Locale.getDefault());
            this.hnd_column_remarks = BundleHandler.getBundleHandle("column-remarks", null);
            this.hnd_table_remarks = BundleHandler.getBundleHandle("table-remarks", null);
            BundleHandler.setLocale(oldLocale);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    Integer getBRIPseudo() {
        return ValuePool.getInt(this.bestRowNotPseudo);
    }

    Integer getBRIScope() {
        return this.table.isWritable() ? ValuePool.getInt(this.bestRowTemporary) : ValuePool.getInt(this.bestRowSession);
    }

    Integer getColBufLen(int i) {
        int size;
        ColumnSchema column = this.table.getColumn(i);
        int type = column.getDataType().getJDBCTypeCode();
        switch (type) {
            case 1: 
            case 12: 
            case 40: 
            case 100: {
                int n = size = column.getDataType().precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)column.getDataType().precision;
                if (size == 0) break;
                if (size > 0x3FFFFFFF) {
                    size = 0;
                    break;
                }
                size = 2 * size;
                break;
            }
            case 30: 
            case 60: 
            case 61: {
                size = column.getDataType().precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)column.getDataType().precision;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 25: 
            case 91: 
            case 92: 
            case 94: {
                size = 8;
                break;
            }
            case 93: 
            case 95: {
                size = 12;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                size = 4;
                break;
            }
            case 16: {
                size = 1;
                break;
            }
            default: {
                size = 0;
            }
        }
        return size > 0 ? ValuePool.getInt(size) : null;
    }

    Integer getColCharOctLen(int i) {
        int size;
        ColumnSchema column = this.table.getColumn(i);
        int type = column.getDataType().getJDBCTypeCode();
        switch (type) {
            case 1: 
            case 12: 
            case 40: 
            case 100: {
                int n = size = column.getDataType().precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)column.getDataType().precision;
                if (size == 0) break;
                if (size > 0x3FFFFFFF) {
                    size = 0;
                    break;
                }
                size = 2 * size;
                break;
            }
            default: {
                size = 0;
            }
        }
        return size == 0 ? null : ValuePool.getInt(size);
    }

    Integer getColJDBCDataType(int i) {
        return ValuePool.getInt(this.table.getColumn(i).getDataType().getJDBCTypeCode());
    }

    String getColDataTypeName(int i) {
        return this.table.getColumn(i).getDataType().getNameString();
    }

    Integer getColDataTypeSub(int i) {
        int type = this.table.getColumn(i).getDataType().getJDBCTypeCode();
        int sub = type == 100 ? 4 : 1;
        return ValuePool.getInt(sub);
    }

    String getColDefault(int i) {
        return this.table.getColumn(i).getDefaultSQL();
    }

    Boolean getColIsIdentity(int i) {
        return this.table.getColumn(i).isIdentity() ? Boolean.TRUE : Boolean.FALSE;
    }

    String getColIsNullable(int i) {
        ColumnSchema column = this.table.getColumn(i);
        return column.isNullable() && !column.isPrimaryKey() ? "YES" : "NO";
    }

    String getColName(int i) {
        return this.table.getColumn((int)i).getName().name;
    }

    Integer getColNullability(int i) {
        ColumnSchema column = this.table.getColumn(i);
        return column.isNullable() && !column.isPrimaryKey() ? ValuePool.getInt(1) : ValuePool.getInt(0);
    }

    Integer getColPrecRadix(int i) {
        ti.setTypeCode(this.table.getColumn(i).getDataType().getJDBCTypeCode());
        return ti.getNumPrecRadix();
    }

    String getColRemarks(int i) {
        if (this.table.getTableType() != 0) {
            return null;
        }
        String key = this.getName() + "_" + this.getColName(i);
        return BundleHandler.getString(this.hnd_column_remarks, key);
    }

    Integer getColScaleOrNull(int i) {
        ColumnSchema column = this.table.getColumn(i);
        int type = column.getDataType().getJDBCTypeCode();
        return Types.acceptsScaleCreateParam(type) ? ValuePool.getInt(column.getDataType().scale) : null;
    }

    String getColScopeCat(int i) {
        return null;
    }

    String getColScopeSchem(int i) {
        return null;
    }

    String getColScopeTable(int i) {
        return null;
    }

    Integer getColSize(int i) {
        int size;
        ColumnSchema column = this.table.getColumn(i);
        int type = column.getDataType().getJDBCTypeCode();
        if (!Types.acceptsPrecision(type)) {
            return null;
        }
        int n = size = column.getDataType().precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)column.getDataType().precision;
        if (size > 0) {
            return ValuePool.getInt(size);
        }
        ti.setTypeCode(type);
        return ti.getPrecision();
    }

    Integer getColSqlDataType(int i) {
        ti.setTypeCode(this.table.getColumn(i).getDataType().getJDBCTypeCode());
        return ti.getSqlDataType();
    }

    Integer getColSqlDateTimeSub(int i) {
        ti.setTypeCode(this.table.getColumn((int)i).getDataType().typeCode);
        return ti.getSqlDateTimeSub();
    }

    String getDataSource() {
        return this.table.isText() ? ((TextTable)this.table).getDataSource() : null;
    }

    String getHsqlType() {
        switch (this.table.getTableType()) {
            case 0: 
            case 2: 
            case 3: {
                return "MEMORY";
            }
            case 4: {
                return "CACHED";
            }
            case 5: 
            case 6: {
                return "TEXT";
            }
        }
        return null;
    }

    Integer getIndexCardinality(int i) {
        return null;
    }

    String getIndexColDirection(int i, int columnPosition) {
        return "A";
    }

    int[] getIndexColumns(int i) {
        return this.table.getIndex(i).getColumns();
    }

    String getIndexName(int i) {
        return this.table.getIndex((int)i).getName().name;
    }

    Integer getIndexRowCardinality(int i) {
        return null;
    }

    Integer getIndexType(int i) {
        return ValuePool.getInt(3);
    }

    int getIndexVisibleColumns(int i) {
        return this.table.getIndex(i).getColumnCount();
    }

    String getName() {
        return this.table.getName().name;
    }

    Long getNextIdentity() {
        if (this.table.hasIdentityColumn()) {
            return ValuePool.getLong(this.table.getNextIdentity());
        }
        return null;
    }

    String getRemark() {
        return this.table.getTableType() == 0 ? BundleHandler.getString(this.hnd_table_remarks, this.getName()) : null;
    }

    String getJDBCStandardType() {
        switch (this.table.getTableType()) {
            case 7: {
                return "VIEW";
            }
            case 2: 
            case 5: {
                return "GLOBAL TEMPORARY";
            }
            case 0: {
                return "SYSTEM TABLE";
            }
        }
        if (this.table.getOwner().isSystem()) {
            return "SYSTEM TABLE";
        }
        return "TABLE";
    }

    Table getTable() {
        return this.table;
    }

    Boolean isDataSourceDescending() {
        if (this.table.isText()) {
            return ((TextTable)this.table).isDescDataSource() ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    Boolean isIndexNonUnique(int i) {
        return ValuePool.getBoolean(!this.table.getIndex(i).isUnique());
    }

    Boolean isReadOnly() {
        return ValuePool.getBoolean(this.table.isDataReadOnly());
    }

    void setTable(Table table) {
        this.table = table;
    }
}

