/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hsqldb.cmdline.SqlToolError;
import org.hsqldb.cmdline.SqltoolRB;
import org.hsqldb.cmdline.sqltool.SqlFileScanner;
import org.hsqldb.cmdline.sqltool.Token;
import org.hsqldb.cmdline.sqltool.TokenList;
import org.hsqldb.cmdline.sqltool.TokenSource;
import org.hsqldb.lib.AppendableException;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.RCData;
import org.hsqldb.lib.StringUtil;

public class SqlFile {
    private static FrameworkLogger logger = FrameworkLogger.getLog(SqlFile.class);
    private static final int DEFAULT_HISTORY_SIZE = 40;
    private boolean permitEmptySqlStatements = false;
    private File file;
    private boolean interactive;
    private String primaryPrompt = "sql> ";
    private String rawPrompt = null;
    private String contPrompt = "  +> ";
    private Connection curConn = null;
    private boolean htmlMode = false;
    private Map userVars;
    private Map macros;
    private List history = null;
    private String nullRepToken = null;
    private String dsvTargetFile = null;
    private String dsvTargetTable = null;
    private String dsvConstCols = null;
    private String dsvRejectFile = null;
    private String dsvRejectReport = null;
    private int dsvRecordsPerCommit = 0;
    public static String LS = System.getProperty("line.separator");
    private int maxHistoryLength = 1;
    private SqltoolRB rb = null;
    private boolean reportTimes = false;
    private static Pattern specialPattern = Pattern.compile("(\\S+)(?:\\s+(.*\\S))?\\s*");
    private static Pattern plPattern = Pattern.compile("(.*\\S)?\\s*");
    private static Pattern foreachPattern = Pattern.compile("foreach\\s+(\\S+)\\s*\\(([^)]+)\\)\\s*");
    private static Pattern ifwhilePattern = Pattern.compile("\\S+\\s*\\(([^)]*)\\)\\s*");
    private static Pattern varsetPattern = Pattern.compile("(\\S+)\\s*([=_~])\\s*(?:(.*\\S)\\s*)?");
    private static Pattern substitutionPattern = Pattern.compile("(\\S)(.+?)\\1(.*?)\\1(.+)?\\s*");
    private static Pattern slashHistoryPattern = Pattern.compile("\\s*/([^/]+)/\\s*(\\S.*)?");
    private static Pattern historyPattern = Pattern.compile("\\s*(-?\\d+)?\\s*(\\S.*)?");
    private static Pattern wincmdPattern = null;
    private static Pattern useMacroPattern = Pattern.compile("(\\w+)(\\s.*[^;])?(;?)");
    private static Pattern editMacroPattern = Pattern.compile("(\\w+)\\s*:(.*)");
    private static Pattern spMacroPattern = Pattern.compile("(\\w+)\\s+([*\\\\])(.*\\S)");
    private static Pattern sqlMacroPattern = Pattern.compile("(\\w+)\\s+(.*\\S)");
    private static Pattern integerPattern = Pattern.compile("\\d+");
    private static Pattern nameValPairPattern = Pattern.compile("\\s*(\\w+)\\s*=(.*)");
    private static Pattern nameDotPattern = Pattern.compile("(\\w+)\\.");
    private static Pattern commitOccursPattern = Pattern.compile("(?is)(?:set\\s+autocommit.*)|(commit\\s*)");
    private static Pattern logPattern = Pattern.compile("(?i)(FINER|WARNING|SEVERE|INFO|FINEST)\\s+(.*\\S)");
    private static Map nestingPLCommands = new HashMap();
    BooleanBucket possiblyUncommitteds = new BooleanBucket();
    private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
    private static String revnum;
    private String DSV_OPTIONS_TEXT = null;
    private String D_OPTIONS_TEXT = null;
    public boolean recursed = false;
    private PrintStream psStd = null;
    private PrintWriter pwQuery = null;
    private PrintWriter pwDsv = null;
    private boolean continueOnError = false;
    private static final String DEFAULT_CHARSET;
    private SqlFileScanner scanner = null;
    private String charset = null;
    private Token buffer = null;
    private boolean preempt = false;
    private String lastSqlStatement = null;
    private boolean doPrepare = false;
    private String prepareVar = null;
    private String dsvColDelim = null;
    private String dsvColSplitter = null;
    private String dsvSkipPrefix = null;
    private String dsvRowDelim = null;
    private String dsvRowSplitter = null;
    private String dsvSkipCols = null;
    private boolean dsvTrimAll = false;
    private String DSV_X_SYNTAX_MSG = null;
    private String DSV_M_SYNTAX_MSG = null;
    private String nobufferYetString = null;
    private static final char[] nonVarChars;
    public boolean plMode = false;
    private String fetchingVar = null;
    private boolean silentFetch = false;
    private boolean fetchBinary = false;
    private static final String DEFAULT_NULL_REP = "[null]";
    private static final String DEFAULT_ROW_DELIM;
    private static final String DEFAULT_ROW_SPLITTER = "\\r\\n|\\r|\\n";
    private static final String DEFAULT_COL_DELIM = "|";
    private static final String DEFAULT_COL_SPLITTER = "\\|";
    private static final String DEFAULT_SKIP_PREFIX = "#";
    private static final int DEFAULT_ELEMENT = 0;
    private static final int HSQLDB_ELEMENT = 1;
    private static final int ORACLE_ELEMENT = 2;
    private static final int[] listMDSchemaCols;
    private static final int[] listMDIndexCols;
    private static final int[][] listMDTableCols;
    private static final String[] oracleSysSchemas;
    private boolean excludeSysSchemas = false;
    private static final int COL_HEAD = 0;
    private static final int COL_ODD = 1;
    private static final int COL_EVEN = 2;
    private static final String PRE_TR = "    ";
    private static final String PRE_TD = "        ";
    int oldestHist = 1;
    byte[] binBuffer = null;
    private static final int JDBC3_BOOLEAN = 16;
    private static final int JDBC3_DATALINK = 70;

    private void updateUserSettings() {
        this.dsvSkipPrefix = SqlFile.convertEscapes((String)this.userVars.get("*DSV_SKIP_PREFIX"));
        if (this.dsvSkipPrefix == null) {
            this.dsvSkipPrefix = DEFAULT_SKIP_PREFIX;
        }
        this.dsvSkipCols = (String)this.userVars.get("*DSV_SKIP_COLS");
        this.dsvTrimAll = Boolean.valueOf((String)this.userVars.get("*DSV_TRIM_ALL"));
        this.dsvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*DSV_COL_DELIM"));
        if (this.dsvColDelim == null) {
            this.dsvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_COL_DELIM"));
        }
        if (this.dsvColDelim == null) {
            this.dsvColDelim = DEFAULT_COL_DELIM;
        }
        this.dsvColSplitter = (String)this.userVars.get("*DSV_COL_SPLITTER");
        if (this.dsvColSplitter == null) {
            this.dsvColSplitter = DEFAULT_COL_SPLITTER;
        }
        this.dsvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*DSV_ROW_DELIM"));
        if (this.dsvRowDelim == null) {
            this.dsvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_ROW_DELIM"));
        }
        if (this.dsvRowDelim == null) {
            this.dsvRowDelim = DEFAULT_ROW_DELIM;
        }
        this.dsvRowSplitter = (String)this.userVars.get("*DSV_ROW_SPLITTER");
        if (this.dsvRowSplitter == null) {
            this.dsvRowSplitter = DEFAULT_ROW_SPLITTER;
        }
        this.dsvTargetFile = (String)this.userVars.get("*DSV_TARGET_FILE");
        if (this.dsvTargetFile == null) {
            this.dsvTargetFile = (String)this.userVars.get("*CSV_FILEPATH");
        }
        this.dsvTargetTable = (String)this.userVars.get("*DSV_TARGET_TABLE");
        if (this.dsvTargetTable == null) {
            this.dsvTargetTable = (String)this.userVars.get("*CSV_TABLENAME");
        }
        this.dsvConstCols = (String)this.userVars.get("*DSV_CONST_COLS");
        this.dsvRejectFile = (String)this.userVars.get("*DSV_REJECT_FILE");
        this.dsvRejectReport = (String)this.userVars.get("*DSV_REJECT_REPORT");
        if (this.userVars.get("*DSV_RECORDS_PER_COMMIT") != null) {
            try {
                this.dsvRecordsPerCommit = Integer.parseInt((String)this.userVars.get("*DSV_RECORDS_PER_COMMIT"));
            }
            catch (NumberFormatException nfe) {
                logger.error(this.rb.getString(SqltoolRB.REJECT_RPC, (String)this.userVars.get("*DSV_RECORDS_PER_COMMIT")));
                this.userVars.remove("*DSV_REJECT_REPORT");
                this.dsvRecordsPerCommit = 0;
            }
        }
        this.nullRepToken = (String)this.userVars.get("*NULL_REP_TOKEN");
        if (this.nullRepToken == null) {
            this.nullRepToken = (String)this.userVars.get("*CSV_NULL_REP");
        }
        if (this.nullRepToken == null) {
            this.nullRepToken = DEFAULT_NULL_REP;
        }
    }

    public SqlFile(File file, boolean interactive, Map userVars) throws IOException {
        this(file, interactive, userVars, null);
    }

    public SqlFile(File file, boolean interactive, Map userVars, Map macros) throws IOException {
        logger.privlog(Level.FINER, "<init>ting SqlFile instance", null, 2, FrameworkLogger.class);
        try {
            this.rb = new SqltoolRB();
            this.rb.validate();
            this.rb.setMissingPosValueBehavior(2);
            this.rb.setMissingPropertyBehavior(2);
        }
        catch (RuntimeException re) {
            logger.privlog(Level.SEVERE, "Failed to initialize resource bundle", null, 2, FrameworkLogger.class);
            throw re;
        }
        this.rawPrompt = this.rb.getString(SqltoolRB.RAWMODE_PROMPT) + "> ";
        this.DSV_OPTIONS_TEXT = this.rb.getString(SqltoolRB.DSV_OPTIONS);
        this.D_OPTIONS_TEXT = this.rb.getString(SqltoolRB.D_OPTIONS);
        this.DSV_X_SYNTAX_MSG = this.rb.getString(SqltoolRB.DSV_X_SYNTAX);
        this.DSV_M_SYNTAX_MSG = this.rb.getString(SqltoolRB.DSV_M_SYNTAX);
        this.nobufferYetString = this.rb.getString(SqltoolRB.NOBUFFER_YET);
        this.file = file;
        this.interactive = interactive;
        this.userVars = userVars;
        this.macros = macros;
        if (this.userVars == null) {
            this.userVars = new HashMap();
        }
        if (this.macros == null) {
            this.macros = new HashMap();
        }
        this.updateUserSettings();
        if (file != null && !file.canRead()) {
            throw new IOException(this.rb.getString(SqltoolRB.SQLFILE_READFAIL, file.toString()));
        }
        if (interactive) {
            this.history = new TokenList();
            String histLenString = System.getProperty("sqltool.historyLength");
            if (histLenString != null) {
                try {
                    this.maxHistoryLength = Integer.parseInt(histLenString);
                }
                catch (Exception e) {}
            } else {
                this.maxHistoryLength = 40;
            }
        }
    }

    public SqlFile(boolean interactive, Map userVars) throws IOException {
        this(null, interactive, userVars, null);
    }

    public SqlFile(boolean interactive, Map userVars, Map macros) throws IOException {
        this(null, interactive, userVars, macros);
    }

    public void execute(Connection conn, Boolean coeOverride) throws SqlToolError, SQLException {
        this.execute(conn, System.out, coeOverride);
    }

    public void execute(Connection conn, boolean coeOverride) throws SqlToolError, SQLException {
        this.execute(conn, System.out, new Boolean(coeOverride));
    }

    public void execute(Connection curConn, PrintStream psStd, PrintStream psErr, Boolean coeOverride) throws SqlToolError, SQLException {
        psErr.println(this.rb.getString(SqltoolRB.ERRSTREAM_DEPRECATED));
        this.execute(curConn, psStd, coeOverride);
    }

    public void execute(Connection curConn, PrintStream psStd, Boolean coeOverride) throws SqlToolError, SQLException {
        this.curConn = curConn;
        this.psStd = psStd;
        this.buffer = null;
        this.continueOnError = coeOverride == null ? this.interactive : coeOverride;
        String specifiedCharSet = System.getProperty("sqlfile.charset");
        this.charset = specifiedCharSet == null ? DEFAULT_CHARSET : specifiedCharSet;
        this.lastSqlStatement = null;
        try {
            this.scanner = new SqlFileScanner(this.charset == null ? new InputStreamReader(this.file == null ? System.in : new FileInputStream(this.file)) : new InputStreamReader(this.file == null ? System.in : new FileInputStream(this.file), this.charset));
            this.scanner.setStdPrintStream(psStd);
            this.scanner.setResourceBundle(this.rb);
            if (this.interactive) {
                this.stdprintln(this.rb.getString(SqltoolRB.SQLFILE_BANNER, revnum));
                this.scanner.setRawPrompt(this.rawPrompt);
                this.scanner.setSqlPrompt(this.contPrompt);
                this.scanner.setSqltoolPrompt(this.primaryPrompt);
                this.scanner.setInteractive(true);
                this.stdprint(this.primaryPrompt);
            }
            this.scanpass(this.scanner);
        }
        catch (IOException ioe) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.PRIMARYINPUT_ACCESSFAIL), ioe);
        }
        finally {
            if (this.scanner != null) {
                try {
                    this.scanner.yyclose();
                    this.closeQueryOutputStream();
                }
                catch (IOException ioe) {
                    this.errprintln("Failed to close pipes");
                }
            }
        }
    }

    private String nestingCommand(Token token) throws BadSpecial {
        if (token.type != 2) {
            return null;
        }
        String commandWord = token.val.replaceFirst("\\s.*", "");
        if (!nestingPLCommands.containsKey(commandWord)) {
            return null;
        }
        Pattern pattern = (Pattern)nestingPLCommands.get(commandWord);
        if (pattern.matcher(token.val).matches()) {
            return commandWord;
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.PL_MALFORMAT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void scanpass(TokenSource ts) throws SqlToolError, SQLException {
        rollbackUncoms = true;
        token = null;
        if (this.userVars.size() > 0) {
            this.plMode = true;
        }
        block24: while (true) {
            try lbl-1000:
            // 5 sources

            {
                while (true) lbl-1000:
                // 2 sources

                {
                    ** try [egrp 1[TRYBLOCK] [0, 10, 20, 30, 40, 50 : 22->509)] { 
lbl9:
                    // 1 sources

                    break;
lbl10:
                    // 1 sources

                    catch (BadSpecial bs) {
                        if (token == null) {
                            this.errprintln(this.rb.getString(SqltoolRB.ERRORAT, new String[]{this.file == null ? "stdin" : this.file.toString(), "?", "?", bs.getMessage()}));
                        } else {
                            this.errprintln(this.rb.getString(SqltoolRB.ERRORAT, new String[]{this.file == null ? "stdin" : this.file.toString(), Integer.toString(token.line), token.reconstitute(), bs.getMessage()}));
                        }
                        cause = bs.getCause();
                        if (cause != null) {
                            this.errprintln(this.rb.getString(SqltoolRB.CAUSEREPORT, cause.toString()));
                        }
                        if (this.continueOnError) ** GOTO lbl-1000
                        throw new SqlToolError(bs);
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PRIMARYINPUT_ACCESSFAIL), ioe);
            }
            catch (QuitNow qn) {
                if (this.recursed) {
                    throw qn;
                }
                rollbackUncoms = qn.getMessage() != null;
                if (rollbackUncoms == false) return;
                this.errprintln(this.rb.getString(SqltoolRB.ABORTING, qn.getMessage()));
                throw new SqlToolError(qn.getMessage());
            }
            block26: while (true) {
                if (this.preempt) {
                    token = this.buffer;
                    this.preempt = false;
                } else {
                    token = ts.yylex();
                    SqlFile.logger.finest("SqlFile got new token:  " + token);
                }
                if (token == null) return;
                nestingCommand = this.nestingCommand(token);
                if (nestingCommand != null) {
                    if (token.nestedBlock == null) {
                        token.nestedBlock = this.seekTokenSource(nestingCommand);
                    }
                    this.processBlock(token);
                    continue;
                }
                switch (token.type) {
                    case 6: {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.INPUT_MALFORMAT));
                    }
                    case 7: {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.INPUT_UNTERMINATED, token.val));
                    }
                    case 4: 
                    case 5: {
                        if (token.val == null) {
                            token.val = "";
                        }
                        if (token.val.trim().length() < 1) {
                            throw new SqlToolError(this.rb.getString(SqltoolRB.RAW_EMPTY));
                        }
                        receivedType = token.type;
                        token.type = 0;
                        if (this.setBuf(token) && receivedType == 4 && this.interactive) {
                            this.stdprintln("");
                            this.stdprintln(this.rb.getString(SqltoolRB.RAW_MOVEDTOBUFFER));
                            this.stdprint(this.primaryPrompt);
                        }
                        if (receivedType != 5) continue block24;
                        this.historize();
                        this.processSQL();
                        continue block26;
                    }
                    case 9: {
                        this.processMacro(token);
                        continue block26;
                    }
                    case 2: {
                        this.setBuf(token);
                        this.historize();
                        this.processPL(null);
                        continue block26;
                    }
                    case 1: {
                        this.setBuf(token);
                        this.historize();
                        this.processSpecial(null);
                        continue block26;
                    }
                    case 3: {
                        this.processBuffHist(token);
                        continue block26;
                    }
                    case 8: {
                        token.type = 0;
                        if (this.setBuf(token)) ** break;
                        continue block24;
                        this.stdprintln(this.rb.getString(SqltoolRB.INPUT_MOVEDTOBUFFER));
                        continue block26;
                    }
                    case 0: {
                        if (token.val == null) {
                            token.val = "";
                        }
                        this.setBuf(token);
                        this.historize();
                        this.processSQL();
                        continue block26;
                    }
                }
                break;
            }
            break;
        }
        throw new RuntimeException("Internal assertion failed.  Unexpected token type: " + token.getTypeString());
lbl101:
        // 1 sources

        catch (SQLException se) {
            this.errprintln("SQL " + this.rb.getString(SqltoolRB.ERRORAT, new String[]{this.file == null ? "stdin" : this.file.toString(), token == null ? "?" : Integer.toString(token.line), this.lastSqlStatement, se.getMessage()}));
            if (this.continueOnError) ** GOTO lbl-1000
            throw se;
        }
lbl105:
        // 1 sources

        catch (BreakException be) {
            msg = be.getMessage();
            if (this.recursed) {
                rollbackUncoms = false;
            } else {
                if (msg == null) return;
                if (msg.equals("file")) return;
                this.errprintln(this.rb.getString(SqltoolRB.BREAK_UNSATISFIED, msg));
            }
            if (this.recursed != false) throw be;
            if (this.continueOnError) ** GOTO lbl-1000
            throw be;
        }
lbl116:
        // 1 sources

        catch (ContinueException ce) {
            msg = ce.getMessage();
            if (this.recursed) {
                rollbackUncoms = false;
            } else {
                this.errprintln(this.rb.getString(SqltoolRB.CONTINUE_UNSATISFIED, msg));
            }
            if (this.recursed != false) throw ce;
            if (this.continueOnError) ** GOTO lbl-1000
            throw ce;
        }
lbl125:
        // 1 sources

        catch (QuitNow qn) {
            throw qn;
        }
lbl127:
        // 1 sources

        catch (SqlToolError ste) {
            if (token == null) {
                v0 = new String[4];
                v0[0] = this.file == null ? "stdin" : this.file.toString();
                v0[1] = "?";
                v0[2] = "?";
                v1 = v0;
                v0[3] = ste.getMessage() == null ? "" : ste.getMessage();
            } else {
                v2 = new String[4];
                v2[0] = this.file == null ? "stdin" : this.file.toString();
                v2[1] = Integer.toString(token.line);
                v2[2] = token.val == null ? "" : token.reconstitute();
                v1 = v2;
                v2[3] = ste.getMessage() == null ? "" : ste.getMessage();
            }
            sb = new StringBuffer(this.rb.getString(SqltoolRB.ERRORAT, v1));
            if (ste.getMessage() != null) {
                sb.append(SqlFile.LS);
            }
            this.errprintln((cause = ste.getCause()) == null ? sb.toString() : this.rb.getString(SqltoolRB.CAUSEREPORT, cause.toString()));
            if (this.continueOnError) ** continue;
            throw ste;
        }
        finally {
            if (this.fetchingVar != null) {
                this.errprintln(this.rb.getString(SqltoolRB.PLVAR_SET_INCOMPLETE, this.fetchingVar));
                rollbackUncoms = true;
            }
            if (rollbackUncoms && !this.curConn.getAutoCommit() && this.possiblyUncommitteds.get()) {
                this.errprintln(this.rb.getString(SqltoolRB.ROLLINGBACK));
                this.curConn.rollback();
                this.possiblyUncommitteds.set(false);
            }
        }
    }

    private void processBuffHist(Token token) throws BadSpecial, SQLException, SqlToolError {
        if (token.val.length() < 1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.BUFHIST_UNSPECIFIED));
        }
        char commandChar = token.val.charAt(0);
        String other = token.val.substring(1);
        if (other.trim().length() == 0) {
            other = null;
        }
        switch (commandChar) {
            case 'b': 
            case 'l': {
                this.enforce1charBH(other, 'l');
                if (this.buffer == null) {
                    this.stdprintln(this.nobufferYetString);
                } else {
                    this.stdprintln(this.rb.getString(SqltoolRB.EDITBUFFER_CONTENTS, this.buffer.reconstitute()));
                }
                return;
            }
            case 'h': {
                this.enforce1charBH(other, 'h');
                this.showHistory();
                return;
            }
            case '?': {
                this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_HELP));
                return;
            }
        }
        Integer histNum = null;
        Matcher hm = slashHistoryPattern.matcher(token.val);
        if (hm.matches()) {
            histNum = this.historySearch(hm.group(1));
            if (histNum == null) {
                this.stdprintln(this.rb.getString(SqltoolRB.SUBSTITUTION_NOMATCH));
                return;
            }
        } else {
            hm = historyPattern.matcher(token.val);
            if (!hm.matches()) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.EDIT_MALFORMAT));
            }
            Integer n = histNum = hm.group(1) == null || hm.group(1).length() < 1 ? null : new Integer(hm.group(1));
        }
        if (hm.groupCount() != 2) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.EDIT_MALFORMAT));
        }
        commandChar = hm.group(2) == null || hm.group(2).length() < 1 ? (char)'\u0000' : hm.group(2).charAt(0);
        String string = other = commandChar == '\u0000' ? null : hm.group(2).substring(1);
        if (other != null && other.length() < 1) {
            other = null;
        }
        Token targetCommand = histNum == null ? null : this.commandFromHistory(histNum);
        switch (commandChar) {
            case '\u0000': {
                this.setBuf(targetCommand);
                this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_RESTORED, this.buffer.reconstitute()));
                return;
            }
            case ';': {
                this.enforce1charBH(other, ';');
                if (targetCommand != null) {
                    this.setBuf(targetCommand);
                }
                if (this.buffer == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_EXECUTING, this.buffer.reconstitute()));
                this.preempt = true;
                return;
            }
            case 'a': {
                if (targetCommand == null) {
                    targetCommand = this.buffer;
                }
                if (targetCommand == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                boolean doExec = false;
                if (other != null && other.trim().charAt(other.trim().length() - 1) == ';') {
                    if ((other = other.substring(0, other.lastIndexOf(59))).trim().length() < 1) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.APPEND_EMPTY));
                    }
                    doExec = true;
                }
                Token newToken = new Token(targetCommand.type, targetCommand.val, targetCommand.line);
                if (other != null) {
                    newToken.val = newToken.val + other;
                }
                this.setBuf(newToken);
                if (doExec) {
                    this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_EXECUTING, this.buffer.reconstitute()));
                    this.preempt = true;
                    return;
                }
                if (this.interactive) {
                    this.scanner.setMagicPrefix(newToken.reconstitute());
                }
                switch (newToken.type) {
                    case 0: {
                        this.scanner.setRequestedState(2);
                        break;
                    }
                    case 1: {
                        this.scanner.setRequestedState(12);
                        break;
                    }
                    case 2: {
                        this.scanner.setRequestedState(14);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal assertion failed.  Appending to unexpected type: " + newToken.getTypeString());
                    }
                }
                this.scanner.setCommandBuffer(newToken.val);
                return;
            }
            case 'w': {
                if (targetCommand == null) {
                    targetCommand = this.buffer;
                }
                if (targetCommand == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                if (other == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.DESTFILE_DEMAND));
                }
                String targetFile = this.dereference(other.trim(), false);
                PrintWriter pw = null;
                try {
                    pw = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(targetFile, true)) : new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile, true), this.charset));
                    pw.println(targetCommand.reconstitute(true));
                    pw.flush();
                }
                catch (Exception e) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_APPENDFAIL, targetFile), e);
                }
                finally {
                    if (pw != null) {
                        pw.close();
                    }
                }
                return;
            }
            case 's': {
                boolean modeExecute = false;
                boolean modeGlobal = false;
                if (targetCommand == null) {
                    targetCommand = this.buffer;
                }
                if (targetCommand == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                try {
                    String optionGroup;
                    if (other == null || other.length() < 3) {
                        throw new BadSubst(this.rb.getString(SqltoolRB.SUBSTITUTION_MALFORMAT));
                    }
                    Matcher m = substitutionPattern.matcher(other);
                    if (!m.matches()) {
                        throw new BadSubst(this.rb.getString(SqltoolRB.SUBSTITUTION_MALFORMAT));
                    }
                    if (m.groupCount() < 3 || m.groupCount() > 4) {
                        throw new RuntimeException("Internal assertion failed.  Matched substitution pattern, but captured " + m.groupCount() + " groups");
                    }
                    String string2 = optionGroup = m.groupCount() > 3 && m.group(4) != null ? new String(m.group(4)) : null;
                    if (optionGroup != null) {
                        if (optionGroup.indexOf(59) > -1) {
                            modeExecute = true;
                            optionGroup = optionGroup.replaceFirst(";", "");
                        }
                        if (optionGroup.indexOf(103) > -1) {
                            modeGlobal = true;
                            optionGroup = optionGroup.replaceFirst("g", "");
                        }
                    }
                    Matcher bufferMatcher = Pattern.compile("(?s" + (optionGroup == null ? "" : optionGroup) + ')' + m.group(2)).matcher(targetCommand.val);
                    Token newBuffer = new Token(targetCommand.type, modeGlobal ? bufferMatcher.replaceAll(m.group(3)) : bufferMatcher.replaceFirst(m.group(3)), targetCommand.line);
                    if (newBuffer.val.equals(targetCommand.val)) {
                        this.stdprintln(this.rb.getString(SqltoolRB.SUBSTITUTION_NOMATCH));
                        return;
                    }
                    this.setBuf(newBuffer);
                    this.stdprintln(this.rb.getString(modeExecute ? SqltoolRB.BUFFER_EXECUTING : SqltoolRB.EDITBUFFER_CONTENTS, this.buffer.reconstitute()));
                }
                catch (PatternSyntaxException pse) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SUBSTITUTION_SYNTAX), pse);
                }
                catch (BadSubst badswitch) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SUBSTITUTION_SYNTAX));
                }
                if (modeExecute) {
                    this.preempt = true;
                }
                return;
            }
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.BUFFER_UNKNOWN, Character.toString(commandChar)));
    }

    private void enforce1charSpecial(String tokenString, char command) throws BadSpecial {
        if (tokenString.length() != 1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_EXTRACHARS, Character.toString(command), tokenString.substring(1)));
        }
    }

    private void enforce1charBH(String tokenString, char command) throws BadSpecial {
        if (tokenString != null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.BUFFER_EXTRACHARS, Character.toString(command), tokenString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSpecial(String inString) throws BadSpecial, QuitNow, SQLException, SqlToolError {
        String string;
        String string2 = string = inString == null ? this.buffer.val : inString;
        if (string.length() < 1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_UNSPECIFIED));
        }
        Matcher m = specialPattern.matcher(this.plMode ? this.dereference(string, false) : string);
        if (!m.matches()) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_MALFORMAT));
        }
        if (m.groupCount() < 1 || m.groupCount() > 2) {
            throw new RuntimeException("Internal assertion failed.  Pattern matched, yet captured " + m.groupCount() + " groups");
        }
        String arg1 = m.group(1);
        String other = m.groupCount() > 1 ? m.group(2) : null;
        switch (arg1.charAt(0)) {
            case 'q': {
                this.enforce1charSpecial(arg1, 'q');
                if (other != null) {
                    throw new QuitNow(other);
                }
                throw new QuitNow();
            }
            case 'H': {
                this.enforce1charSpecial(arg1, 'H');
                this.htmlMode = !this.htmlMode;
                this.stdprintln(this.rb.getString(SqltoolRB.HTML_MODE, Boolean.toString(this.htmlMode)));
                return;
            }
            case 'm': {
                int colonIndex;
                if (arg1.equals("m?") || arg1.equals("m") && other != null && other.equals("?")) {
                    this.stdprintln(this.DSV_OPTIONS_TEXT + LS + this.DSV_M_SYNTAX_MSG);
                    return;
                }
                if (arg1.length() != 1 || other == null) {
                    throw new BadSpecial(this.DSV_M_SYNTAX_MSG);
                }
                boolean noComments = other.charAt(other.length() - 1) == '*';
                String skipPrefix = null;
                if (noComments) {
                    if ((other = other.substring(0, other.length() - 1).trim()).length() < 1) {
                        throw new BadSpecial(this.DSV_M_SYNTAX_MSG);
                    }
                } else {
                    skipPrefix = this.dsvSkipPrefix;
                }
                if ((colonIndex = other.indexOf(" :")) > -1 && colonIndex < other.length() - 2) {
                    skipPrefix = other.substring(colonIndex + 2);
                    other = other.substring(0, colonIndex).trim();
                }
                this.importDsv(other, skipPrefix);
                return;
            }
            case 'x': {
                if (arg1.equals("x?") || arg1.equals("x") && other != null && other.equals("?")) {
                    this.stdprintln(this.DSV_OPTIONS_TEXT + LS + this.DSV_X_SYNTAX_MSG);
                    return;
                }
                try {
                    String tableName;
                    if (arg1.length() != 1 || other == null) {
                        throw new BadSpecial(this.DSV_X_SYNTAX_MSG);
                    }
                    String string3 = tableName = other.indexOf(32) > 0 ? null : other;
                    if (this.dsvTargetFile == null && tableName == null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_TARGETFILE_DEMAND));
                    }
                    File dsvFile = new File(this.dsvTargetFile == null ? tableName + ".dsv" : this.dsvTargetFile);
                    this.pwDsv = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(dsvFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(dsvFile), this.charset));
                    ResultSet rs = this.curConn.createStatement().executeQuery(tableName == null ? other : "SELECT * FROM " + tableName);
                    try {
                        ArrayList<Integer> colList = new ArrayList<Integer>();
                        int[] incCols = null;
                        if (this.dsvSkipCols != null) {
                            int i;
                            HashSet<String> skipCols = new HashSet<String>();
                            String[] skipColsArray = this.dsvSkipCols.split(this.dsvColDelim, -1);
                            for (int i2 = 0; i2 < skipColsArray.length; ++i2) {
                                skipCols.add(skipColsArray[i2].trim().toLowerCase());
                            }
                            ResultSetMetaData rsmd = rs.getMetaData();
                            for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                                if (skipCols.remove(rsmd.getColumnName(i).toLowerCase())) continue;
                                colList.add(new Integer(i));
                            }
                            if (colList.size() < 1) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_NOCOLSLEFT, this.dsvSkipCols));
                            }
                            if (skipCols.size() > 0) {
                                throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_SKIPCOLS_MISSING, ((Object)skipCols).toString()));
                            }
                            incCols = new int[colList.size()];
                            for (i = 0; i < incCols.length; ++i) {
                                incCols[i] = (Integer)colList.get(i);
                            }
                        }
                        this.displayResultSet(null, rs, incCols, null);
                    }
                    finally {
                        rs.close();
                    }
                    this.pwDsv.flush();
                    this.stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, Long.toString(dsvFile.length()), dsvFile.toString()));
                }
                catch (FileNotFoundException e) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, other), e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, other), e);
                }
                finally {
                    if (this.pwDsv != null) {
                        this.pwDsv.close();
                    }
                    this.pwDsv = null;
                }
                return;
            }
            case 'd': {
                if (arg1.equals("d?") || arg1.equals("d") && other != null && other.equals("?")) {
                    this.stdprintln(this.D_OPTIONS_TEXT);
                    return;
                }
                if (arg1.length() == 2) {
                    this.listTables(arg1.charAt(1), other);
                    return;
                }
                if (arg1.length() == 1 && other != null) {
                    try {
                        int space = other.indexOf(32);
                        if (space < 0) {
                            this.describe(other, null);
                        } else {
                            this.describe(other.substring(0, space), other.substring(space + 1).trim());
                        }
                        return;
                    }
                    catch (SQLException se) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL), se);
                    }
                }
                throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_D_LIKE));
            }
            case 'o': {
                this.enforce1charSpecial(arg1, 'o');
                if (other == null) {
                    if (this.pwQuery == null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.OUTPUTFILE_NONETOCLOSE));
                    }
                    this.closeQueryOutputStream();
                    return;
                }
                if (this.pwQuery != null) {
                    this.stdprintln(this.rb.getString(SqltoolRB.OUTPUTFILE_REOPENING));
                    this.closeQueryOutputStream();
                }
                try {
                    this.pwQuery = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(other, true)) : new OutputStreamWriter((OutputStream)new FileOutputStream(other, true), this.charset));
                    this.pwQuery.println((this.htmlMode ? "<HTML>" + LS + "<!--" : DEFAULT_SKIP_PREFIX) + " " + new Date() + ".  " + this.rb.getString(SqltoolRB.OUTPUTFILE_HEADER, this.getClass().getName()) + (this.htmlMode ? " -->" + LS + LS + "<BODY>" : LS));
                    this.pwQuery.flush();
                }
                catch (Exception e) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, other), e);
                }
                return;
            }
            case 'i': {
                this.enforce1charSpecial(arg1, 'i');
                if (other == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SQLFILE_NAME_DEMAND));
                }
                try {
                    SqlFile sf = new SqlFile(new File(other), false, this.userVars, this.macros);
                    sf.recursed = true;
                    sf.possiblyUncommitteds = this.possiblyUncommitteds;
                    sf.plMode = this.plMode;
                    sf.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException ce) {
                    throw ce;
                }
                catch (BreakException be) {
                    String beMessage = be.getMessage();
                    if (beMessage != null && !beMessage.equals("file")) {
                        throw be;
                    }
                }
                catch (QuitNow qn) {
                    throw qn;
                }
                catch (Exception e) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SQLFILE_EXECUTE_FAIL, other), e);
                }
                return;
            }
            case 'p': {
                this.enforce1charSpecial(arg1, 'p');
                if (other == null) {
                    this.stdprintln(true);
                } else {
                    this.stdprintln(other, true);
                }
                return;
            }
            case 'l': {
                if (arg1.equals("l?") && other == null || arg1.equals("l") && other != null && other.equals("?")) {
                    this.stdprintln(this.rb.getString(SqltoolRB.LOG_SYNTAX));
                } else {
                    Matcher logMatcher;
                    this.enforce1charSpecial(arg1, 'l');
                    Matcher matcher = logMatcher = other == null ? null : logPattern.matcher(other.trim());
                    if (logMatcher == null || !logMatcher.matches()) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.LOG_SYNTAX_ERROR));
                    }
                    String levelString = logMatcher.group(1);
                    Level level = null;
                    if (levelString.equalsIgnoreCase("FINER")) {
                        level = Level.FINER;
                    } else if (levelString.equalsIgnoreCase("WARNING")) {
                        level = Level.WARNING;
                    } else if (levelString.equalsIgnoreCase("SEVERE")) {
                        level = Level.SEVERE;
                    } else if (levelString.equalsIgnoreCase("INFO")) {
                        level = Level.INFO;
                    } else if (levelString.equalsIgnoreCase("FINEST")) {
                        level = Level.FINEST;
                    }
                    if (level == null) {
                        throw new RuntimeException("Internal assertion failed.   Unexpected Level string: " + levelString);
                    }
                    logger.enduserlog(level, logMatcher.group(2));
                }
                return;
            }
            case 'a': {
                this.enforce1charSpecial(arg1, 'a');
                if (other != null) {
                    this.curConn.setAutoCommit(Boolean.valueOf(other));
                    this.possiblyUncommitteds.set(false);
                }
                this.stdprintln(this.rb.getString(SqltoolRB.A_SETTING, Boolean.toString(this.curConn.getAutoCommit())));
                return;
            }
            case 'v': {
                this.enforce1charSpecial(arg1, 'v');
                if (other != null) {
                    if (integerPattern.matcher(other).matches()) {
                        this.curConn.setTransactionIsolation(Integer.parseInt(other));
                    } else {
                        RCData.setTI(this.curConn, other);
                    }
                }
                this.stdprintln(this.rb.getString(SqltoolRB.TRANSISO_REPORT, this.curConn.isReadOnly() ? "R/O " : "R/W ", RCData.tiToString(this.curConn.getTransactionIsolation())));
                return;
            }
            case '=': {
                this.enforce1charSpecial(arg1, '=');
                this.curConn.commit();
                this.possiblyUncommitteds.set(false);
                this.stdprintln(this.rb.getString(SqltoolRB.COMMITTED));
                return;
            }
            case 'b': {
                if (arg1.length() == 1) {
                    if (other != null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
                    }
                    this.fetchBinary = true;
                    return;
                }
                if (arg1.charAt(1) == 'p') {
                    if (other != null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
                    }
                    this.doPrepare = true;
                    return;
                }
                if (arg1.charAt(1) != 'd' && arg1.charAt(1) != 'l' || other == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
                }
                File otherFile = new File(other);
                try {
                    if (arg1.charAt(1) == 'd') {
                        this.dump(otherFile);
                    } else {
                        this.binBuffer = SqlFile.loadBinary(otherFile);
                        this.stdprintln(this.rb.getString(SqltoolRB.BINARY_LOADEDBYTESINTO, this.binBuffer.length));
                    }
                }
                catch (BadSpecial bs) {
                    throw bs;
                }
                catch (IOException ioe) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.BINARY_FILEFAIL, other), ioe);
                }
                return;
            }
            case 't': {
                this.enforce1charSpecial(arg1, '=');
                if (other != null) {
                    this.reportTimes = Boolean.valueOf(other);
                }
                this.stdprintln(this.rb.getString(SqltoolRB.EXECTIME_REPORTING, Boolean.toString(this.reportTimes)));
                return;
            }
            case '*': 
            case 'c': {
                this.enforce1charSpecial(arg1, '=');
                if (other != null) {
                    this.continueOnError = Boolean.valueOf(other);
                }
                this.stdprintln(this.rb.getString(SqltoolRB.C_SETTING, Boolean.toString(this.continueOnError)));
                return;
            }
            case '?': {
                this.stdprintln(this.rb.getString(SqltoolRB.SPECIAL_HELP));
                return;
            }
            case '!': {
                byte[] ba = new byte[1024];
                String extCommand = (arg1.length() == 1 ? "" : arg1.substring(1)) + (arg1.length() > 1 && other != null ? " " : "") + (other == null ? "" : other);
                if (extCommand.trim().length() < 1) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_INCOMPLETE));
                }
                try {
                    int i;
                    Runtime runtime = Runtime.getRuntime();
                    Process proc = wincmdPattern == null ? runtime.exec(extCommand) : runtime.exec(SqlFile.genWinArgs(extCommand));
                    proc.getOutputStream().close();
                    InputStream stream = proc.getInputStream();
                    while ((i = stream.read(ba)) > 0) {
                        this.stdprint(new String(ba, 0, i));
                    }
                    stream.close();
                    stream = proc.getErrorStream();
                    while ((i = stream.read(ba)) > 0) {
                        String s = new String(ba, 0, i);
                        if (s.endsWith(LS)) {
                            if (s.length() == LS.length()) continue;
                            s = s.substring(0, s.length() - LS.length());
                        }
                        logger.severe(s);
                    }
                    stream.close();
                    if (proc.waitFor() != 0) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_COMMAND_FAIL, extCommand));
                    }
                }
                catch (BadSpecial bs) {
                    throw bs;
                }
                catch (Exception e) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_COMMAND_FAIL, extCommand), e);
                }
                return;
            }
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_UNKNOWN, Character.toString(arg1.charAt(0))));
    }

    static int pastName(String inString, int startIndex) {
        String workString = inString.substring(startIndex);
        int e = inString.length();
        for (int i = 0; i < nonVarChars.length; ++i) {
            int nonVarIndex = workString.indexOf(nonVarChars[i]);
            if (nonVarIndex <= -1 || nonVarIndex >= e) continue;
            e = nonVarIndex;
        }
        return startIndex + e;
    }

    private String dereference(String inString, boolean permitAlias) throws SqlToolError {
        boolean permitUnset;
        String s;
        int b;
        String varValue;
        String varName;
        int e;
        StringBuffer expandBuffer = new StringBuffer(inString);
        if (permitAlias && inString.trim().charAt(0) == '/') {
            int slashIndex = inString.indexOf(47);
            e = SqlFile.pastName(inString.substring(slashIndex + 1), 0);
            if (e < 1) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLALIAS_MALFORMAT));
            }
            varName = inString.substring(slashIndex + 1, slashIndex + 1 + e);
            varValue = (String)this.userVars.get(varName);
            if (varValue == null) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, varName));
            }
            expandBuffer.replace(slashIndex, slashIndex + 1 + e, (String)this.userVars.get(varName));
        }
        int iterations = 0;
        while ((b = (s = expandBuffer.toString()).indexOf("${")) >= 0) {
            e = s.indexOf(125, b + 2);
            if (e == b + 2) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_EMPTY));
            }
            if (e < 0) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_UNTERMINATED));
            }
            permitUnset = s.charAt(b + 2) == ':';
            varName = s.substring(b + (permitUnset ? 3 : 2), e);
            if (iterations++ > 10000) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.VAR_INFINITE, varName));
            }
            varValue = System.getProperty(varName);
            if (varValue == null) {
                if (permitUnset) {
                    varValue = "";
                } else {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_UNDEFINED, varName));
                }
            }
            expandBuffer.replace(b, e + 1, varValue);
        }
        iterations = 0;
        while ((b = (s = expandBuffer.toString()).indexOf("*{")) >= 0) {
            e = s.indexOf(125, b + 2);
            if (e == b + 2) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_NAMEEMPTY));
            }
            if (e < 0) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNTERMINATED));
            }
            permitUnset = s.charAt(b + 2) == ':';
            varName = s.substring(b + (permitUnset ? 3 : 2), e);
            if (iterations++ > 10000) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.VAR_INFINITE, varName));
            }
            varValue = (String)this.userVars.get(varName);
            if (varValue == null) {
                if (permitUnset) {
                    varValue = "";
                } else {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, varName));
                }
            }
            expandBuffer.replace(b, e + 1, varValue);
        }
        return expandBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBlock(Token token) throws BadSpecial, SqlToolError {
        Matcher m = plPattern.matcher(this.dereference(token.val, false));
        if (!m.matches()) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_MALFORMAT));
        }
        if (m.groupCount() < 1 || m.group(1) == null) {
            this.plMode = true;
            this.stdprintln(this.rb.getString(SqltoolRB.PL_EXPANSIONMODE, "on"));
            return;
        }
        String[] tokens = m.group(1).split("\\s+", -1);
        this.plMode = true;
        if (tokens[0].equals("foreach")) {
            Matcher foreachM = foreachPattern.matcher(this.dereference(token.val, false));
            if (!foreachM.matches()) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.FOREACH_MALFORMAT));
            }
            if (foreachM.groupCount() != 2) {
                throw new RuntimeException("Internal assertion failed.  foreach pattern matched, but captured " + foreachM.groupCount() + " groups");
            }
            String varName = foreachM.group(1);
            if (varName.indexOf(58) > -1) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
            }
            String[] values = foreachM.group(2).split("\\s+", -1);
            String origval = (String)this.userVars.get(varName);
            try {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        this.userVars.put(varName, values[i]);
                        this.updateUserSettings();
                        boolean origRecursed = this.recursed;
                        this.recursed = true;
                        try {
                            this.scanpass(token.nestedBlock.dup());
                            continue;
                        }
                        finally {
                            this.recursed = origRecursed;
                        }
                    }
                    catch (ContinueException ce) {
                        String ceMessage = ce.getMessage();
                        if (ceMessage == null || ceMessage.equals("foreach")) continue;
                        throw ce;
                    }
                }
            }
            catch (BreakException be) {
                String beMessage = be.getMessage();
                if (beMessage != null && !beMessage.equals("foreach")) {
                    throw be;
                }
            }
            catch (QuitNow qn) {
                throw qn;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), e);
            }
            if (origval == null) {
                this.userVars.remove(varName);
                this.updateUserSettings();
                return;
            } else {
                this.userVars.put(varName, origval);
            }
            return;
        }
        if (!tokens[0].equals("if") && !tokens[0].equals("while")) throw new BadSpecial(this.rb.getString(SqltoolRB.PL_UNKNOWN, tokens[0]));
        Matcher ifwhileM = ifwhilePattern.matcher(this.dereference(token.val, false));
        if (!ifwhileM.matches()) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.IFWHILE_MALFORMAT));
        }
        if (ifwhileM.groupCount() != 1) {
            throw new RuntimeException("Internal assertion failed.  if/while pattern matched, but captured " + ifwhileM.groupCount() + " groups");
        }
        String[] values = ifwhileM.group(1).replaceAll("!([a-zA-Z0-9*])", "! $1").replaceAll("([a-zA-Z0-9*])!", "$1 !").split("\\s+", -1);
        if (tokens[0].equals("if")) {
            try {
                if (!this.eval(values)) return;
                boolean origRecursed = this.recursed;
                this.recursed = true;
                try {
                    this.scanpass(token.nestedBlock.dup());
                    return;
                }
                finally {
                    this.recursed = origRecursed;
                }
            }
            catch (BreakException be) {
                String beMessage = be.getMessage();
                if (beMessage != null && beMessage.equals("if")) return;
                throw be;
            }
            catch (ContinueException ce) {
                throw ce;
            }
            catch (QuitNow qn) {
                throw qn;
            }
            catch (BadSpecial bs) {
                bs.appendMessage(this.rb.getString(SqltoolRB.IF_MALFORMAT));
                throw bs;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), e);
            }
        }
        if (!tokens[0].equals("while")) throw new RuntimeException(this.rb.getString(SqltoolRB.PL_UNKNOWN, tokens[0]));
        try {
            while (this.eval(values)) {
                try {
                    boolean origRecursed = this.recursed;
                    this.recursed = true;
                    try {
                        this.scanpass(token.nestedBlock.dup());
                    }
                    finally {
                        this.recursed = origRecursed;
                    }
                }
                catch (ContinueException ce) {
                    String ceMessage = ce.getMessage();
                    if (ceMessage == null || ceMessage.equals("while")) continue;
                    throw ce;
                    return;
                }
            }
        }
        catch (BreakException be) {
            String beMessage = be.getMessage();
            if (beMessage == null || beMessage.equals("while")) return;
            throw be;
        }
        catch (QuitNow qn) {
            throw qn;
        }
        catch (BadSpecial bs) {
            bs.appendMessage(this.rb.getString(SqltoolRB.WHILE_MALFORMAT));
            throw bs;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), e);
        }
    }

    private void processPL(String inString) throws BadSpecial, SqlToolError {
        String string = inString == null ? this.buffer.val : inString;
        Matcher m = plPattern.matcher(this.dereference(string, false));
        if (!m.matches()) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_MALFORMAT));
        }
        if (m.groupCount() < 1 || m.group(1) == null) {
            this.plMode = true;
            this.stdprintln(this.rb.getString(SqltoolRB.PL_EXPANSIONMODE, "on"));
            return;
        }
        String[] tokens = m.group(1).split("\\s+", -1);
        if (tokens[0].charAt(0) == '?') {
            this.stdprintln(this.rb.getString(SqltoolRB.PL_HELP));
            return;
        }
        this.plMode = true;
        if (tokens[0].equals("end")) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.END_NOBLOCK));
        }
        if (tokens[0].equals("continue")) {
            if (tokens.length > 1) {
                if (tokens.length == 2 && (tokens[1].equals("foreach") || tokens[1].equals("while"))) {
                    throw new ContinueException(tokens[1]);
                }
                throw new BadSpecial(this.rb.getString(SqltoolRB.CONTINUE_SYNTAX));
            }
            throw new ContinueException();
        }
        if (tokens[0].equals("break")) {
            if (tokens.length > 1) {
                if (tokens.length == 2 && (tokens[1].equals("foreach") || tokens[1].equals("if") || tokens[1].equals("while") || tokens[1].equals("file"))) {
                    throw new BreakException(tokens[1]);
                }
                throw new BadSpecial(this.rb.getString(SqltoolRB.BREAK_SYNTAX));
            }
            throw new BreakException();
        }
        if (tokens[0].equals("list") || tokens[0].equals("listvalues") || tokens[0].equals("listsysprops")) {
            boolean doValues;
            boolean sysProps = tokens[0].equals("listsysprops");
            boolean bl = doValues = tokens[0].equals("listvalues") || sysProps;
            if (tokens.length == 1) {
                this.stdprint(this.formatNicely(sysProps ? System.getProperties() : this.userVars, doValues));
            } else {
                if (doValues) {
                    this.stdprintln(this.rb.getString(SqltoolRB.PL_LIST_PARENS));
                } else {
                    this.stdprintln(this.rb.getString(SqltoolRB.PL_LIST_LENGTHS));
                }
                for (int i = 1; i < tokens.length; ++i) {
                    String s = (String)(sysProps ? System.getProperties() : this.userVars).get(tokens[i]);
                    if (s == null) continue;
                    this.stdprintln(PRE_TR + tokens[i] + ": " + (doValues ? "(" + s + ')' : Integer.toString(s.length())));
                }
            }
            return;
        }
        if (tokens[0].equals("dump") || tokens[0].equals("load")) {
            if (tokens.length != 3) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.DUMPLOAD_MALFORMAT));
            }
            String varName = tokens[1];
            if (varName.indexOf(58) > -1) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
            }
            File dlFile = new File(tokens[2]);
            try {
                if (tokens[0].equals("dump")) {
                    this.dump(varName, dlFile);
                } else {
                    this.load(varName, dlFile, this.charset);
                }
            }
            catch (IOException ioe) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.DUMPLOAD_FAIL, varName, dlFile.toString()), ioe);
            }
            return;
        }
        if (tokens[0].equals("prepare")) {
            if (tokens.length != 2) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.PREPARE_MALFORMAT));
            }
            if (this.userVars.get(tokens[1]) == null) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, tokens[1]));
            }
            this.prepareVar = tokens[1];
            this.doPrepare = true;
            return;
        }
        m = varsetPattern.matcher(this.dereference(string, false));
        if (!m.matches()) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_UNKNOWN, tokens[0]));
        }
        if (m.groupCount() < 2 || m.groupCount() > 3) {
            throw new RuntimeException("varset pattern matched but captured " + m.groupCount() + " groups");
        }
        String varName = m.group(1);
        if (varName.indexOf(58) > -1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
        }
        switch (m.group(2).charAt(0)) {
            case '_': {
                this.silentFetch = true;
            }
            case '~': {
                if (m.groupCount() > 2 && m.group(3) != null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_TILDEDASH_NOMOREARGS, m.group(3)));
                }
                this.userVars.remove(varName);
                this.updateUserSettings();
                this.fetchingVar = varName;
                return;
            }
            case '=': {
                if (this.fetchingVar != null && this.fetchingVar.equals(varName)) {
                    this.fetchingVar = null;
                }
                if (m.groupCount() > 2 && m.group(3) != null) {
                    this.userVars.put(varName, m.group(3));
                } else {
                    this.userVars.remove(varName);
                }
                this.updateUserSettings();
                return;
            }
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.PL_UNKNOWN, tokens[0]));
    }

    private void stdprint(String s) {
        this.stdprint(s, false);
    }

    private void stdprintln(String s) {
        this.stdprintln(s, false);
    }

    private void stdprintln(boolean queryOutput) {
        if (this.htmlMode) {
            this.psStd.println("<BR>");
        } else {
            this.psStd.println();
        }
        if (queryOutput && this.pwQuery != null) {
            if (this.htmlMode) {
                this.pwQuery.println("<BR>");
            } else {
                this.pwQuery.println();
            }
            this.pwQuery.flush();
        }
    }

    private void errprintln(String s) {
        if (this.htmlMode) {
            this.psStd.println("<DIV style='color:white; background: red; font-weight: bold'>" + s + "</DIV>");
        } else {
            logger.privlog(Level.SEVERE, s, null, 6, SqlFile.class);
        }
    }

    private void stdprint(String s, boolean queryOutput) {
        this.psStd.print(this.htmlMode ? "<P>" + s + "</P>" : s);
        if (queryOutput && this.pwQuery != null) {
            this.pwQuery.print(this.htmlMode ? "<P>" + s + "</P>" : s);
            this.pwQuery.flush();
        }
    }

    private void stdprintln(String s, boolean queryOutput) {
        this.psStd.println(this.htmlMode ? "<P>" + s + "</P>" : s);
        if (queryOutput && this.pwQuery != null) {
            this.pwQuery.println(this.htmlMode ? "<P>" + s + "</P>" : s);
            this.pwQuery.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listTables(char c, String inFilter) throws BadSpecial, SqlToolError {
        String schema = null;
        int[] listSet = null;
        String[] types = null;
        String[] additionalSchemas = null;
        Statement statement = null;
        ResultSet rs = null;
        String narrower = "";
        String filter = inFilter;
        try {
            Matcher matcher;
            DatabaseMetaData md = this.curConn.getMetaData();
            String dbProductName = md.getDatabaseProductName();
            types = new String[1];
            switch (c) {
                case '*': {
                    types = null;
                    break;
                }
                case 'S': {
                    if (dbProductName.indexOf("Oracle") > -1) {
                        this.errprintln(this.rb.getString(SqltoolRB.VENDOR_ORACLE_DS));
                        types[0] = "TABLE";
                        schema = "SYS";
                        additionalSchemas = oracleSysSchemas;
                        break;
                    }
                    types[0] = "SYSTEM TABLE";
                    break;
                }
                case 's': {
                    if (dbProductName.indexOf("HSQL") > -1) {
                        if (filter != null && (matcher = nameDotPattern.matcher(filter)).matches()) {
                            narrower = "\nWHERE sequence_schema = '" + matcher.group(1) + "'";
                            filter = null;
                        }
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT sequence_schema, sequence_name FROM information_schema.system_sequences" + narrower);
                        break;
                    }
                    types[0] = "SEQUENCE";
                    break;
                }
                case 'r': {
                    if (dbProductName.indexOf("HSQL") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT authorization_name FROM information_schema.system_authorizations\nWHERE authorization_type = 'ROLE'\nORDER BY authorization_name");
                        break;
                    }
                    if (dbProductName.indexOf("Adaptive Server Enterprise") <= -1) {
                        if (dbProductName.indexOf("Apache Derby") <= -1) throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_NOSUP_D, "r"));
                        throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_DERBY_DR));
                    }
                    statement = this.curConn.createStatement();
                    statement.execute("SELECT name FROM syssrvroles ORDER BY name");
                    break;
                }
                case 'u': {
                    if (dbProductName.indexOf("HSQL") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT user_name, admin FROM information_schema.system_users\nORDER BY user_name");
                        break;
                    }
                    if (dbProductName.indexOf("Oracle") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT username, created FROM all_users ORDER BY username");
                        break;
                    }
                    if (dbProductName.indexOf("PostgreSQL") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT usename, usesuper FROM pg_catalog.pg_user ORDER BY usename");
                        break;
                    }
                    if (dbProductName.indexOf("Adaptive Server Enterprise") <= -1) {
                        if (dbProductName.indexOf("Apache Derby") <= -1) throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_NOSUP_D, "u"));
                        throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_DERBY_DU));
                    }
                    statement = this.curConn.createStatement();
                    statement.execute("SELECT name, accdate, fullname FROM syslogins ORDER BY name");
                    break;
                }
                case 'a': {
                    if (dbProductName.indexOf("HSQL") > -1) {
                        if (filter != null && (matcher = nameDotPattern.matcher(filter)).matches()) {
                            narrower = "\nWHERE alias_schema = '" + matcher.group(1) + "'";
                            filter = null;
                        }
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT alias_schem, alias FROM information_schema.system_aliases" + narrower);
                        break;
                    }
                    types[0] = "ALIAS";
                    break;
                }
                case 't': {
                    this.excludeSysSchemas = dbProductName.indexOf("Oracle") > -1;
                    types[0] = "TABLE";
                    break;
                }
                case 'v': {
                    types[0] = "VIEW";
                    break;
                }
                case 'n': {
                    rs = md.getSchemas();
                    if (rs == null) {
                        throw new BadSpecial("Failed to get metadata from database");
                    }
                    this.displayResultSet(null, rs, listMDSchemaCols, filter);
                    return;
                }
                case 'i': {
                    String table = null;
                    if (filter != null) {
                        int dotat = filter.indexOf(46);
                        String string = schema = dotat > 0 ? filter.substring(0, dotat) : null;
                        if (!nameDotPattern.matcher(filter).matches()) {
                            table = dotat > 0 ? filter.substring(dotat + 1) : filter;
                        }
                        filter = null;
                    }
                    if ((rs = md.getIndexInfo(null, schema, table, false, true)) == null) {
                        throw new BadSpecial("Failed to get metadata from database");
                    }
                    this.displayResultSet(null, rs, listMDIndexCols, null);
                    return;
                }
                default: {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_D_UNKNOWN, Character.toString(c)) + LS + this.D_OPTIONS_TEXT);
                }
            }
            if (statement == null) {
                listSet = dbProductName.indexOf("HSQL") > -1 ? listMDTableCols[1] : (dbProductName.indexOf("Oracle") > -1 ? listMDTableCols[2] : listMDTableCols[0]);
                if (schema == null && filter != null && (matcher = nameDotPattern.matcher(filter)).matches()) {
                    schema = matcher.group(1);
                    filter = null;
                }
            }
            ResultSet resultSet = rs = statement == null ? md.getTables(null, schema, null, types) : statement.getResultSet();
            if (rs == null) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL));
            }
            this.displayResultSet(null, rs, listSet, filter);
            if (additionalSchemas == null) return;
            int i = 1;
            while (i < additionalSchemas.length) {
                rs = md.getTables(null, additionalSchemas[i], null, types);
                if (rs == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAILFOR, additionalSchemas[i]));
                }
                if (rs.next()) {
                    this.displayResultSet(null, md.getTables(null, additionalSchemas[i], null, types), listSet, filter);
                }
                ++i;
            }
            return;
        }
        catch (SQLException se) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL), se);
        }
        catch (NullPointerException npe) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL), npe);
        }
        finally {
            this.excludeSysSchemas = false;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException se) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSQL() throws SQLException, SqlToolError {
        if (this.buffer == null) {
            throw new RuntimeException("Internal assertion failed.  No buffer in processSQL().");
        }
        if (this.buffer.type != 0) {
            throw new RuntimeException("Internal assertion failed.  Token type " + this.buffer.getTypeString() + " in processSQL().");
        }
        String string = this.lastSqlStatement = this.plMode ? this.dereference(this.buffer.val, true) : this.buffer.val;
        if (!this.permitEmptySqlStatements && this.buffer.val == null || this.buffer.val.trim().length() < 1) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.SQLSTATEMENT_EMPTY));
        }
        Statement statement = null;
        long startTime = 0L;
        if (this.reportTimes) {
            startTime = new Date().getTime();
        }
        try {
            try {
                if (this.doPrepare) {
                    if (this.lastSqlStatement.indexOf(63) < 1) {
                        this.lastSqlStatement = null;
                        throw new SqlToolError(this.rb.getString(SqltoolRB.PREPARE_DEMANDQM));
                    }
                    this.doPrepare = false;
                    PreparedStatement ps = this.curConn.prepareStatement(this.lastSqlStatement);
                    statement = ps;
                    if (this.prepareVar == null) {
                        if (this.binBuffer == null) {
                            this.lastSqlStatement = null;
                            throw new SqlToolError(this.rb.getString(SqltoolRB.BINBUFFER_EMPTY));
                        }
                        ps.setBytes(1, this.binBuffer);
                    } else {
                        String val = (String)this.userVars.get(this.prepareVar);
                        if (val == null) {
                            this.lastSqlStatement = null;
                            throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, this.prepareVar));
                        }
                        this.prepareVar = null;
                        ps.setString(1, val);
                    }
                    ps.executeUpdate();
                } else {
                    statement = this.curConn.createStatement();
                    statement.execute(this.lastSqlStatement);
                }
            }
            finally {
                if (this.reportTimes) {
                    long elapsed = new Date().getTime() - startTime;
                    this.condlPrintln(this.rb.getString(SqltoolRB.EXECTIME_REPORT, (int)elapsed), false);
                }
            }
            this.possiblyUncommitteds.set(!commitOccursPattern.matcher(this.lastSqlStatement).matches());
            ResultSet rs = null;
            try {
                rs = statement.getResultSet();
                this.displayResultSet(statement, rs, null, null);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException se) {}
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
        }
        this.lastSqlStatement = null;
    }

    private void displayResultSet(Statement statement, ResultSet r, int[] incCols, String filterString) throws SQLException, SqlToolError {
        int updateCount = statement == null ? -1 : statement.getUpdateCount();
        boolean silent = this.silentFetch;
        boolean binary = this.fetchBinary;
        Pattern filter = null;
        this.silentFetch = false;
        this.fetchBinary = false;
        if (filterString != null) {
            try {
                filter = Pattern.compile(filterString);
            }
            catch (PatternSyntaxException pse) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.REGEX_MALFORMAT, pse.getMessage()));
            }
        }
        if (this.excludeSysSchemas) {
            this.stdprintln(this.rb.getString(SqltoolRB.VENDOR_NOSUP_SYSSCHEMAS));
        }
        switch (updateCount) {
            case -1: {
                int j;
                int i;
                String[] fieldArray;
                boolean skip;
                if (r == null) {
                    this.stdprintln(this.rb.getString(SqltoolRB.NORESULT), true);
                    break;
                }
                ResultSetMetaData m = r.getMetaData();
                int cols = m.getColumnCount();
                int incCount = incCols == null ? cols : incCols.length;
                ArrayList<String[]> rows = new ArrayList<String[]>();
                String[] headerArray = null;
                int[] maxWidth = new int[incCount];
                if (!this.htmlMode) {
                    for (int i2 = 0; i2 < maxWidth.length; ++i2) {
                        maxWidth[i2] = 0;
                    }
                }
                boolean[] rightJust = new boolean[incCount];
                int[] dataType = new int[incCount];
                boolean[] autonulls = new boolean[incCount];
                int insi = -1;
                headerArray = new String[incCount];
                for (int i3 = 1; i3 <= cols; ++i3) {
                    if (incCols != null) {
                        skip = true;
                        for (int j2 = 0; j2 < incCols.length; ++j2) {
                            if (i3 != incCols[j2]) continue;
                            skip = false;
                        }
                        if (skip) continue;
                    }
                    headerArray[++insi] = m.getColumnLabel(i3);
                    dataType[insi] = m.getColumnType(i3);
                    rightJust[insi] = false;
                    autonulls[insi] = true;
                    switch (dataType[insi]) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            rightJust[insi] = true;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -1: 
                        case 12: 
                        case 2003: 
                        case 2004: 
                        case 2005: {
                            autonulls[insi] = false;
                        }
                    }
                    if (this.htmlMode || headerArray[insi] == null || headerArray[insi].length() <= maxWidth[insi]) continue;
                    maxWidth[insi] = headerArray[insi].length();
                }
                while (r.next()) {
                    fieldArray = new String[incCount];
                    insi = -1;
                    boolean filteredOut = filter != null;
                    for (i = 1; i <= cols; ++i) {
                        if (incCols != null) {
                            skip = true;
                            for (j = 0; j < incCols.length; ++j) {
                                if (i != incCols[j]) continue;
                                skip = false;
                            }
                            if (skip) continue;
                        }
                        if (!SqlFile.canDisplayType(dataType[++insi])) {
                            binary = true;
                        }
                        String val = null;
                        boolean isValNull = true;
                        if (!binary) {
                            switch (dataType[insi]) {
                                case 91: 
                                case 92: 
                                case 93: 
                                case 94: 
                                case 95: {
                                    Timestamp ts = r.getTimestamp(i);
                                    isValNull = r.wasNull();
                                    String string = val = ts == null ? null : ts.toString();
                                    if (dataType[insi] == 93 || dataType[insi] == 95 || val == null) break;
                                    int dotAt = val.lastIndexOf(46);
                                    for (int z = dotAt + 1; z < val.length(); ++z) {
                                        if (val.charAt(z) == '0') continue;
                                        dotAt = 0;
                                        break;
                                    }
                                    if (dotAt <= 1) break;
                                    val = val.substring(0, dotAt);
                                    break;
                                }
                                default: {
                                    val = r.getString(i);
                                    isValNull = r.wasNull();
                                    if (val != null) break;
                                    try {
                                        val = this.streamToString(r.getAsciiStream(i), this.charset);
                                        isValNull = r.wasNull();
                                        break;
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        if (binary || val == null && !isValNull) {
                            if (this.pwDsv != null) {
                                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_BINCOL));
                            }
                            try {
                                this.binBuffer = SqlFile.streamToBytes(r.getBinaryStream(i));
                                isValNull = r.wasNull();
                            }
                            catch (IOException ioe) {
                                throw new SqlToolError("Failed to read value using stream", ioe);
                            }
                            this.stdprintln(this.rb.getString(SqltoolRB.BINBUF_WRITE, Integer.toString(this.binBuffer.length), headerArray[insi], SqlFile.sqlTypeToString(dataType[insi])));
                            return;
                        }
                        if (this.excludeSysSchemas && val != null && i == 2) {
                            for (int z = 0; z < oracleSysSchemas.length; ++z) {
                                if (!val.equals(oracleSysSchemas[z])) continue;
                                filteredOut = true;
                                break;
                            }
                        }
                        this.userVars.put("?", val == null ? this.nullRepToken : val);
                        if (this.fetchingVar != null) {
                            this.userVars.put(this.fetchingVar, this.userVars.get("?"));
                            this.updateUserSettings();
                            this.fetchingVar = null;
                        }
                        if (silent) {
                            return;
                        }
                        if (filter != null && (val == null || filter.matcher(val).find())) {
                            filteredOut = false;
                        }
                        fieldArray[insi] = val == null && this.pwDsv == null ? (dataType[insi] == 12 ? (this.htmlMode ? "<I>null</I>" : this.nullRepToken) : "") : val;
                        if (this.htmlMode || this.pwDsv != null || fieldArray[insi].length() <= maxWidth[insi]) continue;
                        maxWidth[insi] = fieldArray[insi].length();
                    }
                    if (filteredOut) continue;
                    rows.add(fieldArray);
                }
                if (this.pwDsv == null) {
                    this.condlPrintln("<TABLE border='1'>", true);
                    if (incCount > 1) {
                        this.condlPrint(SqlFile.htmlRow(0) + LS + PRE_TD, true);
                        for (i = 0; i < headerArray.length; ++i) {
                            this.condlPrint("<TD>" + headerArray[i] + "</TD>", true);
                            this.condlPrint((i > 0 ? "  " : "") + (i < headerArray.length - 1 || rightJust[i] ? StringUtil.toPaddedString(headerArray[i], maxWidth[i], ' ', !rightJust[i]) : headerArray[i]), false);
                        }
                        this.condlPrintln(LS + PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                        if (!this.htmlMode) {
                            for (i = 0; i < headerArray.length; ++i) {
                                this.condlPrint((i > 0 ? "  " : "") + SqlFile.divider(maxWidth[i]), false);
                            }
                            this.condlPrintln("", false);
                        }
                    }
                    for (i = 0; i < rows.size(); ++i) {
                        this.condlPrint(SqlFile.htmlRow(i % 2 == 0 ? 2 : 1) + LS + PRE_TD, true);
                        fieldArray = (String[])rows.get(i);
                        for (j = 0; j < fieldArray.length; ++j) {
                            this.condlPrint("<TD>" + fieldArray[j] + "</TD>", true);
                            this.condlPrint((j > 0 ? "  " : "") + (j < fieldArray.length - 1 || rightJust[j] ? StringUtil.toPaddedString(fieldArray[j], maxWidth[j], ' ', !rightJust[j]) : fieldArray[j]), false);
                        }
                        this.condlPrintln(LS + PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                    }
                    this.condlPrintln("</TABLE>", true);
                    if (rows.size() != 1) {
                        this.stdprintln(LS + this.rb.getString(SqltoolRB.ROWS_FETCHED, rows.size()), true);
                    }
                    this.condlPrintln("<HR>", true);
                    break;
                }
                if (incCount > 0) {
                    for (i = 0; i < headerArray.length; ++i) {
                        this.dsvSafe(headerArray[i]);
                        this.pwDsv.print(headerArray[i]);
                        if (i >= headerArray.length - 1) continue;
                        this.pwDsv.print(this.dsvColDelim);
                    }
                    this.pwDsv.print(this.dsvRowDelim);
                }
                for (i = 0; i < rows.size(); ++i) {
                    fieldArray = (String[])rows.get(i);
                    for (j = 0; j < fieldArray.length; ++j) {
                        this.dsvSafe(fieldArray[j]);
                        this.pwDsv.print(fieldArray[j] == null ? (autonulls[j] ? "" : this.nullRepToken) : fieldArray[j]);
                        if (j >= fieldArray.length - 1) continue;
                        this.pwDsv.print(this.dsvColDelim);
                    }
                    this.pwDsv.print(this.dsvRowDelim);
                }
                this.stdprintln(this.rb.getString(SqltoolRB.ROWS_FETCHED_DSV, rows.size()));
                break;
            }
            default: {
                this.userVars.put("?", Integer.toString(updateCount));
                if (this.fetchingVar != null) {
                    this.userVars.put(this.fetchingVar, this.userVars.get("?"));
                    this.updateUserSettings();
                    this.fetchingVar = null;
                }
                if (updateCount == 0) break;
                this.stdprintln(updateCount == 1 ? this.rb.getString(SqltoolRB.ROW_UPDATE_SINGULAR) : this.rb.getString(SqltoolRB.ROW_UPDATE_MULTIPLE, updateCount));
            }
        }
    }

    private static String htmlRow(int colType) {
        switch (colType) {
            case 0: {
                return "    <TR style='font-weight: bold;'>";
            }
            case 1: {
                return "    <TR style='background: #94d6ef; font: normal normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
            case 2: {
                return "    <TR style='background: silver; font: normal normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
        }
        return null;
    }

    private static String divider(int len) {
        return len > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, len);
    }

    private void showHistory() throws BadSpecial {
        if (this.history == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
        }
        if (this.history.size() < 1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_NONE));
        }
        for (int i = 0; i < this.history.size(); ++i) {
            Token token = (Token)this.history.get(i);
            this.psStd.println(DEFAULT_SKIP_PREFIX + (i + this.oldestHist) + " or " + (i - this.history.size()) + ':');
            this.psStd.println(token.reconstitute());
        }
        if (this.buffer != null) {
            this.psStd.println(this.rb.getString(SqltoolRB.EDITBUFFER_CONTENTS, this.buffer.reconstitute()));
        }
        this.psStd.println();
        this.psStd.println(this.rb.getString(SqltoolRB.BUFFER_INSTRUCTIONS));
    }

    private Token commandFromHistory(int inIndex) throws BadSpecial {
        int index = inIndex;
        if (this.history == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
        }
        if (index == 0) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_NUMBER_REQ));
        }
        if (index > 0) {
            if ((index -= this.oldestHist) < 0) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_BACKTO, this.oldestHist));
            }
            if (index >= this.history.size()) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UPTO, this.history.size() + this.oldestHist - 1));
            }
        } else if ((index += this.history.size()) < 0) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_BACK, this.history.size()));
        }
        return (Token)this.history.get(index);
    }

    private Integer historySearch(String findRegex) throws BadSpecial {
        if (this.history == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile("(?ims)" + findRegex);
        }
        catch (PatternSyntaxException pse) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.REGEX_MALFORMAT, pse.getMessage()));
        }
        for (int index = this.history.size() - 1; index >= 0; --index) {
            if (!pattern.matcher(((Token)this.history.get((int)index)).val).find()) continue;
            return new Integer(index + this.oldestHist);
        }
        return null;
    }

    private boolean setBuf(Token newBuffer) {
        if (this.buffer != null && this.buffer != null && this.buffer.equals(newBuffer)) {
            return false;
        }
        switch (newBuffer.type) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new RuntimeException("Internal assertion failed.  Attempted to add command type " + newBuffer.getTypeString() + " to buffer");
            }
        }
        this.buffer = new Token(newBuffer.type, new String(newBuffer.val), newBuffer.line);
        return true;
    }

    private boolean historize() {
        if (this.history == null || this.buffer == null) {
            return false;
        }
        if (this.history.size() > 0 && this.history.get(this.history.size() - 1).equals(this.buffer)) {
            return false;
        }
        this.history.add(this.buffer);
        if (this.history.size() <= this.maxHistoryLength) {
            return true;
        }
        this.history.remove(0);
        ++this.oldestHist;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describe(String tableName, String filterString) throws SQLException {
        Pattern filter = null;
        boolean filterMatchesAll = false;
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String[] headerArray = new String[]{this.rb.getString(SqltoolRB.DESCRIBE_TABLE_NAME), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_DATATYPE), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_WIDTH), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_NONULLS)};
        int[] maxWidth = new int[]{0, 0, 0, 0};
        boolean[] rightJust = new boolean[]{false, false, true, false};
        if (filterString != null) {
            try {
                filterMatchesAll = filterString.charAt(0) == '/';
                filter = Pattern.compile(filterMatchesAll ? filterString.substring(1) : filterString);
            }
            catch (PatternSyntaxException pse) {
                throw new SQLException(this.rb.getString(SqltoolRB.REGEX_MALFORMAT, pse.getMessage()));
            }
        }
        for (int i = 0; i < headerArray.length; ++i) {
            if (this.htmlMode || headerArray[i].length() <= maxWidth[i]) continue;
            maxWidth[i] = headerArray[i].length();
        }
        ResultSet r = null;
        Statement statement = this.curConn.createStatement();
        try {
            int j;
            String[] fieldArray;
            int i;
            statement.execute("SELECT * FROM " + tableName + " WHERE 1 = 2");
            r = statement.getResultSet();
            ResultSetMetaData m = r.getMetaData();
            int cols = m.getColumnCount();
            for (i = 0; i < cols; ++i) {
                fieldArray = new String[4];
                fieldArray[0] = m.getColumnName(i + 1);
                if (filter != null && !filterMatchesAll && !filter.matcher(fieldArray[0]).find()) continue;
                fieldArray[1] = m.getColumnTypeName(i + 1);
                fieldArray[2] = Integer.toString(m.getColumnDisplaySize(i + 1));
                String string = m.isNullable(i + 1) == 1 ? (this.htmlMode ? "&nbsp;" : "") : (fieldArray[3] = "*");
                if (filter != null && filterMatchesAll && !filter.matcher(fieldArray[0] + ' ' + fieldArray[1] + ' ' + fieldArray[2] + ' ' + fieldArray[3]).find()) continue;
                rows.add(fieldArray);
                for (j = 0; j < fieldArray.length; ++j) {
                    if (fieldArray[j].length() <= maxWidth[j]) continue;
                    maxWidth[j] = fieldArray[j].length();
                }
            }
            this.condlPrint("<TABLE border='1'>" + LS + SqlFile.htmlRow(0) + LS + PRE_TD, true);
            for (i = 0; i < headerArray.length; ++i) {
                this.condlPrint("<TD>" + headerArray[i] + "</TD>", true);
                this.condlPrint((i > 0 ? "  " : "") + (i < headerArray.length - 1 || rightJust[i] ? StringUtil.toPaddedString(headerArray[i], maxWidth[i], ' ', !rightJust[i]) : headerArray[i]), false);
            }
            this.condlPrintln(LS + PRE_TR + "</TR>", true);
            this.condlPrintln("", false);
            if (!this.htmlMode) {
                for (i = 0; i < headerArray.length; ++i) {
                    this.condlPrint((i > 0 ? "  " : "") + SqlFile.divider(maxWidth[i]), false);
                }
                this.condlPrintln("", false);
            }
            for (i = 0; i < rows.size(); ++i) {
                this.condlPrint(SqlFile.htmlRow(i % 2 == 0 ? 2 : 1) + LS + PRE_TD, true);
                fieldArray = (String[])rows.get(i);
                for (j = 0; j < fieldArray.length; ++j) {
                    this.condlPrint("<TD>" + fieldArray[j] + "</TD>", true);
                    this.condlPrint((j > 0 ? "  " : "") + (j < fieldArray.length - 1 || rightJust[j] ? StringUtil.toPaddedString(fieldArray[j], maxWidth[j], ' ', !rightJust[j]) : fieldArray[j]), false);
                }
                this.condlPrintln(LS + PRE_TR + "</TR>", true);
                this.condlPrintln("", false);
            }
            this.condlPrintln(LS + "</TABLE>" + LS + "<HR>", true);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                statement.close();
            }
            catch (SQLException se) {}
        }
    }

    private boolean eval(String[] inTokens) throws BadSpecial {
        boolean negate = inTokens.length > 0 && inTokens[0].equals("!");
        String[] tokens = new String[negate ? inTokens.length - 1 : inTokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String inToken = inTokens[i + (negate ? 1 : 0)];
            tokens[i] = inToken.length() > 1 && inToken.charAt(0) == '*' ? (String)this.userVars.get(inToken.substring(1)) : inTokens[i + (negate ? 1 : 0)];
            if (tokens[i] != null) continue;
            tokens[i] = "";
        }
        if (tokens.length == 1) {
            return (tokens[0].length() > 0 && !tokens[0].equals("0")) ^ negate;
        }
        if (tokens.length == 3) {
            if (tokens[1].equals("==")) {
                return tokens[0].equals(tokens[2]) ^ negate;
            }
            if (tokens[1].equals("!=") || tokens[1].equals("<>") || tokens[1].equals("><")) {
                return !tokens[0].equals(tokens[2]) ^ negate;
            }
            if (tokens[1].equals(">")) {
                return (tokens[0].length() > tokens[2].length() || tokens[0].length() == tokens[2].length() && tokens[0].compareTo(tokens[2]) > 0) ^ negate;
            }
            if (tokens[1].equals("<")) {
                return (tokens[2].length() > tokens[0].length() || tokens[2].length() == tokens[0].length() && tokens[2].compareTo(tokens[0]) > 0) ^ negate;
            }
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.LOGICAL_UNRECOGNIZED));
    }

    private void closeQueryOutputStream() {
        if (this.pwQuery == null) {
            return;
        }
        if (this.htmlMode) {
            this.pwQuery.println("</BODY></HTML>");
            this.pwQuery.flush();
        }
        this.pwQuery.close();
        this.pwQuery = null;
    }

    private void condlPrintln(String s, boolean printHtml) {
        if (printHtml && !this.htmlMode || this.htmlMode && !printHtml) {
            return;
        }
        this.psStd.println(s);
        if (this.pwQuery != null) {
            this.pwQuery.println(s);
            this.pwQuery.flush();
        }
    }

    private void condlPrint(String s, boolean printHtml) {
        if (printHtml && !this.htmlMode || this.htmlMode && !printHtml) {
            return;
        }
        this.psStd.print(s);
        if (this.pwQuery != null) {
            this.pwQuery.print(s);
            this.pwQuery.flush();
        }
    }

    private String formatNicely(Map map, boolean withValues) {
        StringBuffer sb = new StringBuffer();
        Iterator it = new TreeMap(map).keySet().iterator();
        if (withValues) {
            SqlFile.appendLine(sb, this.rb.getString(SqltoolRB.PL_LIST_PARENS));
        } else {
            SqlFile.appendLine(sb, this.rb.getString(SqltoolRB.PL_LIST_LENGTHS));
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            String s = (String)map.get(key);
            SqlFile.appendLine(sb, PRE_TR + key + ": " + (withValues ? "(" + s + ')' : Integer.toString(s.length())));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(String varName, File dumpFile) throws IOException, BadSpecial {
        String val = (String)this.userVars.get(varName);
        if (val == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, varName));
        }
        OutputStreamWriter osw = this.charset == null ? new OutputStreamWriter(new FileOutputStream(dumpFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(dumpFile), this.charset);
        try {
            char lastChar;
            osw.write(val);
            if (val.length() > 0 && (lastChar = val.charAt(val.length() - 1)) != '\n' && lastChar != '\r') {
                osw.write(LS);
            }
            osw.flush();
        }
        finally {
            osw.close();
        }
        this.stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, Long.toString(dumpFile.length()), dumpFile.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(File dumpFile) throws IOException, BadSpecial {
        if (this.binBuffer == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.BINBUFFER_EMPTY));
        }
        FileOutputStream fos = new FileOutputStream(dumpFile);
        int len = 0;
        try {
            fos.write(this.binBuffer);
            len = this.binBuffer.length;
            this.binBuffer = null;
            fos.flush();
        }
        finally {
            fos.close();
        }
        this.stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, len, dumpFile.toString()));
    }

    /*
     * Exception decompiling
     */
    public String streamToString(InputStream is, String cs) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void load(String varName, File asciiFile, String cs) throws IOException {
        String string = this.streamToString(new FileInputStream(asciiFile), cs);
        this.userVars.put(varName, string);
        this.updateUserSettings();
    }

    public static byte[] streamToBytes(InputStream is) throws IOException {
        int i;
        byte[] xferBuffer = new byte[10240];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((i = is.read(xferBuffer)) > 0) {
            baos.write(xferBuffer, 0, i);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBinary(File binFile) throws IOException {
        byte[] xferBuffer = new byte[10240];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fis = new FileInputStream(binFile);
        try {
            int i;
            while ((i = fis.read(xferBuffer)) > 0) {
                baos.write(xferBuffer, 0, i);
            }
        }
        finally {
            fis.close();
        }
        byte[] ba = baos.toByteArray();
        return ba;
    }

    public static boolean canDisplayType(int i) {
        switch (i) {
            case 1111: 
            case 2000: 
            case 2002: 
            case 2004: {
                return false;
            }
        }
        return true;
    }

    public static String sqlTypeToString(int i) {
        switch (i) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case 94: {
                return "SQL_TIME_WITH_TIME_ZONE";
            }
            case 95: {
                return "SQL_TIMESTAMP_WITH_TIME_ZONE";
            }
        }
        return "Unknown type " + i;
    }

    public void dsvSafe(String s) throws SqlToolError {
        if (this.pwDsv == null || this.dsvColDelim == null || this.dsvRowDelim == null || this.nullRepToken == null) {
            throw new RuntimeException("Assertion failed.  \ndsvSafe called when DSV settings are incomplete");
        }
        if (s == null) {
            return;
        }
        if (s.indexOf(this.dsvColDelim) > 0) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_COLDELIM_PRESENT, this.dsvColDelim));
        }
        if (s.indexOf(this.dsvRowDelim) > 0) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_ROWDELIM_PRESENT, this.dsvRowDelim));
        }
        if (s.trim().equals(this.nullRepToken)) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NULLREP_PRESENT, this.nullRepToken));
        }
    }

    public static String convertEscapes(String inString) {
        if (inString == null) {
            return null;
        }
        return SqlFile.convertNumericEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(inString, "\\n", "\n"), "\\r", "\r"), "\\t", "\t"), "\\\\", "\\"), "\\f", "\f"));
    }

    private static String convertNumericEscapes(String string) {
        String workString = string;
        int i = 0;
        for (char dig = '0'; dig <= '9'; dig = (char)(dig + '\u0001')) {
            while ((i = workString.indexOf("\\" + dig, i)) > -1 && i < workString.length() - 1) {
                workString = SqlFile.convertNumericEscape(string, i);
            }
            while ((i = workString.indexOf("\\x" + dig, i)) > -1 && i < workString.length() - 1) {
                workString = SqlFile.convertNumericEscape(string, i);
            }
            while ((i = workString.indexOf("\\X" + dig, i)) > -1 && i < workString.length() - 1) {
                workString = SqlFile.convertNumericEscape(string, i);
            }
        }
        return workString;
    }

    private static String convertNumericEscape(String string, int offset) {
        int post = -1;
        int firstDigit = -1;
        int radix = -1;
        if (Character.toUpperCase(string.charAt(offset + 1)) == 'X') {
            firstDigit = offset + 2;
            radix = 16;
            post = firstDigit + 2;
            if (post > string.length()) {
                post = string.length();
            }
        } else {
            firstDigit = offset + 1;
            radix = Character.toUpperCase(string.charAt(firstDigit)) == '0' ? 8 : 10;
            for (post = firstDigit + 1; post < string.length() && Character.isDigit(string.charAt(post)); ++post) {
            }
        }
        return string.substring(0, offset) + (char)Integer.parseInt(string.substring(firstDigit, post), radix) + string.substring(post);
    }

    private static String convertEscapes(String string, String from, String to) {
        String workString = string;
        int i = 0;
        int fromLen = from.length();
        while ((i = workString.indexOf(from, i)) > -1 && i < workString.length() - 1) {
            workString = workString.substring(0, i) + to + workString.substring(i + fromLen);
        }
        return workString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDsv(String filePath, String skipPrefix) throws SqlToolError {
        boolean doResetAutocommit;
        boolean importAborted;
        int skipCount;
        int recCount;
        PrintWriter rejectReportWriter;
        PrintWriter rejectWriter;
        File rejectReportFile;
        File rejectFile;
        int rejectCount;
        block136: {
            int i;
            String curLine;
            int headerOffset;
            boolean switching;
            String trimmedLine;
            int lineCount;
            String tableName;
            ArrayList<String> headerList;
            String[] lines;
            int retval;
            HashSet<String> skipCols;
            TreeMap<String, String> constColMap;
            File dsvFile;
            block135: {
                int bytesread;
                byte[] bfr = null;
                dsvFile = new File(filePath);
                constColMap = null;
                if (this.dsvConstCols != null) {
                    constColMap = new TreeMap<String, String>();
                    String[] constPairs = this.dsvConstCols.split(this.dsvColSplitter, -1);
                    for (int i2 = 0; i2 < constPairs.length; ++i2) {
                        Matcher matcher = nameValPairPattern.matcher(constPairs[i2]);
                        if (!matcher.matches()) {
                            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_CONSTCOLS_NULLCOL));
                        }
                        constColMap.put(matcher.group(1).toLowerCase(), matcher.groupCount() < 2 || matcher.group(2) == null ? "" : matcher.group(2));
                    }
                }
                skipCols = null;
                if (this.dsvSkipCols != null) {
                    skipCols = new HashSet<String>();
                    String[] skipColsArray = this.dsvSkipCols.split(this.dsvColSplitter, -1);
                    for (int i3 = 0; i3 < skipColsArray.length; ++i3) {
                        skipCols.add(skipColsArray[i3].trim().toLowerCase());
                    }
                }
                if (!dsvFile.canRead()) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.FILE_READFAIL, dsvFile.toString()));
                }
                try {
                    bfr = new byte[(int)dsvFile.length()];
                }
                catch (RuntimeException re) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.READ_TOOBIG), re);
                }
                FileInputStream is = null;
                try {
                    is = new FileInputStream(dsvFile);
                    for (bytesread = 0; bytesread < bfr.length && (retval = ((InputStream)is).read(bfr, bytesread, bfr.length - bytesread)) > 0; bytesread += retval) {
                    }
                }
                catch (IOException ioe) {
                    throw new SqlToolError(ioe);
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException ioe) {
                            this.errprintln(this.rb.getString(SqltoolRB.INPUTFILE_CLOSEFAIL) + ": " + ioe);
                        }
                    }
                }
                if (bytesread != bfr.length) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.READ_PARTIAL, bytesread, bfr.length));
                }
                lines = null;
                try {
                    String string = this.charset == null ? new String(bfr) : new String(bfr, this.charset);
                    lines = string.split(this.dsvRowSplitter, -1);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new RuntimeException(uee);
                }
                catch (RuntimeException re) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.READ_CONVERTFAIL), re);
                }
                headerList = new ArrayList<String>();
                tableName = this.dsvTargetTable;
                lineCount = 0;
                trimmedLine = null;
                switching = false;
                headerOffset = 0;
                curLine = "dummy";
                while (true) {
                    if (lineCount >= lines.length) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NONE));
                    }
                    if ((trimmedLine = (curLine = lines[lineCount++]).trim()).length() < 1 || skipPrefix != null && trimmedLine.startsWith(skipPrefix)) continue;
                    if (trimmedLine.startsWith("targettable=")) {
                        if (tableName != null) continue;
                        tableName = trimmedLine.substring("targettable=".length()).trim();
                        continue;
                    }
                    if (trimmedLine.equals("headerswitch{")) {
                        if (tableName == null) {
                            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NOSWITCHTARG, lineCount));
                        }
                        switching = true;
                        continue;
                    }
                    if (trimmedLine.equals("}")) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NOSWITCHMATCH, lineCount));
                    }
                    if (!switching) break block135;
                    int colonAt = trimmedLine.indexOf(58);
                    if (colonAt < 1 || colonAt == trimmedLine.length() - 1) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NONSWITCHED, lineCount));
                    }
                    String headerName = trimmedLine.substring(0, colonAt).trim();
                    if (headerName.equals("*") || headerName.equalsIgnoreCase(tableName)) break;
                }
                headerOffset = 1 + curLine.indexOf(58);
            }
            String headerLine = curLine.substring(headerOffset);
            String[] cols = headerLine.split(this.dsvColSplitter, -1);
            for (int i4 = 0; i4 < cols.length; ++i4) {
                if (cols[i4].length() < 1) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NOCOLHEADER, headerList.size() + 1, lineCount));
                }
                String colName = cols[i4].trim().toLowerCase();
                headerList.add(colName.equals("-") || skipCols != null && skipCols.remove(colName) || constColMap != null && constColMap.containsKey(colName) ? (String)null : colName);
            }
            if (skipCols != null && skipCols.size() > 0) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_SKIPCOLS_MISSING, ((Object)skipCols).toString()));
            }
            boolean oneCol = false;
            for (int i5 = 0; i5 < headerList.size(); ++i5) {
                if (headerList.get(i5) == null) continue;
                oneCol = true;
                break;
            }
            if (!oneCol) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NOCOLSLEFT, this.dsvSkipCols));
            }
            int inputColHeadCount = headerList.size();
            if (constColMap != null) {
                headerList.addAll(constColMap.keySet());
            }
            String[] headers = headerList.toArray(new String[0]);
            if (tableName == null && (i = (tableName = dsvFile.getName()).lastIndexOf(46)) > 0) {
                tableName = tableName.substring(0, i);
            }
            StringBuffer tmpSb = new StringBuffer();
            ArrayList<String> tmpList = new ArrayList<String>();
            int skippers = 0;
            for (int i6 = 0; i6 < headers.length; ++i6) {
                if (headers[i6] == null) {
                    ++skippers;
                    continue;
                }
                if (tmpSb.length() > 0) {
                    tmpSb.append(", ");
                }
                tmpSb.append(headers[i6]);
                tmpList.add(headers[i6]);
            }
            boolean[] autonulls = new boolean[headers.length - skippers];
            boolean[] parseDate = new boolean[autonulls.length];
            boolean[] parseBool = new boolean[autonulls.length];
            char[] readFormat = new char[autonulls.length];
            String[] insertFieldName = tmpList.toArray(new String[0]);
            StringBuffer sb = new StringBuffer("INSERT INTO " + tableName + " (" + tmpSb + ") VALUES (");
            StringBuffer typeQuerySb = new StringBuffer("SELECT " + tmpSb + " FROM " + tableName + " WHERE 1 = 2");
            try {
                ResultSetMetaData rsmd = this.curConn.createStatement().executeQuery(typeQuerySb.toString()).getMetaData();
                if (rsmd.getColumnCount() != autonulls.length) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_METADATA_MISMATCH));
                }
                block65: for (int i7 = 0; i7 < autonulls.length; ++i7) {
                    autonulls[i7] = true;
                    parseDate[i7] = false;
                    parseBool[i7] = false;
                    readFormat[i7] = 115;
                    switch (rsmd.getColumnType(i7 + 1)) {
                        case -7: {
                            autonulls[i7] = true;
                            readFormat[i7] = 98;
                            continue block65;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            autonulls[i7] = true;
                            readFormat[i7] = 120;
                            continue block65;
                        }
                        case 16: {
                            parseBool[i7] = true;
                            continue block65;
                        }
                        case -1: 
                        case 12: 
                        case 2003: 
                        case 2004: 
                        case 2005: {
                            autonulls[i7] = false;
                            continue block65;
                        }
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: {
                            parseDate[i7] = true;
                        }
                    }
                }
            }
            catch (SQLException se) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.QUERY_METADATAFAIL, typeQuerySb.toString()), se);
            }
            for (int i8 = 0; i8 < autonulls.length; ++i8) {
                if (i8 > 0) {
                    sb.append(", ");
                }
                sb.append('?');
            }
            rejectCount = 0;
            rejectFile = null;
            rejectReportFile = null;
            rejectWriter = null;
            rejectReportWriter = null;
            if (this.dsvRejectFile != null) {
                try {
                    rejectFile = new File(this.dsvRejectFile);
                    rejectWriter = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(rejectFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(rejectFile), this.charset));
                    rejectWriter.print(headerLine + this.dsvRowDelim);
                }
                catch (IOException ioe) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_REJECTFILE_SETUPFAIL, this.dsvRejectFile), ioe);
                }
            }
            if (this.dsvRejectReport != null) {
                try {
                    rejectReportFile = new File(this.dsvRejectReport);
                    rejectReportWriter = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(rejectReportFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(rejectReportFile), this.charset));
                    rejectReportWriter.println(this.rb.getString(SqltoolRB.REJECTREPORT_TOP, new String[]{new Date().toString(), dsvFile.getPath(), rejectFile == null ? this.rb.getString(SqltoolRB.NONE) : rejectFile.getPath(), rejectFile == null ? null : rejectFile.getPath()}));
                }
                catch (IOException ioe) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_REJECTREPORT_SETUPFAIL, this.dsvRejectReport), ioe);
                }
            }
            recCount = 0;
            skipCount = 0;
            Statement ps = null;
            importAborted = false;
            doResetAutocommit = false;
            try {
                boolean bl = doResetAutocommit = this.dsvRecordsPerCommit > 0 && this.curConn.getAutoCommit();
                if (doResetAutocommit) {
                    this.curConn.setAutoCommit(false);
                }
            }
            catch (SQLException se) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.RPC_AUTOCOMMIT_FAILURE), se);
            }
            try {
                try {
                    ps = this.curConn.prepareStatement(sb.toString() + ')');
                }
                catch (SQLException se) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.INSERTION_PREPAREFAIL, sb.toString()), se);
                }
                String[] dataVals = new String[autonulls.length];
                String currentFieldName = null;
                while (lineCount < lines.length) {
                    try {
                        try {
                            if ((trimmedLine = (curLine = lines[lineCount++]).trim()).length() < 1) continue;
                            if (skipPrefix != null && trimmedLine.startsWith(skipPrefix)) {
                                ++skipCount;
                                continue;
                            }
                            if (switching) {
                                if (trimmedLine.equals("}")) {
                                    switching = false;
                                    continue;
                                }
                                int colonAt = trimmedLine.indexOf(58);
                                if (colonAt >= 1 && colonAt != trimmedLine.length() - 1) continue;
                                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_MATCHERNONHEAD, lineCount));
                            }
                            ++recCount;
                            int readColCount = 0;
                            int storeColCount = 0;
                            cols = curLine.split(this.dsvColSplitter, -1);
                            for (int coli = 0; coli < cols.length; ++coli) {
                                if (readColCount == inputColHeadCount) {
                                    throw new RowError(this.rb.getString(SqltoolRB.DSV_COLCOUNT_MISMATCH, inputColHeadCount, 1 + readColCount));
                                }
                                if (headers[readColCount++] == null) continue;
                                dataVals[storeColCount++] = this.dsvTrimAll ? cols[coli].trim() : cols[coli];
                            }
                            if (readColCount < inputColHeadCount) {
                                throw new RowError(this.rb.getString(SqltoolRB.DSV_COLCOUNT_MISMATCH, inputColHeadCount, readColCount));
                            }
                            if (constColMap != null) {
                                Iterator it = constColMap.values().iterator();
                                while (it.hasNext()) {
                                    dataVals[storeColCount++] = (String)it.next();
                                }
                            }
                            if (storeColCount != dataVals.length) {
                                throw new RowError(this.rb.getString(SqltoolRB.DSV_INSERTCOL_MISMATCH, dataVals.length, storeColCount));
                            }
                            for (int i9 = 0; i9 < dataVals.length; ++i9) {
                                currentFieldName = insertFieldName[i9];
                                if (autonulls[i9]) {
                                    dataVals[i9] = dataVals[i9].trim();
                                }
                                if (parseDate[i9]) {
                                    if (dataVals[i9].length() < 1 && autonulls[i9] || dataVals[i9].equals(this.nullRepToken)) {
                                        ps.setTimestamp(i9 + 1, null);
                                    } else {
                                        String dateString = dataVals[i9].indexOf(58) > 0 ? dataVals[i9] : dataVals[i9] + " 0:00:00";
                                        try {
                                            ps.setTimestamp(i9 + 1, Timestamp.valueOf(dateString));
                                        }
                                        catch (IllegalArgumentException iae) {
                                            throw new RowError(this.rb.getString(SqltoolRB.TIME_BAD, dateString), iae);
                                        }
                                    }
                                } else if (parseBool[i9]) {
                                    if (dataVals[i9].length() < 1 && autonulls[i9] || dataVals[i9].equals(this.nullRepToken)) {
                                        ps.setNull(i9 + 1, 16);
                                    } else {
                                        try {
                                            ps.setBoolean(i9 + 1, Boolean.valueOf(dataVals[i9]));
                                        }
                                        catch (IllegalArgumentException iae) {
                                            throw new RowError(this.rb.getString(SqltoolRB.BOOLEAN_BAD, dataVals[i9]), iae);
                                        }
                                    }
                                } else {
                                    switch (readFormat[i9]) {
                                        case 'b': {
                                            ps.setBytes(i9 + 1, dataVals[i9].length() < 1 ? null : SqlFile.bitCharsToBytes(dataVals[i9]));
                                            break;
                                        }
                                        case 'x': {
                                            ps.setBytes(i9 + 1, dataVals[i9].length() < 1 ? null : SqlFile.hexCharOctetsToBytes(dataVals[i9]));
                                            break;
                                        }
                                        default: {
                                            ps.setString(i9 + 1, dataVals[i9].length() < 1 && autonulls[i9] || dataVals[i9].equals(this.nullRepToken) ? null : dataVals[i9]);
                                        }
                                    }
                                }
                                currentFieldName = null;
                            }
                            retval = ps.executeUpdate();
                            if (retval != 1) {
                                throw new RowError(this.rb.getString(SqltoolRB.INPUTREC_MODIFIED, retval));
                            }
                            if (this.dsvRecordsPerCommit > 0 && (recCount - rejectCount) % this.dsvRecordsPerCommit == 0) {
                                this.curConn.commit();
                                this.possiblyUncommitteds.set(false);
                                continue;
                            }
                            this.possiblyUncommitteds.set(true);
                        }
                        catch (NumberFormatException nfe) {
                            throw new RowError(null, nfe);
                        }
                        catch (SQLException se) {
                            throw new RowError(null, se);
                        }
                    }
                    catch (RowError re) {
                        ++rejectCount;
                        if (rejectWriter != null || rejectReportWriter != null) {
                            if (rejectWriter != null) {
                                rejectWriter.print(curLine + this.dsvRowDelim);
                            }
                            if (rejectReportWriter == null) continue;
                            this.genRejectReportRecord(rejectReportWriter, rejectCount, lineCount, currentFieldName, re.getMessage(), re.getCause());
                            continue;
                        }
                        importAborted = true;
                        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_RECIN_FAIL, lineCount, currentFieldName) + (re.getMessage() == null ? "" : "  " + re.getMessage()), re.getCause());
                    }
                }
                if (ps == null) break block136;
            }
            catch (Throwable throwable) {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException se) {
                        // empty catch block
                    }
                }
                try {
                    if (this.dsvRecordsPerCommit > 0 && (recCount - rejectCount) % this.dsvRecordsPerCommit != 0) {
                        this.curConn.commit();
                        this.possiblyUncommitteds.set(false);
                    }
                    if (doResetAutocommit) {
                        this.curConn.setAutoCommit(true);
                    }
                }
                catch (SQLException se) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.RPC_COMMIT_FAILURE), se);
                }
                String summaryString = null;
                if (recCount > 0) {
                    summaryString = this.rb.getString(SqltoolRB.DSV_IMPORT_SUMMARY, new String[]{skipPrefix == null ? "" : "'" + skipPrefix + "'-", Integer.toString(skipCount), Integer.toString(rejectCount), Integer.toString(recCount - rejectCount), importAborted ? "importAborted" : null});
                    this.stdprintln(summaryString);
                }
                try {
                    if (recCount > rejectCount && this.dsvRecordsPerCommit < 1 && !this.curConn.getAutoCommit()) {
                        this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
                    }
                }
                catch (SQLException se) {
                    this.stdprintln(this.rb.getString(SqltoolRB.AUTOCOMMIT_FETCHFAIL));
                    this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
                }
                if (rejectWriter != null) {
                    rejectWriter.flush();
                    rejectWriter.close();
                }
                if (rejectReportWriter != null && rejectCount > 0) {
                    rejectReportWriter.println(this.rb.getString(SqltoolRB.REJECTREPORT_BOTTOM, summaryString, revnum));
                    rejectReportWriter.flush();
                    rejectReportWriter.close();
                }
                if (rejectCount == 0) {
                    if (rejectFile != null && rejectFile.exists() && !rejectFile.delete()) {
                        this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTFILE_PURGEFAIL, rejectFile.toString()));
                    }
                    if (rejectReportFile != null && !rejectReportFile.delete()) {
                        this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTREPORT_PURGEFAIL, rejectFile == null ? null : rejectFile.toString()));
                    }
                }
                throw throwable;
            }
            try {
                ps.close();
            }
            catch (SQLException se) {
                // empty catch block
            }
        }
        try {
            if (this.dsvRecordsPerCommit > 0 && (recCount - rejectCount) % this.dsvRecordsPerCommit != 0) {
                this.curConn.commit();
                this.possiblyUncommitteds.set(false);
            }
            if (doResetAutocommit) {
                this.curConn.setAutoCommit(true);
            }
        }
        catch (SQLException se) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.RPC_COMMIT_FAILURE), se);
        }
        String summaryString = null;
        if (recCount > 0) {
            summaryString = this.rb.getString(SqltoolRB.DSV_IMPORT_SUMMARY, new String[]{skipPrefix == null ? "" : "'" + skipPrefix + "'-", Integer.toString(skipCount), Integer.toString(rejectCount), Integer.toString(recCount - rejectCount), importAborted ? "importAborted" : null});
            this.stdprintln(summaryString);
        }
        try {
            if (recCount > rejectCount && this.dsvRecordsPerCommit < 1 && !this.curConn.getAutoCommit()) {
                this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
            }
        }
        catch (SQLException se) {
            this.stdprintln(this.rb.getString(SqltoolRB.AUTOCOMMIT_FETCHFAIL));
            this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
        }
        if (rejectWriter != null) {
            rejectWriter.flush();
            rejectWriter.close();
        }
        if (rejectReportWriter != null && rejectCount > 0) {
            rejectReportWriter.println(this.rb.getString(SqltoolRB.REJECTREPORT_BOTTOM, summaryString, revnum));
            rejectReportWriter.flush();
            rejectReportWriter.close();
        }
        if (rejectCount == 0) {
            if (rejectFile != null && rejectFile.exists() && !rejectFile.delete()) {
                this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTFILE_PURGEFAIL, rejectFile.toString()));
            }
            if (rejectReportFile != null && !rejectReportFile.delete()) {
                this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTREPORT_PURGEFAIL, rejectFile == null ? null : rejectFile.toString()));
            }
        }
    }

    public static void appendLine(StringBuffer sb, String s) {
        sb.append(s + LS);
    }

    private static String[] genWinArgs(String monolithic) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("cmd.exe");
        list.add("/y");
        list.add("/c");
        Matcher m = wincmdPattern.matcher(monolithic);
        while (m.find()) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                if (m.group(i) == null) continue;
                if (m.group(i).length() > 1 && m.group(i).charAt(0) == '\"') {
                    list.add(m.group(i).substring(1, m.group(i).length() - 1));
                    continue;
                }
                String[] internalTokens = m.group(i).split("\\s+", -1);
                for (int j = 0; j < internalTokens.length; ++j) {
                    list.add(internalTokens[j]);
                }
            }
        }
        return list.toArray(new String[0]);
    }

    private void genRejectReportRecord(PrintWriter pw, int rCount, int lCount, String field, String eMsg, Throwable cause) {
        pw.println(this.rb.getString(SqltoolRB.REJECTREPORT_ROW, new String[]{(rCount % 2 == 0 ? "even" : "odd") + "row", Integer.toString(rCount), Integer.toString(lCount), field == null ? "&nbsp;" : field, (eMsg == null ? "" : eMsg) + (eMsg == null || cause == null ? "" : "<HR/>") + (cause == null ? "" : (cause instanceof SQLException && cause.getMessage() != null ? cause.getMessage() : cause.toString()))}));
    }

    private TokenList seekTokenSource(String nestingCommand) throws BadSpecial, IOException {
        Token token;
        TokenList newTS = new TokenList();
        Pattern endPattern = Pattern.compile("end\\s+" + nestingCommand);
        while ((token = this.scanner.yylex()) != null) {
            if (token.type == 2 && endPattern.matcher(token.val).matches()) {
                return newTS;
            }
            String subNestingCommand = this.nestingCommand(token);
            if (subNestingCommand != null) {
                token.nestedBlock = this.seekTokenSource(subNestingCommand);
            }
            newTS.add(token);
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_UNTERMINATED, nestingCommand));
    }

    private void processMacro(Token defToken) throws BadSpecial {
        if (defToken.val.length() < 1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.MACRO_TIP));
        }
        switch (defToken.val.charAt(0)) {
            case '?': {
                this.stdprintln(this.rb.getString(SqltoolRB.MACRO_HELP));
                break;
            }
            case '=': {
                String defString = defToken.val;
                defString = defString.substring(1).trim();
                if (defString.length() < 1) {
                    for (String key : this.macros.keySet()) {
                        Token t = (Token)this.macros.get(key);
                        this.stdprintln(key + " = " + t.reconstitute());
                    }
                    break;
                }
                int newType = -1;
                StringBuffer newVal = new StringBuffer();
                Matcher matcher = editMacroPattern.matcher(defString);
                if (matcher.matches()) {
                    if (this.buffer == null) {
                        this.stdprintln(this.nobufferYetString);
                        return;
                    }
                    newVal.append(this.buffer.val);
                    if (matcher.groupCount() > 1 && matcher.group(2) != null && matcher.group(2).length() > 0) {
                        newVal.append(matcher.group(2));
                    }
                    newType = this.buffer.type;
                } else {
                    matcher = spMacroPattern.matcher(defString);
                    if (matcher.matches()) {
                        newVal.append(matcher.group(3));
                        newType = matcher.group(2).equals("*") ? 2 : 1;
                    } else {
                        matcher = sqlMacroPattern.matcher(defString);
                        if (!matcher.matches()) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.MACRO_MALFORMAT));
                        }
                        newVal.append(matcher.group(2));
                        newType = 0;
                    }
                }
                if (newVal.length() < 1) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.MACRODEF_EMPTY));
                }
                if (newVal.charAt(newVal.length() - 1) == ';') {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.MACRODEF_SEMI));
                }
                this.macros.put(matcher.group(1), new Token(newType, newVal, defToken.line));
                break;
            }
            default: {
                Matcher matcher = useMacroPattern.matcher(defToken.val);
                if (!matcher.matches()) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.MACRO_MALFORMAT));
                }
                Token macroToken = (Token)this.macros.get(matcher.group(1));
                if (macroToken == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.MACRO_UNDEFINED, matcher.group(1)));
                }
                this.setBuf(macroToken);
                this.buffer.line = defToken.line;
                if (matcher.groupCount() > 1 && matcher.group(2) != null && matcher.group(2).length() > 0) {
                    this.buffer.val = this.buffer.val + matcher.group(2);
                }
                this.preempt = matcher.group(matcher.groupCount()).equals(";");
            }
        }
    }

    public static byte[] hexCharOctetsToBytes(String hexChars) {
        int chars = hexChars.length();
        if (chars != chars / 2 * 2) {
            throw new NumberFormatException("Hex character lists contains an odd number of characters: " + chars);
        }
        byte[] ba = new byte[chars / 2];
        int offset = 0;
        for (int i = 0; i < chars; ++i) {
            int octet = 0;
            char c = hexChars.charAt(i);
            if (c >= 'a' && c <= 'f') {
                octet += 10 + c - 97;
            } else if (c >= 'A' && c <= 'F') {
                octet += 10 + c - 65;
            } else if (c >= '0' && c <= '9') {
                octet += c - 48;
            } else {
                throw new NumberFormatException("Non-hex character in input at offset " + i + ": " + c);
            }
            octet <<= 4;
            c = hexChars.charAt(++i);
            if (c >= 'a' && c <= 'f') {
                octet += 10 + c - 97;
            } else if (c >= 'A' && c <= 'F') {
                octet += 10 + c - 65;
            } else if (c >= '0' && c <= '9') {
                octet += c - 48;
            } else {
                throw new NumberFormatException("Non-hex character in input at offset " + i + ": " + c);
            }
            ba[offset++] = (byte)octet;
        }
        if (ba.length != offset) {
            throw new RuntimeException("Internal accounting problem.  Expected to fill buffer of size " + ba.length + ", but wrote only " + offset + " bytes");
        }
        return ba;
    }

    public static byte[] bitCharsToBytes(String hexChars) {
        throw new NumberFormatException("Sorry.  Bit exporting not supported yet");
    }

    static {
        nestingPLCommands.put("if", ifwhilePattern);
        nestingPLCommands.put("while", ifwhilePattern);
        nestingPLCommands.put("foreach", foreachPattern);
        if (System.getProperty("os.name").startsWith("Windows")) {
            wincmdPattern = Pattern.compile("([^\"]+)?(\"[^\"]*\")?");
        }
        revnum = null;
        revnum = "$Revision: 3178 $".substring("$Revision: ".length(), "$Revision: 3178 $".length() - 2);
        DEFAULT_CHARSET = null;
        nonVarChars = new char[]{' ', '\t', '=', '}', '\n', '\r', '\f'};
        DEFAULT_ROW_DELIM = LS;
        listMDSchemaCols = new int[]{1};
        listMDIndexCols = new int[]{2, 6, 3, 9, 4, 10, 11};
        listMDTableCols = new int[][]{{2, 3}, {2, 3}, {2, 3}};
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
    }

    private class RowError
    extends AppendableException {
        static final long serialVersionUID = 754346434606022750L;

        RowError(String s) {
            super(s);
        }

        RowError(Throwable t) {
            this(null, t);
        }

        RowError(String s, Throwable t) {
            super(s, t);
        }
    }

    private class BadSubst
    extends Exception {
        static final long serialVersionUID = 7325933736897253269L;

        BadSubst(String s) {
            super(s);
        }
    }

    private class ContinueException
    extends SqlToolError {
        static final long serialVersionUID = 5064604160827106014L;

        public ContinueException() {
        }

        public ContinueException(String s) {
            super(s);
        }
    }

    private class BreakException
    extends SqlToolError {
        static final long serialVersionUID = 351150072817675994L;

        public BreakException() {
        }

        public BreakException(String s) {
            super(s);
        }
    }

    private class QuitNow
    extends SqlToolError {
        static final long serialVersionUID = 1811094258670900488L;

        public QuitNow(String s) {
            super(s);
        }

        public QuitNow() {
        }
    }

    private static class BadSpecial
    extends AppendableException {
        static final long serialVersionUID = 7162440064026570590L;

        BadSpecial(String s) {
            super(s);
            if (s == null) {
                throw new RuntimeException("Must construct BadSpecials with non-null message");
            }
        }

        BadSpecial(String s, Throwable t) {
            super(s, t);
            if (s == null) {
                throw new RuntimeException("Must construct BadSpecials with non-null message");
            }
        }
    }

    private static class BooleanBucket {
        private boolean bPriv = false;

        BooleanBucket() {
        }

        public void set(boolean bIn) {
            this.bPriv = bIn;
        }

        public boolean get() {
            return this.bPriv;
        }
    }
}

