/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;

public class View
extends TableDerived {
    SubQuery viewSubQuery;
    String statement;
    HsqlNameManager.HsqlName[] columnNames;
    HsqlNameManager.HsqlName compileTimeSchema;
    SubQuery[] viewSubqueries;
    OrderedHashSet schemaObjectNames;
    int check;
    private Table baseTable;
    Expression checkExpression;

    View(Session session, Database db, HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName[] columnNames, String definition, int check) {
        super(db, name, 7);
        this.columnNames = columnNames;
        this.statement = definition;
        this.check = check;
        this.compileTimeSchema = session.getSchemaHsqlName(null);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.schemaObjectNames;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        if (!this.database.schemaManager.schemaExists(this.compileTimeSchema.name)) {
            this.compileTimeSchema = session.getSchemaHsqlName(null);
        }
        session.setSchema(this.compileTimeSchema.name);
        ParserDQL p = new ParserDQL(session, new Scanner(this.statement));
        p.read();
        this.viewSubQuery = p.XreadViewSubquery(this);
        this.queryExpression = this.viewSubQuery.queryExpression;
        if (this.getColumnCount() == 0) {
            if (this.columnNames == null) {
                this.columnNames = this.viewSubQuery.queryExpression.getResultColumnNames();
            }
            if (this.columnNames.length != this.viewSubQuery.queryExpression.getColumnCount()) {
                throw Error.error(5593, this.tableName.statementName);
            }
            TableUtil.setColumnsInSchemaTable(this, this.columnNames, this.queryExpression.getColumnTypes());
        }
        this.viewSubqueries = p.compileContext.getSubqueries();
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            if (this.viewSubqueries[i].parentView != null) continue;
            this.viewSubqueries[i].parentView = this;
        }
        this.viewSubQuery.getTable().view = this;
        this.viewSubQuery.getTable().columnList = this.columnList;
        this.schemaObjectNames = p.compileContext.getSchemaObjectNames();
        this.baseTable = this.queryExpression.getBaseTable();
        if (this.baseTable == null) {
            return;
        }
        switch (this.check) {
            case 0: {
                break;
            }
            case 1: {
                this.checkExpression = this.queryExpression.getCheckCondition();
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw Error.runtimeError(401, "View");
            }
        }
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(' ').append("VIEW");
        sb.append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName()).append(' ');
        sb.append('(');
        int count = this.getColumnCount();
        for (int j = 0; j < count; ++j) {
            sb.append(this.getColumn((int)j).getName().statementName);
            if (j >= count - 1) continue;
            sb.append(',');
        }
        sb.append(')').append(' ').append("AS").append(' ');
        sb.append(this.getStatement());
        return sb.toString();
    }

    @Override
    public int[] getUpdatableColumns() {
        return this.queryExpression.getBaseTableColumnMap();
    }

    public int getCheckOption() {
        return this.check;
    }

    public String getStatement() {
        return this.statement;
    }

    @Override
    public void setDataReadOnly(boolean value) {
        throw Error.error(4000);
    }

    public void collectAllFunctionExpressions(OrderedHashSet collector) {
    }
}

