/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerMV2PL;
import org.hsqldb.TransactionManagerMVCC;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.store.ValuePool;

public class TransactionManager2PL
implements TransactionManager {
    Database database;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    AtomicLong globalChangeTimestamp = new AtomicLong();
    HashMap tableWriteLocks = new HashMap();
    MultiValueHashMap tableReadLocks = new MultiValueHashMap();

    public TransactionManager2PL(Database db) {
        this.database = db;
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public boolean isMVRows() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setTransactionControl(Session session, int mode) {
        this.writeLock.lock();
        try {
            switch (mode) {
                case 2: {
                    TransactionManagerMVCC manager = new TransactionManagerMVCC(this.database);
                    manager.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
                    manager.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    this.database.txManager = manager;
                    return;
                }
                case 1: {
                    TransactionManagerMV2PL manager = new TransactionManagerMV2PL(this.database);
                    manager.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
                    manager.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    this.database.txManager = manager;
                    return;
                }
            }
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void completeActions(Session session) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        for (int i = session.actionIndex; i < limit; ++i) {
            RowAction rowact = (RowAction)list[i];
            rowact.complete(session, null);
        }
    }

    @Override
    public boolean prepareCommitActions(Session session) {
        session.actionTimestamp = this.nextChangeTimestamp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        int limit = session.rowActionList.size();
        Object[] list = limit == 0 ? ValuePool.emptyObjectArray : session.rowActionList.getArray();
        try {
            RowAction action;
            int i;
            this.writeLock.lock();
            this.endTransaction(session);
            if (limit == 0) {
                this.endTransactionTPL(session);
                try {
                    session.logSequences();
                }
                catch (HsqlException e) {
                    // empty catch block
                }
                boolean e = true;
                return e;
            }
            session.actionTimestamp = this.nextChangeTimestamp();
            for (i = 0; i < limit; ++i) {
                action = (RowAction)list[i];
                action.commit(session);
            }
            for (i = 0; i < limit; ++i) {
                action = (RowAction)list[i];
                if (action.type == 0) continue;
                int type = action.getCommitType(session.actionTimestamp);
                PersistentStore store = session.sessionData.getRowStore(action.table);
                Row row = action.memoryRow;
                if (row == null) {
                    row = (Row)store.get(action.getPos(), false);
                }
                if (action.table.hasLobColumn) {
                    switch (type) {
                        case 1: {
                            action.table.addLobUsageCount(session, row.getData());
                            break;
                        }
                    }
                }
                if (action.table.tableType == 6) {
                    switch (type) {
                        case 2: {
                            store.removePersistence(action.getPos());
                            break;
                        }
                        case 1: {
                            store.commitPersistence(row);
                            break;
                        }
                    }
                    action.setAsNoOp(row);
                    continue;
                }
                Object[] data = row.getData();
                try {
                    switch (type) {
                        case 2: {
                            this.database.logger.writeDeleteStatement(session, action.table, data);
                            store.remove(action.getPos());
                            break;
                        }
                        case 1: {
                            this.database.logger.writeInsertStatement(session, action.table, data);
                            break;
                        }
                        case 0: {
                            store.remove(action.getPos());
                        }
                    }
                    action.setAsNoOp(row);
                    continue;
                }
                catch (HsqlException e) {
                    this.database.logger.logWarningEvent("logging problem", e);
                }
            }
            try {
                session.logSequences();
                this.database.logger.writeCommitStatement(session);
            }
            catch (HsqlException e) {
                // empty catch block
            }
            this.endTransactionTPL(session);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        session.abortTransaction = false;
        session.actionTimestamp = this.nextChangeTimestamp();
        this.rollbackPartial(session, 0, session.transactionTimestamp);
        this.endTransaction(session);
        try {
            this.writeLock.lock();
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
    }

    void rollbackPartial(Session session, int start, long timestamp) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = limit - 1; i >= start; --i) {
            RowAction action = (RowAction)list[i];
            if (action == null || action.type == 0 || action.type == 3) continue;
            Row row = action.memoryRow;
            PersistentStore store = session.sessionData.getRowStore(action.table);
            if (row == null) {
                row = (Row)store.get(action.getPos(), false);
            }
            if (row == null) continue;
            action.rollback(session, timestamp);
            int type = action.getCommitType(session.actionTimestamp);
            action.mergeRollback(row);
            if (type == 2) {
                store.indexRow(session, row);
                continue;
            }
            if (type != 1) continue;
            store.delete(row);
            store.remove(action.getPos());
        }
        session.rowActionList.setSize(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteAction(Session session, Table table, Row row) {
        RowAction action;
        Row row2 = row;
        synchronized (row2) {
            action = RowAction.addAction(session, (byte)2, table, row);
        }
        session.rowActionList.add(action);
        PersistentStore store = session.sessionData.getRowStore(table);
        store.delete(row);
        return action;
    }

    @Override
    public void addInsertAction(Session session, Table table, Row row) {
        RowAction action = row.rowAction;
        if (action == null) {
            System.out.println("null insert action " + session + " " + session.actionTimestamp);
        }
        session.rowActionList.add(action);
    }

    int compareRowForInsert(Row newRow, Row existingRow) {
        if (newRow.rowAction != null && !this.canRead(newRow.rowAction.session, existingRow)) {
            return newRow.getPos() - existingRow.getPos();
        }
        return 0;
    }

    @Override
    public boolean canRead(Session session, Row row) {
        RowAction action = row.rowAction;
        if (action == null) {
            return true;
        }
        return action.canRead(session);
    }

    @Override
    public boolean isDeleted(Session session, Row row) {
        RowAction action = row.rowAction;
        if (action == null) {
            return false;
        }
        return !action.canRead(session);
    }

    @Override
    public boolean canRead(Session session, int id) {
        return true;
    }

    @Override
    public void setTransactionInfo(CachedObject object) {
    }

    long nextChangeTimestamp() {
        return this.globalChangeTimestamp.incrementAndGet();
    }

    @Override
    public void beginTransaction(Session session) {
        session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
        session.isTransaction = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement cs) {
        session.actionTimestamp = this.nextChangeTimestamp();
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp;
            session.isTransaction = true;
        }
        if (session.hasLocks()) {
            return;
        }
        try {
            this.writeLock.lock();
            boolean canProceed = this.beginActionTPL(session, cs);
            if (!canProceed) {
                session.abortTransaction = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void endTransactionTPL(Session session) {
        Session current;
        int i;
        int unlockedCount = 0;
        this.unlockTablesTPL(session);
        int waitingCount = session.waitingSessions.size();
        if (waitingCount == 0) {
            return;
        }
        for (i = 0; i < waitingCount; ++i) {
            current = (Session)session.waitingSessions.get(i);
            current.tempUnlocked = false;
            long count = current.latch.getCount();
            if (count != 1L) continue;
            boolean canProceed = this.setWaitedSessionsTPL(current, current.currentStatement);
            if (!canProceed) {
                current.abortTransaction = true;
            }
            if (!current.tempSet.isEmpty()) continue;
            this.lockTablesTPL(current, current.currentStatement);
            current.tempUnlocked = true;
            ++unlockedCount;
        }
        for (i = 0; i < waitingCount; ++i) {
            boolean canProceed;
            current = (Session)session.waitingSessions.get(i);
            if (current.tempUnlocked || (canProceed = this.setWaitedSessionsTPL(current, current.currentStatement))) continue;
            current.abortTransaction = true;
        }
        for (i = 0; i < waitingCount; ++i) {
            boolean hasLocks;
            current = (Session)session.waitingSessions.get(i);
            if (current.tempSet.isEmpty() && !(hasLocks = this.hasLocks(current, current.currentStatement))) {
                System.out.println("trouble");
            }
            this.setWaitingSessionTPL(current);
        }
        session.tempSet.clear();
        session.waitingSessions.clear();
    }

    boolean beginActionTPL(Session session, Statement cs) {
        boolean canProceed = this.setWaitedSessionsTPL(session, cs);
        if (canProceed) {
            if (session.tempSet.isEmpty()) {
                this.lockTablesTPL(session, cs);
            } else {
                this.setWaitingSessionTPL(session);
            }
            return true;
        }
        return false;
    }

    boolean setWaitedSessionsTPL(Session session, Statement cs) {
        Session holder;
        HsqlNameManager.HsqlName name;
        int i;
        session.tempSet.clear();
        if (cs == null || session.abortTransaction) {
            return true;
        }
        HsqlNameManager.HsqlName[] nameList = cs.getTableNamesForWrite();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            holder = (Session)this.tableWriteLocks.get(name);
            if (holder != null && holder != session) {
                session.tempSet.add(holder);
            }
            Iterator it = this.tableReadLocks.get(name);
            while (it.hasNext()) {
                holder = (Session)it.next();
                if (holder == session) continue;
                session.tempSet.add(holder);
            }
        }
        nameList = cs.getTableNamesForRead();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (holder = (Session)this.tableWriteLocks.get(name)) == null || holder == session) continue;
            session.tempSet.add(holder);
        }
        for (i = 0; i < session.waitingSessions.size(); ++i) {
            Session current = (Session)session.waitingSessions.get(i);
            if (!session.tempSet.contains(current)) continue;
            session.tempSet.clear();
            return false;
        }
        return true;
    }

    void setWaitingSessionTPL(Session session) {
        int count = session.tempSet.size();
        for (int i = 0; i < count; ++i) {
            Session current = (Session)session.tempSet.get(i);
            current.waitingSessions.add(session);
        }
        session.tempSet.clear();
        session.latch.setCount(count);
    }

    void lockTablesTPL(Session session, Statement cs) {
        HsqlNameManager.HsqlName name;
        int i;
        if (cs == null || session.abortTransaction) {
            return;
        }
        HsqlNameManager.HsqlName[] nameList = cs.getTableNamesForWrite();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableWriteLocks.put(name, session);
        }
        nameList = cs.getTableNamesForRead();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableReadLocks.put(name, session);
        }
    }

    void unlockTablesTPL(Session session) {
        Session s;
        Iterator it = this.tableWriteLocks.values().iterator();
        while (it.hasNext()) {
            s = (Session)it.next();
            if (s != session) continue;
            it.setValue(null);
        }
        it = this.tableReadLocks.values().iterator();
        while (it.hasNext()) {
            s = (Session)it.next();
            if (s != session) continue;
            it.remove();
        }
    }

    void endTransaction(Session session) {
        session.isTransaction = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLocks(Session session, Statement cs) {
        if (cs == null) {
            return true;
        }
        this.writeLock.lock();
        try {
            Session holder;
            HsqlNameManager.HsqlName name;
            int i;
            HsqlNameManager.HsqlName[] nameList = cs.getTableNamesForWrite();
            for (i = 0; i < nameList.length; ++i) {
                name = nameList[i];
                if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
                holder = (Session)this.tableWriteLocks.get(name);
                if (holder != null && holder != session) {
                    boolean bl = false;
                    return bl;
                }
                Iterator it = this.tableReadLocks.get(name);
                while (it.hasNext()) {
                    holder = (Session)it.next();
                    if (holder == session) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            nameList = cs.getTableNamesForRead();
            for (i = 0; i < nameList.length; ++i) {
                name = nameList[i];
                if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (holder = (Session)this.tableWriteLocks.get(name)) == null || holder == session) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    RowAction[] getRowActionList() {
        try {
            this.writeLock.lock();
            sessions = this.database.sessionManager.getAllSessions();
            tIndex = new int[sessions.length];
            rowActionCount = 0;
            actioncount = 0;
            for (i = 0; i < sessions.length; ++i) {
                actioncount += sessions[i].getTransactionSize();
            }
            rowActions = new RowAction[actioncount];
            block4: while (true) {
                found = false;
                minChangeNo = 0x7FFFFFFFFFFFFFFFL;
                sessionIndex = 0;
                for (i = 0; i < sessions.length; ++i) {
                    tSize = sessions[i].getTransactionSize();
                    if (tIndex[i] >= tSize) continue;
                    current = (RowAction)sessions[i].rowActionList.get(tIndex[i]);
                    if (current.actionTimestamp < minChangeNo) {
                        minChangeNo = current.actionTimestamp;
                        sessionIndex = i;
                    }
                    found = true;
                }
                if (!found) break;
                currentList = sessions[sessionIndex].rowActionList;
                while (true) {
                    if (tIndex[sessionIndex] >= currentList.size()) continue block4;
                    current = (RowAction)currentList.get(tIndex[sessionIndex]);
                    if (current.actionTimestamp == minChangeNo + 1L) {
                        ++minChangeNo;
                    }
                    if (current.actionTimestamp == minChangeNo) ** break;
                    continue block4;
                    rowActions[rowActionCount++] = current;
                    v0 = sessionIndex;
                    tIndex[v0] = tIndex[v0] + 1;
                }
                break;
            }
            var5_5 = rowActions;
            return var5_5;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public DoubleIntIndex getTransactionIDList() {
        DoubleIntIndex lookup = new DoubleIntIndex(10, false);
        return lookup;
    }

    @Override
    public void convertTransactionIDs(DoubleIntIndex lookup) {
    }
}

