/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAVLDiskData;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.TextCache;

public class TextTable
extends Table {
    private String dataSource = "";
    private boolean isReversed = false;
    private boolean isConnected = false;

    TextTable(Database db, HsqlNameManager.HsqlName name, int type) {
        super(db, name, type);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void connect(Session session) {
        this.connect(session, this.isReadOnly);
    }

    private void connect(Session session, boolean withReadOnlyData) {
        PersistentStore store;
        if (this.dataSource.length() == 0 || this.isConnected) {
            return;
        }
        this.store = store = this.database.persistentStoreCollection.getStore(this);
        TextCache cache = null;
        try {
            cache = (TextCache)this.database.logger.openTextFilePersistence(this, this.dataSource, withReadOnlyData, this.isReversed);
            store.setCache(cache);
            Row row = null;
            int nextpos = 0;
            if (cache.ignoreFirst) {
                nextpos += cache.readHeaderLine();
            }
            while ((row = (Row)store.get(nextpos, false)) != null) {
                Object[] data = row.getData();
                nextpos = row.getPos() + row.getStorageSize();
                ((RowAVLDiskData)row).setNewNodes();
                this.systemUpdateIdentityValue(data);
                this.enforceRowConstraints(session, data);
                for (int i = 0; i < this.indexList.length; ++i) {
                    this.indexList[i].insert(null, store, row);
                }
            }
        }
        catch (Throwable t) {
            int linenumber = cache == null ? 0 : ((TextCache)cache).getLineNumber();
            this.clearAllData(session);
            if (cache != null) {
                this.database.logger.closeTextCache(this);
                store.release();
            }
            throw Error.error(t, 76, 0, new Object[]{t.getMessage(), new Integer(linenumber)});
        }
        this.isConnected = true;
        this.isReadOnly = withReadOnlyData;
    }

    public void disconnect() {
        this.store = null;
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        store.release();
        this.isConnected = false;
    }

    private void openCache(Session session, String dataSourceNew, boolean isReversedNew, boolean isReadOnlyNew) {
        String dataSourceOld = this.dataSource;
        boolean isReversedOld = this.isReversed;
        boolean isReadOnlyOld = this.isReadOnly;
        if (dataSourceNew == null) {
            dataSourceNew = "";
        }
        this.disconnect();
        this.dataSource = dataSourceNew;
        this.isReversed = isReversedNew && this.dataSource.length() > 0;
        try {
            this.connect(session, isReadOnlyNew);
        }
        catch (HsqlException e) {
            this.dataSource = dataSourceOld;
            this.isReversed = isReversedOld;
            this.connect(session, isReadOnlyOld);
            throw e;
        }
    }

    protected void setDataSource(Session session, String dataSourceNew, boolean isReversedNew, boolean createFile) {
        if (this.getTableType() != 5) {
            session.getGrantee().checkSchemaUpdateOrGrantRights(this.getSchemaName().name);
        }
        dataSourceNew = dataSourceNew.trim();
        if (createFile && FileUtil.getFileUtil().exists(dataSourceNew)) {
            throw Error.error(196, dataSourceNew);
        }
        if (isReversedNew || isReversedNew != this.isReversed || !this.dataSource.equals(dataSourceNew) || !this.isConnected) {
            this.openCache(session, dataSourceNew, isReversedNew, this.isReadOnly);
        }
        if (this.isReversed) {
            this.isReadOnly = true;
        }
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public boolean isDescDataSource() {
        return this.isReversed;
    }

    public void setHeader(String header) {
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        TextCache cache = (TextCache)store.getCache();
        if (cache != null && cache.ignoreFirst) {
            cache.setHeader(header);
            return;
        }
        throw Error.error(150);
    }

    public String getHeader() {
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        TextCache cache = (TextCache)store.getCache();
        String header = cache == null ? null : cache.getHeader();
        return header == null ? null : StringConverter.toQuotedString(header, '\'', true);
    }

    @Override
    void checkDataReadOnly() {
        if (this.dataSource.length() == 0) {
            throw Error.error(48);
        }
        if (this.isReadOnly) {
            throw Error.error(32);
        }
    }

    @Override
    public boolean isDataReadOnly() {
        return !this.isConnected() || super.isDataReadOnly() || this.store.getCache().isDataReadOnly();
    }

    @Override
    public void setDataReadOnly(boolean value) {
        if (!value) {
            if (this.isReversed) {
                throw Error.error(32);
            }
            if (this.database.isFilesReadOnly()) {
                throw Error.error(31);
            }
        }
        this.isReadOnly = value;
    }

    @Override
    boolean isIndexCached() {
        return false;
    }

    void setIndexRoots(String s) {
    }

    String getDataSourceDDL() {
        String dataSource = this.getDataSource();
        if (dataSource == null) {
            return null;
        }
        boolean isDesc = this.isDescDataSource();
        StringBuffer sb = new StringBuffer(128);
        sb.append("SET").append(' ').append("TABLE").append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName());
        sb.append(' ').append("SOURCE").append(' ').append('\'');
        sb.append(dataSource);
        sb.append('\'');
        if (isDesc) {
            sb.append(' ').append("DESC");
        }
        return sb.toString();
    }

    String getDataSourceHeader() {
        String header = this.getHeader();
        if (header == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append("SET").append(' ').append("TABLE").append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName());
        sb.append(' ').append("SOURCE").append(' ');
        sb.append("HEADER").append(' ');
        sb.append(header);
        return sb.toString();
    }

    @Override
    public void insertData(PersistentStore store, Object[] data) {
        Row row = (Row)store.getNewCachedObject(null, data);
        store.indexRow(null, row);
        store.commitPersistence(row);
    }
}

