/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class StatementSet
extends StatementDMQL {
    Expression expression;
    QueryExpression queryExpression;
    ColumnSchema[] variables;
    int[] variableIndexes;
    final int operationType;
    public static final int TRIGGER_SET = 1;
    public static final int SELECT_INTO = 2;
    public static final int VARIABLE_SET = 3;

    StatementSet(Session session, Table table, RangeVariable[] rangeVars, int[] updateColumnMap, Expression[] colExpressions, ParserDQL.CompileContext compileContext) {
        super(5, 2004, session.getCurrentSchemaHsqlName());
        this.operationType = 1;
        this.targetTable = table;
        this.baseTable = this.targetTable.getBaseTable();
        this.updateColumnMap = updateColumnMap;
        this.updateExpressions = colExpressions;
        this.updateCheckColumns = this.targetTable.getColumnCheckList(updateColumnMap);
        this.targetRangeVariables = rangeVars;
        this.isTransactionStatement = false;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    StatementSet(Session session, ParserDQL.CompileContext compileContext, ColumnSchema[] variables, Expression e, int[] indexes) {
        super(5, 2007, null);
        this.operationType = 3;
        this.isTransactionStatement = false;
        this.expression = e;
        this.variables = variables;
        this.variableIndexes = indexes;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    StatementSet(Session session, ParserDQL.CompileContext compileContext, ColumnSchema[] variables, QueryExpression query, int[] indexes) {
        super(5, 2007, null);
        this.operationType = 2;
        this.isTransactionStatement = false;
        this.queryExpression = query;
        this.variables = variables;
        this.variableIndexes = indexes;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    @Override
    Result getResult(Session session) {
        Result result = null;
        switch (this.operationType) {
            case 1: {
                result = this.executeSetStatement(session);
                break;
            }
            case 2: {
                Object[] values = this.queryExpression.getSingleRowValues(session);
                if (values == null) {
                    result = Result.updateZeroResult;
                    break;
                }
                result = this.executeAssignment(session, values);
                break;
            }
            case 3: {
                Object[] values = this.getExpressionValues(session);
                if (values == null) {
                    result = Result.updateZeroResult;
                    break;
                }
                result = this.executeAssignment(session, values);
                break;
            }
            default: {
                throw Error.runtimeError(401, "StatementSet");
            }
        }
        return result;
    }

    @Override
    public void resolve() {
        switch (this.operationType) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw Error.runtimeError(401, "StatementSet");
            }
        }
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.operationType) {
            case 3: {
                sb.append("SET").append(' ');
                sb.append(this.variables[0].getName().statementName).append(' ');
                sb.append('=').append(' ').append(this.expression.getSQL());
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            this.materializeSubQueries(session);
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    Result executeSetStatement(Session session) {
        Table table = this.targetTable;
        int[] colMap = this.updateColumnMap;
        Expression[] colExpressions = this.updateExpressions;
        Type[] colTypes = table.getColumnTypes();
        int index = this.targetRangeVariables[1].rangePosition;
        Object[] oldData = session.sessionContext.rangeIterators[index].getCurrentRow().getData();
        Object[] data = StatementDML.getUpdatedData(session, table, colMap, colExpressions, colTypes, oldData);
        ArrayUtil.copyArray(data, oldData, data.length);
        return Result.updateOneResult;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        for (i = 0; i < this.rangeVariables.length; ++i) {
            Table rangeTable = this.rangeVariables[i].rangeTable;
            HsqlNameManager.HsqlName name = rangeTable.getName();
            if (rangeTable.isReadOnly() || rangeTable.isTemp() || name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            set.add(name);
        }
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
    }

    Object[] getExpressionValues(Session session) {
        Object[] values;
        if (this.expression.getType() == 25) {
            values = this.expression.getRowValue(session);
        } else if (this.expression.getType() == 23) {
            values = this.expression.subQuery.queryExpression.getSingleRowValues(session);
            if (values == null) {
                return null;
            }
        } else {
            values = new Object[]{this.expression.getValue(session, this.variables[0].getDataType())};
        }
        return values;
    }

    Result executeAssignment(Session session, Object[] values) {
        for (int j = 0; j < values.length; ++j) {
            Object[] data = ValuePool.emptyObjectArray;
            switch (this.variables[j].getType()) {
                case 23: {
                    data = session.sessionContext.routineArguments;
                    break;
                }
                case 22: {
                    data = session.sessionContext.routineVariables;
                }
            }
            int colIndex = this.variableIndexes[j];
            data[colIndex] = this.variables[j].getDataType().convertToDefaultType(session, values[j]);
        }
        return Result.updateZeroResult;
    }
}

