/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongValueHashMap;
import org.hsqldb.result.Result;

public final class StatementManager {
    private Database database;
    private IntKeyHashMap schemaMap;
    private LongKeyHashMap sqlLookup;
    private LongKeyHashMap csidMap;
    private long next_cs_id;

    StatementManager(Database database) {
        this.database = database;
        this.schemaMap = new IntKeyHashMap();
        this.sqlLookup = new LongKeyHashMap();
        this.csidMap = new LongKeyHashMap();
        this.next_cs_id = 0L;
    }

    synchronized void reset() {
        this.schemaMap.clear();
        this.sqlLookup.clear();
        this.csidMap.clear();
        this.next_cs_id = 0L;
    }

    private long nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    private long getStatementID(HsqlNameManager.HsqlName schema, String sql) {
        LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schema.hashCode());
        if (sqlMap == null) {
            return -1L;
        }
        return sqlMap.get((Object)sql, -1);
    }

    public synchronized Statement getStatement(Session session, long csid) {
        Statement cs = (Statement)this.csidMap.get(csid);
        if (cs == null) {
            return null;
        }
        if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            String sql = (String)this.sqlLookup.get(csid);
            HsqlNameManager.HsqlName oldSchema = session.getCurrentSchemaHsqlName();
            try {
                HsqlNameManager.HsqlName schema = cs.getSchemalName();
                session.setSchema(schema.name);
                cs = session.compileStatement(sql);
                session.setSchema(oldSchema.name);
                cs.setID(csid);
                cs.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
                this.csidMap.put(csid, cs);
            }
            catch (Throwable t) {
                this.freeStatement(csid);
                session.setSchema(oldSchema.name);
                return null;
            }
        }
        return cs;
    }

    private long registerStatement(long csid, Statement cs) {
        if (csid < 0L) {
            csid = this.nextID();
            int schemaid = cs.getSchemalName().hashCode();
            LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schemaid);
            if (sqlMap == null) {
                sqlMap = new LongValueHashMap();
                this.schemaMap.put(schemaid, sqlMap);
            }
            sqlMap.put(cs.getSQL(), csid);
            this.sqlLookup.put(csid, cs.getSQL());
        }
        cs.setID(csid);
        cs.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
        this.csidMap.put(csid, cs);
        return csid;
    }

    synchronized void freeStatement(long csid) {
        if (csid == -1L) {
            return;
        }
        Statement cs = (Statement)this.csidMap.remove(csid);
        if (cs != null) {
            int schemaid = cs.getSchemalName().hashCode();
            LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schemaid);
            String sql = (String)this.sqlLookup.remove(csid);
            sqlMap.remove(sql);
        }
    }

    synchronized Statement compile(Session session, Result cmd) throws Throwable {
        String sql = cmd.getMainString();
        long csid = this.getStatementID(session.currentSchema, sql);
        Statement cs = (Statement)this.csidMap.get(csid);
        if (cs == null || !cs.isValid()) {
            cs = session.compileStatement(sql);
            csid = this.registerStatement(csid, cs);
        }
        return cs;
    }
}

