/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;

public abstract class StatementDMQL
extends Statement {
    public static final String PCOL_PREFIX = "@p";
    static final String RETURN_COLUMN_NAME = "@p0";
    Table targetTable;
    Table baseTable;
    int[] baseColumnMap;
    RangeVariable[] targetRangeVariables;
    Table sourceTable;
    Expression condition;
    boolean restartIdentity;
    int[] insertColumnMap;
    int[] updateColumnMap;
    int[] baseUpdateColumnMap;
    Expression[] updateExpressions;
    Expression[][] multiColumnValues;
    Expression insertExpression;
    boolean[] insertCheckColumns;
    boolean[] updateCheckColumns;
    QueryExpression queryExpression;
    ExpressionColumn[] parameters;
    int[] generatedIndexes;
    ResultMetaData generatedResultMetaData;
    ResultMetaData parameterMetaData;
    SubQuery[] subqueries = SubQuery.emptySubqueryArray;
    int rangeIteratorCount;
    NumberSequence[] sequences;
    Routine[] routines;
    RangeVariable[] rangeVariables;

    StatementDMQL(int type, int group, HsqlNameManager.HsqlName schemaName) {
        super(type, group);
        this.schemaName = schemaName;
        this.isTransactionStatement = true;
    }

    void setBaseIndexColumnMap() {
        if (this.targetTable != this.baseTable) {
            this.baseColumnMap = this.targetTable.getBaseTableColumnMap();
        }
    }

    @Override
    public Result execute(Session session) {
        Result result = this.getAccessRightsResult(session);
        if (result != null) {
            return result;
        }
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        if (session.sessionContext.dynamicArguments.length != this.parameters.length) {
            // empty if block
        }
        try {
            this.materializeSubQueries(session);
            result = this.getResult(session);
        }
        catch (Throwable t) {
            session.sessionContext.clearStructures(this);
            result = Result.newErrorResult(t, null);
            result.getException().setStatementType(this.group, this.type);
        }
        session.sessionContext.clearStructures(this);
        return result;
    }

    abstract Result getResult(Session var1);

    abstract void collectTableNamesForRead(OrderedHashSet var1);

    @Override
    public void setGeneratedColumnInfo(int generate, ResultMetaData meta) {
        if (this.type != 50) {
            return;
        }
        int colIndex = this.baseTable.getIdentityColumnIndex();
        if (colIndex == -1) {
            return;
        }
        switch (generate) {
            case 2: {
                return;
            }
            case 21: {
                int[] columnIndexes = meta.getGeneratedColumnIndexes();
                if (columnIndexes.length != 1) {
                    return;
                }
                if (columnIndexes[0] != colIndex) {
                    return;
                }
            }
            case 1: {
                this.generatedIndexes = new int[]{colIndex};
                break;
            }
            case 11: {
                String[] columnNames = meta.getGeneratedColumnNames();
                if (columnNames.length != 1) {
                    return;
                }
                if (this.baseTable.findColumn(columnNames[0]) != colIndex) {
                    return;
                }
                this.generatedIndexes = new int[]{colIndex};
            }
        }
        this.generatedResultMetaData = ResultMetaData.newResultMetaData(this.generatedIndexes.length);
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            ColumnSchema column = this.baseTable.getColumn(this.generatedIndexes[i]);
            this.generatedResultMetaData.columns[i] = column;
        }
        this.generatedResultMetaData.prepareData();
    }

    Object[] getGeneratedColumns(Object[] data) {
        if (this.generatedIndexes == null) {
            return null;
        }
        Object[] values = new Object[this.generatedIndexes.length];
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            values[i] = data[this.generatedIndexes[i]];
        }
        return values;
    }

    @Override
    public boolean hasGeneratedColumns() {
        return this.generatedIndexes != null;
    }

    @Override
    public ResultMetaData generatedResultMetaData() {
        return this.generatedResultMetaData;
    }

    boolean[] getInsertOrUpdateColumnCheckList() {
        switch (this.type) {
            case 50: {
                return this.insertCheckColumns;
            }
            case 82: {
                return this.updateCheckColumns;
            }
            case 128: {
                boolean[] check = (boolean[])ArrayUtil.duplicateArray(this.insertCheckColumns);
                ArrayUtil.orBooleanArray(this.updateCheckColumns, check);
                return check;
            }
        }
        return null;
    }

    private void setParameters() {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].parameterIndex = i;
        }
    }

    void materializeSubQueries(Session session) {
        if (this.subqueries.length == 0) {
            return;
        }
        HashSet subqueryPopFlags = new HashSet();
        for (int i = 0; i < this.subqueries.length; ++i) {
            SubQuery sq = this.subqueries[i];
            if (!subqueryPopFlags.add(sq) || sq.isCorrelated()) continue;
            sq.materialise(session);
        }
    }

    @Override
    public void clearVariables() {
        this.isValid = false;
        this.targetTable = null;
        this.baseTable = null;
        this.condition = null;
        this.insertColumnMap = null;
        this.updateColumnMap = null;
        this.updateExpressions = null;
        this.insertExpression = null;
        this.insertCheckColumns = null;
        this.parameters = null;
        this.subqueries = null;
    }

    void setDatabseObjects(ParserDQL.CompileContext compileContext) {
        int i;
        this.parameters = compileContext.getParameters();
        this.setParameters();
        this.setParameterMetaData();
        this.subqueries = compileContext.getSubqueries();
        this.rangeIteratorCount = compileContext.getRangeVarCount();
        this.rangeVariables = compileContext.getRangeVariables();
        this.sequences = compileContext.getSequences();
        this.routines = compileContext.getRoutines();
        OrderedHashSet set = new OrderedHashSet();
        this.collectTableNamesForRead(set);
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForRead());
        }
        if (set.size() > 0) {
            this.readTableNames = new HsqlNameManager.HsqlName[set.size()];
            set.toArray(this.readTableNames);
            set.clear();
        }
        if (this.baseTable != null) {
            if (this.baseTable.isTemp()) {
                return;
            }
            set.add(this.baseTable.getName());
            for (i = 0; i < this.baseTable.fkPath.length; ++i) {
                set.add(this.baseTable.fkPath[i].getMain().getName());
            }
            this.getTriggerTableNames(set, true);
        }
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForWrite());
        }
        if (set.size() > 0) {
            this.writeTableNames = new HsqlNameManager.HsqlName[set.size()];
            set.toArray(this.writeTableNames);
        }
        this.references = compileContext.getSchemaObjectNames();
    }

    void getTriggerTableNames(OrderedHashSet set, boolean write) {
    }

    void checkAccessRights(Session session) {
        int i;
        if (this.targetTable != null && !this.targetTable.isTemp()) {
            if (this.targetTable.getOwner().isSystem() && !session.getUser().isSystem()) {
                throw Error.error(5501, this.targetTable.getName().name);
            }
            this.targetTable.checkDataReadOnly();
            session.checkReadWrite();
        }
        if (session.isAdmin()) {
            return;
        }
        for (i = 0; i < this.sequences.length; ++i) {
            session.getGrantee().checkAccess(this.sequences[i]);
        }
        for (i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].isLibraryRoutine()) continue;
            session.getGrantee().checkAccess(this.routines[i]);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable range = this.rangeVariables[i];
            if (range.rangeTable.getSchemaName() == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            session.getGrantee().checkSelect(range.rangeTable, range.usedColumns);
        }
        switch (this.type) {
            case 7: {
                break;
            }
            case 50: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 85: {
                break;
            }
            case 19: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 82: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 128: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }

    Result getAccessRightsResult(Session session) {
        try {
            this.checkAccessRights(session);
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
        return null;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 19: 
            case 50: 
            case 82: {
                return ResultMetaData.emptyResultMetaData;
            }
        }
        throw Error.runtimeError(401, "StatementDMQL");
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        return this.parameterMetaData;
    }

    void setParameterMetaData() {
        int offset = 0;
        if (this.parameters.length == 0) {
            this.parameterMetaData = ResultMetaData.emptyParamMetaData;
            return;
        }
        this.parameterMetaData = ResultMetaData.newParameterMetaData(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            int idx = i + offset;
            this.parameterMetaData.columnLabels[idx] = PCOL_PREFIX + (i + 1);
            this.parameterMetaData.columnTypes[idx] = this.parameters[i].dataType;
            byte parameterMode = 1;
            if (this.parameters[i].column != null && this.parameters[i].column.getParameterMode() != 0) {
                parameterMode = this.parameters[i].column.getParameterMode();
            }
            this.parameterMetaData.paramModes[idx] = parameterMode;
            this.parameterMetaData.paramNullable[idx] = this.parameters[i].column == null ? (byte)1 : this.parameters[i].column.getNullability();
        }
    }

    @Override
    public String describe(Session session) {
        try {
            return this.describeImpl(session);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    private String describeImpl(Session session) throws Exception {
        StringBuffer sb = new StringBuffer();
        switch (this.type) {
            case 85: {
                sb.append(this.queryExpression.describe(session));
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb);
                return sb.toString();
            }
            case 50: {
                if (this.queryExpression == null) {
                    sb.append("INSERT VALUES");
                    sb.append('[').append('\n');
                    this.appendMultiColumns(sb, this.insertColumnMap).append('\n');
                    this.appendTable(sb).append('\n');
                    this.appendParms(sb).append('\n');
                    this.appendSubqueries(session, sb).append(']');
                    return sb.toString();
                }
                sb.append("INSERT SELECT");
                sb.append('[').append('\n');
                this.appendColumns(sb, this.insertColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                sb.append(this.queryExpression.describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb).append(']');
                return sb.toString();
            }
            case 82: {
                sb.append("UPDATE");
                sb.append('[').append('\n');
                this.appendColumns(sb, this.updateColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                sb.append(this.targetRangeVariables[0].describe(session)).append('\n');
                sb.append(this.targetRangeVariables[1].describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb).append(']');
                return sb.toString();
            }
            case 19: {
                sb.append("DELETE");
                sb.append('[').append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                sb.append(this.targetRangeVariables[0].describe(session)).append('\n');
                sb.append(this.targetRangeVariables[1].describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb).append(']');
                return sb.toString();
            }
            case 7: {
                sb.append("CALL");
                sb.append('[').append(']');
                return sb.toString();
            }
            case 128: {
                sb.append("MERGE");
                sb.append('[').append('\n');
                this.appendMultiColumns(sb, this.insertColumnMap).append('\n');
                this.appendColumns(sb, this.updateColumnMap).append('\n');
                this.appendTable(sb).append('\n');
                this.appendCondition(session, sb);
                sb.append(this.targetRangeVariables[0].describe(session)).append('\n');
                sb.append(this.targetRangeVariables[1].describe(session)).append('\n');
                sb.append(this.targetRangeVariables[2].describe(session)).append('\n');
                this.appendParms(sb).append('\n');
                this.appendSubqueries(session, sb).append(']');
                return sb.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuffer appendSubqueries(Session session, StringBuffer sb) {
        sb.append("SUBQUERIES[");
        for (int i = 0; i < this.subqueries.length; ++i) {
            sb.append("\n[level=").append(this.subqueries[i].level).append('\n');
            if (this.subqueries[i].queryExpression != null) {
                sb.append(this.subqueries[i].queryExpression.describe(session));
            }
            sb.append("]");
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendTable(StringBuffer sb) {
        sb.append("TABLE[").append(this.targetTable.getName().name).append(']');
        return sb;
    }

    private StringBuffer appendSourceTable(StringBuffer sb) {
        sb.append("SOURCE TABLE[").append(this.sourceTable.getName().name).append(']');
        return sb;
    }

    private StringBuffer appendColumns(StringBuffer sb, int[] columnMap) {
        if (columnMap == null || this.updateExpressions == null) {
            return sb;
        }
        sb.append("COLUMNS=[");
        for (int i = 0; i < columnMap.length; ++i) {
            sb.append('\n').append(columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn(columnMap[i]).getNameString()).append('[').append(this.updateExpressions[i]).append(']');
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendMultiColumns(StringBuffer sb, int[] columnMap) {
        if (columnMap == null || this.multiColumnValues == null) {
            return sb;
        }
        sb.append("COLUMNS=[");
        for (int j = 0; j < this.multiColumnValues.length; ++j) {
            for (int i = 0; i < columnMap.length; ++i) {
                sb.append('\n').append(columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn((int)columnMap[i]).getName().name).append('[').append(this.multiColumnValues[j][i]).append(']');
            }
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendParms(StringBuffer sb) {
        sb.append("PARAMETERS=[");
        for (int i = 0; i < this.parameters.length; ++i) {
            sb.append('\n').append('@').append(i).append('[').append(this.parameters[i]).append(']');
        }
        sb.append(']');
        return sb;
    }

    private StringBuffer appendCondition(Session session, StringBuffer sb) {
        return this.condition == null ? sb.append("CONDITION[]\n") : sb.append("CONDITION[").append(this.condition.describe(session)).append("]\n");
    }

    @Override
    public void resolve() {
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }
}

