/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class SchemaManager {
    Database database;
    HsqlNameManager.HsqlName defaultSchemaHsqlName;
    HashMappedList schemaMap = new HashMappedList();
    MultiValueHashMap referenceMap = new MultiValueHashMap();
    int defaultTableType = 3;
    long schemaChangeTimestamp;
    int[][] tempIndexRoots;

    SchemaManager(Database database) {
        this.database = database;
        this.defaultSchemaHsqlName = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        Schema schema = new Schema(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner);
        this.schemaMap.put(schema.name.name, schema);
        try {
            schema.typeLookup.add(SqlInvariants.CARDINAL_NUMBER);
            schema.typeLookup.add(SqlInvariants.YES_OR_NO);
            schema.typeLookup.add(SqlInvariants.CHARACTER_DATA);
            schema.typeLookup.add(SqlInvariants.SQL_IDENTIFIER);
            schema.typeLookup.add(SqlInvariants.TIME_STAMP);
            schema.charsetLookup.add(SqlInvariants.SQL_TEXT);
            schema.charsetLookup.add(SqlInvariants.SQL_IDENTIFIER_CHARSET);
            schema.charsetLookup.add(SqlInvariants.SQL_CHARACTER);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void setSchemaChangeTimestamp() {
        this.schemaChangeTimestamp = this.database.txManager.getGlobalChangeTimestamp();
    }

    public long getSchemaChangeTimestamp() {
        return this.schemaChangeTimestamp;
    }

    public HsqlNameManager.HsqlName getSQLJSchemaHsqlName() {
        return SqlInvariants.SQLJ_SCHEMA_HSQLNAME;
    }

    void createPublicSchema() {
        HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(null, "PUBLIC", 2);
        Schema schema = new Schema(name, this.database.getGranteeManager().getDBARole());
        this.defaultSchemaHsqlName = schema.name;
        this.schemaMap.put(schema.name.name, schema);
    }

    void createSchema(HsqlNameManager.HsqlName name, Grantee owner) {
        SqlInvariants.checkSchemaNameNotSystem(name.name);
        Schema schema = new Schema(name, owner);
        this.schemaMap.add(name.name, schema);
    }

    void dropSchema(String name, boolean cascade) {
        Schema schema = (Schema)this.schemaMap.get(name);
        if (schema == null) {
            throw Error.error(5501, name);
        }
        if (cascade) {
            OrderedHashSet externalReferences = new OrderedHashSet();
            this.getCascadingSchemaReferences(schema.getName(), externalReferences);
            this.removeSchemaObjects(externalReferences);
        } else if (!schema.isEmpty()) {
            throw Error.error(4200);
        }
        Iterator tableIterator = schema.schemaObjectIterator(3);
        while (tableIterator.hasNext()) {
            Table table = (Table)tableIterator.next();
            this.database.getGranteeManager().removeDbObject(table.getName());
            table.releaseTriggers();
            this.database.persistentStoreCollection.releaseStore(table);
        }
        Iterator sequenceIterator = schema.schemaObjectIterator(7);
        while (sequenceIterator.hasNext()) {
            NumberSequence sequence = (NumberSequence)sequenceIterator.next();
            this.database.getGranteeManager().removeDbObject(sequence.getName());
        }
        schema.clearStructures();
        this.schemaMap.remove(name);
        if (this.defaultSchemaHsqlName.name.equals(name)) {
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(name, false, 2);
            schema = new Schema(hsqlName, this.database.getGranteeManager().getDBARole());
            this.defaultSchemaHsqlName = schema.name;
            this.schemaMap.put(schema.name.name, schema);
        }
        this.database.getUserManager().removeSchemaReference(name);
        this.database.getSessionManager().removeSchemaReference(schema);
    }

    void renameSchema(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName newName) {
        Schema schema = (Schema)this.schemaMap.get(name.name);
        Schema exists = (Schema)this.schemaMap.get(newName.name);
        if (schema == null) {
            throw Error.error(5501, name.name);
        }
        if (exists != null) {
            throw Error.error(5504, newName.name);
        }
        SqlInvariants.checkSchemaNameNotSystem(name.name);
        SqlInvariants.checkSchemaNameNotSystem(newName.name);
        int index = this.schemaMap.getIndex(name.name);
        schema.name.rename(newName);
        this.schemaMap.set(index, newName.name, schema);
    }

    void clearStructures() {
        Iterator it = this.schemaMap.values().iterator();
        while (it.hasNext()) {
            Schema schema = (Schema)it.next();
            schema.clearStructures();
        }
    }

    public Iterator allSchemaNameIterator() {
        return this.schemaMap.keySet().iterator();
    }

    HsqlNameManager.HsqlName getUserSchemaHsqlName(String name) {
        Schema schema = (Schema)this.schemaMap.get(name);
        if (schema == null) {
            throw Error.error(4850, name);
        }
        if (schema.getName() == SqlInvariants.INFORMATION_SCHEMA_HSQLNAME) {
            throw Error.error(4850, name);
        }
        return schema.name;
    }

    public Grantee toSchemaOwner(String name) {
        if (SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.name.equals(name)) {
            return SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner;
        }
        Schema schema = (Schema)this.schemaMap.get(name);
        return schema == null ? null : schema.owner;
    }

    public HsqlNameManager.HsqlName getDefaultSchemaHsqlName() {
        return this.defaultSchemaHsqlName;
    }

    public void setDefaultSchemaHsqlName(HsqlNameManager.HsqlName name) {
        this.defaultSchemaHsqlName = name;
    }

    boolean schemaExists(String name) {
        return "INFORMATION_SCHEMA".equals(name) || this.schemaMap.containsKey(name);
    }

    public HsqlNameManager.HsqlName findSchemaHsqlName(String name) {
        Schema schema = (Schema)this.schemaMap.get(name);
        if (schema == null) {
            return null;
        }
        return schema.name;
    }

    public HsqlNameManager.HsqlName getSchemaHsqlName(String name) {
        if (name == null) {
            return this.defaultSchemaHsqlName;
        }
        if ("INFORMATION_SCHEMA".equals(name)) {
            return SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        }
        Schema schema = (Schema)this.schemaMap.get(name);
        if (schema == null) {
            throw Error.error(4850, name);
        }
        return schema.name;
    }

    public String getSchemaName(String name) {
        return this.getSchemaHsqlName((String)name).name;
    }

    public Iterator fullSchemaNamesIterator() {
        return this.schemaMap.keySet().iterator();
    }

    public boolean isSystemSchema(String schema) {
        return "INFORMATION_SCHEMA".equals(schema) || "DEFINITION_SCHEMA".equals(schema) || "SYSTEM_SCHEMA".equals(schema);
    }

    public boolean isLobsSchema(String schema) {
        return "SYSTEM_LOBS".equals(schema);
    }

    boolean isSchemaAuthorisation(Grantee grantee) {
        Iterator schemas = this.allSchemaNameIterator();
        while (schemas.hasNext()) {
            String schemaName = (String)schemas.next();
            if (!grantee.equals(this.toSchemaOwner(schemaName))) continue;
            return true;
        }
        return false;
    }

    void dropSchemas(Grantee grantee, boolean cascade) {
        HsqlArrayList list = this.getSchemas(grantee);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Schema schema = (Schema)it.next();
            this.dropSchema(schema.name.name, cascade);
        }
    }

    HsqlArrayList getSchemas(Grantee grantee) {
        HsqlArrayList list = new HsqlArrayList();
        Iterator it = this.schemaMap.values().iterator();
        while (it.hasNext()) {
            Schema schema = (Schema)it.next();
            if (!grantee.equals(schema.owner)) continue;
            list.add(schema);
        }
        return list;
    }

    boolean hasSchemas(Grantee grantee) {
        Iterator it = this.schemaMap.values().iterator();
        while (it.hasNext()) {
            Schema schema = (Schema)it.next();
            if (!grantee.equals(schema.owner)) continue;
            return true;
        }
        return false;
    }

    public HsqlArrayList getAllTables() {
        Iterator schemas = this.allSchemaNameIterator();
        HsqlArrayList alltables = new HsqlArrayList();
        while (schemas.hasNext()) {
            String name = (String)schemas.next();
            HashMappedList current = this.getTables(name);
            alltables.addAll(current.values());
        }
        return alltables;
    }

    public HashMappedList getTables(String schema) {
        Schema temp = (Schema)this.schemaMap.get(schema);
        return temp.tableList;
    }

    public HsqlNameManager.HsqlName[] getCatalogAndBaseTableNames() {
        OrderedHashSet names = new OrderedHashSet();
        HsqlArrayList tables = this.getAllTables();
        for (int i = 0; i < tables.size(); ++i) {
            Table table = (Table)tables.get(i);
            if (table.isTemp()) continue;
            names.add(table.getName());
        }
        names.add(this.database.getCatalogName());
        Object[] array = new HsqlNameManager.HsqlName[names.size()];
        names.toArray(array);
        return array;
    }

    SchemaObjectSet getSchemaObjectSet(Schema schema, int type) {
        SchemaObjectSet set = null;
        switch (type) {
            case 7: {
                set = schema.sequenceLookup;
                break;
            }
            case 3: 
            case 4: {
                set = schema.tableLookup;
                break;
            }
            case 14: {
                set = schema.charsetLookup;
                break;
            }
            case 15: {
                set = schema.collationLookup;
                break;
            }
            case 17: {
                set = schema.procedureLookup;
                break;
            }
            case 16: {
                set = schema.functionLookup;
                break;
            }
            case 12: 
            case 13: {
                set = schema.typeLookup;
                break;
            }
            case 20: {
                set = schema.indexLookup;
                break;
            }
            case 5: {
                set = schema.constraintLookup;
                break;
            }
            case 8: {
                set = schema.triggerLookup;
                break;
            }
            case 24: {
                set = schema.specificRoutineLookup;
            }
        }
        return set;
    }

    void checkSchemaObjectNotExists(HsqlNameManager.HsqlName name) {
        Schema schema = (Schema)this.schemaMap.get(name.schema.name);
        SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
        set.checkAdd(name);
    }

    public Table getTable(Session session, String name, String schema) {
        Table t = null;
        if (schema == null) {
            t = this.findSessionTable(session, name, null);
        }
        if (t == null) {
            schema = session.getSchemaName(schema);
            t = this.findUserTable(session, name, schema);
        }
        if (t == null && "INFORMATION_SCHEMA".equals(schema) && this.database.dbInfo != null) {
            t = this.database.dbInfo.getSystemTable(session, name);
        }
        if (t == null) {
            throw Error.error(5501, name);
        }
        return t;
    }

    public Table getUserTable(Session session, HsqlNameManager.HsqlName name) {
        return this.getUserTable(session, name.name, name.schema.name);
    }

    public Table getUserTable(Session session, String name, String schema) {
        Table t = this.findUserTable(session, name, schema);
        if (t == null) {
            throw Error.error(5501, name);
        }
        return t;
    }

    public Table findUserTable(Session session, String name, String schemaName) {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        if (schema == null) {
            return null;
        }
        int i = schema.tableList.getIndex(name);
        if (i == -1) {
            return null;
        }
        return (Table)schema.tableList.get(i);
    }

    public Table findSessionTable(Session session, String name, String schemaName) {
        return session.findSessionTable(name);
    }

    void dropTableOrView(Session session, Table table, boolean cascade) {
        session.commit(false);
        if (table.isView()) {
            this.removeSchemaObject(table.getName(), cascade);
        } else {
            this.dropTable(session, table, cascade);
        }
    }

    void dropTable(Session session, Table table, boolean cascade) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        int dropIndex = schema.tableList.getIndex(table.getName().name);
        OrderedHashSet externalConstraints = table.getDependentExternalConstraints();
        OrderedHashSet externalReferences = new OrderedHashSet();
        this.getCascadingReferences(table.getName(), externalReferences);
        if (!cascade) {
            int i;
            for (i = 0; i < externalConstraints.size(); ++i) {
                Constraint c = (Constraint)externalConstraints.get(i);
                HsqlNameManager.HsqlName tablename = c.getRef().getName();
                HsqlNameManager.HsqlName refname = c.getRefName();
                if (c.getConstraintType() != 1) continue;
                throw Error.error(5533, refname.schema.name + '.' + tablename.name + '.' + refname.name);
            }
            if (!externalReferences.isEmpty()) {
                for (i = 0; i < externalReferences.size(); ++i) {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)externalReferences.get(i);
                    if (name.parent == table.getName()) continue;
                    throw Error.error(5502, name.getSchemaQualifiedStatementName());
                }
            }
        }
        OrderedHashSet tableSet = new OrderedHashSet();
        OrderedHashSet constraintNameSet = new OrderedHashSet();
        OrderedHashSet indexNameSet = new OrderedHashSet();
        for (int i = 0; i < externalConstraints.size(); ++i) {
            Constraint c = (Constraint)externalConstraints.get(i);
            Table t = c.getMain();
            if (t != table) {
                tableSet.add(t);
            }
            if ((t = c.getRef()) != table) {
                tableSet.add(t);
            }
            constraintNameSet.add(c.getMainName());
            constraintNameSet.add(c.getRefName());
            indexNameSet.add(c.getRefIndex().getName());
        }
        TableWorks tw = new TableWorks(session, table);
        tableSet = tw.makeNewTables(tableSet, constraintNameSet, indexNameSet);
        tw.setNewTablesInSchema(tableSet);
        tw.updateConstraints(tableSet, constraintNameSet);
        this.removeSchemaObjects(externalReferences);
        this.removeReferencedObject(table.getName());
        schema.tableList.remove(dropIndex);
        this.database.getGranteeManager().removeDbObject(table.getName());
        schema.triggerLookup.removeParent(table.tableName);
        schema.indexLookup.removeParent(table.tableName);
        schema.constraintLookup.removeParent(table.tableName);
        table.releaseTriggers();
        this.database.persistentStoreCollection.releaseStore(table);
        this.recompileDependentObjects(tableSet);
    }

    void setTable(int index, Table table) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        schema.tableList.set(index, table.getName().name, table);
    }

    int getTableIndex(Table table) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        if (schema == null) {
            return -1;
        }
        HsqlNameManager.HsqlName name = table.getName();
        return schema.tableList.getIndex(name.name);
    }

    void recompileDependentObjects(OrderedHashSet tableSet) {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < tableSet.size(); ++i) {
            Table table = (Table)tableSet.get(i);
            set.addAll(this.getReferencingObjects(table.getName()));
        }
        Session session = this.database.sessionManager.getSysSession();
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
            switch (name.type) {
                case 4: 
                case 5: 
                case 6: {
                    SchemaObject object = this.getSchemaObject(name);
                    object.compile(session, null);
                }
            }
        }
    }

    void recompileDependentObjects(Table table) {
        OrderedHashSet set = this.getReferencingObjects(table.getName());
        Session session = this.database.sessionManager.getSysSession();
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
            switch (name.type) {
                case 4: 
                case 5: 
                case 6: {
                    SchemaObject object = this.getSchemaObject(name);
                    object.compile(session, null);
                }
            }
        }
        HsqlArrayList list = this.getAllTables();
        for (int i = 0; i < list.size(); ++i) {
            Table t = (Table)list.get(i);
            t.updateConstraintPath();
        }
    }

    NumberSequence getSequence(String name, String schemaName, boolean raise) {
        NumberSequence object;
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        if (schema != null && (object = (NumberSequence)schema.sequenceList.get(name)) != null) {
            return object;
        }
        if (raise) {
            throw Error.error(5501, name);
        }
        return null;
    }

    public Type getUserDefinedType(String name, String schemaName, boolean raise) {
        SchemaObject object;
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        if (schema != null && (object = schema.typeLookup.getObject(name)) != null) {
            return (Type)object;
        }
        if (raise) {
            throw Error.error(5501, name);
        }
        return null;
    }

    public Type getDomain(String name, String schemaName, boolean raise) {
        SchemaObject object;
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        if (schema != null && (object = schema.typeLookup.getObject(name)) != null && ((Type)object).isDomainType()) {
            return (Type)object;
        }
        if (raise) {
            throw Error.error(5501, name);
        }
        return null;
    }

    public Type getDistinctType(String name, String schemaName, boolean raise) {
        SchemaObject object;
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        if (schema != null && (object = schema.typeLookup.getObject(name)) != null && ((Type)object).isDomainType()) {
            return (Type)object;
        }
        if (raise) {
            throw Error.error(5501, name);
        }
        return null;
    }

    public SchemaObject getSchemaObject(String name, String schemaName, int type) {
        SchemaObject object = this.findSchemaObject(name, schemaName, type);
        if (object == null) {
            throw Error.error(SchemaObjectSet.getGetErrorCode(type), name);
        }
        return object;
    }

    public SchemaObject findSchemaObject(String name, String schemaName, int type) {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        if (schema == null) {
            return null;
        }
        SchemaObjectSet set = null;
        switch (type) {
            case 7: {
                return schema.sequenceLookup.getObject(name);
            }
            case 3: 
            case 4: {
                return schema.sequenceLookup.getObject(name);
            }
            case 14: {
                if (name.equals("SQL_IDENTIFIER")) {
                    return SqlInvariants.SQL_IDENTIFIER_CHARSET;
                }
                if (name.equals("SQL_TEXT")) {
                    return SqlInvariants.SQL_TEXT;
                }
                if (name.equals("LATIN1")) {
                    return SqlInvariants.LATIN1;
                }
                if (name.equals("ASCII_GRAPHIC")) {
                    return SqlInvariants.ASCII_GRAPHIC;
                }
                return schema.charsetLookup.getObject(name);
            }
            case 15: {
                return schema.collationLookup.getObject(name);
            }
            case 17: {
                return schema.procedureLookup.getObject(name);
            }
            case 16: {
                return schema.functionLookup.getObject(name);
            }
            case 18: {
                SchemaObject object = schema.procedureLookup.getObject(name);
                if (object == null) {
                    object = schema.functionLookup.getObject(name);
                }
                return object;
            }
            case 24: {
                return schema.specificRoutineLookup.getObject(name);
            }
            case 12: 
            case 13: {
                return schema.typeLookup.getObject(name);
            }
            case 20: {
                set = schema.indexLookup;
                HsqlNameManager.HsqlName objectName = set.getName(name);
                if (objectName == null) {
                    return null;
                }
                Table table = (Table)schema.tableList.get(objectName.parent.name);
                return table.getIndex(name);
            }
            case 5: {
                set = schema.constraintLookup;
                HsqlNameManager.HsqlName objectName = set.getName(name);
                if (objectName == null) {
                    return null;
                }
                Table table = (Table)schema.tableList.get(objectName.parent.name);
                if (table == null) {
                    return null;
                }
                return table.getConstraint(name);
            }
            case 8: {
                set = schema.indexLookup;
                HsqlNameManager.HsqlName objectName = set.getName(name);
                if (objectName == null) {
                    return null;
                }
                Table table = (Table)schema.tableList.get(objectName.parent.name);
                return table.getTrigger(name);
            }
        }
        throw Error.runtimeError(401, "SchemaManager");
    }

    Table findUserTableForIndex(Session session, String name, String schemaName) {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        HsqlNameManager.HsqlName indexName = schema.indexLookup.getName(name);
        if (indexName == null) {
            return null;
        }
        return this.findUserTable(session, indexName.parent.name, schemaName);
    }

    void dropIndex(Session session, HsqlNameManager.HsqlName name) {
        Table t = this.getTable(session, name.parent.name, name.parent.schema.name);
        TableWorks tw = new TableWorks(session, t);
        tw.dropIndex(name.name);
    }

    void dropConstraint(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        Table t = this.getTable(session, name.parent.name, name.parent.schema.name);
        TableWorks tw = new TableWorks(session, t);
        tw.dropConstraint(name.name, cascade);
    }

    void removeDependentObjects(HsqlNameManager.HsqlName name) {
        Schema schema = (Schema)this.schemaMap.get(name.schema.name);
        schema.indexLookup.removeParent(name);
        schema.constraintLookup.removeParent(name);
        schema.triggerLookup.removeParent(name);
    }

    void removeExportedKeys(Table toDrop) {
        Schema schema = (Schema)this.schemaMap.get(toDrop.getSchemaName().name);
        for (int i = 0; i < schema.tableList.size(); ++i) {
            Table table = (Table)schema.tableList.get(i);
            for (int j = table.constraintList.length - 1; j >= 0; --j) {
                Table refTable = table.constraintList[j].getRef();
                if (toDrop != refTable) continue;
                table.removeConstraint(j);
            }
        }
    }

    public Iterator databaseObjectIterator(String schemaName, int type) {
        Schema schema = (Schema)this.schemaMap.get(schemaName);
        return schema.schemaObjectIterator(type);
    }

    public Iterator databaseObjectIterator(int type) {
        Iterator it = this.schemaMap.values().iterator();
        WrapperIterator objects = new WrapperIterator();
        while (it.hasNext()) {
            Schema temp = (Schema)it.next();
            objects = new WrapperIterator(objects, temp.schemaObjectIterator(type));
        }
        return objects;
    }

    private void addReferences(SchemaObject object) {
        OrderedHashSet set = object.getReferences();
        if (set == null) {
            return;
        }
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName referenced = (HsqlNameManager.HsqlName)set.get(i);
            if (referenced.type == 9) {
                this.referenceMap.put(referenced.parent, object.getName());
                continue;
            }
            this.referenceMap.put(referenced, object.getName());
        }
    }

    private void removeReferencedObject(HsqlNameManager.HsqlName referenced) {
        this.referenceMap.remove(referenced);
    }

    private void removeReferencingObject(SchemaObject object) {
        OrderedHashSet set = object.getReferences();
        if (set == null) {
            return;
        }
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName referenced = (HsqlNameManager.HsqlName)set.get(i);
            this.referenceMap.remove(referenced, object.getName());
        }
    }

    OrderedHashSet getReferencingObjects(HsqlNameManager.HsqlName object) {
        OrderedHashSet set = new OrderedHashSet();
        Iterator it = this.referenceMap.get(object);
        while (it.hasNext()) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
            set.add(name);
        }
        return set;
    }

    OrderedHashSet getReferencingObjects(HsqlNameManager.HsqlName table, HsqlNameManager.HsqlName column) {
        OrderedHashSet set = new OrderedHashSet();
        Iterator it = this.referenceMap.get(table);
        while (it.hasNext()) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
            SchemaObject object = this.getSchemaObject(name);
            OrderedHashSet references = object.getReferences();
            if (!references.contains(column)) continue;
            set.add(name);
        }
        return set;
    }

    private boolean isReferenced(HsqlNameManager.HsqlName object) {
        return this.referenceMap.containsKey(object);
    }

    void getCascadingReferences(HsqlNameManager.HsqlName object, OrderedHashSet set) {
        OrderedHashSet newSet = new OrderedHashSet();
        Iterator it = this.referenceMap.get(object);
        while (it.hasNext()) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
            boolean added = set.add(name);
            if (!added) continue;
            newSet.add(name);
        }
        for (int i = 0; i < newSet.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)newSet.get(i);
            this.getCascadingReferences(name, set);
        }
    }

    void getCascadingSchemaReferences(HsqlNameManager.HsqlName schema, OrderedHashSet set) {
        Iterator mainIterator = this.referenceMap.keySet().iterator();
        while (mainIterator.hasNext()) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)mainIterator.next();
            if (name.schema != schema) continue;
            this.getCascadingReferences(name, set);
        }
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
            if (name.schema != schema) continue;
            set.remove(i);
            --i;
        }
    }

    HsqlNameManager.HsqlName getSchemaObjectName(HsqlNameManager.HsqlName schemaName, String name, int type, boolean raise) {
        Schema schema = (Schema)this.schemaMap.get(schemaName.name);
        SchemaObjectSet set = null;
        if (schema == null) {
            if (raise) {
                throw Error.error(SchemaObjectSet.getGetErrorCode(type));
            }
            return null;
        }
        set = this.getSchemaObjectSet(schema, type);
        if (raise) {
            set.checkExists(name);
        }
        return set.getName(name);
    }

    SchemaObject getSchemaObject(HsqlNameManager.HsqlName name) {
        Schema schema = (Schema)this.schemaMap.get(name.schema.name);
        if (schema == null) {
            return null;
        }
        switch (name.type) {
            case 7: {
                return (SchemaObject)schema.sequenceList.get(name.name);
            }
            case 3: 
            case 4: {
                return (SchemaObject)schema.tableList.get(name.name);
            }
            case 14: {
                return schema.charsetLookup.getObject(name.name);
            }
            case 15: {
                return schema.collationLookup.getObject(name.name);
            }
            case 17: {
                return schema.procedureLookup.getObject(name.name);
            }
            case 16: {
                return schema.functionLookup.getObject(name.name);
            }
            case 24: {
                return schema.specificRoutineLookup.getObject(name.name);
            }
            case 12: 
            case 13: {
                return schema.typeLookup.getObject(name.name);
            }
            case 8: {
                name = schema.triggerLookup.getName(name.name);
                if (name == null) {
                    return null;
                }
                HsqlNameManager.HsqlName tableName = name.parent;
                Table table = (Table)schema.tableList.get(tableName.name);
                return table.getTrigger(name.name);
            }
            case 5: {
                name = schema.constraintLookup.getName(name.name);
                if (name == null) {
                    return null;
                }
                HsqlNameManager.HsqlName tableName = name.parent;
                Table table = (Table)schema.tableList.get(tableName.name);
                return table.getConstraint(name.name);
            }
            case 6: {
                return null;
            }
            case 20: {
                name = schema.indexLookup.getName(name.name);
                if (name == null) {
                    return null;
                }
                HsqlNameManager.HsqlName tableName = name.parent;
                Table table = (Table)schema.tableList.get(tableName.name);
                return table.getIndex(name.name);
            }
        }
        return null;
    }

    void checkColumnIsReferenced(HsqlNameManager.HsqlName tableName, HsqlNameManager.HsqlName name) {
        OrderedHashSet set = this.getReferencingObjects(tableName, name);
        if (!set.isEmpty()) {
            HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)set.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
    }

    void checkObjectIsReferenced(HsqlNameManager.HsqlName name) {
        OrderedHashSet set = this.getReferencingObjects(name);
        HsqlNameManager.HsqlName refName = null;
        for (int i = 0; i < set.size(); ++i) {
            refName = (HsqlNameManager.HsqlName)set.get(i);
            if (refName.parent != name) break;
            refName = null;
        }
        if (refName == null) {
            return;
        }
        throw Error.error(5502, refName.getSchemaQualifiedStatementName());
    }

    void checkSchemaNameCanChange(HsqlNameManager.HsqlName name) {
        Iterator it = this.referenceMap.values().iterator();
        HsqlNameManager.HsqlName refName = null;
        block3: while (it.hasNext()) {
            refName = (HsqlNameManager.HsqlName)it.next();
            switch (refName.type) {
                case 4: 
                case 16: 
                case 17: 
                case 18: {
                    if (refName.schema == name) break block3;
                }
                default: {
                    refName = null;
                    continue block3;
                }
            }
        }
        if (refName == null) {
            return;
        }
        throw Error.error(5502, refName.getSchemaQualifiedStatementName());
    }

    void addSchemaObject(SchemaObject object) {
        HsqlNameManager.HsqlName name = object.getName();
        Schema schema = (Schema)this.schemaMap.get(name.schema.name);
        SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
        switch (name.type) {
            case 16: 
            case 17: {
                RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                if (routine == null) {
                    routine = new RoutineSchema(name.type, name);
                    routine.addSpecificRoutine(this.database, (Routine)object);
                    set.checkAdd(name);
                    SchemaObjectSet specificSet = this.getSchemaObjectSet(schema, 24);
                    specificSet.checkAdd(((Routine)object).getSpecificName());
                    set.add(routine);
                    specificSet.add(object);
                } else {
                    SchemaObjectSet specificSet = this.getSchemaObjectSet(schema, 24);
                    HsqlNameManager.HsqlName specificName = ((Routine)object).getSpecificName();
                    if (specificName != null) {
                        specificSet.checkAdd(specificName);
                    }
                    routine.addSpecificRoutine(this.database, (Routine)object);
                    specificSet.add(object);
                }
                this.addReferences(object);
                return;
            }
        }
        set.add(object);
        this.addReferences(object);
    }

    void removeSchemaObject(HsqlNameManager.HsqlName name, boolean cascade) {
        OrderedHashSet objectSet = new OrderedHashSet();
        switch (name.type) {
            case 16: 
            case 17: {
                RoutineSchema routine = (RoutineSchema)this.getSchemaObject(name);
                if (routine != null) {
                    Routine[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.getCascadingReferences(specifics[i].getSpecificName(), objectSet);
                    }
                }
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 24: {
                this.getCascadingReferences(name, objectSet);
                break;
            }
        }
        if (objectSet.isEmpty()) {
            this.removeSchemaObject(name);
            return;
        }
        if (!cascade) {
            HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)objectSet.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
        objectSet.add(name);
        this.removeSchemaObjects(objectSet);
    }

    void removeSchemaObjects(OrderedHashSet set) {
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
            this.removeSchemaObject(name);
        }
    }

    void removeSchemaObject(HsqlNameManager.HsqlName name) {
        Schema schema = (Schema)this.schemaMap.get(name.schema.name);
        SchemaObject object = null;
        SchemaObjectSet set = null;
        switch (name.type) {
            case 7: {
                set = schema.sequenceLookup;
                object = set.getObject(name.name);
                break;
            }
            case 3: 
            case 4: {
                set = schema.tableLookup;
                object = set.getObject(name.name);
                set.remove(name.name);
                break;
            }
            case 14: {
                set = schema.charsetLookup;
                object = set.getObject(name.name);
                break;
            }
            case 15: {
                set = schema.collationLookup;
                object = set.getObject(name.name);
                break;
            }
            case 17: {
                set = schema.procedureLookup;
                RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                object = routine;
                Routine[] specifics = routine.getSpecificRoutines();
                for (int i = 0; i < specifics.length; ++i) {
                    this.removeSchemaObject(specifics[i].getSpecificName());
                }
                break;
            }
            case 16: {
                set = schema.functionLookup;
                RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                object = routine;
                Routine[] specifics = routine.getSpecificRoutines();
                for (int i = 0; i < specifics.length; ++i) {
                    this.removeSchemaObject(specifics[i].getSpecificName());
                }
                break;
            }
            case 24: {
                set = schema.specificRoutineLookup;
                Routine routine = (Routine)set.getObject(name.name);
                object = routine;
                routine.routineSchema.removeSpecificRoutine(routine);
                if (routine.routineSchema.getSpecificRoutines().length != 0) break;
                this.removeSchemaObject(routine.getName());
                break;
            }
            case 12: 
            case 13: {
                set = schema.typeLookup;
                object = set.getObject(name.name);
                break;
            }
            case 20: {
                set = schema.indexLookup;
                break;
            }
            case 5: {
                set = schema.constraintLookup;
                if (name.parent.type == 3) {
                    Table table = (Table)schema.tableList.get(name.parent.name);
                    object = table.getConstraint(name.name);
                    table.removeConstraint(name.name);
                    break;
                }
                if (name.parent.type != 13) break;
                Type type = (Type)schema.typeLookup.getObject(name.parent.name);
                object = type.userTypeModifier.getConstraint(name.name);
                type.userTypeModifier.removeConstraint(name.name);
                break;
            }
            case 8: {
                set = schema.triggerLookup;
                Table table = (Table)schema.tableList.get(name.parent.name);
                object = table.getTrigger(name.name);
                table.removeTrigger(name.name);
                break;
            }
            default: {
                throw Error.runtimeError(401, "SchemaManager");
            }
        }
        if (object != null) {
            this.database.getGranteeManager().removeDbObject(name);
            this.removeReferencingObject(object);
        }
        set.remove(name.name);
        this.removeReferencedObject(name);
    }

    void renameSchemaObject(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName newName) {
        if (name.schema != newName.schema) {
            throw Error.error(5505, newName.schema.name);
        }
        this.checkObjectIsReferenced(name);
        Schema schema = (Schema)this.schemaMap.get(name.schema.name);
        SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
        set.rename(name, newName);
    }

    public String[] getSQLArray() {
        Iterator it;
        Schema schema;
        OrderedHashSet resolved = new OrderedHashSet();
        OrderedHashSet unresolved = new OrderedHashSet();
        HsqlArrayList list = new HsqlArrayList();
        Iterator schemas = this.schemaMap.values().iterator();
        while (schemas.hasNext()) {
            schema = (Schema)schemas.next();
            if (this.isSystemSchema(schema.name.name) || this.isLobsSchema(schema.name.name)) continue;
            list.addAll(schema.getSQLArray(resolved, unresolved));
        }
        while ((it = unresolved.iterator()).hasNext()) {
            while (it.hasNext()) {
                SchemaObject object = (SchemaObject)it.next();
                OrderedHashSet references = object.getReferences();
                boolean isResolved = true;
                for (int j = 0; j < references.size(); ++j) {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)references.get(j);
                    if (name.type == 9 || name.type == 5) {
                        name = name.parent;
                    }
                    if (resolved.contains(name)) continue;
                    isResolved = false;
                    break;
                }
                if (!isResolved) continue;
                if (object.getType() == 3) {
                    list.addAll(((Table)object).getSQL(resolved, unresolved));
                } else {
                    list.add(object.getSQL());
                    resolved.add(object.getName());
                }
                it.remove();
            }
        }
        schemas = this.schemaMap.values().iterator();
        while (schemas.hasNext()) {
            schema = (Schema)schemas.next();
            if (this.database.schemaManager.isSystemSchema(schema.name.name)) continue;
            if (this.database.schemaManager.isLobsSchema(schema.name.name)) {
                // empty if block
            }
            list.addAll(schema.getTriggerSQL());
            list.addAll(schema.getSequenceRestartSQL());
        }
        if (this.defaultSchemaHsqlName != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("SET").append(' ').append("DATABASE");
            sb.append(' ').append("DEFAULT").append(' ');
            sb.append("INITIAL").append(' ').append("SCHEMA");
            sb.append(' ').append(this.defaultSchemaHsqlName.statementName);
            list.add(sb.toString());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getTextTableSQL(boolean withHeader) {
        HsqlArrayList tableList = this.getAllTables();
        HsqlArrayList list = new HsqlArrayList();
        for (int i = 0; i < tableList.size(); ++i) {
            Table t = (Table)tableList.get(i);
            if (!t.isText()) continue;
            Object[] ddl = t.getSQLForTextSource(withHeader);
            list.addAll(ddl);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getIndexRootsSQL() {
        Session sysSession = this.database.sessionManager.getSysSession();
        int[][] rootsArray = this.getIndexRoots(sysSession);
        HsqlArrayList tableList = this.getAllTables();
        HsqlArrayList list = new HsqlArrayList();
        for (int i = 0; i < rootsArray.length; ++i) {
            Table t = (Table)tableList.get(i);
            if (rootsArray[i] == null || rootsArray[i].length <= 0 || rootsArray[i][0] == -1) continue;
            String ddl = ((Table)tableList.get(i)).getIndexRootsSQL(rootsArray[i]);
            list.add(ddl);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public void setTempIndexRoots(int[][] roots) {
        this.tempIndexRoots = roots;
    }

    public int[][] getIndexRoots(Session session) {
        if (this.tempIndexRoots != null) {
            int[][] roots = this.tempIndexRoots;
            this.tempIndexRoots = null;
            return roots;
        }
        HsqlArrayList allTables = this.getAllTables();
        HsqlArrayList list = new HsqlArrayList();
        int size = allTables.size();
        for (int i = 0; i < size; ++i) {
            Table t = (Table)allTables.get(i);
            if (t.getTableType() == 4) {
                int[] roots = t.getIndexRootsArray();
                list.add(roots);
                continue;
            }
            list.add(null);
        }
        int[][] array = new int[list.size()][];
        list.toArray(array);
        return array;
    }

    public void setIndexRoots(int[][] roots) {
        HsqlArrayList allTables = this.database.schemaManager.getAllTables();
        int size = allTables.size();
        for (int i = 0; i < size; ++i) {
            Table t = (Table)allTables.get(i);
            if (t.getTableType() != 4) continue;
            int[] rootsArray = roots[i];
            if (roots == null) continue;
            t.setIndexRoots(rootsArray);
        }
    }

    public void setDefaultTableType(int type) {
        this.defaultTableType = type;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }
}

