/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Row;
import org.hsqldb.RowActionBase;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;

public class RowAction
extends RowActionBase {
    final Table table;
    Row memoryRow;
    int rowId;
    boolean isMemory;

    public static RowAction addAction(Session session, byte type, Table table, Row row) {
        RowAction action = row.rowAction;
        if (action == null) {
            action = new RowAction(session, table, type);
            if (row.isMemory()) {
                action.isMemory = true;
            }
            action.memoryRow = row;
            action.rowId = row.getPos();
            row.rowAction = action;
        } else {
            if (action.type == 3) {
                throw Error.runtimeError(401, "RowAction");
            }
            if (action.type == 0) {
                action.setAsAction(session, type);
            } else {
                RowActionBase newAction;
                RowActionBase actionItem = action;
                while (actionItem.next != null) {
                    actionItem = actionItem.next;
                }
                actionItem.next = newAction = new RowActionBase(session, type);
            }
        }
        return action;
    }

    RowAction(Session session, Table table, byte type) {
        super(session, type);
        this.table = table;
    }

    public synchronized RowAction duplicate(int newRowId) {
        RowAction action = this.duplicate();
        action.rowId = newRowId;
        return action;
    }

    synchronized RowAction duplicate() {
        RowAction action = new RowAction(this.session, this.table, this.type);
        action.setAsAction(this);
        action.memoryRow = this.memoryRow;
        action.rowId = this.rowId;
        action.isMemory = this.isMemory;
        return action;
    }

    synchronized void setAsAction(Session session, byte type) {
        this.session = session;
        this.type = type;
        this.changeTimestamp = session.actionTimestamp;
    }

    @Override
    synchronized void setAsAction(RowActionBase action) {
        super.setAsAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setAsNoOp(Row row) {
        Row row2 = row;
        synchronized (row2) {
            this.memoryRow = null;
            row.hasAction = false;
            row.rowAction = null;
            this.session = null;
            this.commitTimestamp = 0L;
            this.type = 0;
            this.next = null;
        }
    }

    private void setAsDeleteFinal() {
        this.rolledback = false;
        this.prepared = false;
        this.type = (byte)3;
        this.next = null;
    }

    synchronized void prepareCommit(Session session) {
        RowActionBase action = this;
        do {
            if (action.session != session || action.commitTimestamp != 0L) continue;
            action.prepared = true;
        } while ((action = action.next) != null);
    }

    synchronized void commit(Session session) {
        RowActionBase action = this;
        do {
            if (action.session != session || action.commitTimestamp != 0L) continue;
            action.commitTimestamp = session.actionTimestamp;
            action.prepared = false;
        } while ((action = action.next) != null);
    }

    synchronized void rollback(Session session, long timestamp) {
        RowActionBase action = this;
        do {
            if (action.session != session || action.commitTimestamp != 0L || action.actionTimestamp < timestamp && action.actionTimestamp != 0L) continue;
            action.commitTimestamp = session.actionTimestamp;
            action.rolledback = true;
            action.prepared = false;
        } while ((action = action.next) != null);
    }

    synchronized int getCommitType(long timestamp) {
        RowActionBase action = this;
        byte type = 0;
        do {
            if (action.commitTimestamp != timestamp) continue;
            if (type == 0) {
                type = action.type;
                continue;
            }
            if (type != 1) continue;
            type = 0;
        } while ((action = action.next) != null);
        return type;
    }

    synchronized boolean canCommit(Session session, OrderedHashSet set) {
        long timestamp = session.transactionTimestamp;
        long commitTimestamp = 0L;
        boolean readCommitted = session.isolationMode == 2;
        RowActionBase action = this;
        if (readCommitted) {
            do {
                if (action.session != session || action.commitTimestamp != 0L) continue;
                timestamp = action.actionTimestamp;
            } while ((action = action.next) != null);
            action = this;
        }
        do {
            if (action.rolledback || action.type == 0) {
                action = action.next;
                continue;
            }
            if (action.session != session) {
                if (action.prepared) {
                    return false;
                }
                if (action.commitTimestamp == 0L && action.actionTimestamp != 0L) {
                    set.add(action.session);
                } else if (action.commitTimestamp > commitTimestamp) {
                    commitTimestamp = action.commitTimestamp;
                }
            }
            action = action.next;
        } while (action != null);
        return commitTimestamp < timestamp;
    }

    synchronized boolean complete(Session session, OrderedHashSet set) {
        boolean readCommitted = session.isolationMode == 2;
        boolean result = true;
        RowActionBase action = this;
        do {
            if (action.rolledback || action.type == 0) {
                action = action.next;
                continue;
            }
            if (action.session == session) {
                if (action.actionTimestamp == 0L) {
                    action.actionTimestamp = session.actionTimestamp;
                }
            } else {
                if (action.prepared) {
                    return false;
                }
                if (readCommitted) {
                    if (action.commitTimestamp > session.actionTimestamp) {
                        result = false;
                    } else if (action.commitTimestamp == 0L && action.actionTimestamp != 0L) {
                        if (set != null) {
                            set.add(action.session);
                        }
                        result = false;
                    }
                } else if (action.commitTimestamp > session.transactionTimestamp) {
                    return false;
                }
            }
            action = action.next;
        } while (action != null);
        return result;
    }

    synchronized int getLastChangeActionType(long timestamp) {
        RowActionBase action = this;
        byte actionType = 0;
        do {
            if (action.changeTimestamp != timestamp) continue;
            actionType = action.type;
        } while ((action = action.next) != null);
        return actionType;
    }

    synchronized int getActionType(long timestamp) {
        byte actionType = 0;
        RowActionBase action = this;
        do {
            if (action.actionTimestamp == timestamp) {
                if (action.type == 2 && actionType == 1) {
                    actionType = 0;
                    action = action.next;
                    continue;
                }
                actionType = action.type;
            }
            action = action.next;
        } while (action != null);
        return actionType;
    }

    synchronized int getPos() {
        return this.rowId;
    }

    synchronized void setPos(int pos) {
        this.rowId = pos;
    }

    synchronized void mergeRollback(Row row) {
        RowActionBase action = this;
        RowAction head = null;
        RowAction tail = null;
        if (this.type == 3 || this.type == 0) {
            return;
        }
        do {
            if (action.rolledback) {
                if (tail == null) continue;
                tail.next = null;
                continue;
            }
            if (head == null) {
                head = tail = action;
                continue;
            }
            tail.next = action;
            tail = action;
        } while ((action = action.next) != null);
        if (head == null) {
            boolean exists;
            boolean bl = exists = this.type == 2;
            if (exists) {
                this.setAsNoOp(row);
            } else {
                this.setAsDeleteFinal();
            }
        } else if (head != this) {
            this.setAsAction(head);
        }
    }

    synchronized boolean mergeRollback(Row row, long timestamp) {
        RowActionBase action = this;
        RowAction head = null;
        RowAction tail = null;
        if (this.type == 3 || this.type == 0) {
            return true;
        }
        do {
            if (action.commitTimestamp == timestamp) {
                if (tail == null) continue;
                tail.next = null;
                continue;
            }
            if (head == null) {
                head = tail = action;
                continue;
            }
            tail.next = action;
            tail = action;
        } while ((action = action.next) != null);
        if (head == null) {
            boolean exists;
            boolean bl = exists = this.type == 2;
            if (exists) {
                this.setAsNoOp(row);
            } else {
                this.setAsDeleteFinal();
            }
            return exists;
        }
        if (head != this) {
            this.setAsAction(head);
        }
        return true;
    }

    synchronized void mergeToTimestamp(Row row, long timestamp) {
        RowActionBase action = this;
        RowAction head = null;
        RowAction tail = null;
        boolean exists = true;
        if (this.type == 3 || this.type == 0) {
            return;
        }
        do {
            if (action.commitTimestamp != 0L && action.commitTimestamp <= timestamp) {
                if (tail != null) {
                    tail.next = null;
                }
                exists = action.type == 1;
                continue;
            }
            if (head == null) {
                head = tail = action;
                continue;
            }
            tail.next = action;
            tail = action;
        } while ((action = action.next) != null);
        if (head == null) {
            if (exists) {
                this.setAsNoOp(row);
            } else {
                this.setAsDeleteFinal();
            }
        } else if (head != this) {
            this.setAsAction(head);
        }
    }

    synchronized boolean isPriorTo(long threshold) {
        RowActionBase action = this;
        do {
            if (action.type != 3 && action.commitTimestamp != 0L && action.commitTimestamp <= threshold) continue;
            return false;
        } while ((action = action.next) != null);
        return true;
    }

    synchronized boolean canRead(Session session) {
        long threshold;
        boolean canRead = true;
        if (this.type == 3) {
            return false;
        }
        if (this.type == 0) {
            return true;
        }
        canRead = this.type == 2;
        RowActionBase action = this;
        if (session == null) {
            threshold = Long.MAX_VALUE;
        } else {
            switch (session.isolationMode) {
                case 2: {
                    threshold = session.actionTimestamp;
                    break;
                }
                default: {
                    threshold = session.transactionTimestamp;
                }
            }
        }
        do {
            if (action.rolledback) {
                action = action.next;
                continue;
            }
            if (session == action.session) {
                if (action.type == 2) {
                    canRead = false;
                } else if (action.type == 1) {
                    canRead = true;
                }
                action = action.next;
                continue;
            }
            if (action.commitTimestamp == 0L) {
                action = action.next;
                continue;
            }
            if (action.commitTimestamp < threshold) {
                if (action.type == 2) {
                    canRead = false;
                } else if (action.type == 1) {
                    canRead = true;
                }
            }
            action = action.next;
        } while (action != null);
        return canRead;
    }
}

