/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.TableBase;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.index.NodeAVLMemoryPointer;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowAVLDiskData
extends RowAVLDisk {
    public RowAVLDiskData(TableBase t, Object[] o) {
        super(t, o);
        this.hasDataChanged = true;
    }

    public RowAVLDiskData(TableBase t, RowInputInterface in) throws IOException {
        this.table = t;
        this.tableId = t.getId();
        this.position = in.getPos();
        this.storageSize = in.getSize();
        this.rowData = in.readData(this.table.getColumnTypes());
        this.hasDataChanged = false;
    }

    @Override
    void setNewNodes() {
        int index = this.table.getIndexCount();
        NodeAVL n = this.nPrimaryNode = new NodeAVLMemoryPointer(this);
        for (int i = 1; i < index; ++i) {
            n = n.nNext = new NodeAVLMemoryPointer(this);
        }
    }

    @Override
    public NodeAVL insertNode(int index) {
        NodeAVL backnode = this.getNode(index - 1);
        NodeAVLMemoryPointer newnode = new NodeAVLMemoryPointer(this);
        newnode.nNext = backnode.nNext;
        backnode.nNext = newnode;
        return newnode;
    }

    void setPrimaryNode(NodeAVL primary) {
        this.nPrimaryNode = primary;
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return out.getSize(this);
    }

    @Override
    public void write(RowOutputInterface out) {
        out.writeSize(this.storageSize);
        out.writeData(this.rowData, this.table.colTypes);
        out.writeEnd();
        this.hasDataChanged = false;
    }

    @Override
    public boolean hasChanged() {
        return this.hasDataChanged;
    }

    @Override
    public void setPos(int pos) {
        this.position = pos;
        NodeAVL n = this.nPrimaryNode;
        while (n != null) {
            ((NodeAVLMemoryPointer)n).iData = this.position;
            n = n.nNext;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RowAVLDiskData) {
            return ((RowAVLDiskData)obj).position == this.position && ((RowAVLDiskData)obj).table == this.table;
        }
        return false;
    }
}

