/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.index.NodeAVLDisk;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowAVLDisk
extends RowAVL {
    public static final int NO_POS = -1;
    protected TableBase table;
    int storageSize;
    int keepCount;
    boolean isInMemory;
    int usageCount;
    protected boolean hasDataChanged;
    boolean hasNodesChanged;

    RowAVLDisk() {
    }

    public RowAVLDisk(TableBase t, Object[] o) {
        this.table = t;
        this.tableId = this.table.getId();
        this.setNewNodes();
        this.rowData = o;
        this.hasNodesChanged = true;
        this.hasDataChanged = true;
    }

    public RowAVLDisk(TableBase t, RowInputInterface in) throws IOException {
        this.table = t;
        this.tableId = this.table.getId();
        this.position = in.getPos();
        this.storageSize = in.getSize();
        int indexcount = t.getIndexCount();
        NodeAVL n = this.nPrimaryNode = new NodeAVLDisk(this, in, 0);
        for (int i = 1; i < indexcount; ++i) {
            n = n.nNext = new NodeAVLDisk(this, in, i);
        }
        this.rowData = in.readData(this.table.getColumnTypes());
    }

    @Override
    public NodeAVL insertNode(int index) {
        return null;
    }

    private void readRowInfo(RowInputInterface in) throws IOException {
    }

    public synchronized void setNodesChanged() {
        this.hasNodesChanged = true;
    }

    @Override
    public void updateAccessCount(int count) {
        this.usageCount = count;
    }

    @Override
    public int getAccessCount() {
        return this.usageCount;
    }

    @Override
    public int getStorageSize() {
        return this.storageSize;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public void setPos(int pos) {
        this.position = pos;
        NodeAVL n = this.nPrimaryNode;
        while (n != null) {
            ((NodeAVLDisk)n).iData = this.position;
            n = n.nNext;
        }
    }

    @Override
    public synchronized void setChanged() {
        this.hasDataChanged = true;
    }

    @Override
    public synchronized boolean hasChanged() {
        return this.hasNodesChanged || this.hasDataChanged;
    }

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public void setStorageSize(int size) {
        this.storageSize = size;
    }

    @Override
    public synchronized boolean isKeepInMemory() {
        return this.keepCount > 0;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.table = null;
    }

    @Override
    public synchronized boolean keepInMemory(boolean keep) {
        if (!this.isInMemory) {
            return false;
        }
        if (keep) {
            ++this.keepCount;
        } else {
            --this.keepCount;
            if (this.keepCount < 0) {
                throw Error.runtimeError(401, "RowAVLDisk - keep count");
            }
        }
        return true;
    }

    @Override
    public synchronized boolean isInMemory() {
        return this.isInMemory;
    }

    @Override
    public synchronized void setInMemory(boolean in) {
        this.isInMemory = in;
        if (in) {
            return;
        }
        NodeAVL n = this.nPrimaryNode;
        while (n != null) {
            n.setInMemory(in);
            n = n.nNext;
        }
        RowAction action = this.rowAction;
        if (action != null) {
            action.memoryRow = null;
        }
    }

    void setNewNodes() {
        int indexcount = this.table.getIndexCount();
        NodeAVL n = this.nPrimaryNode = new NodeAVLDisk(this, 0);
        for (int i = 1; i < indexcount; ++i) {
            n = n.nNext = new NodeAVLDisk(this, i);
        }
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        int size = out.getSize(this) + this.table.getIndexCount() * 16;
        return size;
    }

    @Override
    public void write(RowOutputInterface out) {
        try {
            this.writeNodes(out);
            if (this.hasDataChanged) {
                out.writeData(this.rowData, this.table.colTypes);
                out.writeEnd();
                this.hasDataChanged = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(RowOutputInterface out, IntLookup lookup) {
        out.writeSize(this.storageSize);
        NodeAVL rownode = this.nPrimaryNode;
        while (rownode != null) {
            ((NodeAVLDisk)rownode).writeTranslate(out, lookup);
            rownode = rownode.nNext;
        }
        out.writeData(this.getData(), this.table.colTypes);
        out.writeEnd();
    }

    private void writeNodes(RowOutputInterface out) throws IOException {
        out.writeSize(this.storageSize);
        NodeAVL n = this.nPrimaryNode;
        while (n != null) {
            n.write(out);
            n = n.nNext;
        }
        this.hasNodesChanged = false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RowAVLDisk) {
            return ((RowAVLDisk)obj).position == this.position;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.position;
    }
}

