/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TableUtil;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

final class RangeVariable {
    static final RangeVariable[] emptyArray = new RangeVariable[0];
    final Table rangeTable;
    final HsqlNameManager.SimpleName tableAlias;
    private OrderedHashSet columnAliases;
    private HsqlNameManager.SimpleName[] columnAliasNames;
    private OrderedHashSet columnNames;
    OrderedHashSet namedJoinColumns;
    HashMap namedJoinColumnExpressions;
    Index rangeIndex;
    private final Object[] emptyData;
    final boolean[] columnsInGroupBy;
    boolean hasKeyedColumnInGroupBy;
    final boolean[] usedColumns;
    boolean[] updatedColumns;
    Expression indexCondition;
    Expression indexEndCondition;
    boolean isJoinIndex;
    Expression nonIndexJoinCondition;
    Expression nonIndexWhereCondition;
    boolean isLeftJoin;
    boolean isRightJoin;
    boolean isMultiFindFirst;
    private Expression[] findFirstExpressions;
    private int multiColumnCount;
    int level;
    int rangePosition;
    HashMappedList variables;
    boolean isVariable;

    RangeVariable(HashMappedList variables, boolean isVariable) {
        this.variables = variables;
        this.isVariable = isVariable;
        this.rangeTable = null;
        this.tableAlias = null;
        this.emptyData = null;
        this.columnsInGroupBy = null;
        this.usedColumns = null;
    }

    RangeVariable(Table table, HsqlNameManager.SimpleName alias, OrderedHashSet columnList, HsqlNameManager.SimpleName[] columnNameList, ParserDQL.CompileContext compileContext) {
        this.rangeTable = table;
        this.tableAlias = alias;
        this.columnAliases = columnList;
        this.columnAliasNames = columnNameList;
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.rangeIndex = this.rangeTable.getPrimaryIndex();
        compileContext.registerRangeVariable(this);
    }

    RangeVariable(Table table, int position) {
        this.rangeTable = table;
        this.tableAlias = null;
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.rangePosition = position;
    }

    RangeVariable(RangeVariable range) {
        this.rangeTable = range.rangeTable;
        this.tableAlias = null;
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.rangeIndex = this.rangeTable.getPrimaryIndex();
        this.rangePosition = range.rangePosition;
        this.level = range.level;
    }

    void setJoinType(boolean isLeft, boolean isRight) {
        this.isLeftJoin = isLeft;
        this.isRightJoin = isRight;
    }

    public void addNamedJoinColumns(OrderedHashSet columns) {
        this.namedJoinColumns = columns;
    }

    public void addColumn(int columnIndex) {
        this.usedColumns[columnIndex] = true;
    }

    void addNamedJoinColumnExpression(String name, Expression e) {
        if (this.namedJoinColumnExpressions == null) {
            this.namedJoinColumnExpressions = new HashMap();
        }
        this.namedJoinColumnExpressions.put(name, e);
    }

    ExpressionColumn getColumnExpression(String name) {
        return this.namedJoinColumnExpressions == null ? null : (ExpressionColumn)this.namedJoinColumnExpressions.get(name);
    }

    Table getTable() {
        return this.rangeTable;
    }

    public OrderedHashSet getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new OrderedHashSet();
            this.rangeTable.getColumnNames(this.usedColumns, this.columnNames);
        }
        return this.columnNames;
    }

    public OrderedHashSet getUniqueColumnNameSet() {
        OrderedHashSet set = new OrderedHashSet();
        if (this.columnAliases != null) {
            set.addAll(this.columnAliases);
            return set;
        }
        for (int i = 0; i < this.rangeTable.columnList.size(); ++i) {
            String name = this.rangeTable.getColumn((int)i).getName().name;
            boolean added = set.add(name);
            if (added) continue;
            throw Error.error(5578, name);
        }
        return set;
    }

    public int findColumn(String columnName) {
        if (this.namedJoinColumnExpressions != null && this.namedJoinColumnExpressions.containsKey(columnName)) {
            return -1;
        }
        if (this.variables != null) {
            return this.variables.getIndex(columnName);
        }
        if (this.columnAliases != null) {
            return this.columnAliases.getIndex(columnName);
        }
        return this.rangeTable.findColumn(columnName);
    }

    ColumnSchema getColumn(String columnName) {
        int index = this.findColumn(columnName);
        return index < 0 ? null : this.rangeTable.getColumn(index);
    }

    ColumnSchema getColumn(int i) {
        if (this.variables != null) {
            return (ColumnSchema)this.variables.get(i);
        }
        return this.rangeTable.getColumn(i);
    }

    String getColumnAlias(int i) {
        HsqlNameManager.SimpleName name = this.getColumnAliasName(i);
        return name.name;
    }

    public HsqlNameManager.SimpleName getColumnAliasName(int i) {
        if (this.columnAliases != null) {
            return this.columnAliasNames[i];
        }
        return this.rangeTable.getColumn(i).getName();
    }

    boolean hasColumnAlias() {
        return this.columnAliases != null;
    }

    boolean resolvesTableName(ExpressionColumn e) {
        if (e.tableName == null) {
            return true;
        }
        return e.schema == null ? (this.tableAlias == null ? e.tableName.equals(this.rangeTable.tableName.name) : e.tableName.equals(this.tableAlias.name)) : e.tableName.equals(this.rangeTable.tableName.name) && e.schema.equals(this.rangeTable.tableName.schema.name);
    }

    public boolean resolvesTableName(String name) {
        if (name == null) {
            return true;
        }
        return this.tableAlias == null ? name.equals(this.rangeTable.tableName.name) : name.equals(this.tableAlias.name);
    }

    boolean resolvesSchemaName(String name) {
        if (name == null) {
            return true;
        }
        if (this.tableAlias != null) {
            return false;
        }
        return name.equals(this.rangeTable.tableName.schema.name);
    }

    void addTableColumns(HsqlArrayList exprList) {
        if (this.namedJoinColumns != null) {
            int count = exprList.size();
            int position = 0;
            for (int i = 0; i < count; ++i) {
                Expression e = (Expression)exprList.get(i);
                String columnName = e.getColumnName();
                if (!this.namedJoinColumns.contains(columnName)) continue;
                if (position != i) {
                    exprList.remove(i);
                    exprList.add(position, e);
                }
                e = this.getColumnExpression(columnName);
                exprList.set(position, e);
                ++position;
            }
        }
        this.addTableColumns(exprList, exprList.size(), this.namedJoinColumns);
    }

    int addTableColumns(HsqlArrayList expList, int position, HashSet exclude) {
        Table table = this.getTable();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String columnName;
            ColumnSchema column = table.getColumn(i);
            String string = columnName = this.columnAliases == null ? column.getName().name : (String)this.columnAliases.get(i);
            if (exclude != null && exclude.contains(columnName)) continue;
            ExpressionColumn e = new ExpressionColumn(this, column, i);
            expList.add(position++, e);
        }
        return position;
    }

    void addTableColumns(Expression expression, HashSet exclude) {
        HsqlArrayList list = new HsqlArrayList();
        Table table = this.getTable();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String columnName;
            ColumnSchema column = table.getColumn(i);
            String string = columnName = this.columnAliases == null ? column.getName().name : (String)this.columnAliases.get(i);
            if (exclude != null && exclude.contains(columnName)) continue;
            ExpressionColumn e = new ExpressionColumn(this, column, i);
            list.add(e);
        }
        Expression[] nodes = new Expression[list.size()];
        list.toArray(nodes);
        expression.nodes = nodes;
    }

    void setForCheckConstraint() {
        this.rangeIndex = null;
    }

    void addIndexCondition(Expression e, Index index, boolean isJoin) {
        this.rangeIndex = index;
        this.isJoinIndex = isJoin;
        switch (e.getType()) {
            case 48: {
                this.indexCondition = e;
                break;
            }
            case 47: {
                this.indexEndCondition = e;
                break;
            }
            case 41: {
                this.indexEndCondition = this.indexCondition = e;
                break;
            }
            case 42: 
            case 43: {
                this.indexCondition = e;
                break;
            }
            case 44: 
            case 45: {
                this.indexEndCondition = e;
                break;
            }
            default: {
                Error.runtimeError(401, "RangeVariable");
            }
        }
    }

    void addJoinCondition(Expression e) {
        this.nonIndexJoinCondition = ExpressionLogical.andExpressions(this.nonIndexJoinCondition, e);
    }

    void addWhereCondition(Expression e) {
        this.nonIndexWhereCondition = ExpressionLogical.andExpressions(this.nonIndexWhereCondition, e);
    }

    void addCondition(Expression e, boolean isJoin) {
        if (isJoin) {
            this.addJoinCondition(e);
        } else {
            this.addWhereCondition(e);
        }
    }

    void addIndexCondition(Expression[] exprList, Index index, int colCount, boolean isJoin) {
        this.rangeIndex = index;
        this.isJoinIndex = isJoin;
        for (int i = 0; i < colCount; ++i) {
            Expression e = exprList[i];
            this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
        }
        if (colCount == 1) {
            this.indexCondition = exprList[0];
        } else {
            this.findFirstExpressions = exprList;
            this.isMultiFindFirst = true;
            this.multiColumnCount = colCount;
        }
    }

    boolean hasIndexCondition() {
        return this.isMultiFindFirst || this.indexCondition != null;
    }

    public String describe(Session session) {
        boolean fullScan;
        StringBuffer sb = new StringBuffer();
        Index index = this.rangeIndex;
        Index primaryIndex = this.rangeTable.getPrimaryIndex();
        int[] primaryKey = this.rangeTable.getPrimaryKey();
        boolean hidden = false;
        boolean bl = fullScan = this.indexCondition == null && this.indexEndCondition == null;
        if (index == null) {
            index = primaryIndex;
        }
        if (index == primaryIndex && primaryKey.length == 0) {
            hidden = true;
            fullScan = true;
        }
        sb.append(super.toString()).append('\n');
        sb.append("table=[").append(this.rangeTable.getName().name).append("]\n");
        if (this.tableAlias != null) {
            sb.append("alias=[").append(this.tableAlias.name).append("]\n");
        }
        sb.append("access=[").append(fullScan ? "FULL SCAN" : "INDEX PRED").append("]\n");
        sb.append("index=[");
        sb.append(index == null ? "NONE" : (index.getName() == null ? "UNNAMED" : index.getName().name));
        sb.append(hidden ? "[HIDDEN]]\n" : "]\n");
        String temp = "INNER";
        if (this.isLeftJoin) {
            temp = "LEFT OUTER";
            if (this.isRightJoin) {
                temp = "FULL";
            }
        } else if (this.isRightJoin) {
            temp = "RIGHT OUTER";
        }
        sb.append("joinType=[").append(temp).append("]\n");
        String string = temp = this.indexCondition == null ? "null" : this.indexCondition.describe(session);
        if (this.findFirstExpressions != null) {
            StringBuffer sbt = new StringBuffer();
            for (int i = 0; i < this.multiColumnCount; ++i) {
                sbt.append(this.findFirstExpressions[i].describe(session));
            }
            temp = sbt.toString();
        }
        sb.append("eStart=[").append(temp).append("]\n");
        temp = this.indexEndCondition == null ? "null" : this.indexEndCondition.describe(session);
        sb.append("eEnd=[").append(temp).append("]\n");
        temp = this.nonIndexJoinCondition == null ? "null" : this.nonIndexJoinCondition.describe(session);
        sb.append("eAnd=[").append(temp).append("]");
        return sb.toString();
    }

    public RangeIteratorMain getIterator(Session session) {
        RangeIteratorMain it = new RangeIteratorMain(session, this);
        session.sessionContext.setRangeIterator(it);
        return it;
    }

    public RangeIteratorMain getFullIterator(Session session, RangeIteratorMain mainIterator) {
        FullRangeIterator it = new FullRangeIterator(session, this, mainIterator);
        session.sessionContext.setRangeIterator(it);
        return it;
    }

    public static RangeIteratorMain getIterator(Session session, RangeVariable[] rangeVars) {
        if (rangeVars.length == 1) {
            return rangeVars[0].getIterator(session);
        }
        RangeIteratorMain[] iterators = new RangeIteratorMain[rangeVars.length];
        for (int i = 0; i < rangeVars.length; ++i) {
            iterators[i] = rangeVars[i].getIterator(session);
        }
        return new JoinedRangeIterator(iterators);
    }

    public static class JoinedRangeIterator
    extends RangeIteratorMain {
        RangeIteratorMain[] rangeIterators;
        int currentIndex = 0;

        public JoinedRangeIterator(RangeIteratorMain[] rangeIterators) {
            this.rangeIterators = rangeIterators;
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            while (this.currentIndex >= 0) {
                RangeIteratorMain it = this.rangeIterators[this.currentIndex];
                if (it.next()) {
                    if (this.currentIndex < this.rangeIterators.length - 1) {
                        ++this.currentIndex;
                        continue;
                    }
                    this.currentRow = this.rangeIterators[this.currentIndex].currentRow;
                    this.currentData = this.currentRow.getData();
                    return true;
                }
                it.reset();
                --this.currentIndex;
            }
            this.currentData = this.rangeIterators[this.rangeIterators.length - 1].rangeVar.emptyData;
            this.currentRow = null;
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
            return false;
        }

        @Override
        public void reset() {
        }
    }

    public static class FullRangeIterator
    extends RangeIteratorMain {
        public FullRangeIterator(Session session, RangeVariable rangeVar, RangeIteratorMain rangeIterator) {
            this.rangePosition = rangeVar.rangePosition;
            this.store = session.sessionData.getRowStore(rangeVar.rangeTable);
            this.session = session;
            this.rangeVar = rangeVar;
            this.isFullIterator = true;
            this.isBeforeFirst = true;
            this.lookupTable = rangeIterator.lookupTable;
            this.lookupStore = rangeIterator.lookupStore;
            this.it = rangeVar.rangeIndex.firstRow(session, this.store);
        }

        @Override
        protected void initialiseIterator() {
        }

        @Override
        protected boolean findNext() {
            boolean result;
            block1: {
                while (true) {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block1;
                    RowIterator lookupIterator = this.lookupTable.indexList[0].findFirstRow(this.session, this.lookupStore, ValuePool.getInt(this.currentRow.getPos()), 41);
                    result = !lookupIterator.hasNext();
                    lookupIterator.release();
                    if (!result) continue;
                    this.currentData = this.currentRow.getData();
                    if (this.rangeVar.nonIndexWhereCondition == null || this.rangeVar.nonIndexWhereCondition.testCondition(this.session)) break;
                }
                this.isBeforeFirst = false;
                return true;
            }
            result = false;
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            return result;
        }
    }

    public static class RangeIteratorMain
    extends RangeIteratorBase {
        boolean hasOuterRow;
        boolean isFullIterator;
        RangeVariable rangeVar;
        Table lookupTable;
        PersistentStore lookupStore;

        RangeIteratorMain() {
        }

        public RangeIteratorMain(Session session, RangeVariable rangeVar) {
            this.rangePosition = rangeVar.rangePosition;
            this.store = session.sessionData.getRowStore(rangeVar.rangeTable);
            this.session = session;
            this.rangeVar = rangeVar;
            this.currentData = rangeVar.emptyData;
            this.isBeforeFirst = true;
            if (rangeVar.isRightJoin) {
                this.lookupTable = TableUtil.newLookupTable(session.database);
                this.lookupStore = session.sessionData.getRowStore(this.lookupTable);
            }
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            if (this.isBeforeFirst) {
                this.isBeforeFirst = false;
                this.initialiseIterator();
            } else if (this.it == null) {
                return false;
            }
            return this.findNext();
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentData = this.rangeVar.emptyData;
            this.currentRow = null;
            this.hasOuterRow = false;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangeVar.rangePosition;
        }

        protected void initialiseIterator() {
            this.hasOuterRow = this.rangeVar.isLeftJoin;
            if (this.rangeVar.isMultiFindFirst) {
                this.getFirstRowMulti();
                if (!this.rangeVar.isJoinIndex) {
                    this.hasOuterRow = false;
                }
            } else if (this.rangeVar.indexCondition == null) {
                this.it = this.rangeVar.indexEndCondition == null || this.rangeVar.indexEndCondition.getType() == 47 ? this.rangeVar.rangeIndex.firstRow(this.session, this.store) : this.rangeVar.rangeIndex.findFirstRowNotNull(this.session, this.store);
            } else {
                if (this.rangeVar.indexCondition.getType() == 48) {
                    this.it = this.rangeVar.rangeIndex.findFirstRowNotNull(this.session, this.store);
                } else {
                    this.getFirstRow();
                }
                if (!this.rangeVar.isJoinIndex) {
                    this.hasOuterRow = false;
                }
            }
        }

        private void getFirstRow() {
            Object value = this.rangeVar.indexCondition.getRightNode().getValue(this.session);
            Type valueType = this.rangeVar.indexCondition.getRightNode().getDataType();
            Type targetType = this.rangeVar.indexCondition.getLeftNode().getDataType();
            int exprType = this.rangeVar.indexCondition.getType();
            int range = 0;
            if (targetType != valueType) {
                range = targetType.compareToTypeRange(value);
            }
            if (range == 0) {
                value = targetType.convertToType(this.session, value, valueType);
                this.it = this.rangeVar.rangeIndex.findFirstRow(this.session, this.store, value, exprType);
            } else if (range < 0) {
                switch (exprType) {
                    case 42: 
                    case 43: {
                        this.it = this.rangeVar.rangeIndex.findFirstRowNotNull(this.session, this.store);
                        break;
                    }
                    default: {
                        this.it = this.rangeVar.rangeIndex.emptyIterator();
                        break;
                    }
                }
            } else {
                switch (exprType) {
                    case 44: 
                    case 45: {
                        this.it = this.rangeVar.rangeIndex.findFirstRowNotNull(this.session, this.store);
                        break;
                    }
                    default: {
                        this.it = this.rangeVar.rangeIndex.emptyIterator();
                    }
                }
            }
        }

        private void getFirstRowMulti() {
            boolean convertible = true;
            Object[] currentJoinData = new Object[this.rangeVar.rangeIndex.getVisibleColumns()];
            for (int i = 0; i < this.rangeVar.multiColumnCount; ++i) {
                Object value;
                Type valueType = this.rangeVar.findFirstExpressions[i].getRightNode().getDataType();
                Type targetType = this.rangeVar.findFirstExpressions[i].getLeftNode().getDataType();
                if (targetType.compareToTypeRange(value = this.rangeVar.findFirstExpressions[i].getRightNode().getValue(this.session)) != 0) {
                    convertible = false;
                    break;
                }
                currentJoinData[i] = targetType.convertToType(this.session, value, valueType);
            }
            this.it = convertible ? this.rangeVar.rangeIndex.findFirstRow(this.session, this.store, currentJoinData, this.rangeVar.multiColumnCount) : this.rangeVar.rangeIndex.emptyIterator();
        }

        protected boolean findNext() {
            boolean result;
            block5: {
                result = false;
                while (true) {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block5;
                    this.currentData = this.currentRow.getData();
                    if (this.rangeVar.indexEndCondition != null && !this.rangeVar.indexEndCondition.testCondition(this.session)) {
                        if (!this.rangeVar.isJoinIndex) {
                            this.hasOuterRow = false;
                        }
                        break block5;
                    }
                    if (this.rangeVar.nonIndexJoinCondition != null && !this.rangeVar.nonIndexJoinCondition.testCondition(this.session)) continue;
                    if (this.rangeVar.nonIndexWhereCondition == null || this.rangeVar.nonIndexWhereCondition.testCondition(this.session)) break;
                    this.hasOuterRow = false;
                }
                this.addFoundRow();
                result = true;
            }
            if (result) {
                this.hasOuterRow = false;
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            if (this.hasOuterRow) {
                result = this.rangeVar.nonIndexWhereCondition == null || this.rangeVar.nonIndexWhereCondition.testCondition(this.session);
            }
            this.hasOuterRow = false;
            return result;
        }

        protected void addFoundRow() {
            if (this.rangeVar.isRightJoin) {
                try {
                    this.lookupTable.insertData(this.lookupStore, new Object[]{ValuePool.getInt(this.currentRow.getPos())});
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
    }

    public static class RangeIteratorBase
    implements RangeIterator {
        Session session;
        int rangePosition;
        RowIterator it;
        PersistentStore store;
        Object[] currentData;
        Row currentRow;
        boolean isBeforeFirst;

        RangeIteratorBase() {
        }

        public RangeIteratorBase(Session session, PersistentStore store, TableBase t, int position) {
            this.session = session;
            this.rangePosition = position;
            this.store = store;
            this.it = t.rowIterator(store);
            this.isBeforeFirst = true;
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            if (this.isBeforeFirst) {
                this.isBeforeFirst = false;
            } else if (this.it == null) {
                return false;
            }
            this.currentRow = this.it.getNextRow();
            if (this.currentRow == null) {
                return false;
            }
            this.currentData = this.currentRow.getData();
            return true;
        }

        @Override
        public Row getCurrentRow() {
            return this.currentRow;
        }

        @Override
        public Object[] getCurrent() {
            return this.currentData;
        }

        @Override
        public long getRowid() {
            return this.currentRow == null ? 0L : this.currentRow.getId();
        }

        @Override
        public Object getRowidObject() {
            return this.currentRow == null ? null : Long.valueOf(this.currentRow.getId());
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangePosition;
        }
    }
}

