/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAggregate;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class QuerySpecification
extends QueryExpression {
    private int resultRangePosition;
    public boolean isDistinctSelect;
    public boolean isAggregated;
    public boolean isGrouped;
    RangeVariable[] rangeVariables;
    private HsqlArrayList rangeVariableList;
    Expression queryCondition;
    Expression checkQueryCondition;
    private Expression havingCondition;
    Expression[] exprColumns;
    private HsqlArrayList exprColumnList;
    public int indexLimitVisible;
    private int indexLimitRowId;
    private int groupByColumnCount;
    private int havingColumnCount;
    private int indexStartHaving;
    public int indexStartOrderBy;
    private int indexStartAggregates;
    private int indexLimitExpressions;
    private int indexLimitData;
    public boolean isUniqueResultRows;
    private boolean simpleLimit;
    private boolean acceptsSequences;
    Type[] columnTypes;
    private ArrayListIdentity aggregateSet;
    private ArrayListIdentity resolvedSubqueryExpressions = null;
    private boolean[] aggregateCheck;
    private OrderedHashSet tempSet = new OrderedHashSet();
    int[] columnMap;
    private Table baseTable;
    private OrderedHashSet conditionTables;
    public Index groupIndex;

    QuerySpecification(Session session, Table table, ParserDQL.CompileContext compileContext) {
        this(compileContext);
        RangeVariable range = new RangeVariable(table, null, null, null, compileContext);
        range.addTableColumns(this.exprColumnList, 0, null);
        this.indexLimitVisible = this.exprColumnList.size();
        this.addRangeVariable(range);
        this.resolveReferences(session);
        this.resolveTypes(session);
        this.resolveTypes(session);
        this.sortAndSlice = SortAndSlice.noSort;
    }

    QuerySpecification(ParserDQL.CompileContext compileContext) {
        super(compileContext);
        this.compileContext = compileContext;
        this.resultRangePosition = compileContext.getNextRangeVarIndex();
        this.rangeVariableList = new HsqlArrayList();
        this.exprColumnList = new HsqlArrayList();
        this.sortAndSlice = SortAndSlice.noSort;
    }

    void addRangeVariable(RangeVariable rangeVar) {
        this.rangeVariableList.add(rangeVar);
    }

    private void finaliseRangeVariables() {
        if (this.rangeVariables == null || this.rangeVariables.length < this.rangeVariableList.size()) {
            this.rangeVariables = new RangeVariable[this.rangeVariableList.size()];
            this.rangeVariableList.toArray(this.rangeVariables);
        }
    }

    void addSelectColumnExpression(Expression e) {
        if (e.getType() == 25) {
            throw Error.error(5564);
        }
        this.exprColumnList.add(e);
        ++this.indexLimitVisible;
    }

    void addQueryCondition(Expression e) {
        this.queryCondition = e;
    }

    void addGroupByColumnExpression(Expression e) {
        if (e.getType() == 25) {
            throw Error.error(5564);
        }
        this.exprColumnList.add(e);
        this.isGrouped = true;
        ++this.groupByColumnCount;
    }

    void addHavingExpression(Expression e) {
        this.exprColumnList.add(e);
        this.havingCondition = e;
        this.havingColumnCount = 1;
        this.isGrouped = true;
    }

    @Override
    void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
    }

    @Override
    public void resolveReferences(Session session) {
        this.finaliseRangeVariables();
        this.resolveColumnReferencesForAsterisk();
        this.finaliseColumns();
        this.resolveColumnReferences();
        this.unionColumnTypes = new Type[this.indexLimitVisible];
        this.unionColumnMap = new int[this.indexLimitVisible];
        ArrayUtil.fillSequence(this.unionColumnMap);
    }

    private void resolveColumnReferences() {
        int i;
        if (this.isDistinctSelect || this.isGrouped) {
            this.acceptsSequences = false;
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            Expression e = this.rangeVariables[i].nonIndexJoinCondition;
            if (e == null) continue;
            this.resolveColumnReferencesAndAllocate(e, i + 1, false);
        }
        this.resolveColumnReferencesAndAllocate(this.queryCondition, this.rangeVariables.length, false);
        if (this.resolvedSubqueryExpressions != null) {
            this.resolvedSubqueryExpressions.setSize(0);
        }
        for (i = 0; i < this.indexLimitVisible; ++i) {
            this.resolveColumnReferencesAndAllocate(this.exprColumns[i], this.rangeVariables.length, this.acceptsSequences);
        }
        for (i = this.indexLimitVisible; i < this.indexStartHaving; ++i) {
            this.resolveColumnReferencesAndAllocate(this.exprColumns[i], this.rangeVariables.length, false);
        }
        for (i = this.indexStartHaving; i < this.indexStartOrderBy; ++i) {
            this.resolveColumnReferencesAndAllocate(this.exprColumns[i], this.rangeVariables.length, false);
        }
        this.resolveColumnRefernecesInOrderBy(this.sortAndSlice);
    }

    void resolveColumnRefernecesInOrderBy(SortAndSlice sortAndSlice) {
        int orderCount = sortAndSlice.getOrderLength();
        for (int i = 0; i < orderCount; ++i) {
            ExpressionOrderBy e = (ExpressionOrderBy)sortAndSlice.exprList.get(i);
            this.replaceColumnIndexInOrderBy(e);
            if (e.getLeftNode().queryTableColumnIndex != -1) continue;
            if (sortAndSlice.sortUnion && e.getLeftNode().getType() != 2) {
                throw Error.error(5576);
            }
            e.replaceAliasInOrderBy(this.exprColumns, this.indexLimitVisible);
            this.resolveColumnReferencesAndAllocate(e, this.rangeVariables.length, false);
        }
        sortAndSlice.prepare(this);
    }

    private boolean resolveColumnReferences(Expression e, int rangeCount, boolean withSequences) {
        if (e == null) {
            return true;
        }
        int oldSize = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        this.unresolvedExpressions = e.resolveColumnReferences(this.rangeVariables, rangeCount, this.unresolvedExpressions, withSequences);
        int newSize = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        return oldSize == newSize;
    }

    private void resolveColumnReferencesForAsterisk() {
        int pos = 0;
        while (pos < this.indexLimitVisible) {
            Expression e = (Expression)this.exprColumnList.get(pos);
            if (e.getType() == 97) {
                this.exprColumnList.remove(pos);
                String tablename = ((ExpressionColumn)e).getTableName();
                if (tablename == null) {
                    this.addAllJoinedColumns(e);
                } else {
                    int rangeIndex = e.findMatchingRangeVariableIndex(this.rangeVariables);
                    if (rangeIndex == -1) {
                        throw Error.error(5501, tablename);
                    }
                    RangeVariable range = this.rangeVariables[rangeIndex];
                    HashSet exclude = this.getAllNamedJoinColumns();
                    range.addTableColumns(e, exclude);
                }
                for (int i = 0; i < e.nodes.length; ++i) {
                    this.exprColumnList.add(pos, e.nodes[i]);
                    ++pos;
                }
                this.indexLimitVisible += e.nodes.length - 1;
                continue;
            }
            ++pos;
        }
    }

    private void resolveColumnReferencesAndAllocate(Expression expression, int count, boolean withSequences) {
        if (expression == null) {
            return;
        }
        HsqlList list = expression.resolveColumnReferences(this.rangeVariables, count, null, withSequences);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Expression e = (Expression)list.get(i);
                boolean resolved = e.isSelfAggregate() ? this.resolveColumnReferences(e.getLeftNode(), count, false) : this.resolveColumnReferences(e, count, withSequences);
                if (resolved) {
                    if (e.isSelfAggregate()) {
                        if (this.aggregateSet == null) {
                            this.aggregateSet = new ArrayListIdentity();
                        }
                        this.aggregateSet.add(e);
                        this.isAggregated = true;
                        expression.isAggregate = true;
                    }
                    if (this.resolvedSubqueryExpressions == null) {
                        this.resolvedSubqueryExpressions = new ArrayListIdentity();
                    }
                    this.resolvedSubqueryExpressions.add(e);
                    continue;
                }
                if (this.unresolvedExpressions == null) {
                    this.unresolvedExpressions = new ArrayListIdentity();
                }
                this.unresolvedExpressions.add(e);
            }
        }
    }

    private HashSet getAllNamedJoinColumns() {
        HashSet set = null;
        for (int i = 0; i < this.rangeVariableList.size(); ++i) {
            RangeVariable range = (RangeVariable)this.rangeVariableList.get(i);
            if (range.namedJoinColumns == null) continue;
            if (set == null) {
                set = new HashSet();
            }
            set.addAll(range.namedJoinColumns);
        }
        return set;
    }

    public Expression getEquiJoinExpressions(OrderedHashSet nameSet, RangeVariable rightRange, boolean fullList) {
        HashSet set = new HashSet();
        Expression result = null;
        OrderedHashSet joinColumnNames = new OrderedHashSet();
        for (int i = 0; i < this.rangeVariableList.size(); ++i) {
            RangeVariable range = (RangeVariable)this.rangeVariableList.get(i);
            HashMappedList columnList = range.rangeTable.columnList;
            for (int j = 0; j < columnList.size(); ++j) {
                boolean repeated;
                ColumnSchema column = (ColumnSchema)columnList.get(j);
                String name = range.getColumnAlias(j);
                boolean columnInList = nameSet.contains(name);
                boolean namedJoin = range.namedJoinColumns != null && range.namedJoinColumns.contains(name);
                boolean bl = repeated = !namedJoin && !set.add(name);
                if (repeated && (!fullList || columnInList)) {
                    throw Error.error(5578, name);
                }
                if (!columnInList) continue;
                joinColumnNames.add(name);
                int position = rightRange.rangeTable.getColumnIndex(name);
                ColumnSchema rightColumn = rightRange.rangeTable.getColumn(position);
                ExpressionLogical e = new ExpressionLogical(range, column, rightRange, rightColumn);
                result = ExpressionLogical.andExpressions(result, e);
                ExpressionColumn col = range.getColumnExpression(name);
                if (col == null) {
                    col = new ExpressionColumn(new Expression[]{e.getLeftNode(), e.getRightNode()}, name);
                    range.addNamedJoinColumnExpression(name, col);
                } else {
                    col.nodes = (Expression[])ArrayUtil.resizeArray(col.nodes, col.nodes.length + 1);
                    col.nodes[col.nodes.length - 1] = e.getRightNode();
                }
                rightRange.addNamedJoinColumnExpression(name, col);
            }
        }
        if (fullList && !joinColumnNames.containsAll(nameSet)) {
            throw Error.error(5501);
        }
        rightRange.addNamedJoinColumns(joinColumnNames);
        return result;
    }

    private void addAllJoinedColumns(Expression e) {
        HsqlArrayList list = new HsqlArrayList();
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].addTableColumns(list);
        }
        Expression[] nodes = new Expression[list.size()];
        list.toArray(nodes);
        e.nodes = nodes;
    }

    private void finaliseColumns() {
        int i;
        this.indexLimitRowId = this.indexLimitVisible;
        this.indexStartHaving = this.indexLimitRowId + this.groupByColumnCount;
        this.indexStartOrderBy = this.indexStartHaving + this.havingColumnCount;
        this.indexLimitData = this.indexLimitExpressions = (this.indexStartAggregates = this.indexStartOrderBy + this.sortAndSlice.getOrderLength());
        this.exprColumns = new Expression[this.indexLimitExpressions];
        this.exprColumnList.toArray(this.exprColumns);
        for (i = 0; i < this.indexLimitVisible; ++i) {
            this.exprColumns[i].queryTableColumnIndex = i;
        }
        if (this.sortAndSlice.hasOrder()) {
            for (i = 0; i < this.sortAndSlice.getOrderLength(); ++i) {
                this.exprColumns[this.indexStartOrderBy + i] = (Expression)this.sortAndSlice.exprList.get(i);
            }
        }
    }

    private void replaceColumnIndexInOrderBy(Expression orderBy) {
        int i;
        Expression e = orderBy.getLeftNode();
        if (e.getType() != 1) {
            return;
        }
        if (e.getDataType().typeCode == 4 && 0 < (i = ((Integer)e.getValue(null)).intValue()) && i <= this.indexLimitVisible) {
            orderBy.setLeftNode(this.exprColumns[i - 1]);
            return;
        }
        throw Error.error(5576);
    }

    void collectRangeVariables(RangeVariable[] rangeVars, Set set) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].collectRangeVariables(rangeVars, set);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectRangeVariables(rangeVars, set);
        }
        if (this.havingCondition != null) {
            this.havingCondition.collectRangeVariables(rangeVars, set);
        }
    }

    @Override
    public boolean hasReference(RangeVariable range) {
        if (this.unresolvedExpressions == null) {
            return false;
        }
        for (int i = 0; i < this.unresolvedExpressions.size(); ++i) {
            if (!((Expression)this.unresolvedExpressions.get(i)).hasReference(range)) continue;
            return true;
        }
        return false;
    }

    public void resolveExpressionTypes(Session session) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            Expression e = this.exprColumns[i];
            e.resolveTypes(session, null);
            if (e.getType() != 25) continue;
            throw Error.error(5564);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
            Expression e = this.rangeVariables[i].nonIndexJoinCondition;
            if (e == null) continue;
            e.resolveTypes(session, null);
            if (e.getDataType() == Type.SQL_BOOLEAN) continue;
            throw Error.error(5568);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes(session, null);
            if (this.queryCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.havingCondition != null) {
            this.havingCondition.resolveTypes(session, null);
            if (this.havingCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
    }

    private void resolveAggregates() {
        this.tempSet.clear();
        if (this.isAggregated) {
            this.aggregateCheck = new boolean[this.indexStartAggregates];
            this.tempSet.addAll(this.aggregateSet);
            this.indexLimitData = this.indexLimitExpressions = this.exprColumns.length + this.tempSet.size();
            this.exprColumns = (Expression[])ArrayUtil.resizeArray(this.exprColumns, this.indexLimitExpressions);
            int i = this.indexStartAggregates;
            int j = 0;
            while (i < this.indexLimitExpressions) {
                ExpressionAggregate e = (ExpressionAggregate)this.tempSet.get(j);
                this.exprColumns[i] = new ExpressionAggregate(e);
                this.exprColumns[i].dataType = e.dataType;
                ++i;
                ++j;
            }
            this.tempSet.clear();
        }
    }

    @Override
    public boolean areColumnsResolved() {
        return this.unresolvedExpressions == null || this.unresolvedExpressions.isEmpty();
    }

    private void setRangeVariableConditions() {
        RangeVariableResolver rangeResolver = new RangeVariableResolver(this.rangeVariables, this.queryCondition, this.compileContext);
        rangeResolver.processConditions();
        this.rangeVariables = rangeResolver.rangeVariables;
    }

    @Override
    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        ArrayUtil.copyArray(this.resultTable.colTypes, this.unionColumnTypes, this.unionColumnTypes.length);
        for (int i = 0; i < this.indexStartHaving; ++i) {
            if (this.exprColumns[i].dataType != null) continue;
            throw Error.error(5567);
        }
        this.isResolved = true;
    }

    @Override
    void resolveTypesPartOne(Session session) {
        this.resolveExpressionTypes(session);
        this.setRangeVariableConditions();
        this.resolveAggregates();
        for (int i = 0; i < this.unionColumnMap.length; ++i) {
            this.unionColumnTypes[i] = Type.getAggregateType(this.unionColumnTypes[i], this.exprColumns[i].getDataType());
        }
    }

    @Override
    void resolveTypesPartTwo(Session session) {
        int i;
        this.resolveGroups();
        for (i = 0; i < this.unionColumnMap.length; ++i) {
            Type type = this.unionColumnTypes[this.unionColumnMap[i]];
            if (type == null) {
                throw Error.error(5567);
            }
            this.exprColumns[this.unionColumnMap[i]].setDataType(session, type);
        }
        for (i = 0; i < this.indexStartHaving; ++i) {
            if (this.exprColumns[i].dataType != null) continue;
            throw Error.error(5567);
        }
        this.setReferenceableColumns();
        this.setUpdatability();
        this.createResultMetaData();
        this.createTable(session);
        if (this.isUpdatable) {
            this.getMergedSelect();
        }
    }

    private void resolveGroups() {
        Expression e;
        int i;
        ExpressionColumn c;
        Expression e2;
        int i2;
        Expression e3;
        int i3;
        int orderCount;
        int i4;
        this.tempSet.clear();
        if (this.isGrouped) {
            for (i4 = this.indexLimitVisible; i4 < this.indexLimitVisible + this.groupByColumnCount; ++i4) {
                Expression.collectAllExpressions(this.tempSet, this.exprColumns[i4], Expression.aggregateFunctionSet, Expression.subqueryExpressionSet);
                if (this.tempSet.isEmpty()) continue;
                throw Error.error(5572, ((Expression)this.tempSet.get(0)).getSQL());
            }
            for (i4 = 0; i4 < this.indexLimitVisible; ++i4) {
                if (this.exprColumns[i4].isComposedOf(this.exprColumns, this.indexLimitVisible, this.indexLimitVisible + this.groupByColumnCount, Expression.subqueryAggregateExpressionSet)) continue;
                this.tempSet.add(this.exprColumns[i4]);
            }
            if (!this.tempSet.isEmpty() && !this.resolveForGroupBy(this.tempSet)) {
                throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
            }
        } else if (this.isAggregated) {
            for (i4 = 0; i4 < this.indexLimitVisible; ++i4) {
                Expression.collectAllExpressions(this.tempSet, this.exprColumns[i4], Expression.columnExpressionSet, Expression.aggregateFunctionSet);
                if (this.tempSet.isEmpty()) continue;
                throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
            }
        }
        this.tempSet.clear();
        if (this.havingCondition != null) {
            if (this.unresolvedExpressions != null) {
                this.tempSet.addAll(this.unresolvedExpressions);
            }
            for (i4 = this.indexLimitVisible; i4 < this.indexLimitVisible + this.groupByColumnCount; ++i4) {
                this.tempSet.add(this.exprColumns[i4]);
            }
            if (!this.havingCondition.isComposedOf(this.tempSet, Expression.subqueryAggregateExpressionSet)) {
                throw Error.error(5573);
            }
            this.tempSet.clear();
        }
        if (this.isDistinctSelect) {
            orderCount = this.sortAndSlice.getOrderLength();
            for (i3 = 0; i3 < orderCount; ++i3) {
                e3 = (Expression)this.sortAndSlice.exprList.get(i3);
                if (e3.queryTableColumnIndex != -1 || e3.isComposedOf(this.exprColumns, 0, this.indexLimitVisible, Expression.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (this.isGrouped) {
            orderCount = this.sortAndSlice.getOrderLength();
            for (i3 = 0; i3 < orderCount; ++i3) {
                e3 = (Expression)this.sortAndSlice.exprList.get(i3);
                if (e3.queryTableColumnIndex != -1 || e3.isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, Expression.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        boolean bl = this.simpleLimit = !this.isDistinctSelect && !this.isGrouped && !this.sortAndSlice.hasOrder();
        if (!this.isAggregated) {
            return;
        }
        OrderedHashSet expressions = new OrderedHashSet();
        OrderedHashSet columnExpressions = new OrderedHashSet();
        for (i2 = this.indexStartAggregates; i2 < this.indexLimitExpressions; ++i2) {
            e2 = this.exprColumns[i2];
            c = new ExpressionColumn(e2, i2, this.resultRangePosition);
            expressions.add(e2);
            columnExpressions.add(c);
        }
        for (i2 = 0; i2 < this.indexStartHaving; ++i2) {
            if (this.exprColumns[i2].isAggregate || !expressions.add(e2 = this.exprColumns[i2])) continue;
            c = new ExpressionColumn(e2, i2, this.resultRangePosition);
            columnExpressions.add(c);
        }
        int orderCount2 = this.sortAndSlice.getOrderLength();
        for (i = 0; i < orderCount2; ++i) {
            e = (Expression)this.sortAndSlice.exprList.get(i);
            if (!e.getLeftNode().isAggregate) continue;
            e.isAggregate = true;
        }
        for (i = this.indexStartOrderBy; i < this.indexStartAggregates; ++i) {
            if (!this.exprColumns[i].getLeftNode().isAggregate) continue;
            this.exprColumns[i].isAggregate = true;
        }
        for (i = 0; i < this.indexStartAggregates; ++i) {
            e = this.exprColumns[i];
            if (!e.isAggregate) continue;
            this.aggregateCheck[i] = true;
            e.convertToSimpleColumn(expressions, columnExpressions);
        }
        for (i = 0; i < this.aggregateSet.size(); ++i) {
            e = (Expression)this.aggregateSet.get(i);
            e.convertToSimpleColumn(expressions, columnExpressions);
        }
        if (this.resolvedSubqueryExpressions != null) {
            for (i = 0; i < this.resolvedSubqueryExpressions.size(); ++i) {
                e = (Expression)this.resolvedSubqueryExpressions.get(i);
                e.convertToSimpleColumn(expressions, columnExpressions);
            }
        }
    }

    boolean resolveForGroupBy(HsqlList unresolvedSet) {
        int i;
        for (i = this.indexLimitVisible; i < this.indexLimitVisible + this.groupByColumnCount; ++i) {
            Expression e = this.exprColumns[i];
            if (e.getType() != 2) continue;
            RangeVariable range = e.getRangeVariable();
            int colIndex = e.getColumnIndex();
            range.columnsInGroupBy[colIndex] = true;
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable range = this.rangeVariables[i];
            range.hasKeyedColumnInGroupBy = range.rangeTable.getUniqueNotNullColumnGroup(range.columnsInGroupBy) != null;
        }
        OrderedHashSet set = null;
        for (int i2 = 0; i2 < unresolvedSet.size(); ++i2) {
            Expression e = (Expression)unresolvedSet.get(i2);
            set = e.getUnkeyedColumns(set);
        }
        return set == null;
    }

    private int getLimitStart(Session session) {
        if (this.sortAndSlice.limitCondition != null) {
            Integer limit = (Integer)this.sortAndSlice.limitCondition.getLeftNode().getValue(session);
            if (limit == null || limit < 0) {
                throw Error.error(3453);
            }
            return limit;
        }
        return 0;
    }

    private int getLimitCount(Session session, int rowCount) {
        int limitCount = Integer.MAX_VALUE;
        if (this.sortAndSlice.limitCondition != null) {
            Integer limit = (Integer)this.sortAndSlice.limitCondition.getRightNode().getValue(session);
            if (limit == null || limit <= 0) {
                throw Error.error(3452);
            }
            limitCount = limit;
        }
        if (rowCount != 0 && rowCount < limitCount) {
            limitCount = rowCount;
        }
        return limitCount;
    }

    private int getMaxRowCount(Session session, int rowCount) {
        int limitStart = this.getLimitStart(session);
        int limitCount = this.getLimitCount(session, rowCount);
        if (this.simpleLimit) {
            if (rowCount == 0) {
                rowCount = limitCount;
            }
            rowCount = rowCount == 0 || rowCount > Integer.MAX_VALUE - limitStart ? Integer.MAX_VALUE : (rowCount += limitStart);
        } else {
            rowCount = Integer.MAX_VALUE;
        }
        return rowCount;
    }

    @Override
    Result getResult(Session session, int maxrows) {
        Result r = this.getSingleResult(session, maxrows);
        r.getNavigator().reset();
        return r;
    }

    private Result getSingleResult(Session session, int rowCount) {
        int maxRows = this.getMaxRowCount(session, rowCount);
        Result r = this.buildResult(session, maxRows);
        RowSetNavigatorData navigator = (RowSetNavigatorData)r.getNavigator();
        if (this.isDistinctSelect) {
            navigator.removeDuplicates();
        }
        navigator.sortOrder();
        navigator.trim(this.getLimitStart(session), this.getLimitCount(session, rowCount));
        return r;
    }

    private Result buildResult(Session session, int limitcount) {
        RowSetNavigatorData navigator = new RowSetNavigatorData(session, this);
        Result result = Result.newResult(navigator);
        result.metaData = this.resultMetaData;
        result.setDataResultConcurrency(this.isUpdatable);
        int fullJoinIndex = 0;
        RangeIterator[] rangeIterators = new RangeIterator[this.rangeVariables.length];
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            rangeIterators[i] = this.rangeVariables[i].getIterator(session);
        }
        int currentIndex = 0;
        while (true) {
            int i;
            RangeIterator it;
            if (currentIndex < fullJoinIndex) {
                boolean end = true;
                for (int i2 = fullJoinIndex + 1; i2 < this.rangeVariables.length; ++i2) {
                    if (!this.rangeVariables[i2].isRightJoin) continue;
                    rangeIterators[i2] = this.rangeVariables[i2].getFullIterator(session, (RangeVariable.RangeIteratorMain)rangeIterators[i2]);
                    fullJoinIndex = i2;
                    currentIndex = i2;
                    end = false;
                    break;
                }
                if (end) break;
            }
            if ((it = rangeIterators[currentIndex]).next()) {
                if (currentIndex < this.rangeVariables.length - 1) {
                    ++currentIndex;
                    continue;
                }
            } else {
                it.reset();
                --currentIndex;
                continue;
            }
            session.sessionData.startRowProcessing();
            Object[] data = new Object[this.indexLimitData];
            for (i = 0; i < this.indexStartAggregates; ++i) {
                if (this.isAggregated && this.aggregateCheck[i]) continue;
                data[i] = this.exprColumns[i].getValue(session);
            }
            for (i = this.indexLimitVisible; i < this.indexLimitRowId; ++i) {
                data[i] = it.getRowidObject();
            }
            Object[] groupData = null;
            if ((this.isAggregated || this.isGrouped) && (groupData = navigator.getGroupData(data)) != null) {
                data = groupData;
            }
            for (int i3 = this.indexStartAggregates; i3 < this.indexLimitExpressions; ++i3) {
                data[i3] = ((ExpressionAggregate)this.exprColumns[i3]).updateAggregatingValue(session, data[i3]);
            }
            if (groupData == null) {
                navigator.add(data);
            }
            if (!this.isAggregated && !this.isGrouped && navigator.getSize() >= limitcount) break;
        }
        navigator.reset();
        if (!this.isGrouped && !this.isAggregated) {
            return result;
        }
        if (this.isAggregated) {
            if (!this.isGrouped && navigator.getSize() == 0) {
                Object[] data = new Object[this.exprColumns.length];
                navigator.add(data);
            }
            RangeVariable.RangeIteratorBase it = new RangeVariable.RangeIteratorBase(session, navigator.store, navigator.table, this.resultRangePosition);
            session.sessionContext.setRangeIterator(it);
            while (it.next()) {
                int i;
                for (i = this.indexStartAggregates; i < this.indexLimitExpressions; ++i) {
                    ExpressionAggregate aggregate = (ExpressionAggregate)this.exprColumns[i];
                    it.currentData[i] = aggregate.getAggregatedValue(session, it.currentData[i]);
                }
                for (i = 0; i < this.indexStartAggregates; ++i) {
                    if (!this.aggregateCheck[i]) continue;
                    it.currentData[i] = this.exprColumns[i].getValue(session);
                }
            }
        }
        navigator.reset();
        if (this.havingCondition != null) {
            while (navigator.hasNext()) {
                Object[] data = navigator.getNext();
                if (Boolean.TRUE.equals(data[this.indexLimitVisible + this.groupByColumnCount])) continue;
                navigator.remove();
            }
            navigator.reset();
        }
        return result;
    }

    void setReferenceableColumns() {
        this.accessibleColumns = new boolean[this.indexLimitVisible];
        IntValueHashMap aliases = new IntValueHashMap();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression expression = this.exprColumns[i];
            String alias = expression.getAlias();
            if (alias.length() == 0) {
                HsqlNameManager.HsqlName name = HsqlNameManager.getAutoColumnName(i);
                expression.setAlias(name);
                continue;
            }
            int index = aliases.get((Object)alias, -1);
            if (index == -1) {
                aliases.put(alias, i);
                this.accessibleColumns[i] = true;
                continue;
            }
            this.accessibleColumns[index] = false;
        }
    }

    private void createResultMetaData() {
        Expression e;
        int i;
        this.columnTypes = new Type[this.indexLimitData];
        for (i = 0; i < this.indexStartAggregates; ++i) {
            e = this.exprColumns[i];
            this.columnTypes[i] = e.getDataType();
        }
        for (i = this.indexLimitVisible; i < this.indexLimitRowId; ++i) {
            this.columnTypes[i] = Type.SQL_BIGINT;
        }
        for (i = this.indexLimitRowId; i < this.indexLimitData; ++i) {
            e = this.exprColumns[i];
            this.columnTypes[i] = e.getDataType();
        }
        this.resultMetaData = ResultMetaData.newResultMetaData(this.columnTypes, this.columnMap, this.indexLimitVisible, this.indexLimitRowId);
        for (i = 0; i < this.indexLimitVisible; ++i) {
            e = this.exprColumns[i];
            this.resultMetaData.columnTypes[i] = e.getDataType();
            if (i >= this.indexLimitVisible) continue;
            ColumnBase column = e.getColumn();
            if (column != null) {
                this.resultMetaData.columns[i] = column;
                this.resultMetaData.columnLabels[i] = e.getAlias();
                continue;
            }
            column = new ColumnBase();
            column.setType(e.getDataType());
            this.resultMetaData.columns[i] = column;
            this.resultMetaData.columnLabels[i] = e.getAlias();
        }
    }

    @Override
    void createTable(Session session) {
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder()) {
            this.orderIndex = this.resultTable.createAndAddIndexStructure(null, this.sortAndSlice.sortOrder, this.sortAndSlice.sortDescending, this.sortAndSlice.sortNullsLast, false, false, false);
        }
        if (this.isDistinctSelect || this.isFullOrder) {
            int[] fullCols = new int[this.indexLimitVisible];
            ArrayUtil.fillSequence(fullCols);
            this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(null, fullCols, null, null, false, false, false);
        }
        if (this.isGrouped) {
            int[] groupCols = new int[this.groupByColumnCount];
            for (int i = 0; i < this.groupByColumnCount; ++i) {
                groupCols[i] = this.indexLimitVisible + i;
            }
            this.groupIndex = this.resultTable.createAndAddIndexStructure(null, groupCols, null, null, false, false, false);
        } else if (this.isAggregated) {
            this.groupIndex = this.mainIndex;
        }
    }

    @Override
    void createResultTable(Session session) {
        HsqlNameManager.HsqlName tableName = session.database.nameManager.getSubqueryTableName();
        int tableType = this.persistenceScope == 11 ? 1 : 8;
        HashMappedList columnList = new HashMappedList();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression e = this.exprColumns[i];
            HsqlNameManager.SimpleName simpleName = e.getSimpleName();
            String nameString = simpleName.name;
            HsqlNameManager.HsqlName name = session.database.nameManager.newColumnSchemaHsqlName(tableName, simpleName);
            if (!this.accessibleColumns[i]) {
                nameString = HsqlNameManager.getAutoNoNameColumnString(i);
            }
            ColumnSchema column = new ColumnSchema(name, e.dataType, true, false, null);
            columnList.add(nameString, column);
        }
        try {
            this.resultTable = new TableDerived(session.database, tableName, tableType, this.columnTypes, columnList, null);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getSQL() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(' ');
        int limit = this.indexLimitVisible;
        for (i = 0; i < limit; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.exprColumns[i].getSQL());
        }
        sb.append("FROM");
        limit = this.rangeVariables.length;
        for (i = 0; i < limit; ++i) {
            RangeVariable rangeVar = this.rangeVariables[i];
            if (i > 0) {
                if (rangeVar.isLeftJoin && rangeVar.isRightJoin) {
                    sb.append("FULL").append(' ');
                } else if (rangeVar.isLeftJoin) {
                    sb.append("LEFT").append(' ');
                } else if (rangeVar.isRightJoin) {
                    sb.append("RIGHT").append(' ');
                }
                sb.append("JOIN").append(' ');
            }
            sb.append(rangeVar.getTable().getName().statementName);
        }
        if (this.isGrouped) {
            sb.append(' ').append("GROUP").append(' ').append("BY");
            limit = this.indexLimitVisible + this.groupByColumnCount;
            for (i = this.indexLimitVisible; i < limit; ++i) {
                sb.append(this.exprColumns[i].getSQL());
                if (i >= limit - 1) continue;
                sb.append(',');
            }
        }
        if (this.havingCondition != null) {
            sb.append(' ').append("HAVING").append(' ');
            sb.append(this.havingCondition.getSQL());
        }
        if (this.sortAndSlice.hasOrder()) {
            limit = this.indexStartOrderBy + this.sortAndSlice.getOrderLength();
            sb.append(' ').append("ORDER").append("BY").append(' ');
            for (i = this.indexStartOrderBy; i < limit; ++i) {
                sb.append(this.exprColumns[i].getSQL());
                if (i >= limit - 1) continue;
                sb.append(',');
            }
        }
        if (this.sortAndSlice.hasLimit()) {
            sb.append(this.sortAndSlice.limitCondition.getLeftNode().getSQL());
        }
        return sb.toString();
    }

    @Override
    public ResultMetaData getMetaData() {
        return this.resultMetaData;
    }

    @Override
    public String describe(Session session) {
        int index;
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append("[\n");
        if (this.sortAndSlice.limitCondition != null) {
            sb.append("offset=[").append(this.sortAndSlice.limitCondition.getLeftNode().describe(session)).append("]\n");
            sb.append("limit=[").append(this.sortAndSlice.limitCondition.getRightNode().describe(session)).append("]\n");
        }
        sb.append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        sb.append("isGrouped=[").append(this.isGrouped).append("]\n");
        sb.append("isAggregated=[").append(this.isAggregated).append("]\n");
        sb.append("columns=[");
        for (i = 0; i < this.indexLimitVisible; ++i) {
            index = i;
            if (this.exprColumns[i].getType() == 5) {
                index = this.exprColumns[i].columnIndex;
            }
            sb.append(this.exprColumns[index].describe(session));
        }
        sb.append("\n]\n");
        sb.append("range variables=[\n");
        for (i = 0; i < this.rangeVariables.length; ++i) {
            sb.append("[\n");
            sb.append(this.rangeVariables[i].describe(session));
            sb.append("\n]");
        }
        sb.append("]\n");
        String temp = this.queryCondition == null ? "null" : this.queryCondition.describe(session);
        sb.append("queryCondition=[").append(temp).append("]\n");
        sb.append("groupColumns=[");
        for (i = this.indexLimitRowId; i < this.indexLimitRowId + this.groupByColumnCount; ++i) {
            index = i;
            if (this.exprColumns[i].getType() == 5) {
                index = this.exprColumns[i].columnIndex;
            }
            sb.append(this.exprColumns[index].describe(session));
        }
        sb.append("]\n");
        temp = this.havingCondition == null ? "null" : this.havingCondition.describe(session);
        sb.append("havingCondition=[").append(temp).append("]\n");
        return sb.toString();
    }

    void setUpdatability() {
        String name;
        Expression expression;
        int i;
        if (this.isAggregated || this.isGrouped || this.isDistinctSelect || !this.isTopLevel) {
            return;
        }
        if (this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder()) {
            return;
        }
        if (this.rangeVariables.length != 1) {
            return;
        }
        RangeVariable rangeVar = this.rangeVariables[0];
        Table table = rangeVar.getTable();
        Table baseTable = table.getBaseTable();
        this.isInsertable = table.isInsertable();
        this.isUpdatable = table.isUpdatable();
        if (!this.isInsertable && !this.isUpdatable) {
            return;
        }
        IntValueHashMap columns = new IntValueHashMap();
        int[] baseColumnMap = table.getBaseTableColumnMap();
        int[] columnMap = new int[this.indexLimitVisible];
        for (i = 0; i < this.indexLimitVisible; ++i) {
            expression = this.exprColumns[i];
            if (expression.getType() != 2) continue;
            name = expression.getColumn().getName().name;
            if (columns.containsKey(name)) {
                columns.put(name, 1);
                continue;
            }
            columns.put(name, 0);
        }
        this.isUpdatable = false;
        for (i = 0; i < this.indexLimitVisible; ++i) {
            if (this.accessibleColumns[i] && (expression = this.exprColumns[i]).getType() == 2 && columns.get(name = expression.getColumn().getName().name) == 0) {
                int index = table.findColumn(name);
                columnMap[i] = baseColumnMap[index];
                if (columnMap[i] == -1) continue;
                this.isUpdatable = true;
                continue;
            }
            columnMap[i] = -1;
            this.isInsertable = false;
        }
        if (this.isInsertable) {
            boolean[] checkList = baseTable.getColumnCheckList(columnMap);
            for (i = 0; i < checkList.length; ++i) {
                ColumnSchema column;
                if (checkList[i] || (column = baseTable.getColumn(i)).isIdentity() || column.isGenerated() || column.hasDefault() || column.isNullable()) continue;
                this.isInsertable = false;
                break;
            }
        }
        if (!this.isUpdatable) {
            this.isInsertable = false;
        }
        if (this.isUpdatable) {
            this.columnMap = columnMap;
            this.baseTable = baseTable;
            if (this.persistenceScope == 11) {
                return;
            }
            ++this.indexLimitRowId;
            this.indexLimitData = this.indexLimitRowId;
        }
    }

    @Override
    public Table getBaseTable() {
        return this.baseTable;
    }

    @Override
    public void collectAllExpressions(HsqlList set, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            Expression.collectAllExpressions(set, this.exprColumns[i], typeSet, stopAtTypeSet);
        }
        Expression.collectAllExpressions(set, this.queryCondition, typeSet, stopAtTypeSet);
        Expression.collectAllExpressions(set, this.havingCondition, typeSet, stopAtTypeSet);
    }

    @Override
    public void collectObjectNames(Set set) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].collectObjectNames(set);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectObjectNames(set);
        }
        if (this.havingCondition != null) {
            this.havingCondition.collectObjectNames(set);
        }
    }

    void getMergedSelect() {
        RangeVariable rangeVar = this.rangeVariables[0];
        Table table = rangeVar.getTable();
        Expression localQueryCondition = this.queryCondition;
        Expression baseQueryCondition = null;
        if (table instanceof TableDerived) {
            QuerySpecification baseSelect = ((TableDerived)table).queryExpression.getMainSelect();
            RangeVariable baseRangeVariable = baseSelect.rangeVariables[0];
            this.rangeVariables = new RangeVariable[1];
            this.rangeVariables[0] = new RangeVariable(baseRangeVariable);
            Expression[] newExprColumns = new Expression[this.indexLimitRowId];
            for (int i = 0; i < this.indexLimitVisible; ++i) {
                Expression e = this.exprColumns[i];
                newExprColumns[i] = e.replaceColumnReferences(rangeVar, baseSelect.exprColumns);
            }
            this.exprColumns = newExprColumns;
            if (localQueryCondition != null) {
                localQueryCondition = localQueryCondition.replaceColumnReferences(rangeVar, baseSelect.exprColumns);
            }
            baseQueryCondition = baseSelect.queryCondition;
            this.checkQueryCondition = baseSelect.checkQueryCondition;
        }
        this.queryCondition = ExpressionLogical.andExpressions(baseQueryCondition, localQueryCondition);
        if (this.queryCondition != null) {
            this.tempSet.clear();
            Expression.collectAllExpressions(this.tempSet, this.queryCondition, Expression.subqueryExpressionSet, Expression.emptyExpressionSet);
            int size = this.tempSet.size();
            for (int i = 0; i < size; ++i) {
                Expression e = (Expression)this.tempSet.get(i);
                e.collectObjectNames(this.tempSet);
            }
            if (this.tempSet.contains(this.baseTable.getName())) {
                this.isUpdatable = false;
                this.isInsertable = false;
            }
        }
        if (this.view != null) {
            switch (this.view.getCheckOption()) {
                case 1: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = localQueryCondition;
                    break;
                }
                case 2: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = this.queryCondition;
                }
            }
        }
        this.setRangeVariableConditions();
    }

    @Override
    public void setAsTopLevel() {
        this.setReturningResultSet();
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    @Override
    void setReturningResultSet() {
        this.persistenceScope = 13;
        this.columnMode = 15;
    }

    @Override
    public boolean isSingleColumn() {
        return this.indexLimitVisible == 1;
    }

    @Override
    public String[] getColumnNames() {
        String[] names = new String[this.indexLimitVisible];
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            names[i] = this.exprColumns[i].getAlias();
        }
        return names;
    }

    @Override
    public Type[] getColumnTypes() {
        if (this.columnTypes.length == this.indexLimitVisible) {
            return this.columnTypes;
        }
        Type[] types = new Type[this.indexLimitVisible];
        ArrayUtil.copyArray(this.columnTypes, types, types.length);
        return types;
    }

    @Override
    public int getColumnCount() {
        return this.indexLimitVisible;
    }

    @Override
    public int[] getBaseTableColumnMap() {
        return this.columnMap;
    }

    @Override
    public Expression getCheckCondition() {
        return this.queryCondition;
    }

    @Override
    void getBaseTableNames(OrderedHashSet set) {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            Table rangeTable = this.rangeVariables[i].rangeTable;
            HsqlNameManager.HsqlName name = rangeTable.getName();
            if (rangeTable.isReadOnly() || rangeTable.isTemp() || name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            set.add(name);
        }
    }
}

