/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TableDerived;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class QueryExpression {
    public static final int NOUNION = 0;
    public static final int UNION = 1;
    public static final int UNION_ALL = 2;
    public static final int INTERSECT = 3;
    public static final int INTERSECT_ALL = 4;
    public static final int EXCEPT_ALL = 5;
    public static final int EXCEPT = 6;
    public static final int UNION_TERM = 7;
    int columnCount;
    private QueryExpression leftQueryExpression;
    private QueryExpression rightQueryExpression;
    SortAndSlice sortAndSlice;
    private int unionType;
    private boolean unionCorresponding;
    private OrderedHashSet unionCorrespondingColumns;
    int[] unionColumnMap;
    Type[] unionColumnTypes;
    boolean isFullOrder;
    HsqlList unresolvedExpressions;
    boolean isResolved;
    int persistenceScope = 11;
    int columnMode = 16;
    ResultMetaData resultMetaData;
    boolean[] accessibleColumns;
    View view;
    boolean isUpdatable;
    boolean isInsertable;
    boolean isCheckable;
    boolean isTopLevel;
    public TableBase resultTable;
    public Index mainIndex;
    public Index fullIndex;
    public Index orderIndex;
    ParserDQL.CompileContext compileContext;

    QueryExpression(ParserDQL.CompileContext compileContext) {
        this.compileContext = compileContext;
        this.sortAndSlice = SortAndSlice.noSort;
    }

    public QueryExpression(ParserDQL.CompileContext compileContext, QueryExpression leftQueryExpression) {
        this(compileContext);
        this.sortAndSlice = SortAndSlice.noSort;
        this.leftQueryExpression = leftQueryExpression;
    }

    void addUnion(QueryExpression queryExpression, int unionType) {
        this.sortAndSlice = SortAndSlice.noSort;
        this.rightQueryExpression = queryExpression;
        this.unionType = unionType;
        this.setFullOrder();
    }

    void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
        sortAndSlice.sortUnion = true;
    }

    public void setUnionCorresoponding() {
        this.unionCorresponding = true;
    }

    public void setUnionCorrespondingColumns(OrderedHashSet names) {
        this.unionCorrespondingColumns = names;
    }

    public void setFullOrder() {
        this.isFullOrder = true;
        if (this.leftQueryExpression == null) {
            return;
        }
        this.leftQueryExpression.setFullOrder();
        this.rightQueryExpression.setFullOrder();
    }

    public void resolve(Session session) {
        this.resolveReferences(session);
        ExpressionColumn.checkColumnsResolved(this.unresolvedExpressions);
        this.resolveTypes(session);
    }

    public void resolve(Session session, RangeVariable[] outerRanges, Type[] targetTypes) {
        this.resolveReferences(session);
        if (this.unresolvedExpressions != null) {
            for (int i = 0; i < this.unresolvedExpressions.size(); ++i) {
                Expression e = (Expression)this.unresolvedExpressions.get(i);
                HsqlList list = e.resolveColumnReferences(outerRanges, null);
                ExpressionColumn.checkColumnsResolved(list);
            }
        }
        this.unionColumnTypes = targetTypes;
        this.resolveTypes(session);
    }

    public void resolveReferences(Session session) {
        this.leftQueryExpression.resolveReferences(session);
        this.rightQueryExpression.resolveReferences(session);
        this.addUnresolvedExpressions(this.leftQueryExpression.unresolvedExpressions);
        this.addUnresolvedExpressions(this.rightQueryExpression.unresolvedExpressions);
        if (!this.unionCorresponding) {
            this.columnCount = this.leftQueryExpression.getColumnCount();
            int rightCount = this.rightQueryExpression.getColumnCount();
            if (this.columnCount != rightCount) {
                throw Error.error(5594);
            }
            this.unionColumnTypes = new Type[this.columnCount];
            this.leftQueryExpression.unionColumnMap = this.rightQueryExpression.unionColumnMap = new int[this.columnCount];
            ArrayUtil.fillSequence(this.leftQueryExpression.unionColumnMap);
            this.resolveColumnRefernecesInUnionOrderBy();
            return;
        }
        Object[] leftNames = this.leftQueryExpression.getColumnNames();
        Object[] rightNames = this.rightQueryExpression.getColumnNames();
        if (this.unionCorrespondingColumns == null) {
            this.unionCorrespondingColumns = new OrderedHashSet();
            OrderedIntHashSet leftColumns = new OrderedIntHashSet();
            OrderedIntHashSet rightColumns = new OrderedIntHashSet();
            for (int i = 0; i < leftNames.length; ++i) {
                String name = leftNames[i];
                int index = ArrayUtil.find(rightNames, name);
                if (name.length() <= 0 || index == -1) continue;
                leftColumns.add(i);
                rightColumns.add(index);
                this.unionCorrespondingColumns.add(name);
            }
            if (this.unionCorrespondingColumns.isEmpty()) {
                throw Error.error(5579);
            }
            this.leftQueryExpression.unionColumnMap = leftColumns.toArray();
            this.rightQueryExpression.unionColumnMap = rightColumns.toArray();
        } else {
            this.leftQueryExpression.unionColumnMap = new int[this.unionCorrespondingColumns.size()];
            this.rightQueryExpression.unionColumnMap = new int[this.unionCorrespondingColumns.size()];
            for (int i = 0; i < this.unionCorrespondingColumns.size(); ++i) {
                String name = (String)this.unionCorrespondingColumns.get(i);
                int index = ArrayUtil.find(leftNames, name);
                if (index == -1) {
                    throw Error.error(5579);
                }
                this.leftQueryExpression.unionColumnMap[i] = index;
                index = ArrayUtil.find(rightNames, name);
                if (index == -1) {
                    throw Error.error(5579);
                }
                this.rightQueryExpression.unionColumnMap[i] = index;
            }
        }
        this.columnCount = this.unionCorrespondingColumns.size();
        this.unionColumnTypes = new Type[this.columnCount];
        this.resolveColumnRefernecesInUnionOrderBy();
    }

    void resolveColumnRefernecesInUnionOrderBy() {
        int orderCount = this.sortAndSlice.getOrderLength();
        if (orderCount == 0) {
            return;
        }
        Object[] unionColumnNames = this.getColumnNames();
        for (int i = 0; i < orderCount; ++i) {
            int index;
            Expression sort = (Expression)this.sortAndSlice.exprList.get(i);
            Expression e = sort.getLeftNode();
            if (e.getType() == 1) {
                if (e.getDataType().typeCode == 4 && 0 < (index = ((Integer)e.getValue(null)).intValue()) && index <= unionColumnNames.length) {
                    sort.getLeftNode().queryTableColumnIndex = index - 1;
                    continue;
                }
            } else if (e.getType() == 2 && (index = ArrayUtil.find(unionColumnNames, e.getColumnName())) >= 0) {
                sort.getLeftNode().queryTableColumnIndex = index;
                continue;
            }
            throw Error.error(5576);
        }
        this.sortAndSlice.prepare(null);
    }

    private void addUnresolvedExpressions(HsqlList expressions) {
        if (expressions == null) {
            return;
        }
        if (this.unresolvedExpressions == null) {
            this.unresolvedExpressions = new ArrayListIdentity();
        }
        this.unresolvedExpressions.addAll(expressions);
    }

    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        this.isResolved = true;
    }

    void resolveTypesPartOne(Session session) {
        ArrayUtil.projectRowReverse(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.leftQueryExpression.resolveTypesPartOne(session);
        ArrayUtil.projectRow(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        ArrayUtil.projectRowReverse(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.rightQueryExpression.resolveTypesPartOne(session);
        ArrayUtil.projectRow(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
    }

    void resolveTypesPartTwo(Session session) {
        ArrayUtil.projectRowReverse(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.leftQueryExpression.resolveTypesPartTwo(session);
        ArrayUtil.projectRowReverse(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.rightQueryExpression.resolveTypesPartTwo(session);
        if (this.unionCorresponding) {
            this.resultMetaData = this.leftQueryExpression.getMetaData().getNewMetaData(this.leftQueryExpression.unionColumnMap);
            this.createTable(session);
        }
        if (this.sortAndSlice.hasOrder()) {
            QueryExpression queryExpression = this;
            while (true) {
                if (queryExpression.leftQueryExpression == null || queryExpression.unionCorresponding) {
                    this.sortAndSlice.setIndex(queryExpression.resultTable);
                    break;
                }
                queryExpression = queryExpression.leftQueryExpression;
            }
        }
    }

    public Object[] getValues(Session session) {
        Result r = this.getResult(session, 2);
        int size = r.getNavigator().getSize();
        if (size == 0) {
            return new Object[r.metaData.getColumnCount()];
        }
        if (size == 1) {
            return r.getSingleRowData();
        }
        throw Error.error(3201);
    }

    public Object[] getSingleRowValues(Session session) {
        Result r = this.getResult(session, 2);
        int size = r.getNavigator().getSize();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return r.getSingleRowData();
        }
        throw Error.error(3201);
    }

    public Object getValue(Session session) {
        Object[] values = this.getValues(session);
        return values[0];
    }

    Result getResult(Session session, int maxRows) {
        int currentMaxRows = this.unionType == 2 ? maxRows : Integer.MAX_VALUE;
        Result first = this.leftQueryExpression.getResult(session, currentMaxRows);
        RowSetNavigatorData navigator = (RowSetNavigatorData)first.getNavigator();
        Result second = this.rightQueryExpression.getResult(session, currentMaxRows);
        RowSetNavigatorData rightNavigator = (RowSetNavigatorData)second.getNavigator();
        if (this.unionCorresponding) {
            RowSetNavigatorData rowSet = new RowSetNavigatorData(session, this);
            rowSet.copy(navigator, this.leftQueryExpression.unionColumnMap);
            navigator = rowSet;
            first.setNavigator(navigator);
            first.metaData = this.getMetaData();
            rowSet = new RowSetNavigatorData(session, this);
            if (this.unionType != 1 && this.unionType != 2) {
                rowSet.copy(rightNavigator, this.rightQueryExpression.unionColumnMap);
                rightNavigator = rowSet;
            }
        }
        switch (this.unionType) {
            case 1: {
                navigator.union(rightNavigator, this.rightQueryExpression.unionColumnMap);
                break;
            }
            case 2: {
                navigator.unionAll(rightNavigator, this.rightQueryExpression.unionColumnMap);
                break;
            }
            case 3: {
                navigator.intersect(rightNavigator);
                break;
            }
            case 4: {
                navigator.intersectAll(rightNavigator);
                break;
            }
            case 6: {
                navigator.except(rightNavigator);
                break;
            }
            case 5: {
                navigator.exceptAll(rightNavigator);
                break;
            }
            default: {
                throw Error.runtimeError(401, "QueryExpression");
            }
        }
        if (this.sortAndSlice.hasOrder()) {
            RowSetNavigatorData nav = (RowSetNavigatorData)first.getNavigator();
            nav.sortUnion(this.sortAndSlice);
            nav.trim(this.sortAndSlice.getLimitStart(session), this.sortAndSlice.getLimitCount(session, maxRows));
        }
        navigator.reset();
        return first;
    }

    public boolean isSingleColumn() {
        return this.leftQueryExpression.isSingleColumn();
    }

    public ResultMetaData getMetaData() {
        if (this.resultMetaData != null) {
            return this.resultMetaData;
        }
        return this.leftQueryExpression.getMetaData();
    }

    public QuerySpecification getMainSelect() {
        if (this.leftQueryExpression == null) {
            return (QuerySpecification)this;
        }
        return this.leftQueryExpression.getMainSelect();
    }

    public String describe(Session session) {
        return this.leftQueryExpression.describe(session);
    }

    public HsqlList getUnresolvedExpressions() {
        return this.unresolvedExpressions;
    }

    public boolean areColumnsResolved() {
        return this.unresolvedExpressions == null || this.unresolvedExpressions.isEmpty();
    }

    String[] getColumnNames() {
        if (this.unionCorrespondingColumns == null) {
            return this.leftQueryExpression.getColumnNames();
        }
        Object[] names = new String[this.unionCorrespondingColumns.size()];
        this.unionCorrespondingColumns.toArray(names);
        return names;
    }

    public Type[] getColumnTypes() {
        return this.unionColumnTypes;
    }

    public int getColumnCount() {
        if (this.unionCorrespondingColumns == null) {
            int right;
            int left = this.leftQueryExpression.getColumnCount();
            if (left != (right = this.rightQueryExpression.getColumnCount())) {
                throw Error.error(5594);
            }
            return left;
        }
        return this.unionCorrespondingColumns.size();
    }

    public void collectAllExpressions(HsqlList set, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        this.leftQueryExpression.collectAllExpressions(set, typeSet, stopAtTypeSet);
        if (this.rightQueryExpression != null) {
            this.rightQueryExpression.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
    }

    public void collectObjectNames(Set set) {
        this.leftQueryExpression.collectObjectNames(set);
        if (this.rightQueryExpression != null) {
            this.rightQueryExpression.collectObjectNames(set);
        }
    }

    public HashMappedList getColumns() {
        this.getResultTable();
        return ((TableDerived)this.getResultTable()).columnList;
    }

    public void setView(View view) {
        this.view = view;
    }

    public void setTableColumnNames(HashMappedList list) {
        if (this.resultTable != null) {
            ((TableDerived)this.resultTable).columnList = list;
            return;
        }
        this.leftQueryExpression.setTableColumnNames(list);
    }

    void createTable(Session session) {
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder()) {
            this.orderIndex = this.resultTable.createAndAddIndexStructure(null, this.sortAndSlice.sortOrder, this.sortAndSlice.sortDescending, this.sortAndSlice.sortNullsLast, false, false, false);
        }
        int[] fullCols = new int[this.columnCount];
        ArrayUtil.fillSequence(fullCols);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(null, fullCols, null, null, false, false, false);
    }

    void createResultTable(Session session) {
        HsqlNameManager.HsqlName tableName = session.database.nameManager.getSubqueryTableName();
        int tableType = this.persistenceScope == 11 ? 1 : 8;
        HashMappedList columnList = this.leftQueryExpression.getUnionColumns();
        try {
            this.resultTable = new TableDerived(session.database, tableName, tableType, this.unionColumnTypes, columnList, null);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setColumnsDefined() {
        this.columnMode = 16;
        if (this.leftQueryExpression != null) {
            this.leftQueryExpression.setColumnsDefined();
        }
    }

    public void setAsTopLevel() {
        if (this.compileContext.getSequences().length > 0) {
            throw Error.error(5598);
        }
        this.isTopLevel = true;
        this.setReturningResultSet();
    }

    void setReturningResultSet() {
        if (this.unionCorresponding) {
            this.persistenceScope = 13;
            this.columnMode = 15;
            return;
        }
        this.leftQueryExpression.setReturningResultSet();
    }

    private HashMappedList getUnionColumns() {
        if (this.unionCorresponding || this.leftQueryExpression == null) {
            HashMappedList columns = ((TableDerived)this.resultTable).columnList;
            HashMappedList list = new HashMappedList();
            for (int i = 0; i < this.unionColumnMap.length; ++i) {
                ColumnSchema column = (ColumnSchema)columns.get(i);
                list.add(column.getName().name, column);
            }
            return list;
        }
        return this.leftQueryExpression.getUnionColumns();
    }

    public HsqlNameManager.HsqlName[] getResultColumnNames() {
        if (this.resultTable == null) {
            return this.leftQueryExpression.getResultColumnNames();
        }
        HashMappedList list = ((TableDerived)this.resultTable).columnList;
        HsqlNameManager.HsqlName[] resultColumnNames = new HsqlNameManager.HsqlName[list.size()];
        for (int i = 0; i < resultColumnNames.length; ++i) {
            resultColumnNames[i] = ((ColumnSchema)list.get(i)).getName();
        }
        return resultColumnNames;
    }

    public TableBase getResultTable() {
        if (this.resultTable != null) {
            return this.resultTable;
        }
        if (this.leftQueryExpression != null) {
            return this.leftQueryExpression.getResultTable();
        }
        return null;
    }

    public Table getBaseTable() {
        return null;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public boolean isInsertable() {
        return this.isInsertable;
    }

    public int[] getBaseTableColumnMap() {
        return null;
    }

    public Expression getCheckCondition() {
        return null;
    }

    public boolean hasReference(RangeVariable range) {
        if (this.leftQueryExpression.hasReference(range)) {
            return true;
        }
        return this.rightQueryExpression.hasReference(range);
    }

    void getBaseTableNames(OrderedHashSet set) {
        this.leftQueryExpression.getBaseTableNames(set);
        this.rightQueryExpression.getBaseTableNames(set);
    }
}

