/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDML;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCompound;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementExpression;
import org.hsqldb.StatementHandler;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSet;
import org.hsqldb.StatementSimple;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.types.Type;

public class ParserRoutine
extends ParserDML {
    ParserRoutine(Session session, Scanner t) {
        super(session, t);
    }

    Expression readDefaultClause(Type dataType) {
        Expression e = null;
        boolean minus = false;
        if (dataType.isDateTimeType() || dataType.isIntervalType()) {
            switch (this.token.tokenType) {
                case 71: 
                case 138: 
                case 279: 
                case 280: {
                    e = this.readDateTimeIntervalLiteral();
                    if (e.dataType.typeCode != dataType.typeCode) {
                        throw this.unexpectedToken();
                    }
                    Object defaultValue = e.getValue(this.session, dataType);
                    return new ExpressionValue(defaultValue, dataType);
                }
                case 745: {
                    break;
                }
                default: {
                    e = this.XreadDateTimeValueFunctionOrNull();
                    break;
                }
            }
        } else if (dataType.isNumberType()) {
            if (this.token.tokenType == 693) {
                this.read();
                minus = true;
            }
        } else if (dataType.isCharacterType()) {
            switch (this.token.tokenType) {
                case 59: 
                case 62: 
                case 63: 
                case 64: 
                case 68: 
                case 251: 
                case 275: 
                case 303: {
                    FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                    e = this.readSQLFunction(function);
                    break;
                }
            }
        } else if (dataType.isBooleanType()) {
            switch (this.token.tokenType) {
                case 292: {
                    this.read();
                    return Expression.EXPR_TRUE;
                }
                case 105: {
                    this.read();
                    return Expression.EXPR_FALSE;
                }
            }
        }
        if (e == null) {
            if (this.token.tokenType == 184) {
                this.read();
                return new ExpressionValue(null, dataType);
            }
            if (this.token.tokenType == 745) {
                e = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                if (minus) {
                    e = new ExpressionArithmetic(31, e);
                    e.resolveTypes(this.session, null);
                }
                this.read();
                Object defaultValue = e.getValue(this.session, dataType);
                return new ExpressionValue(defaultValue, dataType);
            }
            throw this.unexpectedToken();
        }
        e.resolveTypes(this.session, null);
        if (dataType.typeComparisonGroup != e.getDataType().typeComparisonGroup) {
            throw Error.error(5562);
        }
        return e;
    }

    Statement compileSelectSingleRowStatement(RangeVariable[] rangeVars) {
        OrderedHashSet variableNames = new OrderedHashSet();
        QuerySpecification select = this.XreadSelect();
        this.readThis(139);
        this.readColumnNamesForSelectInto(variableNames, rangeVars);
        this.XreadTableExpression(select);
        select.setAsTopLevel();
        select.resolve(this.session, rangeVars, new Type[variableNames.size()]);
        int[] indexes = new int[variableNames.size()];
        ColumnSchema[] variables = new ColumnSchema[variableNames.size()];
        ParserRoutine.setVariables(rangeVars, variableNames, indexes, variables);
        StatementSet statement = new StatementSet(this.session, this.compileContext, variables, select, indexes);
        return statement;
    }

    Statement compileSetStatement(RangeVariable[] rangeVars) {
        this.read();
        OrderedHashSet variableNames = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        this.readSetClauseList(rangeVars, variableNames, exprList);
        if (exprList.size() > 1) {
            throw Error.error(5602);
        }
        Expression expression = (Expression)exprList.get(0);
        if (expression.getDegree() != variableNames.size()) {
            // empty if block
        }
        int[] indexes = new int[variableNames.size()];
        ColumnSchema[] variables = new ColumnSchema[variableNames.size()];
        ParserRoutine.setVariables(rangeVars, variableNames, indexes, variables);
        HsqlList unresolved = expression.resolveColumnReferences(rangeVars, rangeVars.length, null, false);
        unresolved = Expression.resolveColumnSet(rangeVars, unresolved, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        expression.resolveTypes(this.session, null);
        StatementSet cs = new StatementSet(this.session, this.compileContext, variables, expression, indexes);
        return cs;
    }

    private static void setVariables(RangeVariable[] rangeVars, OrderedHashSet colNames, int[] indexes, ColumnSchema[] variables) throws IndexOutOfBoundsException {
        int index = -1;
        block0: for (int i = 0; i < variables.length; ++i) {
            String colName = (String)colNames.get(i);
            for (int j = 0; j < rangeVars.length; ++j) {
                index = rangeVars[j].variables.getIndex(colName);
                if (index <= -1) continue;
                indexes[i] = index;
                variables[i] = rangeVars[j].getColumn(index);
                continue block0;
            }
        }
    }

    StatementSchema compileCreateProcedureOrFunction() {
        int routineType = this.token.tokenType == 213 ? 17 : 16;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(routineType, false);
        Routine routine = new Routine(routineType);
        routine.setName(name);
        this.readThis(695);
        if (this.token.tokenType == 682) {
            this.read();
        } else {
            while (true) {
                ColumnSchema newcolumn = this.readRoutineParameter(routine);
                routine.addParameter(newcolumn);
                if (this.token.tokenType != 684) break;
                this.read();
            }
            this.readThis(682);
        }
        if (routineType != 17) {
            this.readThis(236);
            if (this.token.tokenType == 276) {
                this.read();
                TableDerived table = new TableDerived(this.database, name, 10);
                this.readThis(695);
                if (this.token.tokenType == 682) {
                    this.read();
                } else {
                    while (true) {
                        ColumnSchema newcolumn = this.readRoutineParameter(routine);
                        table.addColumn(newcolumn);
                        if (this.token.tokenType != 684) break;
                        this.read();
                    }
                    this.readThis(682);
                }
                routine.setReturnTable(table);
            } else {
                Type type = this.readTypeDefinition(true);
                routine.setReturnType(type);
            }
        }
        this.readRoutineCharacteristics(routine);
        if (this.token.tokenType == 103) {
            if (routine.getLanguage() != 1) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(444);
            this.checkIsValue(1);
            routine.setMethodURL((String)this.token.tokenValue);
            this.read();
            if (this.token.tokenType == 202) {
                this.read();
                this.readThis(517);
                this.readThis(425);
            }
        } else {
            this.startRecording();
            Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
            Token[] tokenList = this.getRecordedStatement();
            String sql = Token.getSQL(tokenList);
            statement.setSQL(sql);
            routine.setProcedure(statement);
        }
        Object[] args = new Object[]{routine};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, 14, args, null, null);
        return cs;
    }

    private void readRoutineCharacteristics(Routine routine) {
        OrderedIntHashSet set = new OrderedIntHashSet();
        boolean end = false;
        block16: while (!end) {
            switch (this.token.tokenType) {
                case 144: {
                    if (!set.add(144)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 425) {
                        this.read();
                        routine.setLanguage(1);
                        continue block16;
                    }
                    if (this.token.tokenType == 259) {
                        this.read();
                        routine.setLanguage(2);
                        continue block16;
                    }
                    throw this.unexpectedToken();
                }
                case 202: {
                    if (!set.add(202)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(517);
                    if (this.token.tokenType == 425) {
                        this.read();
                        routine.setParameterStyle(1);
                        continue block16;
                    }
                    this.readThis(259);
                    routine.setParameterStyle(2);
                    continue block16;
                }
                case 257: {
                    if (!set.add(257)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(24, false);
                    routine.setSpecificName(name);
                    continue block16;
                }
                case 82: {
                    if (!set.add(82)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    routine.setDeterministic(true);
                    continue block16;
                }
                case 181: {
                    if (!set.add(82)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(82);
                    routine.setDeterministic(false);
                    continue block16;
                }
                case 169: {
                    if (!set.add(259)) {
                        throw this.unexpectedToken();
                    }
                    if (routine.getType() == 16) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(259);
                    this.readThis(378);
                    routine.setDataImpact(4);
                    continue block16;
                }
                case 178: {
                    if (!set.add(259)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(259);
                    routine.setDataImpact(1);
                    continue block16;
                }
                case 216: {
                    if (!set.add(259)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(259);
                    this.readThis(378);
                    routine.setDataImpact(3);
                    continue block16;
                }
                case 375: {
                    if (!set.add(259)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(259);
                    routine.setDataImpact(2);
                    continue block16;
                }
                case 236: {
                    if (!set.add(184) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(184);
                    this.readThis(192);
                    this.readThis(184);
                    this.readThis(419);
                    routine.setNullInputOutput(true);
                    continue block16;
                }
                case 25: {
                    if (!set.add(184) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(192);
                    this.readThis(184);
                    this.readThis(419);
                    routine.setNullInputOutput(false);
                    continue block16;
                }
                case 88: {
                    if (!set.add(234) || routine.isFunction()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(234);
                    this.readThis(508);
                    this.readBigint();
                    continue block16;
                }
                case 177: {
                    if (routine.getType() == 16 || !set.add(244)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(244);
                    this.readThis(432);
                    routine.setNewSavepointLevel(true);
                    continue block16;
                }
                case 191: {
                    if (routine.getType() == 16 || !set.add(244)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(244);
                    this.readThis(432);
                    routine.setNewSavepointLevel(false);
                    throw super.unsupportedFeature("OLD");
                }
            }
            end = true;
        }
    }

    private Object[] readLocalDeclarationList(Routine routine, StatementCompound context) {
        HsqlArrayList list = new HsqlArrayList();
        while (this.token.tokenType == 76) {
            Object var = this.readLocalVariableDeclarationOrNull();
            if (var == null) {
                var = this.compileLocalHandlerDeclaration(routine, context);
            }
            list.add(var);
        }
        Object[] declarations = new Object[list.size()];
        list.toArray(declarations);
        return declarations;
    }

    ColumnSchema readLocalVariableDeclarationOrNull() {
        Type type;
        HsqlNameManager.HsqlName name;
        int position = super.getPosition();
        try {
            this.readThis(76);
            if (this.isReservedKey()) {
                this.rewind(position);
                return null;
            }
            name = super.readNewSchemaObjectName(22, false);
            type = this.readTypeDefinition(true);
        }
        catch (Exception e) {
            this.rewind(position);
            return null;
        }
        Expression def = null;
        if (this.token.tokenType == 77) {
            this.read();
            def = this.readDefaultClause(type);
        }
        ColumnSchema variable = new ColumnSchema(name, type, true, false, def);
        variable.setParameterMode((byte)2);
        this.readThis(699);
        return variable;
    }

    private StatementHandler compileLocalHandlerDeclaration(Routine routine, StatementCompound context) {
        int handlerType;
        this.readThis(76);
        switch (this.token.tokenType) {
            case 376: {
                this.read();
                handlerType = 5;
                break;
            }
            case 101: {
                this.read();
                handlerType = 6;
                break;
            }
            case 295: {
                this.read();
                handlerType = 7;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(123);
        this.readThis(111);
        StatementHandler handler = new StatementHandler(handlerType);
        boolean end = false;
        boolean start = true;
        block12: while (!end) {
            int conditionType = 0;
            switch (this.token.tokenType) {
                case 684: {
                    if (start) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    start = true;
                    continue block12;
                }
                case 261: {
                    conditionType = 4;
                }
                case 260: {
                    if (conditionType == 0) {
                        conditionType = 1;
                    }
                }
                case 262: {
                    if (conditionType == 0) {
                        conditionType = 2;
                    }
                }
                case 181: {
                    if (conditionType == 0) {
                        conditionType = 3;
                    }
                    if (!start) {
                        throw this.unexpectedToken();
                    }
                    start = false;
                    this.read();
                    if (conditionType == 3) {
                        this.readThis(404);
                    } else if (conditionType == 4) {
                        String sqlState = this.parseSQLStateValue();
                        handler.addConditionState(sqlState);
                        continue block12;
                    }
                    handler.addConditionType(conditionType);
                    continue block12;
                }
            }
            if (start) {
                throw this.unexpectedToken();
            }
            end = true;
        }
        if (this.token.tokenType == 699) {
            this.read();
        } else {
            Statement e = this.compileSQLProcedureStatementOrNull(routine, context);
            if (e == null) {
                throw this.unexpectedToken();
            }
            this.readThis(699);
            handler.addStatement(e);
        }
        return handler;
    }

    String parseSQLStateValue() {
        this.readIfThis(305);
        this.checkIsValue(1);
        String sqlState = this.token.tokenString;
        if (this.token.tokenString.length() != 5) {
            throw Error.error(1200);
        }
        this.read();
        return sqlState;
    }

    private Statement compileCompoundStatement(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        boolean atomic = true;
        this.readThis(16);
        this.readThis(13);
        StatementCompound statement = new StatementCompound(12, label);
        statement.setAtomic(true);
        statement.setRoot(routine);
        statement.setParent(context);
        Object[] declarations = this.readLocalDeclarationList(routine, context);
        statement.setLocalDeclarations(declarations);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, statement);
        statement.setStatements(statements);
        this.readThis(93);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        return statement;
    }

    private Statement[] compileSQLProcedureStatementList(Routine routine, StatementCompound context) {
        Statement e;
        HsqlArrayList list = new HsqlArrayList();
        while ((e = this.compileSQLProcedureStatementOrNull(routine, context)) != null) {
            this.readThis(699);
            list.add(e);
        }
        if (list.size() == 0) {
            throw this.unexpectedToken();
        }
        Statement[] statements = new Statement[list.size()];
        list.toArray(statements);
        return statements;
    }

    private Statement compileSQLProcedureStatementOrNull(Routine routine, StatementCompound context) {
        RangeVariable[] rangeVariables;
        Statement cs = null;
        HsqlNameManager.HsqlName label = null;
        RangeVariable[] rangeVariableArray = rangeVariables = context == null ? routine.getParameterRangeVariables() : context.getRangeVariables();
        if (this.isSimpleName() && !this.isReservedKey()) {
            label = this.readNewSchemaObjectName(21, false);
            this.readThis(683);
        }
        this.compileContext.reset();
        switch (this.token.tokenType) {
            case 249: {
                cs = this.compileSelectSingleRowStatement(rangeVariables);
                break;
            }
            case 133: {
                cs = this.compileInsertStatement(rangeVariables);
                break;
            }
            case 301: {
                cs = this.compileUpdateStatement(rangeVariables);
                break;
            }
            case 78: 
            case 293: {
                cs = this.compileDeleteStatement(rangeVariables);
                break;
            }
            case 164: {
                cs = this.compileMergeStatement(rangeVariables);
                break;
            }
            case 252: {
                cs = this.compileSetStatement(rangeVariables);
                break;
            }
            case 24: {
                if (label != null) {
                    throw this.unexpectedToken();
                }
                cs = this.compileCallStatement(rangeVariables, true);
                break;
            }
            case 235: {
                if (label != null) {
                    throw this.unexpectedToken();
                }
                this.read();
                cs = this.compileReturnValue(routine, context);
                break;
            }
            case 16: {
                cs = this.compileCompoundStatement(routine, context, label);
                break;
            }
            case 320: {
                cs = this.compileWhile(routine, context, label);
                break;
            }
            case 232: {
                cs = this.compileRepeat(routine, context, label);
                break;
            }
            case 158: {
                cs = this.compileLoop(routine, context, label);
                break;
            }
            case 111: {
                cs = this.compileFor(routine, context, label);
                break;
            }
            case 141: {
                if (label != null) {
                    throw this.unexpectedToken();
                }
                cs = this.compileIterate();
                break;
            }
            case 150: {
                if (label != null) {
                    throw this.unexpectedToken();
                }
                cs = this.compileLeave(routine, context);
                break;
            }
            case 412: {
                if (label != null) {
                    throw this.unexpectedToken();
                }
                cs = this.compileIf(routine, context);
                break;
            }
            case 28: {
                if (label != null) {
                    throw this.unexpectedToken();
                }
                cs = this.compileCase(routine, context);
                break;
            }
            case 253: {
                cs = this.compileSignal(routine, context, label);
                break;
            }
            case 233: {
                cs = this.compileResignal(routine, context, label);
                break;
            }
            default: {
                return null;
            }
        }
        cs.setRoot(routine);
        cs.setParent(context);
        return cs;
    }

    private Statement compileReturnValue(Routine routine, StatementCompound context) {
        Expression e = this.XreadValueExpressionOrNull();
        if (e == null) {
            this.checkIsValue();
            if (this.token.tokenValue == null) {
                e = new ExpressionValue(null, null);
            }
        }
        this.resolveOuterReferences(routine, context, e);
        return new StatementExpression(this.session, this.compileContext, 58, e);
    }

    private Statement compileIterate() {
        this.readThis(141);
        HsqlNameManager.HsqlName label = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(102, label);
    }

    private Statement compileLeave(Routine routine, StatementCompound context) {
        this.readThis(150);
        HsqlNameManager.HsqlName label = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(89, label);
    }

    private Statement compileWhile(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(320);
        StatementExpression condition = new StatementExpression(this.session, this.compileContext, 1101, this.XreadBooleanValueExpression());
        this.readThis(85);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(93);
        this.readThis(320);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statement = new StatementCompound(97, label);
        statement.setStatements(statements);
        statement.setCondition(condition);
        return statement;
    }

    private Statement compileRepeat(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(232);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(300);
        StatementExpression condition = new StatementExpression(this.session, this.compileContext, 1101, this.XreadBooleanValueExpression());
        this.readThis(93);
        this.readThis(232);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statement = new StatementCompound(95, label);
        statement.setStatements(statements);
        statement.setCondition(condition);
        return statement;
    }

    private Statement compileLoop(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(158);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(93);
        this.readThis(158);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound result = new StatementCompound(90, label);
        result.setStatements(statements);
        return result;
    }

    private Statement compileFor(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(111);
        StatementDMQL cursorStatement = this.compileCursorSpecification();
        this.readThis(85);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(93);
        this.readThis(111);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound result = new StatementCompound(46, label);
        result.setLoopStatement(cursorStatement);
        result.setStatements(statements);
        return result;
    }

    private Statement compileIf(Routine routine, StatementCompound context) {
        int i;
        HsqlArrayList list = new HsqlArrayList();
        this.readThis(412);
        Expression condition = this.XreadBooleanValueExpression();
        this.resolveOuterReferences(routine, context, condition);
        StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1101, condition);
        list.add(statement);
        this.readThis(278);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        for (i = 0; i < statements.length; ++i) {
            list.add(statements[i]);
        }
        while (this.token.tokenType == 92) {
            this.read();
            condition = this.XreadBooleanValueExpression();
            this.resolveOuterReferences(routine, context, condition);
            statement = new StatementExpression(this.session, this.compileContext, 1101, condition);
            list.add(statement);
            this.readThis(278);
            statements = this.compileSQLProcedureStatementList(routine, context);
            for (i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        }
        if (this.token.tokenType == 91) {
            this.read();
            condition = Expression.EXPR_TRUE;
            statement = new StatementExpression(this.session, this.compileContext, 1101, condition);
            list.add(statement);
            statements = this.compileSQLProcedureStatementList(routine, context);
            for (i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        }
        this.readThis(93);
        this.readThis(412);
        statements = new Statement[list.size()];
        list.toArray(statements);
        StatementCompound result = new StatementCompound(88, null);
        result.setStatements(statements);
        return result;
    }

    private Statement compileCase(Routine routine, StatementCompound context) {
        Statement[] statements;
        HsqlArrayList list = new HsqlArrayList();
        Expression condition = null;
        this.readThis(28);
        list = this.token.tokenType == 312 ? this.readCaseWhen(routine, context) : this.readSimpleCaseWhen(routine, context);
        if (this.token.tokenType == 91) {
            this.read();
            condition = Expression.EXPR_TRUE;
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1101, condition);
            list.add(statement);
            statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        }
        this.readThis(93);
        this.readThis(28);
        statements = new Statement[list.size()];
        list.toArray(statements);
        StatementCompound result = new StatementCompound(88, null);
        result.setStatements(statements);
        return result;
    }

    private HsqlArrayList readSimpleCaseWhen(Routine routine, StatementCompound context) {
        HsqlArrayList list = new HsqlArrayList();
        Expression condition = null;
        Expression predicand = this.XreadRowValuePredicand();
        do {
            this.readThis(312);
            while (true) {
                Expression newCondition;
                if (predicand == (newCondition = this.XreadPredicateRightPart(predicand))) {
                    newCondition = new ExpressionLogical(predicand, this.XreadRowValuePredicand());
                }
                this.resolveOuterReferences(routine, context, newCondition);
                newCondition.resolveTypes(this.session, null);
                condition = condition == null ? newCondition : new ExpressionLogical(50, condition, newCondition);
                if (this.token.tokenType != 684) break;
                this.read();
            }
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1101, condition);
            list.add(statement);
            this.readThis(278);
            Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        } while (this.token.tokenType == 312);
        return list;
    }

    private HsqlArrayList readCaseWhen(Routine routine, StatementCompound context) {
        HsqlArrayList list = new HsqlArrayList();
        Expression condition = null;
        do {
            this.readThis(312);
            condition = this.XreadBooleanValueExpression();
            this.resolveOuterReferences(routine, context, condition);
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1101, condition);
            list.add(statement);
            this.readThis(278);
            Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        } while (this.token.tokenType == 312);
        return list;
    }

    private Statement compileSignal(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(253);
        this.readThis(261);
        String sqlState = this.parseSQLStateValue();
        StatementSimple cs = new StatementSimple(92, sqlState);
        return cs;
    }

    private Statement compileResignal(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        String sqlState = null;
        this.readThis(233);
        if (this.readIfThis(261)) {
            sqlState = this.parseSQLStateValue();
        }
        StatementSimple cs = new StatementSimple(91, sqlState);
        return cs;
    }

    private ColumnSchema readRoutineParameter(Routine routine) {
        HsqlNameManager.HsqlName hsqlName = null;
        byte parameterMode = 1;
        switch (this.token.tokenType) {
            case 128: {
                this.read();
                break;
            }
            case 197: {
                if (routine.getType() != 17) {
                    throw this.unexpectedToken();
                }
                this.read();
                parameterMode = 4;
                break;
            }
            case 131: {
                if (routine.getType() != 17) {
                    throw this.unexpectedToken();
                }
                this.read();
                parameterMode = 2;
                break;
            }
        }
        if (!this.isReservedKey()) {
            hsqlName = this.readNewDependentSchemaObjectName(routine.getName(), 23);
        }
        Type typeObject = this.readTypeDefinition(true);
        ColumnSchema column = new ColumnSchema(hsqlName, typeObject, true, false, null);
        column.setParameterMode(parameterMode);
        return column;
    }

    void resolveOuterReferences(Routine routine, StatementCompound context, Expression e) {
        RangeVariable[] rangeVars = routine.getParameterRangeVariables();
        if (context != null) {
            rangeVars = context.getRangeVariables();
        }
        HsqlList unresolved = e.resolveColumnReferences(rangeVars, rangeVars.length, null, false);
        unresolved = Expression.resolveColumnSet(rangeVars, unresolved, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        e.resolveTypes(this.session, null);
    }
}

