/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.constant.Constable;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.RangeVariable;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Type;

public class ParserCommand
extends ParserDDL {
    ParserCommand(Session session, Scanner t) {
        super(session, t);
    }

    Statement compileStatement() {
        Statement cs = this.compilePart();
        if (this.token.tokenType == 748) {
            if (cs.getSchemalName() == null) {
                cs.setSchemaHsqlName(this.session.getCurrentSchemaHsqlName());
            }
            return cs;
        }
        throw this.unexpectedToken();
    }

    HsqlArrayList compileStatements(String sql, int returnType) {
        HsqlArrayList list = new HsqlArrayList();
        Statement cs = null;
        this.reset(sql);
        while (this.token.tokenType != 748) {
            cs = this.compilePart();
            list.add(cs);
        }
        if (returnType != 0) {
            int group = cs.getGroup();
            if (group == 2003) {
                if (returnType == 1) {
                    throw Error.error(1253);
                }
            } else if (returnType == 2) {
                throw Error.error(1254);
            }
        }
        return list;
    }

    private Statement compilePart() {
        Statement cs;
        this.compileContext.reset();
        this.setParsePosition(this.getPosition());
        if (this.token.tokenType == 749) {
            this.read();
        }
        switch (this.token.tokenType) {
            case 249: 
            case 276: 
            case 306: 
            case 317: 
            case 695: {
                cs = this.compileCursorSpecification();
                break;
            }
            case 133: {
                cs = this.compileInsertStatement(RangeVariable.emptyArray);
                break;
            }
            case 301: {
                cs = this.compileUpdateStatement(RangeVariable.emptyArray);
                break;
            }
            case 164: {
                cs = this.compileMergeStatement(RangeVariable.emptyArray);
                break;
            }
            case 78: {
                cs = this.compileDeleteStatement(RangeVariable.emptyArray);
                break;
            }
            case 293: {
                cs = this.compileDeleteStatement(RangeVariable.emptyArray);
                break;
            }
            case 24: {
                cs = this.compileCallStatement(this.session.sessionContext.sessionVariablesRange, false);
                break;
            }
            case 252: {
                cs = this.compileSet();
                break;
            }
            case 265: {
                cs = this.compileStartTransaction();
                break;
            }
            case 43: {
                cs = this.compileCommit();
                break;
            }
            case 239: {
                cs = this.compileRollback();
                break;
            }
            case 244: {
                cs = this.compileSavepoint();
                break;
            }
            case 231: {
                cs = this.compileReleaseSavepoint();
                break;
            }
            case 54: {
                cs = this.compileCreate();
                break;
            }
            case 4: {
                cs = this.compileAlter();
                break;
            }
            case 87: {
                cs = this.compileDrop();
                break;
            }
            case 120: 
            case 237: {
                cs = this.compileGrantOrRevoke();
                break;
            }
            case 579: {
                cs = this.compileLock();
                break;
            }
            case 46: {
                cs = this.compileConnect();
                break;
            }
            case 83: {
                cs = this.compileDisconnect();
                break;
            }
            case 592: {
                cs = this.compileScript();
                break;
            }
            case 594: {
                cs = this.compileShutdown();
                break;
            }
            case 553: {
                cs = this.compileBackup();
                break;
            }
            case 559: {
                cs = this.compileCheckpoint();
                break;
            }
            case 568: {
                cs = this.compileExplainPlan();
                break;
            }
            case 76: {
                cs = this.compileDeclare();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (cs.type != 76) {
            cs.setSQL(this.getLastPart());
        }
        if (this.token.tokenType == 699) {
            this.read();
        } else if (this.token.tokenType == 748) {
            // empty if block
        }
        return cs;
    }

    private Statement compileDeclare() {
        ColumnSchema variable = this.readLocalVariableDeclarationOrNull();
        if (variable != null) {
            Object[] args = new Object[]{variable};
            StatementSession cs = new StatementSession(1056, args);
            return cs;
        }
        StatementDMQL cs = this.compileDeclareCursor();
        return cs;
    }

    private Statement compileScript() {
        String name = null;
        this.read();
        if (this.token.tokenType == 745) {
            if (this.token.dataType.typeCode != 1) {
                throw Error.error(5581);
            }
            name = this.token.tokenString;
            this.read();
        }
        Object[] args = new Object[]{name};
        StatementCommand cs = new StatementCommand(1004, args, null, null);
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        cs.readTableNames = names;
        return cs;
    }

    private Statement compileConnect() {
        String password = null;
        this.read();
        this.readThis(303);
        this.checkIsSimpleName();
        String userName = this.token.tokenString;
        this.read();
        this.readThis(586);
        password = this.readPassword();
        Expression[] args = new Expression[]{new ExpressionValue(userName, Type.SQL_VARCHAR), new ExpressionValue(password, Type.SQL_VARCHAR)};
        StatementSession cs = new StatementSession(76, args);
        return cs;
    }

    private StatementCommand compileSetDefault() {
        this.read();
        switch (this.token.tokenType) {
            case 577: {
                this.read();
                this.readThis(496);
                HsqlNameManager.HsqlName schema = this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] args = new Object[]{schema};
                return new StatementCommand(1011, args, null, null);
            }
            case 234: {
                this.read();
                this.readThis(582);
                this.readThis(243);
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementCommand(1031, args, null, null);
            }
            case 276: {
                this.read();
                this.readThis(533);
                int type = 3;
                switch (this.token.tokenType) {
                    case 582: {
                        break;
                    }
                    case 557: {
                        type = 4;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] args = new Object[]{type};
                return new StatementCommand(1012, args, null, null);
            }
        }
        throw this.unexpectedToken();
    }

    private StatementCommand compileSetProperty() {
        Object value;
        this.read();
        HsqlDatabaseProperties props = this.database.getProperties();
        this.checkIsSimpleName();
        this.checkIsDelimitedIdentifier();
        String property = this.token.tokenString;
        boolean isboolean = props.isBoolean(this.token.tokenString);
        boolean isintegral = props.isIntegral(this.token.tokenString);
        boolean isstring = props.isString(this.token.tokenString);
        if (!(isboolean || isintegral || isstring)) {
            throw Error.error(5511);
        }
        int typeCode = isboolean ? 16 : (isintegral ? 4 : 1);
        this.read();
        if (this.token.tokenType == 292) {
            value = Boolean.TRUE;
            if (!isboolean) {
                throw Error.error(5565, this.token.tokenString);
            }
        } else if (this.token.tokenType == 105) {
            value = Boolean.FALSE;
            if (!isboolean) {
                throw Error.error(5565, this.token.tokenString);
            }
        } else {
            this.checkIsValue();
            value = this.token.tokenValue;
            if (this.token.dataType.typeCode != typeCode) {
                throw Error.error(5565, this.token.tokenString);
            }
        }
        this.read();
        Object[] args = new Object[]{property, value};
        return new StatementCommand(1028, args, null, null);
    }

    private Statement compileSet() {
        int position = super.getPosition();
        this.session.setScripting(false);
        this.read();
        switch (this.token.tokenType) {
            case 348: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null) {
                    HsqlNameManager.HsqlName name = this.readSchemaName();
                    Object[] args = new Object[]{name};
                    return new StatementSession(66, args);
                }
                if (!e.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(e.getType() == 1 || e.getType() == 28 && ((FunctionSQL)e).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] args = new Expression[]{e};
                return new StatementSession(66, args);
            }
            case 496: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null) {
                    HsqlNameManager.HsqlName name = this.readSchemaName();
                    Object[] args = new Object[]{name};
                    return new StatementSession(74, args);
                }
                if (!e.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(e.getType() == 1 || e.getType() == 28 && ((FunctionSQL)e).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] args = new Expression[]{e};
                return new StatementSession(74, args);
            }
            case 279: {
                this.read();
                return this.compileSetTimeZone();
            }
            case 489: {
                this.read();
                return this.compileSetRole();
            }
            case 507: {
                this.read();
                return this.compileSessionSettings();
            }
            case 524: {
                this.read();
                Object[] args = this.processTransactionCharacteristics();
                if (args[0] == null && args[1] == null) {
                    throw this.unexpectedToken();
                }
                return new StatementSession(75, args);
            }
            case 552: {
                this.read();
                Boolean mode = this.processTrueOrFalseObject();
                Object[] args = new Object[]{mode};
                return new StatementSession(1045, args);
            }
            case 589: {
                this.read();
                Boolean readonly = this.processTrueOrFalseObject();
                Object[] args = new Object[]{readonly};
                return new StatementSession(109, args);
            }
            case 573: {
                this.read();
                Boolean mode = this.processTrueOrFalseObject();
                Object[] args = new Object[]{mode};
                return new StatementCommand(1034, args, null, null);
            }
            case 581: {
                this.read();
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementSession(1046, args);
            }
            case 77: {
                this.read();
                this.readThis(276);
                this.readThis(533);
                int type = 3;
                switch (this.token.tokenType) {
                    case 582: {
                        break;
                    }
                    case 557: {
                        type = 4;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] args = new Object[]{type};
                return new StatementCommand(1012, args, null, null);
            }
            case 234: {
                this.read();
                this.readThis(582);
                this.readThis(510);
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementSession(1047, args);
            }
            case 276: {
                int newType;
                this.read();
                Table t = this.readTableName();
                Object[] args = new Object[]{t.tableName, null};
                switch (this.token.tokenType) {
                    default: {
                        throw this.unexpectedToken();
                    }
                    case 511: {
                        this.read();
                        return this.compileTextTableSource(t);
                    }
                    case 479: {
                        this.read();
                        boolean readonly = false;
                        if (this.token.tokenType != 545) {
                            this.readThis(193);
                            readonly = true;
                        }
                        args[1] = readonly;
                        return new StatementCommand(1068, args, null, t.getName());
                    }
                    case 589: {
                        this.read();
                        Boolean readonly = this.processTrueOrFalseObject();
                        args[1] = readonly;
                        return new StatementCommand(1068, args, null, t.getName());
                    }
                    case 576: {
                        this.read();
                        this.checkIsValue();
                        String value = this.token.tokenString;
                        this.read();
                        args[1] = value;
                        return new StatementCommand(1067, args, null, null);
                    }
                    case 533: 
                }
                this.read();
                if (this.token.tokenType == 557) {
                    newType = 4;
                } else if (this.token.tokenType == 582) {
                    newType = 3;
                } else {
                    throw Error.error(5581);
                }
                this.read();
                args[1] = new Integer(newType);
                return new StatementCommand(1071, args, null, t.getName());
            }
            case 597: {
                this.read();
                int delay = 0;
                if (this.token.tokenType == 292) {
                    delay = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 105) {
                    delay = 0;
                    this.read();
                } else {
                    delay = this.readInteger();
                    if (delay < 0) {
                        delay = 0;
                    }
                    if (this.token.tokenType == 583) {
                        this.read();
                    } else {
                        delay *= 1000;
                    }
                }
                Object[] args = new Object[]{new Integer(delay)};
                return new StatementCommand(1026, args, null, null);
            }
            case 586: {
                this.read();
                String password = this.readPassword();
                Object[] args = new Object[]{null, password};
                return new StatementCommand(1043, args, null, null);
            }
            case 577: {
                this.read();
                this.readThis(496);
                HsqlNameManager.HsqlName schema = this.token.tokenType == 77 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] args = new Object[]{null, schema};
                return new StatementCommand(1042, args, null, null);
            }
            case 570: {
                return this.compileSetFilesProperty();
            }
            case 564: {
                return this.compileSetDatabaseProperty();
            }
            case 588: {
                return this.compileSetProperty();
            }
        }
        this.rewind(position);
        return this.compileSetStatement(this.session.sessionContext.sessionVariablesRange);
    }

    StatementCommand compileSetDatabaseProperty() {
        this.read();
        switch (this.token.tokenType) {
            case 358: {
                this.read();
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                this.read();
                Object[] args = new Object[]{name};
                return new StatementCommand(1033, args, null, null);
            }
            case 77: {
                return this.compileSetDefault();
            }
            case 567: {
                this.read();
                this.readThis(638);
                this.readThis(432);
                Integer value = this.readIntegerObject();
                Object[] args = new Object[]{value};
                return new StatementCommand(1017, args, null, null);
            }
            case 571: {
                this.read();
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementCommand(1027, args, null, null);
            }
            case 590: {
                this.read();
                this.readThis(575);
                boolean mode = this.processTrueOrFalse();
                Object[] args = new Object[]{mode};
                return new StatementCommand(1035, args, null, null);
            }
            case 259: {
                this.read();
                int type = 0;
                Boolean flag = null;
                switch (this.token.tokenType) {
                    case 510: {
                        this.read();
                        type = 1037;
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 445: {
                        this.read();
                        type = 1036;
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    default: {
                        this.unexpectedToken();
                    }
                }
                Object[] args = new Object[]{flag};
                return new StatementCommand(type, args, null, null);
            }
            case 596: {
                this.read();
                this.readThis(276);
                this.readThis(381);
                String source = this.readQuotedString();
                Object[] args = new Object[]{source};
                return new StatementCommand(1038, args, null, null);
            }
            case 524: {
                this.read();
                this.readThis(563);
                int mode = 0;
                switch (this.token.tokenType) {
                    case 643: {
                        this.read();
                        mode = 2;
                        break;
                    }
                    case 644: {
                        this.read();
                        mode = 1;
                        break;
                    }
                    case 580: {
                        this.read();
                        mode = 0;
                    }
                }
                Object[] args = new Object[]{mode};
                return new StatementCommand(1039, args, null, null);
            }
            case 297: {
                this.read();
                this.readThis(444);
                this.isUndelimitedSimpleName();
                String name = this.token.tokenString;
                this.read();
                if (name.length() != 16) {
                    throw Error.error(5511);
                }
                if (!Charset.isInSet(name, Charset.unquotedIdentifier) || !Charset.startsWith(name, Charset.uppercaseLetters)) {
                    throw Error.error(5501);
                }
                Object[] args = new Object[]{name};
                return new StatementCommand(1040, args, null, null);
            }
        }
        throw this.unexpectedToken();
    }

    StatementCommand compileSetFilesProperty() {
        this.read();
        int type = 0;
        Boolean flag = null;
        Integer value = null;
        switch (this.token.tokenType) {
            case 579: {
                this.read();
                flag = this.processTrueOrFalseObject();
                type = 1018;
                break;
            }
            case 556: {
                this.read();
                if (this.readIfThis(510)) {
                    value = this.readIntegerObject();
                    type = 1015;
                    break;
                }
                if (!this.readIfThis(243)) break;
                value = this.readIntegerObject();
                type = 1014;
                break;
            }
            case 495: {
                this.read();
                value = this.readIntegerObject();
                type = 1023;
                break;
            }
            case 565: {
                this.read();
                type = 1016;
                value = this.readIntegerObject();
                break;
            }
            case 645: {
                this.read();
                type = 1020;
                flag = this.processTrueOrFalseObject();
                break;
            }
            case 553: {
                this.read();
                type = 1013;
                this.readThis(417);
                flag = this.processTrueOrFalseObject();
                break;
            }
            case 638: {
                this.read();
                this.readThis(510);
                this.checkDatabaseUpdateAuthorisation();
                type = 1019;
                value = this.readIntegerObject();
                break;
            }
            case 595: {
                this.read();
                this.readThis(471);
                this.checkDatabaseUpdateAuthorisation();
                type = 1025;
                value = this.readIntegerObject();
                break;
            }
            case 545: {
                this.read();
                this.readThis(566);
                type = 1026;
                int delay = 0;
                if (this.token.tokenType == 292) {
                    delay = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 105) {
                    delay = 0;
                    this.read();
                } else {
                    delay = this.readInteger();
                    if (delay < 0) {
                        delay = 0;
                    }
                    if (this.token.tokenType == 583) {
                        this.read();
                    } else {
                        delay *= 1000;
                    }
                }
                value = new Integer(delay);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] args = new Object[]{flag == null ? (Constable)value : (Constable)flag};
        return new StatementCommand(type, args, this.database.getCatalogName(), null);
    }

    Object[] processTransactionCharacteristics() {
        int level = 0;
        boolean readonly = false;
        Object[] args = new Object[2];
        block9: while (true) {
            switch (this.token.tokenType) {
                case 479: {
                    if (args[0] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 193) {
                        this.read();
                        readonly = true;
                    } else {
                        this.readThis(545);
                        readonly = false;
                    }
                    args[0] = readonly;
                    continue block9;
                }
                case 424: {
                    if (args[1] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(432);
                    switch (this.token.tokenType) {
                        case 505: {
                            this.read();
                            level = 8;
                            break;
                        }
                        case 479: {
                            this.read();
                            if (this.token.tokenType == 365) {
                                this.read();
                                level = 2;
                                break;
                            }
                            if (this.token.tokenType == 535) {
                                this.read();
                                level = 1;
                                break;
                            }
                            throw this.unexpectedToken();
                        }
                        case 481: {
                            this.read();
                            this.readThis(479);
                            level = 4;
                            break;
                        }
                        default: {
                            throw this.unexpectedToken();
                        }
                    }
                    args[1] = new Integer(level);
                    continue block9;
                }
            }
            break;
        }
        if (!readonly && level == 1) {
            throw this.unexpectedToken("WRITE");
        }
        return args;
    }

    private boolean processTrueOrFalse() {
        if (this.token.namePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 292) {
            this.read();
            return true;
        }
        if (this.token.tokenType == 105) {
            this.read();
            return false;
        }
        throw this.unexpectedToken();
    }

    private Boolean processTrueOrFalseObject() {
        if (this.token.namePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 292) {
            this.read();
            return Boolean.TRUE;
        }
        if (this.token.tokenType == 105) {
            this.read();
            return Boolean.FALSE;
        }
        throw this.unexpectedToken();
    }

    private Statement compileCommit() {
        boolean chain = false;
        this.read();
        this.readIfThis(544);
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 178) {
                this.read();
            } else {
                chain = true;
            }
            this.readThis(350);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{chain};
        StatementSession cs = new StatementSession(11, args);
        return cs;
    }

    private Statement compileStartTransaction() {
        this.read();
        this.readThis(524);
        Object[] args = this.processTransactionCharacteristics();
        StatementSession cs = new StatementSession(111, args);
        return cs;
    }

    private Statement compileLock() {
        this.read();
        this.readThis(276);
        OrderedHashSet readSet = new OrderedHashSet();
        OrderedHashSet writeSet = new OrderedHashSet();
        while (true) {
            Table table = this.readTableName();
            switch (this.token.tokenType) {
                case 479: {
                    this.read();
                    readSet.add(table.getName());
                    break;
                }
                case 545: {
                    this.read();
                    writeSet.add(table.getName());
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (this.token.tokenType != 684) break;
            this.read();
        }
        Object[] readTableNames = new HsqlNameManager.HsqlName[readSet.size()];
        readSet.toArray(readTableNames);
        Object[] writeTableNames = new HsqlNameManager.HsqlName[writeSet.size()];
        writeSet.toArray(writeTableNames);
        StatementSession cs = new StatementSession(1044, (HsqlNameManager.HsqlName[])readTableNames, (HsqlNameManager.HsqlName[])writeTableNames);
        return cs;
    }

    private Statement compileRollback() {
        boolean chain = false;
        String savepoint = null;
        this.read();
        if (this.token.tokenType == 283) {
            this.read();
            this.readThis(244);
            this.checkIsSimpleName();
            savepoint = this.token.tokenString;
            this.read();
            String sql = this.getLastPart();
            Object[] args = new Object[]{savepoint};
            StatementSession cs = new StatementSession(1048, args);
            return cs;
        }
        if (this.token.tokenType == 544) {
            this.read();
        }
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 178) {
                this.read();
            } else {
                chain = true;
            }
            this.readThis(350);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{chain};
        StatementSession cs = new StatementSession(62, args);
        return cs;
    }

    private Statement compileSavepoint() {
        this.read();
        this.checkIsSimpleName();
        String name = this.token.tokenString;
        this.read();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name};
        return new StatementSession(63, args);
    }

    private Statement compileReleaseSavepoint() {
        this.read();
        this.readThis(244);
        String name = this.token.tokenString;
        this.read();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name};
        return new StatementSession(57, args);
    }

    private Statement compileSessionSettings() {
        if (this.token.tokenType == 354) {
            this.read();
            this.readThis(9);
            Object[] args = this.processTransactionCharacteristics();
            return new StatementSession(109, args);
        }
        if (this.token.tokenType == 14) {
            this.read();
            Expression e = this.XreadValueSpecificationOrNull();
            if (e == null) {
                throw Error.error(5584);
            }
            e.resolveTypes(this.session, null);
            if (e.isParam()) {
                e.dataType = Type.SQL_VARCHAR;
            }
            if (e.dataType == null || !e.dataType.isCharacterType()) {
                throw Error.error(5565);
            }
            Expression[] args = new Expression[]{e, null};
            return new StatementSession(76, args);
        }
        throw this.unexpectedToken();
    }

    private Statement compileSetRole() {
        Expression e;
        if (this.token.tokenType == 179) {
            this.read();
            e = new ExpressionValue(null, Type.SQL_VARCHAR);
        } else {
            e = this.XreadValueSpecificationOrNull();
            if (e == null) {
                throw Error.error(4100);
            }
            if (!e.getDataType().isCharacterType()) {
                throw Error.error(2200);
            }
            if (!(e.getType() == 1 || e.getType() == 28 && ((FunctionSQL)e).isValueFunction())) {
                throw Error.error(2200);
            }
        }
        String sql = this.getLastPart();
        return new StatementSession(73, new Expression[]{e});
    }

    private Statement compileSetTimeZone() {
        Expression e;
        this.readThis(546);
        if (this.token.tokenType == 155) {
            this.read();
            e = new ExpressionValue(null, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
        } else {
            e = this.XreadIntervalValueExpression();
            HsqlList unresolved = e.resolveColumnReferences(RangeVariable.emptyArray, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            e.resolveTypes(this.session, null);
            if (e.dataType == null) {
                throw Error.error(5565);
            }
            if (e.dataType.typeCode != 111) {
                throw Error.error(5565);
            }
        }
        String sql = this.getLastPart();
        return new StatementSession(71, new Expression[]{e});
    }

    private Statement compileShutdown() {
        this.session.checkAdmin();
        int closemode = 0;
        this.read();
        switch (this.token.tokenType) {
            case 574: {
                closemode = -1;
                this.read();
                break;
            }
            case 561: {
                closemode = 1;
                this.read();
                break;
            }
            case 592: {
                closemode = 2;
                this.read();
            }
        }
        if (this.token.tokenType == 699) {
            this.read();
        }
        if (this.token.tokenType != 748) {
            throw this.unexpectedToken();
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{new Integer(closemode)};
        StatementCommand cs = new StatementCommand(1003, args, null, null);
        return cs;
    }

    private Statement compileBackup() {
        this.read();
        this.readThis(564);
        this.readThis(283);
        this.checkIsValue();
        String path = this.readQuotedString();
        Boolean blockingMode = null;
        Boolean scriptMode = null;
        Boolean compression = null;
        block6: while (true) {
            switch (this.token.tokenType) {
                case 555: {
                    if (blockingMode != null) {
                        throw this.unexpectedToken();
                    }
                    blockingMode = Boolean.TRUE;
                    this.read();
                    continue block6;
                }
                case 592: {
                    if (scriptMode != null) {
                        throw this.unexpectedToken();
                    }
                    scriptMode = Boolean.TRUE;
                    this.read();
                    continue block6;
                }
                case 562: {
                    if (compression != null) {
                        throw this.unexpectedToken();
                    }
                    compression = Boolean.TRUE;
                    this.read();
                    continue block6;
                }
                case 181: {
                    this.read();
                    if (this.token.tokenType == 562) {
                        if (compression != null) {
                            throw this.unexpectedToken();
                        }
                        compression = Boolean.FALSE;
                        this.read();
                        continue block6;
                    }
                    if (this.token.tokenType == 555) {
                        blockingMode = Boolean.FALSE;
                        this.read();
                        continue block6;
                    }
                    throw this.unexpectedToken();
                }
            }
            break;
        }
        if (scriptMode != null) {
            throw this.unsupportedFeature("SCRIPT");
        }
        scriptMode = Boolean.FALSE;
        if (blockingMode == null) {
            throw this.unexpectedTokenRequire("BLOCKING");
        }
        if (compression == null) {
            compression = Boolean.TRUE;
        }
        StatementCommand cs = new StatementCommand(1001, new Object[]{path, blockingMode, scriptMode, compression}, null, null);
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        cs.writeTableNames = names;
        return cs;
    }

    private Statement compileCheckpoint() {
        boolean defrag = false;
        this.read();
        if (this.token.tokenType == 565) {
            defrag = true;
            this.read();
        } else if (this.token.tokenType == 699) {
            this.read();
        }
        if (this.token.tokenType != 748) {
            throw this.unexpectedToken();
        }
        String sql = this.getLastPart();
        return ParserCommand.getCheckpointStatement(this.database, defrag);
    }

    public static Statement getCheckpointStatement(Database database, boolean defrag) {
        Object[] args = new Object[]{defrag};
        StatementCommand cs = new StatementCommand(1002, args, null, null);
        HsqlNameManager.HsqlName[] names = database.schemaManager.getCatalogAndBaseTableNames();
        cs.writeTableNames = names;
        return cs;
    }

    private Statement compileDisconnect() {
        this.read();
        String sql = "DISCONNECT";
        StatementSession cs = new StatementSession(22, (Object[])null);
        return cs;
    }

    private Statement compileExplainPlan() {
        this.read();
        this.readThis(587);
        this.readThis(111);
        Statement cs = this.compilePart();
        cs.writeTableNames = HsqlNameManager.HsqlName.emptyArray;
        cs.readTableNames = HsqlNameManager.HsqlName.emptyArray;
        cs.setDescribe();
        return cs;
    }

    private Statement compileTextTableSource(Table t) {
        String sql;
        boolean isSourceHeader = false;
        boolean isDesc = false;
        Object[] args = new Object[5];
        args[0] = t.tableName;
        if (!t.isText()) {
            HsqlException e = Error.error(321);
        }
        if (this.token.tokenType == 192) {
            this.read();
            sql = this.getLastPart();
            args[1] = Boolean.TRUE;
            return new StatementCommand(1069, args, null, t.getName());
        }
        if (this.token.tokenType == 585) {
            this.read();
            sql = this.getLastPart();
            args[1] = Boolean.FALSE;
            return new StatementCommand(1069, args, null, t.getName());
        }
        if (this.token.tokenType == 572) {
            this.read();
            isSourceHeader = true;
        }
        if (!(this.token.tokenType == 747 || this.token.tokenType == 745 && this.token.dataType.isCharacterType())) {
            throw Error.error(5581);
        }
        String source = this.token.tokenString;
        this.read();
        if (!isSourceHeader && this.token.tokenType == 389) {
            isDesc = true;
            this.read();
        }
        sql = this.getLastPart();
        args[2] = source;
        args[3] = isDesc;
        args[4] = isSourceHeader;
        int type = isSourceHeader ? 1070 : 1069;
        return new StatementCommand(type, args, null, t.getName());
    }
}

