/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;

public class Library {
    private Library() {
    }

    public static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(d);
        int len = sb.length();
        if (len < 16) {
            return d;
        }
        char cx = sb.charAt(len - 1);
        char c1 = sb.charAt(len - 2);
        char c2 = sb.charAt(len - 3);
        char c3 = sb.charAt(len - 4);
        if (c1 == '0' && c2 == '0' && c3 == '0' && cx != '.') {
            sb.setCharAt(len - 1, '0');
        } else if (c1 == '9' && c2 == '9' && c3 == '9' && cx != '.') {
            sb.setCharAt(len - 1, '9');
            sb.append('9');
            sb.append('9');
        }
        return Double.valueOf(sb.toString());
    }

    public static double round(double d, int p) {
        double f = Math.pow(10.0, p);
        return (double)Math.round(d * f) / f;
    }

    public static String character(int code) {
        return String.valueOf((char)code);
    }

    public static int difference(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0;
        }
        s1 = Library.soundex(s1);
        s2 = Library.soundex(s2);
        int e = 0;
        for (int i = 0; i < 4; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            ++e;
        }
        return e;
    }

    public static int locate(String search, String s, Integer start) {
        if (s == null || search == null) {
            return 0;
        }
        int i = start == null ? 0 : start - 1;
        return s.indexOf(search, i < 0 ? 0 : i) + 1;
    }

    public static String repeat(String s, Integer count) {
        if (s == null || count == null || count < 0) {
            return null;
        }
        int i = count;
        StringBuffer sb = new StringBuffer(s.length() * i);
        while (i-- > 0) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String replace(String s, String replace, String with) {
        if (s == null || replace == null) {
            return s;
        }
        if (with == null) {
            with = "";
        }
        StringBuffer b = new StringBuffer();
        int start = 0;
        int lenreplace = replace.length();
        while (true) {
            int i;
            if ((i = s.indexOf(replace, start)) == -1) break;
            b.append(s.substring(start, i));
            b.append(with);
            start = i + lenreplace;
        }
        b.append(s.substring(start));
        return b.toString();
    }

    public static String soundex(String s) {
        if (s == null) {
            return s;
        }
        s = s.toUpperCase(Locale.ENGLISH);
        int len = s.length();
        char[] b = new char[]{'0', '0', '0', '0'};
        int lastdigit = 48;
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            int newdigit;
            char c = s.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                newdigit = 55;
            } else if (c == 'H' || c == 'W') {
                newdigit = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                newdigit = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                newdigit = 50;
            } else if (c == 'D' || c == 'T') {
                newdigit = 51;
            } else if (c == 'L') {
                newdigit = 52;
            } else if (c == 'M' || c == 'N') {
                newdigit = 53;
            } else {
                if (c != 'R') continue;
                newdigit = 54;
            }
            if (j == 0) {
                b[j++] = c;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit <= 54) {
                if (newdigit == lastdigit) continue;
                b[j++] = newdigit;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit != 55) continue;
            lastdigit = newdigit;
        }
        return new String(b, 0, 4);
    }

    public static String getDatabaseFullProductVersion() {
        return "1.9.0.0";
    }

    public static String getDatabaseProductName() {
        return "HSQL Database Engine";
    }

    public static String getDatabaseProductVersion() {
        return "1.9.0";
    }

    public static int getDatabaseMajorVersion() {
        return 1;
    }

    public static int getDatabaseMinorVersion() {
        return 9;
    }
}

