/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.types.Type;

public class ExpressionColumn
extends Expression {
    public static final ExpressionColumn[] emptyArray = new ExpressionColumn[0];
    ColumnSchema column;
    String schema;
    String tableName;
    String columnName;
    RangeVariable rangeVariable;
    NumberSequence sequence;
    boolean isWritable;

    ExpressionColumn(String schema, String table, String column) {
        super(2);
        this.schema = schema;
        this.tableName = table;
        this.columnName = column;
    }

    ExpressionColumn(ColumnSchema column) {
        super(2);
        this.columnName = column.getName().name;
    }

    ExpressionColumn(RangeVariable rangeVar, ColumnSchema column) {
        super(2);
        this.columnIndex = rangeVar.rangeTable.findColumn(column.getName().name);
        this.setAttributesAsColumn(rangeVar, this.columnIndex);
    }

    ExpressionColumn(RangeVariable rangeVar, ColumnSchema column, int index) {
        super(2);
        this.columnIndex = index;
        this.setAttributesAsColumn(rangeVar, this.columnIndex);
    }

    ExpressionColumn(Expression e, int colIndex, int rangePosition) {
        super(5);
        this.dataType = e.dataType;
        this.columnIndex = colIndex;
        this.alias = e.alias;
        this.rangePosition = rangePosition;
    }

    ExpressionColumn() {
        super(9);
    }

    ExpressionColumn(int type) {
        super(type);
        if (type == 8) {
            this.isParam = true;
        }
    }

    ExpressionColumn(Expression[] nodes, String name) {
        super(3);
        this.nodes = nodes;
        this.columnName = name;
    }

    ExpressionColumn(String schema, String table) {
        super(97);
        this.schema = schema;
        this.tableName = table;
    }

    ExpressionColumn(NumberSequence sequence) {
        super(10);
        this.sequence = sequence;
        this.dataType = sequence.getDataType();
    }

    void setAttributesAsColumn(RangeVariable range, int i) {
        if (range.variables != null) {
            this.columnIndex = i;
            this.column = range.getColumn(i);
            this.dataType = this.column.getDataType();
            this.rangeVariable = range;
        } else {
            Table t = range.getTable();
            this.columnIndex = i;
            this.column = range.getColumn(i);
            this.dataType = this.column.getDataType();
            this.columnName = this.column.getName().name;
            this.tableName = t.getName().name;
            this.schema = t.getSchemaName().name;
            if (this.alias == null && range.hasColumnAlias()) {
                this.alias = range.getColumnAliasName(i);
            }
            this.rangeVariable = range;
            this.rangeVariable.addColumn(this.columnIndex);
        }
    }

    @Override
    void setAttributesAsColumn(ColumnSchema column, boolean isWritable) {
        this.column = column;
        this.dataType = column.getDataType();
        this.isWritable = isWritable;
    }

    @Override
    HsqlNameManager.SimpleName getSimpleName() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.column != null) {
            return this.column.getName();
        }
        if (this.opType == 3) {
            return this.nodes[0].getSimpleName();
        }
        return null;
    }

    @Override
    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        if (this.opType == 2) {
            return this.columnName;
        }
        if (this.opType == 3) {
            return this.columnName;
        }
        return "";
    }

    public String getBaseColumnName() {
        if (this.opType == 2 && this.rangeVariable != null) {
            return this.rangeVariable.getTable().getColumn((int)this.columnIndex).getName().name;
        }
        return null;
    }

    public HsqlNameManager.HsqlName getBaseColumnHsqlName() {
        return this.column.getName();
    }

    @Override
    void collectObjectNames(Set set) {
        switch (this.opType) {
            case 10: {
                HsqlNameManager.HsqlName name = ((NumberSequence)this.valueData).getName();
                set.add(name);
                return;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 97: {
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                set.add(this.column.getName());
                if (this.column.getName().parent != null) {
                    set.add(this.column.getName().parent);
                }
                return;
            }
        }
    }

    @Override
    String getColumnName() {
        if (this.opType == 2 && this.column != null) {
            return this.column.getName().name;
        }
        return this.getAlias();
    }

    @Override
    ColumnSchema getColumn() {
        return this.column;
    }

    String getSchemaName() {
        return this.schema;
    }

    @Override
    RangeVariable getRangeVariable() {
        return this.rangeVariable;
    }

    @Override
    public HsqlList resolveColumnReferences(RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        switch (this.opType) {
            case 10: {
                if (acceptsSequences) break;
                throw Error.error(5598);
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 97: {
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                if (this.rangeVariable != null) {
                    return unresolvedSet;
                }
                for (int i = 0; i < rangeCount; ++i) {
                    RangeVariable rangeVar = rangeVarArray[i];
                    if (rangeVar == null || !this.resolveColumnReference(rangeVar)) continue;
                    return unresolvedSet;
                }
                if (unresolvedSet == null) {
                    unresolvedSet = new ArrayListIdentity();
                }
                unresolvedSet.add(this);
            }
        }
        return unresolvedSet;
    }

    public boolean resolveColumnReference(RangeVariable rangeVar) {
        if (this.tableName == null) {
            ExpressionColumn e = rangeVar.getColumnExpression(this.columnName);
            if (e != null) {
                this.opType = e.opType;
                this.nodes = e.nodes;
                this.dataType = e.dataType;
                return true;
            }
            if (rangeVar.variables != null) {
                int colIndex = rangeVar.findColumn(this.columnName);
                if (colIndex == -1) {
                    return false;
                }
                ColumnSchema column = rangeVar.getColumn(colIndex);
                if (column.getParameterMode() == 4) {
                    return false;
                }
                this.opType = rangeVar.isVariable ? 6 : 7;
                this.setAttributesAsColumn(rangeVar, colIndex);
                return true;
            }
        }
        if (!rangeVar.resolvesTableName(this)) {
            return false;
        }
        int colIndex = rangeVar.findColumn(this.columnName);
        if (colIndex != -1) {
            this.setAttributesAsColumn(rangeVar, colIndex);
            return true;
        }
        return false;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        switch (this.opType) {
            case 4: {
                if (parent == null || parent.opType == 25) break;
                throw Error.error(5544);
            }
            case 3: {
                Type type = null;
                for (int i = 0; i < this.nodes.length; ++i) {
                    type = Type.getAggregateType(this.nodes[i].dataType, type);
                }
                this.dataType = type;
                break;
            }
        }
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 4: {
                return null;
            }
            case 6: {
                return session.sessionContext.routineVariables[this.columnIndex];
            }
            case 7: {
                return session.sessionContext.routineArguments[this.columnIndex];
            }
            case 2: {
                Object[] data = session.sessionContext.rangeIterators[this.rangeVariable.rangePosition].getCurrent();
                Object value = data[this.columnIndex];
                Type colType = this.column.getDataType();
                if (!this.dataType.equals(colType)) {
                    value = this.dataType.convertToType(session, value, colType);
                }
                return value;
            }
            case 5: {
                Object[] data = session.sessionContext.rangeIterators[this.rangePosition].getCurrent();
                return data[this.columnIndex];
            }
            case 3: {
                Object value = null;
                for (int i = 0; i < this.nodes.length; ++i) {
                    value = this.nodes[i].getValue(session, this.dataType);
                    if (value == null) continue;
                    return value;
                }
                return value;
            }
            case 8: {
                return session.sessionContext.dynamicArguments[this.parameterIndex];
            }
            case 10: {
                return session.sessionData.getSequenceValue(this.sequence);
            }
        }
        throw Error.runtimeError(401, "ExpressionColumn");
    }

    @Override
    public String getSQL() {
        switch (this.opType) {
            case 4: {
                return "DEFAULT";
            }
            case 8: {
                return "?";
            }
            case 9: {
                return "*";
            }
            case 3: {
                return this.alias.getStatementName();
            }
            case 2: 
            case 6: 
            case 7: {
                if (this.column == null) {
                    if (this.alias != null) {
                        return this.alias.getStatementName();
                    }
                    return this.columnName;
                }
                if (this.rangeVariable.tableAlias == null) {
                    return this.column.getName().getSchemaQualifiedStatementName();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(this.rangeVariable.tableAlias.getStatementName());
                sb.append('.');
                sb.append(this.column.getName().statementName);
                return sb.toString();
            }
            case 97: {
                if (this.nodes.length == 0) {
                    return "*";
                }
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.nodes.length; ++i) {
                    Expression e = this.nodes[i];
                    if (i > 0) {
                        sb.append(',');
                    }
                    String s = e.getSQL();
                    sb.append(s);
                }
                return sb.toString();
            }
        }
        throw Error.runtimeError(401, "ExpressionColumn");
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 4: {
                sb.append("DEFAULT");
                break;
            }
            case 9: {
                sb.append("OpTypes.ASTERISK ");
                break;
            }
            case 6: {
                sb.append("VARIABLE: ");
                sb.append(this.column.getName().name);
                break;
            }
            case 7: {
                sb.append("PARAMETER").append(": ");
                sb.append(this.column.getName().name);
                break;
            }
            case 3: {
                sb.append("COLUMN").append(": ");
                sb.append(this.columnName);
                if (this.alias == null) break;
                sb.append(" AS ").append(this.alias.name);
                break;
            }
            case 2: {
                sb.append("COLUMN").append(": ");
                sb.append(this.column.getName().name);
                if (this.alias != null) {
                    sb.append(" AS ").append(this.alias.name);
                }
                sb.append(' ').append("TABLE").append(": ").append(this.tableName);
                break;
            }
            case 8: {
                sb.append("DYNAMIC PARAM: ");
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                break;
            }
            case 10: {
                sb.append("SEQUENCE").append(": ");
                sb.append(this.sequence.getName().name);
                break;
            }
        }
        return sb.toString();
    }

    String getTableName() {
        if (this.opType == 97) {
            return this.tableName;
        }
        if (this.opType == 2) {
            if (this.rangeVariable == null) {
                return this.tableName;
            }
            return this.rangeVariable.getTable().getName().name;
        }
        return "";
    }

    static void checkColumnsResolved(HsqlList set) {
        if (set != null && !set.isEmpty()) {
            ExpressionColumn e = (ExpressionColumn)set.get(0);
            StringBuffer sb = new StringBuffer();
            if (e.schema != null) {
                sb.append(e.schema + '.');
            }
            if (e.tableName != null) {
                sb.append(e.tableName + '.');
            }
            throw Error.error(5501, sb.toString() + e.getColumnName());
        }
    }

    @Override
    public OrderedHashSet getUnkeyedColumns(OrderedHashSet unresolvedSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].getUnkeyedColumns(unresolvedSet);
        }
        if (this.opType == 2 && !this.rangeVariable.hasKeyedColumnInGroupBy) {
            if (unresolvedSet == null) {
                unresolvedSet = new OrderedHashSet();
            }
            unresolvedSet.add(this);
        }
        return unresolvedSet;
    }

    @Override
    void collectRangeVariables(RangeVariable[] rangeVariables, Set set) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].collectRangeVariables(rangeVariables, set);
        }
        if (this.rangeVariable != null) {
            for (i = 0; i < rangeVariables.length; ++i) {
                if (rangeVariables[i] != this.rangeVariable) continue;
                set.add(rangeVariables[i]);
                break;
            }
        }
    }

    @Override
    Expression replaceAliasInOrderBy(Expression[] columns, int length) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceAliasInOrderBy(columns, length);
        }
        switch (this.opType) {
            case 2: 
            case 3: {
                for (i = 0; i < length; ++i) {
                    String alias;
                    HsqlNameManager.SimpleName aliasName = columns[i].alias;
                    String string = alias = aliasName == null ? null : aliasName.name;
                    if (this.schema != null || this.tableName != null || !this.columnName.equals(alias)) continue;
                    return columns[i];
                }
                for (i = 0; i < length; ++i) {
                    if (!(columns[i] instanceof ExpressionColumn)) continue;
                    if (this.equals(columns[i])) {
                        return columns[i];
                    }
                    if (this.tableName != null || this.schema != null || !this.columnName.equals(((ExpressionColumn)columns[i]).columnName)) continue;
                    return columns[i];
                }
                break;
            }
        }
        return this;
    }

    @Override
    Expression replaceColumnReferences(RangeVariable range, Expression[] list) {
        if (this.opType == 2 && this.rangeVariable == range) {
            return list[this.columnIndex];
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceColumnReferences(range, list);
        }
        return this;
    }

    @Override
    int findMatchingRangeVariableIndex(RangeVariable[] rangeVarArray) {
        for (int i = 0; i < rangeVarArray.length; ++i) {
            RangeVariable rangeVar = rangeVarArray[i];
            if (!rangeVar.resolvesTableName(this)) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean hasReference(RangeVariable range) {
        if (range == this.rangeVariable) {
            return true;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].hasReference(range)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Expression other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.opType != other.opType) {
            return false;
        }
        switch (this.opType) {
            case 5: {
                return this.columnIndex == other.columnIndex;
            }
            case 3: {
                return this.nodes == other.nodes;
            }
            case 2: {
                return this.column == other.getColumn();
            }
        }
        return false;
    }
}

