/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.store.ValuePool;

public class ExpressionAggregate
extends Expression {
    boolean isDistinctAggregate;

    ExpressionAggregate(int type, boolean distinct, Expression e) {
        super(type);
        this.nodes = new Expression[1];
        this.isDistinctAggregate = distinct;
        this.nodes[0] = e;
    }

    ExpressionAggregate(ExpressionAggregate e) {
        super(e.opType);
        this.isDistinctAggregate = e.isDistinctAggregate;
        this.nodes = e.nodes;
    }

    @Override
    boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        String left = ExpressionAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 71: {
                sb.append(' ').append("COUNT").append('(');
                break;
            }
            case 72: {
                sb.append(' ').append("SUM").append('(');
                sb.append(left).append(')');
                break;
            }
            case 73: {
                sb.append(' ').append("MIN").append('(');
                sb.append(left).append(')');
                break;
            }
            case 74: {
                sb.append(' ').append("MAX").append('(');
                sb.append(left).append(')');
                break;
            }
            case 75: {
                sb.append(' ').append("AVG").append('(');
                sb.append(left).append(')');
                break;
            }
            case 76: {
                sb.append(' ').append("EVERY").append('(');
                sb.append(left).append(')');
                break;
            }
            case 77: {
                sb.append(' ').append("SOME").append('(');
                sb.append(left).append(')');
                break;
            }
            case 78: {
                sb.append(' ').append("STDDEV_POP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 79: {
                sb.append(' ').append("STDDEV_SAMP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 80: {
                sb.append(' ').append("VAR_POP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 81: {
                sb.append(' ').append("VAR_SAMP").append('(');
                sb.append(left).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(401, "ExpressionAggregate");
            }
        }
        return sb.toString();
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 71: {
                sb.append("COUNT ");
                break;
            }
            case 72: {
                sb.append("SUM ");
                break;
            }
            case 73: {
                sb.append("MIN ");
                break;
            }
            case 74: {
                sb.append("MAX ");
                break;
            }
            case 75: {
                sb.append("AVG ");
                break;
            }
            case 76: {
                sb.append("EVERY").append(' ');
                break;
            }
            case 77: {
                sb.append("SOME").append(' ');
                break;
            }
            case 78: {
                sb.append("STDDEV_POP").append(' ');
                break;
            }
            case 79: {
                sb.append("STDDEV_SAMP").append(' ');
                break;
            }
            case 80: {
                sb.append("VAR_POP").append(' ');
                break;
            }
            case 81: {
                sb.append("VAR_SAMP").append(' ');
            }
        }
        if (this.nodes[0] != null) {
            sb.append(" arg=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (unresolvedSet == null) {
            unresolvedSet = new ArrayListIdentity();
        }
        unresolvedSet.add(this);
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].isParam) {
            throw Error.error(5567);
        }
        this.dataType = SetFunction.getType(this.opType, this.nodes[0].dataType);
    }

    @Override
    public boolean equals(Expression other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.opType == other.opType && this.exprSubType == other.exprSubType && this.isDistinctAggregate == ((ExpressionAggregate)other).isDistinctAggregate && ExpressionAggregate.equals(this.nodes, other.nodes);
    }

    public Object updateAggregatingValue(Session session, Object currValue) {
        if (currValue == null) {
            currValue = new SetFunction(this.opType, this.nodes[0].dataType, this.isDistinctAggregate);
        }
        Integer newValue = this.nodes[0].opType == 9 ? ValuePool.INTEGER_1 : this.nodes[0].getValue(session);
        ((SetFunction)currValue).add(session, newValue);
        return currValue;
    }

    public Object getAggregatedValue(Session session, Object currValue) {
        if (currValue == null) {
            return this.opType == 71 ? ValuePool.INTEGER_0 : null;
        }
        return ((SetFunction)currValue).getValue(session);
    }
}

