/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.NullType;
import org.hsqldb.types.Type;

public class Expression {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    static final Expression[] emptyExpressionArray = new Expression[0];
    static final Expression EXPR_TRUE = new ExpressionLogical(true);
    static final Expression EXPR_FALSE = new ExpressionLogical(false);
    static final OrderedIntHashSet aggregateFunctionSet = new OrderedIntHashSet();
    static final OrderedIntHashSet columnExpressionSet;
    static final OrderedIntHashSet subqueryExpressionSet;
    static final OrderedIntHashSet subqueryAggregateExpressionSet;
    static final OrderedIntHashSet emptyExpressionSet;
    protected int opType;
    protected int exprSubType;
    HsqlNameManager.SimpleName alias;
    protected boolean isAggregate;
    protected Object valueData;
    protected Expression[] nodes;
    Type[] nodeDataTypes;
    SubQuery subQuery;
    boolean isCorrelated;
    int columnIndex = -1;
    protected Type dataType;
    int queryTableColumnIndex = -1;
    boolean isParam;
    int parameterIndex = -1;
    int rangePosition = -1;
    boolean isColumnEqual;

    Expression(int type) {
        this.opType = type;
        this.nodes = emptyExpressionArray;
    }

    Expression(int exprType, SubQuery sq) {
        this(23);
        this.subQuery = sq;
    }

    Expression(int type, Expression[] list) {
        this(type);
        this.nodes = list;
    }

    public String describe(Session session) {
        return this.describe(session, 0);
    }

    static String getContextSQL(Expression expression) {
        if (expression == null) {
            return null;
        }
        String ddl = expression.getSQL();
        switch (expression.opType) {
            case 1: 
            case 2: 
            case 25: 
            case 27: 
            case 28: 
            case 91: 
            case 93: 
            case 96: {
                return ddl;
            }
        }
        StringBuffer sb = new StringBuffer();
        ddl = sb.append('(').append(ddl).append(')').toString();
        return ddl;
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 25: {
                sb.append('(');
                for (int i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].getSQL());
                    if (i >= this.nodes.length - 1) continue;
                    sb.append(',');
                }
                sb.append(')');
                return sb.toString();
            }
            case 26: {
                for (int i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].getSQL());
                    if (i >= this.nodes.length - 1) continue;
                    sb.append(',');
                }
                return sb.toString();
            }
        }
        switch (this.opType) {
            case 22: 
            case 23: {
                break;
            }
            default: {
                throw Error.runtimeError(401, "Expression");
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        int i;
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 22: 
            case 23: {
                sb.append("QUERY ");
                sb.append(this.subQuery.queryExpression.describe(session));
                return sb.toString();
            }
            case 25: {
                sb.append("ROW = ");
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + 1));
                }
                sb.append("), TYPE = ").append(this.dataType.getNameString());
                break;
            }
            case 26: {
                sb.append("VALUELIST ");
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + 1));
                    sb.append(' ');
                }
                break;
            }
        }
        if (this.nodes[0] != null) {
            sb.append(" arg_left=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.nodes[1] != null) {
            sb.append(" arg_right=[");
            sb.append(this.nodes[1].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    void setDataType(Session session, Type type) {
        if (this.opType == 1) {
            this.valueData = type.convertToType(session, this.valueData, this.dataType);
        }
        this.dataType = type;
    }

    public boolean equals(Expression other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.opType != other.opType || this.exprSubType != other.exprSubType || !Expression.equals(this.dataType, other.dataType)) {
            return false;
        }
        switch (this.opType) {
            case 5: {
                return this.columnIndex == other.columnIndex;
            }
            case 1: {
                return Expression.equals(this.valueData, other.valueData);
            }
        }
        return Expression.equals(this.nodes, other.nodes) && Expression.equals(this.subQuery, other.subQuery);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Expression) {
            return this.equals((Expression)other);
        }
        return false;
    }

    public int hashCode() {
        int val = this.opType + this.exprSubType;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            val += this.nodes[i].hashCode();
        }
        return val;
    }

    static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static boolean equals(Expression[] row1, Expression[] row2) {
        if (row1 == row2) {
            return true;
        }
        if (row1.length != row2.length) {
            return false;
        }
        int len = row1.length;
        for (int i = 0; i < len; ++i) {
            boolean equals;
            Expression e1 = row1[i];
            Expression e2 = row2[i];
            boolean bl = e1 == null ? e2 == null : (equals = e1.equals(e2));
            if (equals) continue;
            return false;
        }
        return true;
    }

    boolean isComposedOf(Expression[] exprList, int start, int end, OrderedIntHashSet excludeSet) {
        if (this.opType == 1) {
            return true;
        }
        if (excludeSet.contains(this.opType)) {
            return true;
        }
        for (int i = start; i < end; ++i) {
            if (!this.equals(exprList[i])) continue;
            return true;
        }
        switch (this.opType) {
            case 22: 
            case 23: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                return false;
            }
        }
        if (this.nodes.length == 0) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < this.nodes.length; ++i) {
            result &= this.nodes[i] == null || this.nodes[i].isComposedOf(exprList, start, end, excludeSet);
        }
        return result;
    }

    boolean isComposedOf(OrderedHashSet expressions, OrderedIntHashSet excludeSet) {
        if (this.opType == 1) {
            return true;
        }
        if (excludeSet.contains(this.opType)) {
            return true;
        }
        for (int i = 0; i < expressions.size(); ++i) {
            if (!this.equals(expressions.get(i))) continue;
            return true;
        }
        switch (this.opType) {
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                return false;
            }
        }
        if (this.nodes.length == 0) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < this.nodes.length; ++i) {
            result &= this.nodes[i] == null || this.nodes[i].isComposedOf(expressions, excludeSet);
        }
        return result;
    }

    Expression replace(OrderedHashSet expressions, OrderedHashSet replacements) {
        if (this.opType == 1) {
            return this;
        }
        int index = expressions.getIndex(this);
        if (index != -1) {
            return (Expression)replacements.get(index);
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replace(expressions, replacements);
        }
        return this;
    }

    Expression replaceColumnReferences(RangeVariable range, Expression[] list) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceColumnReferences(range, list);
        }
        return this;
    }

    void convertToSimpleColumn(OrderedHashSet expressions, OrderedHashSet replacements) {
        if (this.opType == 1) {
            return;
        }
        int index = expressions.getIndex(this);
        if (index != -1) {
            Expression e = (Expression)replacements.get(index);
            this.nodes = emptyExpressionArray;
            this.opType = 5;
            this.columnIndex = e.columnIndex;
            this.rangePosition = e.rangePosition;
            return;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].convertToSimpleColumn(expressions, replacements);
        }
    }

    boolean isSelfAggregate() {
        return false;
    }

    void setAlias(HsqlNameManager.SimpleName name) {
        this.alias = name;
    }

    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        return "";
    }

    HsqlNameManager.SimpleName getSimpleName() {
        if (this.alias != null) {
            return this.alias;
        }
        return null;
    }

    public int getType() {
        return this.opType;
    }

    Expression getLeftNode() {
        return this.nodes.length > 0 ? this.nodes[0] : null;
    }

    Expression getRightNode() {
        return this.nodes.length > 1 ? this.nodes[1] : null;
    }

    void setLeftNode(Expression e) {
        this.nodes[0] = e;
    }

    void setRightNode(Expression e) {
        this.nodes[1] = e;
    }

    RangeVariable getRangeVariable() {
        return null;
    }

    Expression replaceAliasInOrderBy(Expression[] columns, int length) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceAliasInOrderBy(columns, length);
        }
        return this;
    }

    int findMatchingRangeVariableIndex(RangeVariable[] rangeVarArray) {
        return -1;
    }

    void collectRangeVariables(RangeVariable[] rangeVariables, Set set) {
        HsqlList unresolvedExpressions;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].collectRangeVariables(rangeVariables, set);
        }
        if (this.subQuery != null && this.subQuery.queryExpression != null && (unresolvedExpressions = this.subQuery.queryExpression.getUnresolvedExpressions()) != null) {
            for (int i = 0; i < unresolvedExpressions.size(); ++i) {
                Expression e = (Expression)unresolvedExpressions.get(i);
                e.collectRangeVariables(rangeVariables, set);
            }
        }
    }

    void collectObjectNames(Set set) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].collectObjectNames(set);
        }
        if (this.subQuery != null && this.subQuery.queryExpression != null) {
            this.subQuery.queryExpression.collectObjectNames(set);
        }
    }

    boolean hasReference(RangeVariable range) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].hasReference(range)) continue;
            return true;
        }
        return this.subQuery != null && this.subQuery.queryExpression != null && this.subQuery.queryExpression.hasReference(range);
    }

    public HsqlList resolveColumnReferences(RangeVariable[] rangeVarArray, HsqlList unresolvedSet) {
        return this.resolveColumnReferences(rangeVarArray, rangeVarArray.length, unresolvedSet, true);
    }

    public HsqlList resolveColumnReferences(RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        switch (this.opType) {
            case 93: {
                acceptsSequences = false;
                break;
            }
            case 26: {
                int i;
                HsqlList localSet = null;
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    localSet = this.nodes[i].resolveColumnReferences(RangeVariable.emptyArray, localSet);
                }
                if (localSet != null) {
                    this.isCorrelated = true;
                    if (this.subQuery != null) {
                        this.subQuery.setCorrelated();
                    }
                    for (i = 0; i < localSet.size(); ++i) {
                        Expression e = (Expression)localSet.get(i);
                        unresolvedSet = e.resolveColumnReferences(rangeVarArray, unresolvedSet);
                    }
                    unresolvedSet = Expression.resolveColumnSet(rangeVarArray, localSet, unresolvedSet);
                }
                return unresolvedSet;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        switch (this.opType) {
            case 22: 
            case 23: {
                QueryExpression queryExpression = this.subQuery.queryExpression;
                if (queryExpression.areColumnsResolved()) break;
                this.isCorrelated = true;
                this.subQuery.setCorrelated();
                if (unresolvedSet == null) {
                    unresolvedSet = new ArrayListIdentity();
                }
                unresolvedSet.addAll(queryExpression.getUnresolvedExpressions());
                break;
            }
        }
        return unresolvedSet;
    }

    public OrderedHashSet getUnkeyedColumns(OrderedHashSet unresolvedSet) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].getUnkeyedColumns(unresolvedSet);
        }
        switch (this.opType) {
            case 22: 
            case 23: {
                if (this.subQuery == null) break;
                if (unresolvedSet == null) {
                    unresolvedSet = new OrderedHashSet();
                }
                unresolvedSet.add(this);
            }
        }
        return unresolvedSet;
    }

    public void resolveTypes(Session session, Expression parent) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 26: {
                break;
            }
            case 25: {
                this.nodeDataTypes = new Type[this.nodes.length];
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    this.nodeDataTypes[i] = this.nodes[i].dataType;
                }
                break;
            }
            case 22: 
            case 23: {
                QueryExpression queryExpression = this.subQuery.queryExpression;
                queryExpression.resolveTypes(session);
                this.subQuery.prepareTable(session);
                this.nodeDataTypes = queryExpression.getColumnTypes();
                this.dataType = this.nodeDataTypes[0];
                break;
            }
            default: {
                throw Error.runtimeError(401, "Expression");
            }
        }
    }

    void setAsConstantValue(Session session) {
        this.valueData = this.getConstantValue(session);
        this.opType = 1;
        this.nodes = emptyExpressionArray;
    }

    void setAsConstantValue(Object value) {
        this.valueData = value;
        this.opType = 1;
        this.nodes = emptyExpressionArray;
    }

    void prepareTable(Session session, Expression row, int degree) {
        if (this.nodeDataTypes != null) {
            return;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            if (e.opType == 25) {
                if (degree == e.nodes.length) continue;
                throw Error.error(5564);
            }
            if (degree == 1) {
                this.nodes[i] = new Expression(25);
                this.nodes[i].nodes = new Expression[]{e};
                continue;
            }
            throw Error.error(5564);
        }
        this.nodeDataTypes = new Type[degree];
        for (int j = 0; j < degree; ++j) {
            int i;
            Type type = row == null ? null : row.nodes[j].dataType;
            for (i = 0; i < this.nodes.length; ++i) {
                type = Type.getAggregateType(this.nodes[i].nodes[j].dataType, type);
            }
            if (type == null) {
                throw Error.error(5567);
            }
            this.nodeDataTypes[j] = type;
            if (row != null && row.nodes[j].isParam) {
                row.nodes[j].dataType = type;
            }
            for (i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i].nodes[j].isParam) {
                    this.nodes[i].nodes[j].dataType = this.nodeDataTypes[j];
                    continue;
                }
                if (this.nodes[i].nodes[j].opType != 1 || this.nodes[i].nodes[j].valueData != null) continue;
                this.nodes[i].nodes[j].dataType = this.nodeDataTypes[j];
            }
            if (this.nodeDataTypes[j].isCharacterType() && ((CharacterType)this.nodeDataTypes[j]).isEqualIdentical()) continue;
        }
    }

    void insertValuesIntoSubqueryTable(Session session, PersistentStore store) {
        for (int i = 0; i < this.nodes.length; ++i) {
            Object[] data = this.nodes[i].getRowValue(session);
            for (int j = 0; j < this.nodeDataTypes.length; ++j) {
                data[j] = this.nodeDataTypes[j].convertToType(session, data[j], this.nodes[i].nodes[j].dataType);
            }
            Row row = (Row)store.getNewCachedObject(session, data);
            try {
                store.indexRow(session, row);
                continue;
            }
            catch (HsqlException e) {
                // empty catch block
            }
        }
    }

    String getColumnName() {
        return this.getAlias();
    }

    ColumnSchema getColumn() {
        return null;
    }

    int getColumnIndex() {
        return this.columnIndex;
    }

    Type getDataType() {
        return this.dataType;
    }

    int getDegree() {
        return this.opType == 25 ? this.nodes.length : 1;
    }

    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 25: {
                Object[] data = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    data[i] = this.nodes[i].getValue(session);
                }
                return data;
            }
            case 22: 
            case 23: {
                return this.subQuery.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(401, "Expression");
    }

    Object getValue(Session session, Type type) {
        Object o = this.getValue(session);
        if (o == null || this.dataType == type) {
            return o;
        }
        return type.convertToType(session, o, this.dataType);
    }

    public Object getConstantValue(Session session) {
        return this.getValue(session);
    }

    public Object getConstantValueNoCheck(Session session) {
        try {
            return this.getValue(session);
        }
        catch (HsqlException e) {
            return null;
        }
    }

    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                Object[] data = session.sessionContext.rangeIterators[this.rangePosition].getCurrent();
                return data[this.columnIndex];
            }
            case 25: {
                if (this.nodes.length == 1) {
                    return this.nodes[0].getValue(session);
                }
                Object[] row = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    row[i] = this.nodes[i].getValue(session);
                }
                return row;
            }
            case 22: 
            case 23: {
                this.subQuery.materialiseCorrelated(session);
                Object value = this.subQuery.getValue(session);
                return value;
            }
        }
        throw Error.runtimeError(401, "Expression");
    }

    boolean testCondition(Session session) {
        return Boolean.TRUE.equals(this.getValue(session));
    }

    static int countNulls(Object[] a) {
        int nulls = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != null) continue;
            ++nulls;
        }
        return nulls;
    }

    static void convertToType(Session session, Object[] data, Type[] dataType, Type[] newType) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = newType[i].convertToType(session, data[i], dataType[i]);
        }
    }

    static QuerySpecification getCheckSelect(Session session, Table t, Expression e) {
        ParserDQL.CompileContext compileContext = new ParserDQL.CompileContext(session);
        QuerySpecification s = new QuerySpecification(compileContext);
        s.exprColumns = new Expression[1];
        s.exprColumns[0] = EXPR_TRUE;
        RangeVariable range = new RangeVariable(t, null, null, null, compileContext);
        s.rangeVariables = new RangeVariable[]{range};
        HsqlList unresolved = e.resolveColumnReferences(s.rangeVariables, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        e.resolveTypes(session, null);
        if (Type.SQL_BOOLEAN != e.getDataType()) {
            throw Error.error(5568);
        }
        ExpressionLogical condition = new ExpressionLogical(48, e);
        s.queryCondition = condition;
        s.resolveReferences(session);
        s.resolveTypes(session);
        return s;
    }

    static void resolveGenerationExpression(Session session, Table t, Expression e) {
        HsqlList unresolved = e.resolveColumnReferences(t.defaultRanges, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        e.resolveTypes(session, null);
        OrderedHashSet set = new OrderedHashSet();
        e.collectObjectNames(set);
        for (int i = 0; i < set.size(); ++i) {
            int colIndex;
            ColumnSchema column;
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
            if (name.type != 9 || !(column = t.getColumn(colIndex = t.findColumn(name.name))).isGenerated()) continue;
            throw Error.error(5512);
        }
    }

    boolean isParam() {
        return this.isParam;
    }

    void setAttributesAsColumn(ColumnSchema column, boolean isWritable) {
        throw Error.runtimeError(401, "Expression");
    }

    String getValueClassName() {
        Type type = this.dataType == null ? NullType.getNullType() : this.dataType;
        return type.getJDBCClassName();
    }

    public void collectAllFunctionExpressions(HsqlList set) {
        Expression.collectAllExpressions(set, this, emptyExpressionSet, emptyExpressionSet);
    }

    static void collectAllExpressions(HsqlList set, Expression e, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        if (e == null) {
            return;
        }
        if (stopAtTypeSet.contains(e.opType)) {
            return;
        }
        for (int i = 0; i < e.nodes.length; ++i) {
            Expression.collectAllExpressions(set, e.nodes[i], typeSet, stopAtTypeSet);
        }
        if (typeSet.contains(e.opType)) {
            set.add(e);
        }
        if (e.subQuery != null && e.subQuery.queryExpression != null) {
            e.subQuery.queryExpression.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
    }

    public boolean isCorrelated() {
        return this.opType == 23 && this.subQuery != null && this.subQuery.isCorrelated();
    }

    public void checkValidCheckConstraint() {
        HsqlArrayList set = new HsqlArrayList();
        Expression.collectAllExpressions(set, this, subqueryExpressionSet, emptyExpressionSet);
        if (!set.isEmpty()) {
            throw Error.error(1500, "subquery in check constraint");
        }
    }

    static HsqlList resolveColumnSet(RangeVariable[] rangeVars, HsqlList sourceSet, HsqlList targetSet) {
        if (sourceSet == null) {
            return targetSet;
        }
        for (int i = 0; i < sourceSet.size(); ++i) {
            Expression e = (Expression)sourceSet.get(i);
            targetSet = e.resolveColumnReferences(rangeVars, targetSet);
        }
        return targetSet;
    }

    Expression getIndexableExpression(RangeVariable rangeVar) {
        return null;
    }

    static {
        aggregateFunctionSet.add(71);
        aggregateFunctionSet.add(72);
        aggregateFunctionSet.add(73);
        aggregateFunctionSet.add(74);
        aggregateFunctionSet.add(75);
        aggregateFunctionSet.add(76);
        aggregateFunctionSet.add(77);
        aggregateFunctionSet.add(78);
        aggregateFunctionSet.add(79);
        aggregateFunctionSet.add(80);
        aggregateFunctionSet.add(81);
        columnExpressionSet = new OrderedIntHashSet();
        columnExpressionSet.add(2);
        subqueryExpressionSet = new OrderedIntHashSet();
        subqueryExpressionSet.add(22);
        subqueryExpressionSet.add(23);
        subqueryAggregateExpressionSet = new OrderedIntHashSet();
        subqueryAggregateExpressionSet.add(71);
        subqueryAggregateExpressionSet.add(72);
        subqueryAggregateExpressionSet.add(73);
        subqueryAggregateExpressionSet.add(74);
        subqueryAggregateExpressionSet.add(75);
        subqueryAggregateExpressionSet.add(76);
        subqueryAggregateExpressionSet.add(77);
        subqueryAggregateExpressionSet.add(78);
        subqueryAggregateExpressionSet.add(79);
        subqueryAggregateExpressionSet.add(80);
        subqueryAggregateExpressionSet.add(81);
        subqueryAggregateExpressionSet.add(23);
        subqueryAggregateExpressionSet.add(22);
        emptyExpressionSet = new OrderedIntHashSet();
    }
}

