/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.persist.HsqlProperties;

public class DatabaseURL {
    static final String S_DOT = ".";
    public static final String S_MEM = "mem:";
    public static final String S_FILE = "file:";
    public static final String S_RES = "res:";
    public static final String S_ALIAS = "alias:";
    public static final String S_HSQL = "hsql://";
    public static final String S_HSQLS = "hsqls://";
    public static final String S_HTTP = "http://";
    public static final String S_HTTPS = "https://";
    public static final String S_URL_PREFIX = "jdbc:hsqldb:";
    public static final String url_connection_type = "connection_type";
    public static final String url_database = "database";

    public static boolean isFileBasedDatabaseType(String type) {
        return type == S_FILE || type == S_RES;
    }

    public static boolean isInProcessDatabaseType(String type) {
        return type == S_FILE || type == S_RES || type == S_MEM;
    }

    public static HsqlProperties parseURL(String url, boolean hasPrefix, boolean noPath) {
        String database;
        String urlImage = url.toLowerCase(Locale.ENGLISH);
        HsqlProperties props = new HsqlProperties();
        HsqlProperties extraProps = null;
        String arguments = null;
        int pos = 0;
        if (hasPrefix) {
            if (urlImage.startsWith(S_URL_PREFIX)) {
                pos = S_URL_PREFIX.length();
            } else {
                return props;
            }
        }
        String type = null;
        int port = 0;
        boolean isNetwork = false;
        props.setProperty("url", url);
        int postUrlPos = url.length();
        int semiPos = url.indexOf(59, pos);
        if (semiPos > -1) {
            arguments = url.substring(semiPos + 1, urlImage.length());
            postUrlPos = semiPos;
            extraProps = HsqlProperties.delimitedArgPairsToProps(arguments, "=", ";", null);
            props.addProperties(extraProps);
        }
        if (postUrlPos == pos + 1 && urlImage.startsWith(S_DOT, pos)) {
            type = S_DOT;
        } else if (urlImage.startsWith(S_MEM, pos)) {
            type = S_MEM;
        } else if (urlImage.startsWith(S_FILE, pos)) {
            type = S_FILE;
        } else if (urlImage.startsWith(S_RES, pos)) {
            type = S_RES;
        } else if (urlImage.startsWith(S_ALIAS, pos)) {
            type = S_ALIAS;
        } else if (urlImage.startsWith(S_HSQL, pos)) {
            type = S_HSQL;
            port = 9001;
            isNetwork = true;
        } else if (urlImage.startsWith(S_HSQLS, pos)) {
            type = S_HSQLS;
            port = 554;
            isNetwork = true;
        } else if (urlImage.startsWith(S_HTTP, pos)) {
            type = S_HTTP;
            port = 80;
            isNetwork = true;
        } else if (urlImage.startsWith(S_HTTPS, pos)) {
            type = S_HTTPS;
            port = 443;
            isNetwork = true;
        }
        if (type == null) {
            type = S_FILE;
        } else if (type == S_DOT) {
            type = S_MEM;
        } else {
            pos += type.length();
        }
        props.setProperty(url_connection_type, type);
        if (isNetwork) {
            String filePath;
            String path;
            String pathSeg = null;
            String hostSeg = null;
            String portSeg = null;
            int slashPos = url.indexOf(47, pos);
            if (slashPos > 0 && slashPos < postUrlPos) {
                pathSeg = url.substring(slashPos, postUrlPos);
                postUrlPos = slashPos;
            }
            if (postUrlPos <= pos) {
                return null;
            }
            if (url.charAt(pos) == '[') {
                int endIpv6 = url.indexOf(93, pos + 2);
                if (endIpv6 < 0 || endIpv6 >= postUrlPos) {
                    return null;
                }
                hostSeg = urlImage.substring(pos + 1, endIpv6);
                if (postUrlPos > endIpv6 + 1) {
                    portSeg = url.substring(endIpv6 + 1, postUrlPos);
                }
            } else {
                int colPos = url.indexOf(58, pos + 1);
                hostSeg = urlImage.substring(pos, colPos > 0 ? colPos : postUrlPos);
                if (colPos > -1 && postUrlPos > colPos + 1) {
                    portSeg = url.substring(colPos, postUrlPos);
                }
            }
            if (portSeg != null) {
                if (portSeg.length() < 2 || portSeg.charAt(0) != ':') {
                    return null;
                }
                try {
                    port = Integer.parseInt(portSeg.substring(1));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (noPath) {
                path = "";
                database = pathSeg;
            } else if (pathSeg == null) {
                path = "/";
                database = "";
            } else {
                int lastSlashPos = pathSeg.lastIndexOf(47);
                if (lastSlashPos < 1) {
                    path = "/";
                    database = pathSeg.substring(1).toLowerCase(Locale.ENGLISH);
                } else {
                    path = pathSeg.substring(0, lastSlashPos);
                    database = pathSeg.substring(lastSlashPos + 1);
                }
            }
            props.setProperty("port", port);
            props.setProperty("host", hostSeg);
            props.setProperty("path", path);
            if (!noPath && extraProps != null && (filePath = extraProps.getProperty("filepath")) != null && database.length() != 0) {
                database = database + ";" + filePath;
            }
        } else {
            if (type == S_MEM) {
                database = urlImage.substring(pos, postUrlPos);
            } else if (type == S_RES) {
                database = url.substring(pos, postUrlPos);
                if (database.indexOf(47) != 0) {
                    database = '/' + database;
                }
            } else {
                database = url.substring(pos, postUrlPos);
            }
            if (database.length() == 0) {
                return null;
            }
        }
        props.setProperty(url_database, database);
        return props;
    }
}

