/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Vector;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.Server;
import org.hsqldb.store.ValuePool;

public class DatabaseManager {
    private static int dbIDCounter;
    static final HashMap memDatabaseMap;
    static final HashMap fileDatabaseMap;
    static final HashMap resDatabaseMap;
    static final IntKeyHashMap databaseIDMap;
    static HashMap serverMap;
    private static final HsqlTimer timer;

    public static Vector getDatabaseURIs() {
        Vector<String> v = new Vector<String>();
        Iterator it = databaseIDMap.values().iterator();
        while (it.hasNext()) {
            Database db = (Database)it.next();
            v.addElement(db.getURI());
        }
        return v;
    }

    public static void closeDatabases(int mode) {
        Iterator it = databaseIDMap.values().iterator();
        while (it.hasNext()) {
            Database db = (Database)it.next();
            try {
                db.close(mode);
            }
            catch (HsqlException hsqlException) {}
        }
    }

    public static Session newSession(int dbID, String user, String password, String zoneString, int timeZoneSeconds) {
        Database db = (Database)databaseIDMap.get(dbID);
        if (db == null) {
            return null;
        }
        Session session = db.connect(user, password, zoneString, timeZoneSeconds);
        session.isNetwork = true;
        return session;
    }

    public static Session newSession(String type, String path, String user, String password, HsqlProperties props, String zoneString, int timeZoneSeconds) {
        Database db = DatabaseManager.getDatabase(type, path, props);
        if (db == null) {
            return null;
        }
        return db.connect(user, password, zoneString, timeZoneSeconds);
    }

    public static Session getSession(int dbId, long sessionId) {
        Database db = (Database)databaseIDMap.get(dbId);
        return db == null ? null : db.sessionManager.getSession(sessionId);
    }

    public static int getDatabase(String type, String path, Server server, HsqlProperties props) {
        Database db = DatabaseManager.getDatabase(type, path, props);
        DatabaseManager.registerServer(server, db);
        return db.databaseID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(String type, String path, HsqlProperties props) {
        Database db;
        Database database = db = DatabaseManager.getDatabaseObject(type, path, props);
        synchronized (database) {
            switch (db.getState()) {
                case 1: {
                    break;
                }
                case 16: {
                    if (DatabaseManager.lookupDatabaseObject(type, path) == null) {
                        DatabaseManager.addDatabaseObject(type, path, db);
                    }
                    db.open();
                    break;
                }
                case 4: 
                case 8: {
                    throw Error.error(11, 107);
                }
            }
        }
        return db;
    }

    private static synchronized Database getDatabaseObject(String type, String path, HsqlProperties props) {
        Database db;
        HashMap databaseMap;
        String key = path;
        if (type == "file:") {
            databaseMap = fileDatabaseMap;
            key = DatabaseManager.filePathToKey(path);
            db = (Database)databaseMap.get(key);
            if (db == null && databaseMap.size() > 0) {
                Iterator it = databaseMap.keySet().iterator();
                while (it.hasNext()) {
                    String current = (String)it.next();
                    if (!key.equalsIgnoreCase(current)) continue;
                    key = current;
                    break;
                }
            }
        } else if (type == "res:") {
            databaseMap = resDatabaseMap;
        } else if (type == "mem:") {
            databaseMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(401, "DatabaseManager");
        }
        if ((db = (Database)databaseMap.get(key)) == null) {
            db = new Database(type, path, key, props);
            db.databaseID = dbIDCounter;
            databaseIDMap.put(dbIDCounter, db);
            ++dbIDCounter;
            databaseMap.put(key, db);
        }
        return db;
    }

    public static synchronized Database lookupDatabaseObject(String type, String path) {
        HashMap databaseMap;
        String key = path;
        if (type == "file:") {
            databaseMap = fileDatabaseMap;
            key = DatabaseManager.filePathToKey(path);
        } else if (type == "res:") {
            databaseMap = resDatabaseMap;
        } else if (type == "mem:") {
            databaseMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(401, "DatabaseManager");
        }
        return (Database)databaseMap.get(key);
    }

    private static synchronized void addDatabaseObject(String type, String path, Database db) {
        HashMap databaseMap;
        String key = path;
        if (type == "file:") {
            databaseMap = fileDatabaseMap;
            key = DatabaseManager.filePathToKey(path);
        } else if (type == "res:") {
            databaseMap = resDatabaseMap;
        } else if (type == "mem:") {
            databaseMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(401, "DatabaseManager");
        }
        databaseIDMap.put(db.databaseID, db);
        databaseMap.put(key, db);
    }

    static void removeDatabase(Database database) {
        HashMap databaseMap;
        String path;
        int dbID = database.databaseID;
        String type = database.getType();
        String key = path = database.getPath();
        DatabaseManager.notifyServers(database);
        if (type == "file:") {
            databaseMap = fileDatabaseMap;
            key = DatabaseManager.filePathToKey(path);
        } else if (type == "res:") {
            databaseMap = resDatabaseMap;
        } else if (type == "mem:") {
            databaseMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(401, "DatabaseManager");
        }
        databaseIDMap.remove(dbID);
        databaseMap.remove(key);
        if (databaseIDMap.isEmpty()) {
            ValuePool.resetPool();
        }
    }

    public static void deRegisterServer(Server server) {
        serverMap.remove(server);
    }

    private static void deRegisterServer(Server server, Database db) {
        Iterator it = serverMap.values().iterator();
        while (it.hasNext()) {
            HashSet databases = (HashSet)it.next();
            databases.remove(db);
            if (!databases.isEmpty()) continue;
            it.remove();
        }
    }

    private static void registerServer(Server server, Database db) {
        if (!serverMap.containsKey(server)) {
            serverMap.put(server, new HashSet());
        }
        HashSet databases = (HashSet)serverMap.get(server);
        databases.add(db);
    }

    private static void notifyServers(Database db) {
        Iterator it = serverMap.keySet().iterator();
        while (it.hasNext()) {
            Server server = (Server)it.next();
            HashSet databases = (HashSet)serverMap.get(server);
            if (!databases.contains(db)) continue;
            server.notify(0, db.databaseID);
        }
    }

    static boolean isServerDB(Database db) {
        Iterator it = serverMap.keySet().iterator();
        while (it.hasNext()) {
            Server server = (Server)it.next();
            HashSet databases = (HashSet)serverMap.get(server);
            if (!databases.contains(db)) continue;
            return true;
        }
        return false;
    }

    public static HsqlTimer getTimer() {
        return timer;
    }

    private static String filePathToKey(String path) {
        try {
            return FileUtil.getFileUtil().canonicalPath(path);
        }
        catch (Exception e) {
            return path;
        }
    }

    static {
        memDatabaseMap = new HashMap();
        fileDatabaseMap = new HashMap();
        resDatabaseMap = new HashMap();
        databaseIDMap = new IntKeyHashMap();
        serverMap = new HashMap();
        timer = new HsqlTimer();
    }
}

