/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ConstraintCore;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;

public final class Constraint
implements SchemaObject {
    ConstraintCore core;
    private HsqlNameManager.HsqlName name;
    int constType;
    boolean isForward;
    Expression check;
    String checkStatement;
    private boolean isNotNull;
    int notNullColumnIndex;
    RangeVariable rangeVariable;
    OrderedHashSet schemaObjectNames;
    OrderedHashSet mainColSet;
    OrderedHashSet refColSet;
    public static final Constraint[] emptyArray = new Constraint[0];

    public Constraint(HsqlNameManager.HsqlName name, Table t, Index index, int type) {
        this.core = new ConstraintCore();
        this.name = name;
        this.constType = type;
        this.core.mainTable = t;
        this.core.mainIndex = index;
        this.core.mainCols = index.getColumns();
    }

    public Constraint(HsqlNameManager.HsqlName name, Constraint fkconstraint) {
        this.name = name;
        this.constType = 1;
        this.core = fkconstraint.core;
    }

    Constraint duplicate() {
        Constraint copy = new Constraint();
        copy.core = this.core.duplicate();
        copy.name = this.name;
        copy.constType = this.constType;
        copy.isForward = this.isForward;
        copy.check = this.check;
        copy.isNotNull = this.isNotNull;
        copy.notNullColumnIndex = this.notNullColumnIndex;
        copy.rangeVariable = this.rangeVariable;
        copy.schemaObjectNames = this.schemaObjectNames;
        return copy;
    }

    public Constraint(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName refTableName, OrderedHashSet refCols, HsqlNameManager.HsqlName mainTableName, OrderedHashSet mainCols, int type, int deleteAction, int updateAction, int matchType) {
        this.core = new ConstraintCore();
        this.name = name;
        this.constType = type;
        this.mainColSet = mainCols;
        this.core.refTableName = refTableName;
        this.core.mainTableName = mainTableName;
        this.refColSet = refCols;
        this.core.deleteAction = deleteAction;
        this.core.updateAction = updateAction;
        this.core.matchType = matchType;
    }

    public Constraint(HsqlNameManager.HsqlName name, OrderedHashSet mainCols, int type) {
        this.core = new ConstraintCore();
        this.name = name;
        this.constType = type;
        this.mainColSet = mainCols;
    }

    void setColumnsIndexes(Table table) {
        if (this.constType == 0) {
            if (this.mainColSet == null) {
                this.core.mainCols = this.core.mainTable.getPrimaryKey();
                if (this.core.mainCols == null) {
                    throw Error.error(5581);
                }
            } else if (this.core.mainCols == null) {
                this.core.mainCols = this.core.mainTable.getColumnIndexes(this.mainColSet);
            }
            if (this.core.refCols == null) {
                this.core.refCols = table.getColumnIndexes(this.refColSet);
            }
        } else if (this.mainColSet != null) {
            this.core.mainCols = table.getColumnIndexes(this.mainColSet);
        }
    }

    private Constraint() {
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        switch (this.constType) {
            case 3: {
                return this.schemaObjectNames;
            }
            case 0: {
                OrderedHashSet set = new OrderedHashSet();
                set.add(this.core.uniqueName);
                return set;
            }
        }
        return null;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.getConstraintType()) {
            case 4: {
                if (this.getMainColumns().length <= 1 && (this.getMainColumns().length != 1 || this.getName().isReservedName())) break;
                if (!this.getName().isReservedName()) {
                    sb.append("CONSTRAINT").append(' ');
                    sb.append(this.getName().statementName).append(' ');
                }
                sb.append("PRIMARY").append(' ').append("KEY");
                Constraint.getColumnList(this.getMain(), this.getMainColumns(), this.getMainColumns().length, sb);
                break;
            }
            case 2: {
                if (!this.getName().isReservedName()) {
                    sb.append("CONSTRAINT").append(' ');
                    sb.append(this.getName().statementName);
                    sb.append(' ');
                }
                sb.append("UNIQUE");
                int[] col = this.getMainColumns();
                Constraint.getColumnList(this.getMain(), col, col.length, sb);
                break;
            }
            case 0: {
                if (this.isForward) {
                    sb.append("ALTER").append(' ').append("TABLE").append(' ');
                    sb.append(this.getRef().getName().getSchemaQualifiedStatementName());
                    sb.append(' ').append("ADD").append(' ');
                    this.getFKStatement(sb);
                    break;
                }
                this.getFKStatement(sb);
                break;
            }
            case 3: {
                if (this.isNotNull()) break;
                if (!this.getName().isReservedName()) {
                    sb.append("CONSTRAINT").append(' ');
                    sb.append(this.getName().statementName).append(' ');
                }
                sb.append("CHECK").append('(');
                sb.append(this.check.getSQL());
                sb.append(')');
            }
        }
        return sb.toString();
    }

    private void getFKStatement(StringBuffer a) {
        if (!this.getName().isReservedName()) {
            a.append("CONSTRAINT").append(' ');
            a.append(this.getName().statementName);
            a.append(' ');
        }
        a.append("FOREIGN").append(' ').append("KEY");
        int[] col = this.getRefColumns();
        Constraint.getColumnList(this.getRef(), col, col.length, a);
        a.append(' ').append("REFERENCES").append(' ');
        a.append(this.getMain().getName().getSchemaQualifiedStatementName());
        col = this.getMainColumns();
        Constraint.getColumnList(this.getMain(), col, col.length, a);
        if (this.getDeleteAction() != 3) {
            a.append(' ').append("ON").append(' ').append("DELETE").append(' ');
            a.append(this.getDeleteActionString());
        }
        if (this.getUpdateAction() != 3) {
            a.append(' ').append("ON").append(' ').append("UPDATE").append(' ');
            a.append(this.getUpdateActionString());
        }
    }

    private static void getColumnList(Table t, int[] col, int len, StringBuffer a) {
        a.append('(');
        for (int i = 0; i < len; ++i) {
            a.append(t.getColumn((int)col[i]).getName().statementName);
            if (i >= len - 1) continue;
            a.append(',');
        }
        a.append(')');
    }

    public HsqlNameManager.HsqlName getMainTableName() {
        return this.core.mainTableName;
    }

    public HsqlNameManager.HsqlName getMainName() {
        return this.core.mainName;
    }

    public HsqlNameManager.HsqlName getRefName() {
        return this.core.refName;
    }

    public HsqlNameManager.HsqlName getUniqueName() {
        return this.core.uniqueName;
    }

    public int getConstraintType() {
        return this.constType;
    }

    public Table getMain() {
        return this.core.mainTable;
    }

    Index getMainIndex() {
        return this.core.mainIndex;
    }

    public Table getRef() {
        return this.core.refTable;
    }

    Index getRefIndex() {
        return this.core.refIndex;
    }

    private static String getActionString(int action) {
        switch (action) {
            case 1: {
                return "RESTRICT";
            }
            case 0: {
                return "CASCADE";
            }
            case 4: {
                return "SET DEFAULT";
            }
            case 2: {
                return "SET NULL";
            }
        }
        return "NO ACTION";
    }

    public int getDeleteAction() {
        return this.core.deleteAction;
    }

    public String getDeleteActionString() {
        return Constraint.getActionString(this.core.deleteAction);
    }

    public int getUpdateAction() {
        return this.core.updateAction;
    }

    public String getUpdateActionString() {
        return Constraint.getActionString(this.core.updateAction);
    }

    public boolean hasTriggeredAction() {
        if (this.constType == 0) {
            switch (this.core.deleteAction) {
                case 0: 
                case 2: 
                case 4: {
                    return true;
                }
            }
            switch (this.core.updateAction) {
                case 0: 
                case 2: 
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    public int getDeferability() {
        return 0;
    }

    public int[] getMainColumns() {
        return this.core.mainCols;
    }

    public int[] getRefColumns() {
        return this.core.refCols;
    }

    public String getCheckSQL() {
        return this.check.getSQL();
    }

    public boolean isNotNull() {
        return this.isNotNull;
    }

    boolean hasColumnOnly(int colIndex) {
        switch (this.constType) {
            case 3: {
                return this.rangeVariable.usedColumns[colIndex] && ArrayUtil.countTrueElements(this.rangeVariable.usedColumns) == 1;
            }
            case 2: 
            case 4: {
                return this.core.mainCols.length == 1 && this.core.mainCols[0] == colIndex;
            }
            case 1: {
                return this.core.mainCols.length == 1 && this.core.mainCols[0] == colIndex && this.core.mainTable == this.core.refTable;
            }
            case 0: {
                return this.core.refCols.length == 1 && this.core.refCols[0] == colIndex && this.core.mainTable == this.core.refTable;
            }
        }
        throw Error.runtimeError(401, "Constraint");
    }

    boolean hasColumnPlus(int colIndex) {
        switch (this.constType) {
            case 3: {
                return this.rangeVariable.usedColumns[colIndex] && ArrayUtil.countTrueElements(this.rangeVariable.usedColumns) > 1;
            }
            case 2: 
            case 4: {
                return this.core.mainCols.length != 1 && ArrayUtil.find(this.core.mainCols, colIndex) != -1;
            }
            case 1: {
                return ArrayUtil.find(this.core.mainCols, colIndex) != -1 && (this.core.mainCols.length != 1 || this.core.mainTable != this.core.refTable);
            }
            case 0: {
                return ArrayUtil.find(this.core.refCols, colIndex) != -1 && (this.core.mainCols.length != 1 || this.core.mainTable == this.core.refTable);
            }
        }
        throw Error.runtimeError(401, "Constraint");
    }

    boolean hasColumn(int colIndex) {
        switch (this.constType) {
            case 3: {
                return this.rangeVariable.usedColumns[colIndex];
            }
            case 1: 
            case 2: 
            case 4: {
                return ArrayUtil.find(this.core.mainCols, colIndex) != -1;
            }
            case 0: {
                return ArrayUtil.find(this.core.refCols, colIndex) != -1;
            }
        }
        throw Error.runtimeError(401, "Constraint");
    }

    boolean isUniqueWithColumns(int[] cols) {
        if (this.constType != 2 || this.core.mainCols.length != cols.length) {
            return false;
        }
        return ArrayUtil.haveEqualSets(this.core.mainCols, cols, cols.length);
    }

    boolean isEquivalent(Table mainTable, int[] mainCols, Table refTable, int[] refCols) {
        if (this.constType != 1 && this.constType != 0) {
            return false;
        }
        if (mainTable != this.core.mainTable || refTable != this.core.refTable) {
            return false;
        }
        return ArrayUtil.areEqualSets(this.core.mainCols, mainCols) && ArrayUtil.areEqualSets(this.core.refCols, refCols);
    }

    void updateTable(Session session, Table oldTable, Table newTable, int colIndex, int adjust) {
        if (oldTable == this.core.mainTable) {
            this.core.mainTable = newTable;
            if (this.core.mainIndex != null) {
                this.core.mainIndex = this.core.mainTable.getIndex(this.core.mainIndex.getName().name);
                this.core.mainCols = ArrayUtil.toAdjustedColumnArray(this.core.mainCols, colIndex, adjust);
            }
        }
        if (oldTable == this.core.refTable) {
            this.core.refTable = newTable;
            if (this.core.refIndex != null) {
                this.core.refIndex = this.core.refTable.getIndex(this.core.refIndex.getName().name);
                this.core.refCols = ArrayUtil.toAdjustedColumnArray(this.core.refCols, colIndex, adjust);
            }
        }
        if (this.constType == 3) {
            this.recompile(session, newTable);
        }
    }

    void checkInsert(Session session, Table table, Object[] row) {
        switch (this.constType) {
            case 3: {
                if (!this.isNotNull) {
                    this.checkCheckConstraint(session, table, row);
                }
                return;
            }
            case 0: {
                PersistentStore store = session.sessionData.getRowStore(this.core.mainTable);
                if (ArrayUtil.hasNull(row, this.core.refCols)) {
                    if (this.core.matchType == 59) {
                        return;
                    }
                    if (this.core.refCols.length == 1) {
                        return;
                    }
                    if (ArrayUtil.hasAllNull(row, this.core.refCols)) {
                        return;
                    }
                } else {
                    int compare;
                    if (this.core.mainIndex.exists(session, store, row, this.core.refCols)) {
                        return;
                    }
                    if (this.core.mainTable == this.core.refTable && (compare = this.core.mainIndex.compareRowNonUnique(session, row, this.core.refCols, row)) == 0) {
                        return;
                    }
                }
                Object[] info = new String[]{this.core.refName.name, this.core.mainTable.getName().name};
                throw Error.error(null, 177, 2, info);
            }
        }
    }

    void checkCheckConstraint(Session session, Table table, Object[] data) {
        RangeVariable.RangeIteratorBase it = session.sessionContext.getCheckIterator(this.rangeVariable);
        it.currentData = data;
        boolean nomatch = Boolean.FALSE.equals(this.check.getValue(session));
        it.currentData = null;
        if (nomatch) {
            Object[] info = new String[]{this.name.name, table.tableName.name};
            throw Error.error(null, 157, 2, info);
        }
    }

    void checkCheckConstraint(Session session, Table table, Object data) {
        session.sessionData.currentValue = data;
        boolean nomatch = Boolean.FALSE.equals(this.check.getValue(session));
        session.sessionData.currentValue = null;
        if (nomatch) {
            if (table == null) {
                throw Error.error(157, this.name.name);
            }
            Object[] info = new String[]{this.name.name, table.tableName.name};
            throw Error.error(null, 157, 2, info);
        }
    }

    RowIterator findFkRef(Session session, Object[] row, boolean delete) {
        if (row == null || ArrayUtil.hasNull(row, this.core.mainCols)) {
            return this.core.refIndex.emptyIterator();
        }
        PersistentStore store = session.sessionData.getRowStore(this.core.refTable);
        return this.core.refIndex.findFirstRow(session, store, row, this.core.mainCols);
    }

    boolean checkHasMainRef(Session session, Object[] row) {
        if (ArrayUtil.hasNull(row, this.core.refCols)) {
            return false;
        }
        PersistentStore store = session.sessionData.getRowStore(this.core.mainTable);
        boolean exists = this.core.mainIndex.exists(session, store, row, this.core.refCols);
        if (!exists) {
            Object[] info = new String[]{this.core.refName.name, this.core.mainTable.getName().name};
            throw Error.error(null, 177, 2, info);
        }
        return exists;
    }

    void checkReferencedRows(Session session, Table table, int[] rowColArray) {
        Row row;
        Index mainIndex = this.getMainIndex();
        PersistentStore mainStore = session.sessionData.getRowStore(this.getMain());
        RowIterator it = table.rowIterator(session);
        while ((row = it.getNextRow()) != null) {
            Object[] rowData = row.getData();
            if ((!ArrayUtil.hasNull(rowData, rowColArray) ? mainIndex.exists(session, mainStore, rowData, rowColArray) : this.core.matchType == 59) || ArrayUtil.hasAllNull(rowData, rowColArray)) continue;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < rowColArray.length; ++i) {
                Object o = rowData[rowColArray[i]];
                sb.append(table.getColumnTypes()[i].convertToString(o));
                sb.append(',');
            }
            Object[] info = new String[]{this.getName().name, this.getMain().getName().name, sb.toString()};
            throw Error.error(null, 177, 2, info);
        }
    }

    public Expression getCheckExpression() {
        return this.check;
    }

    public OrderedHashSet getCheckColumnExpressions() {
        OrderedHashSet set = new OrderedHashSet();
        Expression.collectAllExpressions(set, this.check, Expression.columnExpressionSet, Expression.emptyExpressionSet);
        return set;
    }

    void recompile(Session session, Table newTable) {
        Expression condition;
        String ddl = this.check.getSQL();
        Scanner scanner = new Scanner(ddl);
        ParserDQL parser = new ParserDQL(session, scanner);
        parser.read();
        parser.isCheckOrTriggerCondition = true;
        this.check = condition = parser.XreadBooleanValueExpression();
        this.schemaObjectNames = parser.compileContext.getSchemaObjectNames();
        QuerySpecification s = Expression.getCheckSelect(session, newTable, this.check);
        this.rangeVariable = s.rangeVariables[0];
        this.rangeVariable.setForCheckConstraint();
    }

    void prepareCheckConstraint(Session session, Table table, boolean checkValues) {
        this.check.checkValidCheckConstraint();
        if (table == null) {
            this.check.resolveTypes(session, null);
        } else {
            QuerySpecification s = Expression.getCheckSelect(session, table, this.check);
            Result r = s.getResult(session, 1);
            if (r.getNavigator().getSize() != 0) {
                Object[] info = new String[]{table.getName().name, ""};
                throw Error.error(null, 157, 2, info);
            }
            this.rangeVariable = s.rangeVariables[0];
            this.rangeVariable.setForCheckConstraint();
        }
        if (this.check.getType() == 48 && this.check.getLeftNode().getType() == 47 && this.check.getLeftNode().getLeftNode().getType() == 2) {
            this.notNullColumnIndex = this.check.getLeftNode().getLeftNode().getColumnIndex();
            this.isNotNull = true;
        }
    }
}

