/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.ClientConnection;
import org.hsqldb.HsqlException;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.result.Result;

public class ClientConnectionHTTP
extends ClientConnection {
    static final String ENCODING = "8859_1";
    static final int IDLENGTH = 12;

    public ClientConnectionHTTP(String host, int port, String path, String database, boolean isTLS, String user, String password, int timeZoneSeconds) {
        super(host, port, path, database, isTLS, user, password, timeZoneSeconds);
    }

    @Override
    protected void initConnection(String host, int port, boolean isTLS) {
    }

    @Override
    public synchronized Result execute(Result r) {
        super.openConnection(this.host, this.port, this.isTLS);
        Result result = super.execute(r);
        super.closeConnection();
        return result;
    }

    @Override
    protected void write(Result r) throws IOException, HsqlException {
        this.dataOutput.write("POST ".getBytes(ENCODING));
        this.dataOutput.write(this.path.getBytes(ENCODING));
        this.dataOutput.write(" HTTP/1.0\r\n".getBytes(ENCODING));
        this.dataOutput.write("Content-Type: application/octet-stream\r\n".getBytes(ENCODING));
        this.dataOutput.write(("Content-Length: " + this.rowOut.size() + 12 + "\r\n").getBytes(ENCODING));
        this.dataOutput.write("\r\n".getBytes(ENCODING));
        this.dataOutput.writeInt(r.getDatabaseId());
        this.dataOutput.writeLong(r.getSessionId());
        r.write(this.dataOutput, this.rowOut);
    }

    @Override
    protected Result read() throws IOException, HsqlException {
        int count;
        this.rowOut.reset();
        while ((count = InOutUtil.readLine(this.dataInput, (OutputStream)((Object)this.rowOut))) > 2) {
        }
        Result result = Result.newResult(this.dataInput, this.rowIn);
        result.readAdditionalResults(this, this.dataInput, this.rowIn);
        return result;
    }

    @Override
    protected void handshake() throws IOException {
    }
}

