/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.viewer;

import com.onpositive.richtexteditor.actions.ActionFactory;
import com.onpositive.richtexteditor.model.IPartition;
import com.onpositive.richtexteditor.model.ISimpleRichTextModel;
import com.onpositive.richtexteditor.model.LayerManager;
import com.onpositive.richtexteditor.model.Logger;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.registry.InnerWidgetRegistry;
import com.onpositive.richtexteditor.viewer.IRichDocumentAutoStylingStrategy;
import com.onpositive.richtexteditor.viewer.IRichDocumentListener;
import com.onpositive.richtexteditor.viewer.RichTextViewerControlConfiguration;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class RichTextViewer
extends SourceViewer {
    private static final String EXTENDED_STYLED_TEXT_CLASS = "org.eclipse.swt.custom.ExtendedStyledText";
    protected IContributionManager toolbarManager;
    private MenuManager menuManager = new MenuManager();
    private ArrayList<IRichDocumentListener> listeners = new ArrayList();
    private ArrayList<IRichDocumentAutoStylingStrategy> autoStyling = new ArrayList();
    protected RichTextViewerControlConfiguration configuration;
    private Composite viewerArea;
    protected LayerManager manager;
    protected ActionFactory factory;
    private int style;
    private boolean initToolbarManager = true;

    public final MenuManager getMenuManager() {
        return this.menuManager;
    }

    public RichTextViewer(Composite parent, int style) {
        super(parent, (IVerticalRuler)new VerticalRuler(16), 2880);
        this.style = style;
    }

    public void ignoreAutoEditStrategies(boolean ignore) {
        super.ignoreAutoEditStrategies(ignore);
    }

    protected void createControl(Composite parent, int styles) {
        this.configuration = this.getConfiguration();
        this.viewerArea = new Composite(parent, this.style);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        this.viewerArea.setLayout((Layout)layout);
        if (this.configuration.isCreateToolbar()) {
            this.toolbarManager = this.createToolbarManager();
            Label la = new Label(this.viewerArea, 258);
            la.setLayoutData((Object)new GridData(768));
        }
        super.createControl(this.viewerArea, styles);
        Control control = super.getControl();
        control.setLayoutData((Object)new GridData(1808));
        Document doc = new Document();
        this.setDocument((IDocument)doc, (IAnnotationModel)new AnnotationModel());
        final StyledText textWidget = this.getTextWidget();
        textWidget.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                InnerWidgetRegistry registry = InnerWidgetRegistry.getInstanceFor((Composite)textWidget);
                Control[] children = textWidget.getChildren();
                Point globalWidgetSize = textWidget.getSize();
                int i = 0;
                while (i < children.length) {
                    if (!registry.wasRedrawed(children[i])) {
                        children[i].setLocation(globalWidgetSize.x + 10, globalWidgetSize.y + 10);
                    }
                    ++i;
                }
                registry.clear();
            }
        });
        this.manager = this.createLayerManager(textWidget, (IDocument)doc);
        this.factory = this.createActionFactory();
        this.manager.addRichDocumentListener(this.factory);
        this.initActions();
        if (this.toolbarManager != null) {
            this.toolbarManager.update(true);
        }
        this.menuManager = new MenuManager();
        this.menuManager.createContextMenu((Control)textWidget);
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RichTextViewer.this.fillPopupMenu(RichTextViewer.this.menuManager);
            }
        });
        this.hookListeners();
    }

    protected LayerManager createLayerManager(StyledText textWidget, IDocument doc) {
        return new LayerManager(textWidget, doc);
    }

    protected void fillPopupMenu(MenuManager menuManager) {
    }

    protected ActionFactory createActionFactory() {
        return new ActionFactory(this.manager, (ITextViewer)this);
    }

    protected void delayedConfigureActionFactory(ActionFactory factory) {
        factory.delayedConfigure(this.manager, (ITextViewer)this);
    }

    protected IContributionManager createToolbarManager() {
        ToolBar toolBar = new ToolBar(this.viewerArea, 0x800100);
        toolBar.setLayoutData((Object)new GridData(768));
        return new ToolBarManager(toolBar);
    }

    public void changeDocument(ISimpleRichTextModel model) {
        this.manager.getLayer().setFireEvents(false);
        try {
            this.manager.set(model);
        }
        catch (BadLocationException badLocationException) {}
        this.manager.getLayer().setFireEvents(true);
    }

    public boolean isInitToolbarManager() {
        return this.initToolbarManager;
    }

    public void setInitToolbarManager(boolean initToolbarManager) {
        this.initToolbarManager = initToolbarManager;
    }

    public String getContentsHTML() {
        if (this.manager != null) {
            return this.manager.getContentsHTML();
        }
        return "";
    }

    private void hookListeners() {
        this.addTextInputListener(new ITextInputListener(){

            public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            }

            public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                RichTextViewer.this.manager.dispose();
                if (newInput != null) {
                    RichTextViewer.this.manager = new LayerManager(RichTextViewer.this.getTextWidget(), newInput);
                    RichTextViewer.this.configureManager();
                    RichTextViewer.this.factory.setManager(RichTextViewer.this.manager);
                    RichTextViewer.this.manager.addRichDocumentListener(RichTextViewer.this.factory);
                }
            }
        });
        this.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                RichTextViewer.this.handleKey(e);
            }
        });
    }

    protected void initActions() {
        if (this.configuration.isCreateToolbar()) {
            this.factory.fillToolbarManager(this.toolbarManager);
        }
    }

    protected void customizeDocumentCommand(DocumentCommand command) {
        int offset = command.offset;
        int length = command.length;
        if (length == 0) {
            super.customizeDocumentCommand(command);
            return;
        }
        IPartition part1 = this.manager.getLayer().getPartitionAtOffset(offset);
        IPartition part2 = this.manager.getLayer().getPartitionAtOffset(offset + length - 1);
        if (part1 instanceof BasePartition && ((BasePartition)part1).requiresFullDeletion()) {
            int diff = part1.getOffset() - command.offset;
            command.offset = part1.getOffset();
            command.length += diff;
        }
        if (part2 instanceof BasePartition && ((BasePartition)part2).requiresFullDeletion()) {
            command.length = part2.getLength() + part2.getOffset() - command.offset;
        }
        super.customizeDocumentCommand(command);
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        try {
            Class<?> forName = Class.forName(EXTENDED_STYLED_TEXT_CLASS);
            Constructor<?> constructor = forName.getConstructor(Composite.class, Integer.TYPE);
            StyledText control = (StyledText)constructor.newInstance(parent, styles);
            return control;
        }
        catch (Exception exception) {
            return super.createTextWidget(parent, styles);
        }
    }

    public Control getControl() {
        return this.viewerArea;
    }

    public IContributionManager getToolbarManager() {
        return this.toolbarManager;
    }

    public LayerManager getLayerManager() {
        return this.manager;
    }

    protected void handleKey(VerifyEvent e) {
        if ((e.keyCode == 118 || e.keyCode == 118) && (e.stateMask & SWT.MOD1) != 0 || e.keyCode == 0x1000009 && (e.stateMask & SWT.MOD2) != 0) {
            this.pasteOperation(e);
        } else if (e.keyCode == 127 && (e.stateMask & SWT.MOD2) != 0) {
            this.cutOperation();
        } else if ((e.keyCode == 97 || e.keyCode == 65) && (e.stateMask & SWT.MOD1) != 0) {
            this.selectAllOperation(e);
        } else if ((e.keyCode == 99 || e.keyCode == 67) && (e.stateMask & SWT.MOD1) != 0) {
            this.copyOperation(e);
        } else if ((e.keyCode == 98 || e.keyCode == 66) && (e.stateMask & SWT.MOD1) != 0) {
            this.boldOperation(e);
        } else if ((e.keyCode == 105 || e.keyCode == 73) && (e.stateMask & SWT.MOD1) != 0) {
            this.italicOperation(e);
        } else if ((e.keyCode == 117 || e.keyCode == 85) && (e.stateMask & SWT.MOD1) != 0) {
            this.underlineOperation(e);
        } else if ((e.keyCode == 122 || e.keyCode == 90) && (e.stateMask & SWT.MOD1) != 0) {
            this.doOperation(1);
        } else if ((e.keyCode == 121 || e.keyCode == 89) && (e.stateMask & SWT.MOD1) != 0) {
            this.doOperation(2);
        }
    }

    private void pasteOperation(VerifyEvent e) {
        TransferData[] availableTypes;
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        HTMLTransfer instance = HTMLTransfer.getInstance();
        TransferData[] transferDataArray = availableTypes = clipboard.getAvailableTypes();
        int n = availableTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData d = transferDataArray[n2];
            boolean supportedType = instance.isSupportedType(d);
            if (supportedType) {
                String contents = (String)clipboard.getContents((Transfer)instance);
                this.manager.pasteHTML(contents, this.getTextWidget().getCaretOffset());
                e.doit = false;
            }
            ++n2;
        }
    }

    private void cutOperation() {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        HTMLTransfer instance = HTMLTransfer.getInstance();
        String selectedHTML = this.manager.getSelectedHTML();
        TextTransfer textTransfer = TextTransfer.getInstance();
        if (selectedHTML != null) {
            clipboard.setContents(new Object[]{selectedHTML, this.manager.getEditor().getSelectionText()}, new Transfer[]{instance, textTransfer});
        }
        Point selectedRange = this.getSelectedRange();
        try {
            this.getDocument().replace(selectedRange.x, selectedRange.y, "");
        }
        catch (BadLocationException e1) {
            Logger.log(e1);
        }
    }

    private void selectAllOperation(VerifyEvent e) {
        this.manager.getEditor().setSelection(0, this.manager.getEditor().getCharCount());
        e.doit = false;
    }

    private void copyOperation(VerifyEvent e) {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        HTMLTransfer instance = HTMLTransfer.getInstance();
        String selectedHTML = this.manager.getSelectedHTML();
        TextTransfer textTransfer = TextTransfer.getInstance();
        if (selectedHTML != null) {
            clipboard.setContents(new Object[]{selectedHTML, this.manager.getEditor().getSelectionText()}, new Transfer[]{instance, textTransfer});
        }
        e.doit = false;
    }

    private void boldOperation(VerifyEvent e) {
        IAction boldAction;
        boolean checked = (boldAction = this.factory.getBoldAction()).isChecked();
        boldAction.setChecked(!checked);
        boldAction.run();
        boldAction.setChecked(!checked);
        if (this.toolbarManager != null) {
            this.toolbarManager.update(true);
        }
        e.doit = false;
    }

    private void italicOperation(VerifyEvent e) {
        IAction italicAction;
        boolean checked = (italicAction = this.factory.getItalicAction()).isChecked();
        italicAction.setChecked(!checked);
        italicAction.run();
        italicAction.setChecked(!checked);
        if (this.toolbarManager != null) {
            this.toolbarManager.update(true);
        }
        e.doit = false;
    }

    private void underlineOperation(VerifyEvent e) {
        IAction underlineAction;
        boolean checked = (underlineAction = this.factory.getUnderlineAction()).isChecked();
        underlineAction.setChecked(!checked);
        underlineAction.run();
        underlineAction.setChecked(!checked);
        if (this.toolbarManager != null) {
            this.toolbarManager.update(true);
        }
        e.doit = false;
    }

    public void addRichDocumentListener(IRichDocumentListener richDocumentListener) {
        this.listeners.add(richDocumentListener);
        this.getLayerManager().addRichDocumentListener(richDocumentListener);
    }

    public void removeRichDocumentAutoStylingStrategy(IRichDocumentAutoStylingStrategy strategy) {
        this.autoStyling.remove(strategy);
        this.getLayerManager().removeAutoStylingStrategy(strategy);
    }

    public void addRichDocumentAutoStylingStrategy(IRichDocumentAutoStylingStrategy strategy) {
        this.autoStyling.add(strategy);
        this.getLayerManager().addAutoStylingStrategy(strategy);
    }

    public void removeRichDocumentListener(IRichDocumentListener richDocumentListener) {
        this.listeners.remove(richDocumentListener);
        this.getLayerManager().removeRichDocumentListener(richDocumentListener);
    }

    protected void configureManager() {
        for (IRichDocumentListener iRichDocumentListener : this.listeners) {
            this.manager.addRichDocumentListener(iRichDocumentListener);
        }
        for (IRichDocumentAutoStylingStrategy iRichDocumentAutoStylingStrategy : this.autoStyling) {
            this.manager.addAutoStylingStrategy(iRichDocumentAutoStylingStrategy);
        }
        this.configuration.configureLayerManager(this.manager);
    }

    public ArrayList<IRichDocumentAutoStylingStrategy> getAutoStylingStrategies() {
        return this.autoStyling;
    }

    public void setAutoStylingStrategies(ArrayList<IRichDocumentAutoStylingStrategy> autoStyling) {
        this.autoStyling = autoStyling;
    }

    public void setToolbarManager(IContributionManager toolbarManager) {
        this.toolbarManager = toolbarManager;
    }

    public RichTextViewerControlConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new RichTextViewerControlConfiguration();
        }
        return this.configuration;
    }
}

