/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.resources;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Observer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageManager {
    static File tempDirFile = null;
    private HashMap<String, Image> imageMap = new HashMap();
    private Display display;

    static {
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null) {
            tempDirFile = new File(".");
        }
    }

    public ImageManager(Display display) {
        this.display = display;
    }

    public void sheduleLoad(final String string, final Observer observer) {
        Thread loader = new Thread(){

            @Override
            public void run() {
                try {
                    Image image = (Image)ImageManager.this.imageMap.get(string);
                    if (image != null) {
                        observer.update(null, image);
                        return;
                    }
                    InputStream openStream = new URL(string).openStream();
                    Image loadedImage = new Image((Device)ImageManager.this.display, openStream);
                    ImageManager.this.imageMap.put(string, loadedImage);
                    observer.update(null, loadedImage);
                }
                catch (Exception exception) {}
            }
        };
        loader.start();
    }

    public synchronized Image getImage(String string, Observer observer) {
        Image image = this.imageMap.get(string);
        if (image != null) {
            return image;
        }
        this.sheduleLoad(string, observer);
        return null;
    }

    public void dispose() {
        for (Image i : this.imageMap.values()) {
            i.dispose();
        }
    }

    public Image checkImage(String filename) {
        Image image = this.imageMap.get(filename);
        return image;
    }

    public void registerImage(String filename, Image image) {
        this.imageMap.put(filename, image);
    }
}

