/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager {
    private Display display;
    private HashMap<RGB, Color> colors = new HashMap();
    private ArrayList<RGB> ra = new ArrayList();
    private ArrayList<String> names = new ArrayList();

    private void createDefaultColors() {
        this.ra.add(new RGB(0, 0, 0));
        this.names.add("Black");
        this.ra.add(new RGB(255, 0, 0));
        this.names.add("Red");
        this.ra.add(new RGB(0, 255, 0));
        this.names.add("Green");
        this.ra.add(new RGB(0, 0, 255));
        this.names.add("Blue");
        this.ra.add(new RGB(127, 127, 127));
        this.names.add("Grey");
        this.ra.add(new RGB(180, 180, 180));
        this.names.add("Light Grey");
        this.ra.add(new RGB(255, 255, 255));
        this.names.add("White");
    }

    public void addColor(String name, RGB rgb) {
        this.names.add(name);
        this.ra.add(rgb);
    }

    public ColorManager(Display display) {
        this.display = display;
        this.createDefaultColors();
    }

    public Color getColor(RGB rgb) {
        Color color = this.colors.get(rgb);
        if (color == null) {
            color = new Color((Device)this.display, rgb);
            this.colors.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        for (Color c : this.colors.values()) {
            c.dispose();
        }
    }

    public List<RGB> getColors() {
        return this.ra;
    }

    public String getColorName(int n) {
        return this.names.get(n);
    }
}

