/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.Change;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;
import com.onpositive.richtexteditor.model.partitions.PartitionStorage;

public class ShiftPartitionAtPositionChange
extends Change {
    private int index;
    private int amount;

    public ShiftPartitionAtPositionChange(int index, int amount) {
        this.amount = amount;
        this.index = index;
    }

    @Override
    protected void apply(PartitionDelta delta) {
        int i;
        final PartitionStorage partitionStorage = delta.getStorage();
        int a = i = this.index;
        while (a < partitionStorage.size()) {
            BasePartition basePartition = partitionStorage.get(a);
            basePartition.setOffset(basePartition.getOffset() + this.amount);
            ++a;
        }
        Change change = new Change(){

            @Override
            protected void apply(PartitionDelta delta) {
                int a = i;
                while (a < partitionStorage.size()) {
                    BasePartition basePartition = partitionStorage.get(a);
                    basePartition.setOffset(basePartition.getOffset() - ShiftPartitionAtPositionChange.this.amount);
                    ++a;
                }
                delta.getUndoChange().add(ShiftPartitionAtPositionChange.this);
            }
        };
        delta.getUndoChange().add(change);
    }

    public String toString() {
        return "Shift partition# " + this.index + " amount " + this.amount;
    }
}

