/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.BasePartitionLayer;
import com.onpositive.richtexteditor.model.partitions.AbstractModel;
import com.onpositive.richtexteditor.model.partitions.AddRemovePartitionChange;
import com.onpositive.richtexteditor.model.partitions.AdjustPartitionChange;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.Change;
import com.onpositive.richtexteditor.model.partitions.ILineAttributeModel;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;
import com.onpositive.richtexteditor.model.partitions.PartitionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class PartitionStorage {
    private ArrayList<BasePartition> partitions = new ArrayList();
    private BasePartitionLayer layer;

    public ILineAttributeModel getLineAttributeModel() {
        return ((AbstractModel)this.layer).getLineAttributeModel();
    }

    public PartitionStorage(BasePartitionLayer layer) {
        this.layer = layer;
    }

    public PartitionDelta apply(Change change) {
        PartitionDelta delta = new PartitionDelta(this);
        change.apply(delta);
        Set<BasePartition> changed = delta.getChanged();
        if (delta.isOptimizeParitions()) {
            for (BasePartition p : changed) {
                this.tryMerge(delta, change, p);
            }
        }
        Collections.reverse(delta.getUndoChange().getParts());
        this.validate();
        return delta;
    }

    /*
     * Unable to fully structure code
     */
    private void tryMerge(PartitionDelta delta, Change change, BasePartition p) {
        pa = p.getPosition();
        if (pa != -1) ** GOTO lbl10
        return;
        while ((pz = this.partitions.get(pa - 1)) != p && pz.equalsByStyle(p)) {
            addRemovePartitionChange = new AddRemovePartitionChange(pz.getPosition(), pz, false);
            addRemovePartitionChange.apply(delta);
            adjustPartitionChange = new AdjustPartitionChange(p, pz.getOffset(), p.getLength() + pz.getLength());
            adjustPartitionChange.apply(delta);
            --pa;
lbl10:
            // 2 sources

            if (pa > 0 && pa < this.partitions.size()) continue;
        }
        pa = p.getPosition();
        while (pa < this.partitions.size() - 1 && this.size() > 1) {
            pz = this.partitions.get(pa + 1);
            if (pz == p || !pz.equalsByStyle(p)) break;
            addRemovePartitionChange = new AddRemovePartitionChange(pz.getPosition(), pz, false);
            addRemovePartitionChange.apply(delta);
            adjustPartitionChange = new AdjustPartitionChange(p, p.getOffset(), p.getLength() + pz.getLength());
            adjustPartitionChange.apply(delta);
        }
    }

    void insertPartition(int index, BasePartition partition) {
        this.partitions.add(index, partition);
        partition.index = index;
        int size = this.partitions.size();
        int a = index + 1;
        while (a < size) {
            ++this.partitions.get((int)a).index;
            ++a;
        }
    }

    public void removePartition(BasePartition partition) {
        if (partition.index >= 0) {
            this.partitions.remove(partition.index);
            int size = this.partitions.size();
            int a = partition.index;
            while (a < size) {
                --this.partitions.get((int)a).index;
                ++a;
            }
            partition.index = -1;
        }
    }

    public BasePartition get(int i) {
        return this.partitions.get(i);
    }

    public int size() {
        return this.partitions.size();
    }

    public BasePartition getLastPartition() {
        return this.partitions.get(this.partitions.size() - 1);
    }

    public BasePartition getPartitionAtOffset(int offset) {
        int size = this.partitions.size();
        int a = 0;
        while (a < size) {
            BasePartition partition = this.partitions.get(a);
            if (partition.getOffset() + partition.getLength() > offset) {
                return partition;
            }
            ++a;
        }
        return null;
    }

    public List<BasePartition> getPartitions() {
        return this.partitions;
    }

    public BasePartition newPartition() {
        return new BasePartition(this.layer, 0, 0);
    }

    public BasePartition newPartition(int offset, int length, BasePartition p) {
        return PartitionFactory.createAsSampleStyle(p, this.layer, offset, length);
    }

    public void setPartitions(List<BasePartition> newPartitions) {
        this.partitions.clear();
        int size = newPartitions.size();
        int a = 0;
        while (a < size) {
            BasePartition e = newPartitions.get(a);
            this.partitions.add(e);
            e.index = a++;
        }
    }

    public BasePartition removePartition(int index) {
        BasePartition remove = this.partitions.remove(index);
        int size = this.partitions.size();
        int a = index;
        while (a < size) {
            --this.partitions.get((int)a).index;
            ++a;
        }
        return remove;
    }

    public List<BasePartition> clonePartitions() {
        ArrayList<BasePartition> partition = new ArrayList<BasePartition>();
        for (BasePartition p : this.partitions) {
            partition.add(p.clone());
        }
        return partition;
    }

    protected void validate() {
        int size = this.partitions.size();
        int i = 1;
        while (i < size) {
            BasePartition partition = this.partitions.get(i);
            if (partition.getOffset() != this.partitions.get(i - 1).getOffset() + this.partitions.get(i - 1).getLength()) {
                String message = "Partitios list failure: partitions \n" + this.partitions.get(i - 1) + "\n" + partition;
                throw new RuntimeException(message);
            }
            ++i;
        }
    }

    public String toString() {
        return this.partitions.toString();
    }
}

