/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model;

import com.onpositive.richtexteditor.model.Logger;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.resources.FontStyleManager;
import org.eclipse.swt.graphics.RGB;

public class FontStyle
implements Cloneable {
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINED = 4;
    public static final int STRIKETHROUGH = 8;
    public static final String NORMAL_FONT_NAME = FontStyleManager.NORMAL_FONT_NAME;
    public static final String BOLD_PREFFIX = "bold_";
    public static final String ITALIC_PREFFIX = "italic_";
    public static final String UNDERLINED_PREFFIX = "underlined_";
    public static final String BOLD_ITALIC_PREFFIX = "bold_italic_";
    protected int mask;
    protected String fontDataName = null;
    protected String displayName = null;
    protected RGB color = null;
    protected RGB bgColor = null;

    public FontStyle(int mask) {
        this.mask = mask;
    }

    public FontStyle(int mask, String fontDataName, String displayName) {
        this.mask = mask;
        this.fontDataName = fontDataName;
        this.displayName = displayName;
    }

    public FontStyle(int mask, RGB RGBColor) {
        this.color = RGBColor;
        this.mask = mask;
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    public FontStyle(BasePartition partition) {
        this.mask = partition.getStyleMask();
        this.color = partition.getColorRGB();
        this.bgColor = partition.getBgColorRGB();
        this.fontDataName = partition.getFontDataName();
    }

    public void applyStyle(BasePartition partition) {
        partition.setStyleMask(partition.getStyleMask() | this.mask);
        if (this.color != null) {
            partition.setColorRGB(this.color);
        }
        if (this.bgColor != null) {
            partition.setBgColorRGB(this.bgColor);
        }
        if (this.fontDataName != null) {
            partition.setFontDataName(this.fontDataName);
        }
    }

    public void setStyle(BasePartition partition) {
        partition.setStyleMask(this.mask);
        partition.setColorRGB(this.color);
        partition.setBgColorRGB(this.bgColor);
        partition.setFontDataName(this.fontDataName);
    }

    public void removeStyle(BasePartition partition) {
        partition.setStyleMask(partition.getStyleMask() & ~this.mask);
        if (this.color != null) {
            partition.setColorRGB(null);
        }
        if (this.bgColor != null) {
            partition.setBgColorRGB(null);
        }
        if (this.fontDataName != null && this.fontDataName != NORMAL_FONT_NAME) {
            partition.setFontDataName(NORMAL_FONT_NAME);
        }
    }

    public boolean isApplied(BasePartition partition) {
        return (partition.getStyleMask() & this.mask) > 0;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getFontDataName() {
        return this.fontDataName;
    }

    public void setFontDataName(String fontDataName) {
        this.fontDataName = fontDataName;
    }

    public RGB getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(RGB bgColor) {
        this.bgColor = bgColor;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FontStyle)) {
            return false;
        }
        FontStyle style2 = (FontStyle)obj;
        if (!this.fontDataName.equals(style2.fontDataName)) {
            return false;
        }
        if (this.mask != style2.mask) {
            return false;
        }
        if (this.color == null && style2.color != null) {
            return false;
        }
        if (this.color != null && !this.color.equals((Object)style2.color)) {
            return false;
        }
        if (this.bgColor == null && style2.bgColor != null) {
            return false;
        }
        return this.bgColor == null || this.bgColor.equals((Object)style2.bgColor);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.log(e);
            return null;
        }
    }

    public String toString() {
        return this.displayName;
    }
}

