/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.widgets.Display;

public class BulletFactory {
    protected static HashMap<Integer, Bullet> listBullets = new HashMap();
    protected static StyleRange bulletStyle = new StyleRange();
    public static final int NONE_LIST_CONST = -1;
    public static final int BULLETED_LIST_CONST = 0;

    static {
        BulletFactory.bulletStyle.font = Display.getCurrent().getSystemFont();
        BulletFactory.bulletStyle.length = 1;
        BulletFactory.bulletStyle.start = 0;
        BulletFactory.bulletStyle.metrics = new GlyphMetrics(10, 10, 10);
        listBullets.put(0, new Bullet(bulletStyle));
    }

    public static Bullet getNewBulletedListBulletInstance() {
        return new Bullet(bulletStyle);
    }

    public static Bullet getNewNumberedListBulletInstance() {
        Bullet bullet = new Bullet(18, bulletStyle);
        try {
            Field declaredField = Bullet.class.getDeclaredField("linesIndices");
            declaredField.setAccessible(true);
            declaredField.set(bullet, new int[]{-1});
            declaredField = Bullet.class.getDeclaredField("count");
            declaredField.setAccessible(true);
            declaredField.set(bullet, 1);
        }
        catch (Exception exception) {}
        bullet.text = ".";
        return bullet;
    }

    public static Bullet getBulletForNum(int num) {
        if (num == -1) {
            return null;
        }
        if (!listBullets.containsKey(num)) {
            listBullets.put(num, BulletFactory.getNewNumberedListBulletInstance());
        }
        return listBullets.get(num);
    }
}

