/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.io.html_scaner;

import com.onpositive.richtexteditor.io.LexEvent;
import com.onpositive.richtexteditor.io.html_scaner.AttrValueLexEvent;
import com.onpositive.richtexteditor.io.html_scaner.EOFEvent;
import com.onpositive.richtexteditor.io.html_scaner.ILexListener;
import com.onpositive.richtexteditor.io.html_scaner.Scanner;
import com.onpositive.richtexteditor.io.html_scaner.TagEndEvent;
import com.onpositive.richtexteditor.io.html_scaner.TagLexEvent;
import com.onpositive.richtexteditor.model.BasePartitionLayer;
import com.onpositive.richtexteditor.model.Logger;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.HRPartition;
import com.onpositive.richtexteditor.model.partitions.ImagePartition;
import com.onpositive.richtexteditor.model.partitions.LinkPartition;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class HTMLLexListener
implements ILexListener {
    protected boolean isLink = false;
    protected String curHref = "";
    protected boolean isImg = false;
    protected String curSrc = "";
    protected Scanner scanner;
    protected Stack<Boolean> boldStack = new Stack();
    protected Stack<Boolean> italicStack = new Stack();
    protected Stack<Boolean> underlinedStack = new Stack();
    protected Stack<Boolean> strikethroughStack = new Stack();
    protected Stack<HashMap<String, String>> styleAttrsStack = new Stack();
    protected Stack<Integer> tagsStack = new Stack();
    protected String fontFaceString = "font-family";
    protected String fontSizeString = "font-size";
    protected String fontColorString = "color";
    protected String bkColorString = "background-color";
    protected String h1StyleString = "font-family:Times New Roman; font-size:24pt";
    protected String h2StyleString = "font-family:Times New Roman; font-size:18pt";
    protected String h3StyleString = "font-family:Times New Roman; font-size:14pt";
    protected String h4StyleString = "font-family:Times New Roman; font-size:12pt";
    protected boolean isParagraphAttr = false;
    protected StringBuilder curTextStr = new StringBuilder();
    protected ArrayList<BasePartition> partitions = new ArrayList();
    protected ArrayList<Integer> lineAligns = new ArrayList();
    protected ArrayList<Integer> lineBullets = new ArrayList();
    protected BasePartitionLayer layer;
    protected StringBuilder globalBuilder = new StringBuilder();
    protected int curAlign = 16384;
    protected RGB curRGB = null;
    protected boolean wasLI = false;
    protected boolean wasFontTag = false;
    protected boolean wasSpanTag = false;
    protected boolean appendText = true;
    protected boolean trimWhiteSpaces = true;
    protected int bulletedListLevel = 0;
    protected int numberedListLevel = 0;
    protected int currentNumberedListValue = 1;
    protected boolean isHR = false;

    public HTMLLexListener(BasePartitionLayer layer, Scanner scanner) {
        this.layer = layer;
        this.scanner = scanner;
    }

    @Override
    public void handleLexEvent(LexEvent event) {
        if (event instanceof TagLexEvent) {
            int lastIdx;
            BasePartition partition;
            TagLexEvent tagEvent = (TagLexEvent)event;
            int type = tagEvent.getType();
            if (type == -1 || type == 101) {
                return;
            }
            if (tagEvent.isOpen()) {
                HashMap currentFontStyleMap = new HashMap();
                this.styleAttrsStack.push(currentFontStyleMap);
                this.tagsStack.push(tagEvent.getType());
            }
            if (type == 1 || type == 2) {
                if (this.resolveStr(this.curTextStr).length() > 0 && (partition = this.getNewFontPartition()).getLength() > 0) {
                    this.partitions.add(partition);
                }
            } else if (type == 3) {
                if (tagEvent.isOpen()) {
                    this.insertNewLineIfNeeded();
                    this.isParagraphAttr = true;
                    this.curAlign = 16384;
                } else {
                    this.insertNewLineIfNeeded();
                }
            } else if (type == 11) {
                this.styleAttrsStack.pop();
                this.tagsStack.pop();
                this.endOfLineReached();
            } else if (type == 29) {
                partition = this.getNewFontPartition();
                if (partition.getLength() > 0) {
                    this.partitions.add(partition);
                }
                this.trimWhiteSpaces = !tagEvent.isOpen();
                this.scanner.setClearEnters(this.trimWhiteSpaces);
            } else if (type == 12) {
                if (tagEvent.isOpen()) {
                    ++this.numberedListLevel;
                } else if (this.numberedListLevel > 0) {
                    --this.numberedListLevel;
                } else {
                    ++this.currentNumberedListValue;
                }
            } else if (type == 13) {
                if (tagEvent.isOpen()) {
                    ++this.bulletedListLevel;
                } else if (this.numberedListLevel > 0) {
                    --this.numberedListLevel;
                }
            } else if (type == 14) {
                if (tagEvent.isOpen()) {
                    this.insertNewLineIfNeeded();
                    this.wasLI = true;
                } else {
                    this.endOfLineReached();
                }
            } else if (type == 23 || type == 25 || type == 24) {
                if (tagEvent.isOpen()) {
                    this.insertNewLineIfNeeded();
                } else {
                    this.insertNewLineIfNeeded();
                }
            } else if (type == 15 || type == 16 || type == 21 || type == 22) {
                this.appendText = !tagEvent.isOpen();
            } else if (this.appendText) {
                if (type == 9 && tagEvent.isOpen()) {
                    this.styleAttrsStack.pop();
                    this.tagsStack.pop();
                    this.isImg = true;
                }
                if (type == 27 && tagEvent.isOpen()) {
                    this.styleAttrsStack.pop();
                    this.tagsStack.pop();
                    this.isHR = true;
                }
                if ((partition = this.getNewFontPartition()).getLength() > 0) {
                    this.partitions.add(partition);
                }
                if (type == 4) {
                    this.manageBold(tagEvent.isOpen());
                }
                if (type == 5) {
                    this.manageItalic(tagEvent.isOpen());
                }
                if (type == 6) {
                    this.manageUnderlined(tagEvent.isOpen());
                }
                if (type == 7) {
                    this.manageStrikethrough(tagEvent.isOpen());
                }
                if (type == 8) {
                    this.wasFontTag = tagEvent.isOpen();
                }
                if (type == 10) {
                    this.wasSpanTag = tagEvent.isOpen();
                }
                if (type == 17) {
                    this.endOfLineReached();
                    this.manageBold(tagEvent.isOpen());
                }
                if (type == 18) {
                    this.endOfLineReached();
                    this.manageBold(tagEvent.isOpen());
                }
                if (type == 19) {
                    this.endOfLineReached();
                    this.manageBold(tagEvent.isOpen());
                }
                if (type == 20) {
                    if (tagEvent.isOpen()) {
                        this.isLink = true;
                    } else {
                        this.isLink = false;
                        this.curHref = "";
                    }
                }
            }
            if (!tagEvent.isOpen() && (lastIdx = this.tagsStack.lastIndexOf(tagEvent.getType())) != -1) {
                this.tagsStack.remove(lastIdx);
                this.styleAttrsStack.remove(lastIdx);
            }
        } else if (event instanceof AttrValueLexEvent) {
            AttrValueLexEvent event2 = (AttrValueLexEvent)event;
            if (event2.type == 52) {
                if (this.isParagraphAttr) {
                    if (event2.l.equalsIgnoreCase("left")) {
                        this.curAlign = 16384;
                    } else if (event2.l.equalsIgnoreCase("right")) {
                        this.curAlign = 131072;
                    } else if (event2.l.equalsIgnoreCase("justify")) {
                        this.curAlign = 4;
                    } else if (event2.l.equalsIgnoreCase("center")) {
                        this.curAlign = 0x1000000;
                    }
                    this.isParagraphAttr = false;
                }
            } else {
                if (!this.styleAttrsStack.isEmpty()) {
                    HashMap<String, String> peek = this.styleAttrsStack.peek();
                    if (event2.type == 53) {
                        if (this.wasFontTag || this.wasSpanTag) {
                            if (event2.l.indexOf(58) > -1) {
                                event2.l = this.manageStyleString(event2.l, peek);
                            } else {
                                peek.put(this.fontColorString, event2.l);
                            }
                        } else if (this.isHR) {
                            this.curRGB = HTMLLexListener.getRGBfromHexRGBString(event2.l);
                        }
                    } else if (event2.type == 54) {
                        event2.l = this.manageStyleString(event2.l, peek);
                    }
                }
                if (event2.type == 55) {
                    if (this.isLink) {
                        this.curHref = this.convertLinkURL(event2.l);
                    }
                } else if (event2.type == 56 && this.isImg) {
                    this.curSrc = this.convertImageSrc(event2.l);
                }
            }
        } else if (event instanceof TagEndEvent) {
            this.wasFontTag = false;
            this.wasSpanTag = false;
            this.isImg = false;
            this.isHR = false;
            if (((TagEndEvent)event).isOpen()) {
                if (((TagEndEvent)event).getType() == 17) {
                    this.inheritStyleFromString(this.h1StyleString);
                }
                if (((TagEndEvent)event).getType() == 18) {
                    this.inheritStyleFromString(this.h2StyleString);
                }
                if (((TagEndEvent)event).getType() == 19) {
                    this.inheritStyleFromString(this.h3StyleString);
                }
                if (((TagEndEvent)event).getType() == 9 && !this.curSrc.trim().equals("")) {
                    this.appendImage(this.curSrc);
                }
                if (((TagEndEvent)event).getType() == 27) {
                    this.appendHR(this.curRGB);
                    this.curRGB = null;
                }
            }
        } else if (event instanceof EOFEvent) {
            BasePartition partition = this.getNewFontPartition();
            if (partition.getLength() > 0) {
                this.partitions.add(partition);
            }
            if (this.wasLI) {
                this.lineAligns.add(this.curAlign);
                if (this.bulletedListLevel > 0) {
                    this.lineBullets.add(0);
                } else if (this.numberedListLevel > 0) {
                    this.lineBullets.add(this.currentNumberedListValue);
                } else {
                    this.lineBullets.add(-1);
                }
            }
        } else if (this.appendText && !event.l.trim().equals("")) {
            this.curTextStr.append(event.l);
        }
        if (this.getLineCount(this.globalBuilder.toString()) + this.getLineCount(this.curTextStr.toString()) != this.lineAligns.size()) {
            Logger.log("(!) unsync");
        }
    }

    protected int getLineCount(String s) {
        int cnt = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n') {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    protected String convertImageSrc(String src) {
        return src;
    }

    protected String convertLinkURL(String url) {
        return url;
    }

    private void insertNewLineIfNeeded() {
        if (!this.checkEolPresence()) {
            this.endOfLineReached();
        }
    }

    protected void appendImage(String curSrc) {
        int newOffset = this.getDocEndOffset();
        this.globalBuilder.append("?");
        Image img = null;
        try {
            img = new Image(null, curSrc);
        }
        catch (Exception exception) {
            try {
                InputStream resourceAsStream = this.getClass().getResourceAsStream("/com/onpositive/richtexteditor/img/notFound.gif");
                img = new Image(null, resourceAsStream);
            }
            catch (Exception exception2) {
                System.err.println("Can't find notFound.gif");
            }
        }
        this.partitions.add(new ImagePartition(this.layer, newOffset, 1, img, curSrc));
    }

    protected void appendHR(RGB rgb) {
        int newOffset = this.getDocEndOffset();
        this.partitions.add(new BasePartition(this.layer, newOffset, 1));
        this.globalBuilder.append("\n");
        String hrStr = "?\n";
        HRPartition hrp = new HRPartition(this.layer, ++newOffset, hrStr.length());
        if (rgb != null) {
            hrp.setColorRGB(rgb);
        }
        this.partitions.add(hrp);
        this.globalBuilder.append(hrStr);
    }

    protected int getDocEndOffset() {
        int newOffset = 0;
        if (this.partitions.size() > 0) {
            newOffset = this.partitions.get(this.partitions.size() - 1).getOffset() + this.partitions.get(this.partitions.size() - 1).getLength();
        }
        return newOffset;
    }

    protected boolean checkEolPresence() {
        String resolveStr = this.resolveStr(this.curTextStr);
        if (resolveStr.length() > 0 && !resolveStr.equals(" ") && !resolveStr.equals("\t") ? resolveStr.charAt(resolveStr.length() - 1) == '\n' || resolveStr.charAt(resolveStr.length() - 1) == '\r' : this.globalBuilder.length() > 0 && (this.globalBuilder.charAt(this.globalBuilder.length() - 1) == '\n' || this.globalBuilder.charAt(this.globalBuilder.length() - 1) == '\r')) {
            return true;
        }
        if (this.globalBuilder.toString().trim().equals("") && resolveStr.toString().trim().equals("")) {
            return true;
        }
        return this.globalBuilder.length() == 0 && resolveStr.length() == 0;
    }

    protected String manageStyleString(String l, HashMap<String, String> currentStyleMap) {
        StringTokenizer st = new StringTokenizer(l, ";");
        while (st.hasMoreTokens()) {
            String str = st.nextToken().trim();
            int divPoint = str.indexOf(58);
            try {
                String name = str.substring(0, divPoint).trim();
                String value = str.substring(divPoint + 1).trim();
                currentStyleMap.put(name, value);
            }
            catch (Exception exception) {}
        }
        this.searchUndefinedValues(currentStyleMap);
        return this.getStyleStringForStyleMap(currentStyleMap);
    }

    protected void searchUndefinedValues(HashMap<String, String> currentStyleMap) {
        if (!currentStyleMap.containsKey(this.fontFaceString)) {
            this.searchValueFor(currentStyleMap, this.fontFaceString);
        }
        if (!currentStyleMap.containsKey(this.fontSizeString)) {
            this.searchValueFor(currentStyleMap, this.fontSizeString);
        }
        if (!currentStyleMap.containsKey(this.fontColorString)) {
            this.searchValueFor(currentStyleMap, this.fontColorString);
        }
        if (!currentStyleMap.containsKey(this.bkColorString)) {
            this.searchValueFor(currentStyleMap, this.bkColorString);
        }
    }

    protected String inheritStyleFromString(String l) {
        HashMap<String, String> currentStyleMap = this.styleAttrsStack.peek();
        StringTokenizer st = new StringTokenizer(l, ";");
        while (st.hasMoreTokens()) {
            String str = st.nextToken().trim();
            int divPoint = str.indexOf(58);
            try {
                String name = str.substring(0, divPoint).trim().toLowerCase();
                String value = str.substring(divPoint + 1).trim().toLowerCase();
                if (currentStyleMap.containsKey(name)) continue;
                currentStyleMap.put(name, value);
            }
            catch (Exception exception) {}
        }
        return this.getStyleStringForStyleMap(currentStyleMap);
    }

    protected String getStyleStringForStyleMap(HashMap<String, String> styleMap) {
        String resString = "";
        for (String key : styleMap.keySet()) {
            resString = String.valueOf(resString) + key + ":" + styleMap.get(key) + ";";
        }
        return resString;
    }

    protected void searchValueFor(HashMap<String, String> currentStyleMap, String key) {
        String foundValue = null;
        for (HashMap hashMap : this.styleAttrsStack) {
            if (!hashMap.containsKey(key)) continue;
            foundValue = (String)hashMap.get(key);
            break;
        }
        if (foundValue != null) {
            currentStyleMap.put(key, foundValue);
        }
    }

    protected void manageBold(boolean open) {
        if (open) {
            this.boldStack.push(true);
        } else if (this.boldStack.size() > 0) {
            this.boldStack.pop();
        }
    }

    protected void manageItalic(boolean open) {
        if (open) {
            this.italicStack.push(true);
        } else if (this.italicStack.size() > 0) {
            this.italicStack.pop();
        }
    }

    protected void manageUnderlined(boolean open) {
        if (open) {
            this.underlinedStack.push(true);
        } else if (this.underlinedStack.size() > 0) {
            this.underlinedStack.pop();
        }
    }

    protected void manageStrikethrough(boolean open) {
        if (open) {
            this.strikethroughStack.push(true);
        } else if (this.strikethroughStack.size() > 0) {
            this.strikethroughStack.pop();
        }
    }

    protected static RGB parseBgColorStyleString(String l) {
        int pos = l.indexOf("background-color:");
        if (pos >= 0) {
            int colorValueStartPos = pos + String.valueOf("background-color:").length();
            String colorString = l.substring(colorValueStartPos, colorValueStartPos + 7);
            return HTMLLexListener.parseColorString(colorString);
        }
        return null;
    }

    protected static RGB parseColorString(String colorString) {
        String newString = new String(colorString);
        int pos = newString.indexOf("color:");
        if (pos >= 0) {
            int colorValueStartPos = pos + String.valueOf("color:").length();
            newString = newString.substring(colorValueStartPos, colorValueStartPos + 7);
        }
        return HTMLLexListener.getRGBfromHexRGBString(newString);
    }

    protected static RGB getRGBfromHexRGBString(String hexRGBString) {
        RGB rgb;
        if ((hexRGBString = hexRGBString.trim()).charAt(0) == '#') {
            hexRGBString = hexRGBString.substring(1);
        }
        if (hexRGBString.length() < 6) {
            return new RGB(0, 0, 0);
        }
        try {
            rgb = new RGB(Integer.parseInt(hexRGBString.substring(0, 2), 16), Integer.parseInt(hexRGBString.substring(2, 4), 16), Integer.parseInt(hexRGBString.substring(4, 6), 16));
        }
        catch (Exception exception) {
            rgb = new RGB(0, 0, 0);
        }
        return rgb;
    }

    BasePartition getNewFontPartition() {
        String curFontStyleString;
        BasePartition newPartition;
        String addAfterPartitionStr = "";
        int newOffset = 0;
        if (this.partitions.size() > 0) {
            newOffset = this.partitions.get(this.partitions.size() - 1).getOffset() + this.partitions.get(this.partitions.size() - 1).getLength();
        }
        if (!this.curHref.equals("")) {
            if (this.curTextStr.length() > 0 && !Character.isWhitespace(this.curTextStr.charAt(this.curTextStr.length() - 1))) {
                addAfterPartitionStr = " ";
            }
            newPartition = new LinkPartition(this.layer, newOffset, this.curTextStr.length());
            ((LinkPartition)newPartition).setUrl(this.curHref);
        } else {
            newPartition = new BasePartition(this.layer, newOffset, this.curTextStr.length());
        }
        newPartition.setRefreshVisibleState(false);
        newPartition.setBold(this.boldStack.size() > 0);
        newPartition.setItalic(this.italicStack.size() > 0);
        newPartition.setUnderlined(this.underlinedStack.size() > 0);
        newPartition.setStrikethrough(this.strikethroughStack.size() > 0);
        if (this.styleAttrsStack.size() > 0 && (curFontStyleString = this.manageStyleString("", this.styleAttrsStack.peek())).trim() != "") {
            RGB curBackgroundRGB = HTMLLexListener.parseBgColorStyleString(curFontStyleString);
            RGB curForegroundRGB = HTMLLexListener.parseColorString(curFontStyleString);
            if (curForegroundRGB != null) {
                newPartition.setColorRGB(curForegroundRGB);
            }
            if (curBackgroundRGB != null) {
                newPartition.setBgColorRGB(curBackgroundRGB);
            }
            if (!curFontStyleString.equals("")) {
                newPartition.setFontDataName(curFontStyleString);
            }
        }
        String resStr = this.resolveStr(this.curTextStr);
        if (this.globalBuilder.length() > 0 && this.trimWhiteSpaces && Character.isWhitespace(this.globalBuilder.charAt(this.globalBuilder.length() - 1)) && resStr.length() > 0 && (resStr.charAt(0) == ' ' || resStr.charAt(0) == '\t')) {
            resStr = resStr.substring(1);
        }
        this.globalBuilder.append(resStr);
        newPartition.setLength(resStr.length());
        this.curTextStr = new StringBuilder(addAfterPartitionStr);
        return newPartition;
    }

    protected void endOfLineReached() {
        if (this.trimWhiteSpaces) {
            this.curTextStr.append("\r\n");
        }
        this.lineAligns.add(this.curAlign);
        if (this.bulletedListLevel > 0 && this.wasLI) {
            this.lineBullets.add(0);
        } else if (this.numberedListLevel > 0 && this.wasLI) {
            this.lineBullets.add(this.currentNumberedListValue);
        } else {
            this.lineBullets.add(-1);
        }
        this.wasLI = false;
    }

    protected String resolveStr(StringBuilder str) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            if (builder.length() == 0 || !this.trimWhiteSpaces || !Character.isWhitespace(builder.charAt(builder.length() - 1)) || str.charAt(i) != ' ' && str.charAt(i) != '\t') {
                if (!this.trimWhiteSpaces && str.charAt(i) == '\n') {
                    this.endOfLineReached();
                }
                builder.append(str.charAt(i));
            }
            ++i;
        }
        str = builder;
        i = 0;
        while (i < str.length()) {
            ++i;
        }
        return str.toString();
    }

    public ArrayList<BasePartition> getPartitions() {
        return this.partitions;
    }

    public String getText() {
        return this.globalBuilder.toString();
    }

    public ArrayList<Integer> getLineBullets() {
        return this.lineBullets;
    }

    public ArrayList<Integer> getLineAligns() {
        return this.lineAligns;
    }
}

