package de.ugoe.cs.swe.memos.search;

import java.util.Iterator;
import java.util.Vector;

import org.eclipse.swt.widgets.Composite;

import de.ugoe.cs.swe.memos.database.DatabaseException;
import de.ugoe.cs.swe.memos.datamodel.Category;

public class CategoryCompletionText extends CompletableText {

	
	
	public CategoryCompletionText(Composite parent, int style, boolean multiWords, boolean mustMatch) {
		super(parent, style, multiWords, mustMatch);
		
	}

	@Override
	protected Vector<String> refreshItemList() {
		Vector<Category> catList = new Vector<Category>();
		Vector<String> itemList = new Vector<String>(); 
		try {
			catList = db.queryCategories();
		}
		catch (DatabaseException e) {
			System.out.println(e.toString());
		}
		
		itemList.clear();
		
		// convert to string list, containing the names
		Iterator<Category> catIt = catList.iterator();
		while (catIt.hasNext()) {
			Category cat = catIt.next();
			itemList.add(cat.getPath());
		}
		return itemList; 
	}	

}
