package de.ugoe.cs.swe.memos.gui.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

import de.ugoe.cs.swe.memos.SettingsManager;

public class SettingsDialog extends TitleAreaDialog {

	private String username;
	private String password;
	private String importPath;
	private String exportPath;
	private String URI;
	private String timeout;
	private String hsqlFilename;
	private boolean sslEnabled;
	SettingsManager.DatabaseType dbType;

	private Text textUsername;
	private Text textPassword;
	private Text textImport;
	private Text textExport;
	private Text textURI;
	private Text textTimeout;
	private Text HSQLDirectory;
	private Text keyPath;
	private Button useSSL;
	private Combo dbTyp;

	private Button keyB;
	private Label keyL;
	private Label HSQLDirectoryL;
	private Button  HSQLDirectoryB;
	private Label labelURI;

	public String getUsername() {
		return username;
	}

	public String getPassword() {
		return password;
	}

	public String getImportPath() {
		return importPath;
	}

	public String getExportPath() {
		return exportPath;
	}

	public String getURI() {
		return URI;
	}

	public Long getTimeout() {
		return new Long(timeout);
	}

	private final SettingsManager manager = SettingsManager.getInstance();

	public SettingsDialog(Shell parentShell) {
		super(parentShell);
		this.setTitle("Einstellungen");
	}

	private void createUserTab(CTabFolder folder, GridData gridData) {
		CTabItem userTab = new CTabItem(folder, SWT.NONE);
		userTab.setText("Benutzer");

		// define composite
		Composite userComposite = new Composite(folder, SWT.NONE);
		userTab.setControl(userComposite);
		GridLayout userGridLayout = new GridLayout();
		userGridLayout.numColumns = 3;
		userComposite.setLayout(userGridLayout);
		userComposite.setLayoutData(gridData);

		// username
		Label labelUsername = new Label(userComposite, SWT.RIGHT);
		labelUsername.setText("Benutzer:");
		textUsername = new Text(userComposite, SWT.SINGLE);
		textUsername.setLayoutData(gridData);
		// spacer
		new Label(userComposite, SWT.RIGHT);

		// password
		Label labelPassword = new Label(userComposite, SWT.RIGHT);
		labelPassword.setText("Password:");
		textPassword = new Text(userComposite, SWT.SINGLE | SWT.PASSWORD);
		textPassword.setLayoutData(gridData);
		// spacer
		new Label(userComposite, SWT.RIGHT);

		// import path
		Label labelImport = new Label(userComposite, SWT.RIGHT);
		labelImport.setText("Import Pfad:");
		textImport = new Text(userComposite, SWT.SINGLE);
		textImport.setLayoutData(gridData);
		// choose path
		Button importButton = new Button(userComposite, SWT.PUSH);
		importButton.setText("Auswählen...");
		importButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog directoryDialog = new DirectoryDialog(
						getShell(), SWT.OPEN);
				textImport.setText(directoryDialog.open());
			}
		});

		// export path
		Label labelExport = new Label(userComposite, SWT.RIGHT);
		labelExport.setText("Export Pfad:");
		textExport = new Text(userComposite, SWT.SINGLE);
		textExport.setLayoutData(gridData);

		// choose path
		Button exportButton = new Button(userComposite, SWT.PUSH);
		exportButton.setText("Auswählen...");
		exportButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog directoryDialog = new DirectoryDialog(
						getShell(), SWT.OPEN);
				textExport.setText(directoryDialog.open());
			}
		});
	}

	private void createExtendedTab(CTabFolder folder, GridData gridData) {
		CTabItem extendedTab = new CTabItem(folder, SWT.NONE);
		extendedTab.setText("Erweitert");

		// create composite
		Composite extendedComp = new Composite(folder, SWT.NONE);
		extendedTab.setControl(extendedComp);
		GridLayout extendedGridLayout = new GridLayout();
		extendedGridLayout.numColumns = 3;
		extendedComp.setLayout(extendedGridLayout);

		

		// timeout
		Label labelTimeout = new Label(extendedComp, SWT.RIGHT);
		labelTimeout.setText("Max. Reservierung:");
		textTimeout = new Text(extendedComp, SWT.SINGLE);
		textTimeout.setLayoutData(gridData);

		// timeout "Minuten" anzeigen
		Label labelTimeoutMinute = new Label(extendedComp, SWT.RIGHT);
		labelTimeoutMinute.setText("Minuten");
		textTimeout.setLayoutData(gridData);

		Label switchDB = new Label(extendedComp, SWT.LEFT);
		switchDB.setText("Datenbank:");

		dbTyp = new Combo(extendedComp, SWT.READ_ONLY);
		dbTyp.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2,
				1));
		dbTyp.add("MySQL");
		dbTyp.add("HSQL");
		dbTyp.select(0);
		
		// URI
		labelURI = new Label(extendedComp, SWT.RIGHT);
		labelURI.setText("URI:");

		GridData gridDataText = new GridData(GridData.FILL_HORIZONTAL);
		gridDataText.horizontalSpan = 2;

		textURI = new Text(extendedComp, SWT.SINGLE);
		textURI.setLayoutData(gridDataText);
		
		HSQLDirectoryL = new Label(extendedComp, SWT.LEFT);
		HSQLDirectoryL.setText("Pfad zur HSQL Datenbank:");
		HSQLDirectoryL.setEnabled(false);
		HSQLDirectory = new Text(extendedComp, SWT.SINGLE);
		HSQLDirectory.setLayoutData(gridData);
		HSQLDirectory.setEnabled(false);
		HSQLDirectoryB = new Button(extendedComp, SWT.PUSH);
		HSQLDirectoryB.setText("Auswählen...");
		HSQLDirectoryB.setEnabled(false);
		HSQLDirectoryB.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				FileDialog directoryDialog = new FileDialog(
						getShell(), SWT.OPEN);
				HSQLDirectory.setText(directoryDialog.open());
			}
		});
		dbTyp.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				boolean show=false;
				if(dbTyp.getSelectionIndex()==1)
					show=true;
				
				HSQLDirectoryL.setEnabled(show);
				HSQLDirectory.setEnabled(show);
				HSQLDirectoryB.setEnabled(show);
				useSSL.setEnabled(!show);
				labelURI.setEnabled(!show);
				textURI.setEnabled(!show);
				show=useSSL.getSelection()&& !show;
				keyB.setEnabled(show);
				keyL.setEnabled(show);				
				keyPath.setEnabled(show);

			}
		});

		useSSL = new Button(extendedComp, SWT.CHECK);
		useSSL.setText("Sichere SSL verbindung aufbauen");
		useSSL.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false,
				3, 1));
		keyL = new Label(extendedComp, SWT.LEFT);
		keyL.setText("Pfad zum SSL keyfile:");
		keyL.setEnabled(false);
		keyPath = new Text(extendedComp, SWT.SINGLE);
		keyPath.setLayoutData(gridData);
		keyPath.setEnabled(false);
		keyB = new Button(extendedComp, SWT.PUSH);
		keyB.setText("Auswählen...");
		keyB.setEnabled(false);
		keyB.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				FileDialog directoryDialog = new FileDialog(
						getShell(), SWT.OPEN);
				keyPath.setText(directoryDialog.open());
			}
		});

		useSSL.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {

				keyPath.setEnabled(useSSL.getSelection());
				keyB.setEnabled(useSSL.getSelection());
				keyL.setEnabled(useSSL.getSelection());

			}
		});

	}

	public SettingsManager.DatabaseType getDbTyp() {
		return dbType;
	}

	public String getHSQLDirectory() {
		return hsqlFilename;
	}

	public Text getKeyPath() {
		return keyPath;
	}

	public void setKeyPath(Text keyPath) {
		this.keyPath = keyPath;
	}

	public boolean getUseSSL() {
		return sslEnabled;
	}

	private void getUserValues() {
		textUsername.setText(manager.getUsername());
		textPassword.setText(manager.getPassword());
		textImport.setText(manager.getImport_Path());
		textExport.setText(manager.getExport_Path());
		textURI.setText(manager.getDatabaseURI());
		textTimeout.setText(manager.getLockTimeout().toString());
		useSSL.setSelection(manager.getSSLEnabled());
		HSQLDirectory.setText(manager.getHSQLFilename());
	}

	protected Control createContents(Composite parent) {
		Control contents = super.createContents(parent);
		setTitle("Einstellungen");
		setMessage("Ändern der Nutzer- und Datenbankkonfiguration");
		
		return contents;
	}

	protected Control createDialogArea(Composite parent) {
		Composite comp = (Composite) super.createDialogArea(parent);
		
		CTabFolder tabFolder = new CTabFolder(comp, SWT.BORDER);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		
		// fill tabs
		createUserTab(tabFolder, gd);
		createExtendedTab(tabFolder, gd);
		
		getUserValues();
		
		return comp;
	}
	
	public boolean close() {
		// make the settings available, even if the dialog was disposed
		username = textUsername.getText();
		password = textPassword.getText();
		importPath = textImport.getText();
		exportPath = textExport.getText();
		URI = textURI.getText();
		timeout = textTimeout.getText();
		hsqlFilename = HSQLDirectory.getText();
		sslEnabled = useSSL.getSelection();
		if (dbTyp.getSelectionIndex() == 1)
			dbType = SettingsManager.DatabaseType.HSQL;
		else
			dbType = SettingsManager.DatabaseType.MySQL;

		return super.close();
	}
}
